/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.utils.StringUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ResultSetTableModel
implements TableModel {
    int _numcols;
    private ArrayList<String> _type = new ArrayList();
    private ArrayList<String> _sqlType = new ArrayList();
    private ArrayList<String> _cols = new ArrayList();
    private ArrayList<Integer> _displaySize = new ArrayList();
    private ArrayList<ArrayList<Object>> _rows = new ArrayList();
    private ArrayList<SQLWarning> _sqlWarnList = new ArrayList();
    private boolean _allowEdit = true;

    public ResultSetTableModel(ResultSet rs) throws SQLException {
        this(rs, true);
    }

    public ResultSetTableModel(ResultSet rs, boolean editable) throws SQLException {
        this._allowEdit = editable;
        ResultSetMetaData rsmd = rs.getMetaData();
        this._numcols = rsmd.getColumnCount() + 1;
        for (int c = 1; c < this._numcols; ++c) {
            this._cols.add(rsmd.getColumnLabel(c));
            this._type.add(rsmd.getColumnClassName(c));
            this._sqlType.add(rsmd.getColumnTypeName(c));
            this._displaySize.add(new Integer(Math.max(rsmd.getColumnDisplaySize(c), rsmd.getColumnLabel(c).length())));
        }
        int rowCount = 0;
        while (rs.next()) {
            for (SQLWarning sqlw = rs.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                this._sqlWarnList.add(sqlw);
            }
            rs.clearWarnings();
            ArrayList<Object> row = new ArrayList<Object>();
            for (int c = 1; c < this._numcols; ++c) {
                Object o = rs.getObject(c);
                if (o instanceof String) {
                    row.add(((String)o).trim());
                    continue;
                }
                row.add(o);
            }
            this._rows.add(row);
            ++rowCount;
        }
    }

    public List<SQLWarning> getSQLWarningList() {
        return this._sqlWarnList;
    }

    @Override
    public int getColumnCount() {
        return this._cols.size();
    }

    @Override
    public int getRowCount() {
        return this._rows.size();
    }

    @Override
    public String getColumnName(int column) {
        return this._cols.get(column);
    }

    @Override
    public Class<?> getColumnClass(int colid) {
        Class clazz;
        if (this.getRowCount() == 0) {
            return Object.class;
        }
        Object o = this.getValueAt(0, colid);
        Class clazz2 = clazz = o != null ? o.getClass() : Object.class;
        if (o instanceof Timestamp) {
            return Object.class;
        }
        return clazz;
    }

    @Override
    public Object getValueAt(int r, int c) {
        ArrayList<Object> row = this._rows.get(r);
        Object o = row.get(c);
        return o;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this._allowEdit;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    public int getColumnDisplaySize(int column) {
        return this._displaySize.get(column);
    }

    public String getColumnNameFullSize(int column) {
        int fullSize = this.getColumnDisplaySize(column);
        return StringUtil.left(this.getColumnName(column), fullSize);
    }

    public String getColumnLineFullSize(int column) {
        int fullSize = this.getColumnDisplaySize(column);
        return StringUtil.replicate("-", fullSize);
    }

    public String getValueAtFullSize(int r, int c) {
        ArrayList<Object> row = this._rows.get(r);
        Object o = row.get(c);
        String str = o == null ? "NULL" : o.toString();
        int fullSize = this.getColumnDisplaySize(c);
        if (o instanceof Number) {
            return StringUtil.right(str, fullSize);
        }
        return StringUtil.left(str, fullSize);
    }

    public String toTableString() {
        return this.toTableString(" ");
    }

    public String toTableString(String colSep) {
        int c;
        StringBuilder sb = new StringBuilder(1024);
        int cols = this.getColumnCount();
        int rows = this.getRowCount();
        for (c = 0; c < cols; ++c) {
            sb.append(colSep).append(this.getColumnNameFullSize(c));
        }
        sb.append("\n");
        for (c = 0; c < cols; ++c) {
            sb.append(colSep).append(this.getColumnLineFullSize(c));
        }
        sb.append("\n");
        for (int r = 0; r < rows; ++r) {
            for (int c2 = 0; c2 < cols; ++c2) {
                sb.append(colSep).append(this.getValueAtFullSize(r, c2));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toHtmlTableString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<table border='1'>\n");
        int cols = this.getColumnCount();
        int rows = this.getRowCount();
        sb.append("<tr>");
        for (int c = 0; c < cols; ++c) {
            sb.append("<td nowrap>").append(this.getColumnName(c)).append("</td>");
        }
        sb.append("</tr>\n");
        sb.append("<tr>");
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                sb.append("<td nowrap>").append(this.getValueAtFullSize(r, c)).append("</td>");
            }
            sb.append("\n");
        }
        sb.append("</tr>\n");
        sb.append("</table>\n");
        return sb.toString();
    }
}

