/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import java.io.File;

public class SplashWindow {
    private static final String[] SPLASHES = new String[]{"splash.jpg", "splash2.jpg"};
    private static int _textX = 10;
    private static int _textWClear = 250;
    private static int _barX = 2;
    private static int _barWClear = 250;
    private static int _textH = 10;
    private static int _barH = 9;
    private static int _barW = 5;
    private static int _barRightMargin = 100;
    private static int _textRightMargin = 0;
    private static int _textYpos = 40;
    private static int _numOfBars = 100;
    private static int _expectedProgressCalls = 100;
    private static int _textY;
    private static int _barY;
    private static int _barPos;
    private static SplashScreen _splash;
    private static Graphics2D _graph;
    private static long _lastProgressCall;

    public static void init() {
        SplashWindow.init(true);
    }

    public static void init(boolean printProblems) {
        SplashWindow.init(printProblems, 100, 500L);
    }

    public static void init(boolean printProblems, int expectedProgressCalls, final long bgProgressUpdateTime) {
        _expectedProgressCalls = expectedProgressCalls;
        _splash = SplashScreen.getSplashScreen();
        if (_splash == null) {
            if (printProblems) {
                System.out.println("No splash image specified on the command line.");
            }
            return;
        }
        Dimension splashSize = _splash.getSize();
        _textY = splashSize.height - _textYpos;
        _barY = splashSize.height - _barH - 2;
        _numOfBars = (splashSize.width - _barX - _barRightMargin) / (_barW + 1);
        _barWClear = splashSize.width - _barX - _barRightMargin + 1;
        _textWClear = splashSize.width - _textX - _textRightMargin + 1;
        _graph = _splash.createGraphics();
        if (bgProgressUpdateTime > 0L) {
            Runnable updProgressBar = new Runnable(){

                @Override
                public void run() {
                    long sleepTime = bgProgressUpdateTime;
                    Thread.currentThread().setName("SplashWindow:UpdProgressBar");
                    try {
                        while (_splash.isVisible()) {
                            Thread.sleep(sleepTime);
                            if (System.currentTimeMillis() - _lastProgressCall <= sleepTime) continue;
                            _expectedProgressCalls++;
                            SplashWindow.drawProgress(null);
                        }
                    }
                    catch (IllegalStateException ignore) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            new Thread(updProgressBar).start();
        }
    }

    public static boolean isOk() {
        return _splash != null;
    }

    public static void setExpectedProgressCalls(int num) {
        _expectedProgressCalls = num;
    }

    public static void close() {
        if (_splash == null) {
            _splash = SplashScreen.getSplashScreen();
        }
        if (_splash != null) {
            _splash.close();
            _splash = null;
        }
    }

    public static void drawProgress(String msg) {
        if (_splash == null) {
            return;
        }
        if (!_splash.isVisible()) {
            return;
        }
        _lastProgressCall = System.currentTimeMillis();
        _graph.setComposite(AlphaComposite.Clear);
        if (msg != null) {
            _graph.fillRect(_textX, _textY, _textWClear, _textH + 2);
        }
        if (_barPos == 0) {
            _graph.fillRect(_barX, _barY, _barWClear, _barH);
        }
        _graph.setPaintMode();
        if (msg != null) {
            _graph.setColor(Color.BLACK);
            _graph.drawString(msg, _textX, _textY + _textH);
        }
        _graph.setColor(Color.LIGHT_GRAY);
        int barCount = Math.max(1, _numOfBars / _expectedProgressCalls);
        for (int bc = 0; bc < barCount; ++bc) {
            _graph.fillRect(_barX + _barPos * (_barW + 1), _barY, _barW, _barH);
            ++_barPos;
        }
        _splash.update();
        if (_barPos >= _numOfBars) {
            _barPos = 0;
        }
    }

    public static void changeImage(int i) {
        if (_splash == null) {
            return;
        }
        try {
            _splash.setImageURL(new File(SPLASHES[i / 10 % 2]).toURI().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void drawTopRight(String str) {
        if (_splash == null) {
            return;
        }
        FontMetrics fm = _graph.getFontMetrics();
        int strWidth = fm.stringWidth(str);
        int strHeight = fm.getHeight();
        Dimension splashSize = _splash.getSize();
        int verX = splashSize.width - strWidth - 7;
        int verY = strHeight;
        _graph.setPaintMode();
        _graph.setColor(Color.LIGHT_GRAY);
        _graph.drawString(str, verX, verY);
        _splash.update();
    }

    public static void drawTopLeft(String str) {
        if (_splash == null) {
            return;
        }
        FontMetrics fm = _graph.getFontMetrics();
        int strHeight = fm.getHeight();
        int verX = 7;
        int verY = strHeight;
        _graph.setPaintMode();
        _graph.setColor(Color.LIGHT_GRAY);
        _graph.drawString(str, verX, verY);
        _splash.update();
    }

    public static void main(String[] args) throws Exception {
        SplashWindow.init();
        for (int i = 0; i < 100; ++i) {
            SplashWindow.drawProgress("Progress step number " + i);
            Thread.sleep(250L);
        }
        SplashWindow.close();
    }

    static {
        _barPos = 0;
        _splash = null;
        _graph = null;
        _lastProgressCall = 0L;
    }
}

