/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.GetCounters;
import asemon.Version;
import asemon.cm.CountersModel;
import asemon.gui.ColumnHeaderPropsEntry;
import asemon.gui.MainFrame;
import asemon.gui.TrendGraph;
import asemon.gui.swing.AbstractComponentDecorator;
import asemon.gui.swing.GTabbedPane;
import asemon.gui.swing.GTabbedPaneWindowProps;
import asemon.gui.swing.MultiSortTableCellHeaderRenderer;
import asemon.gui.swing.RowFilterDiffCounterIsZero;
import asemon.gui.swing.RowFilterValueAndOp;
import asemon.pcs.InMemoryCounterHandler;
import asemon.pcs.PersistReader;
import asemon.utils.AseConnectionFactory;
import asemon.utils.Configuration;
import asemon.utils.ConnectionFactory;
import asemon.utils.StringUtil;
import asemon.utils.SwingUtils;
import asemon.utils.TimeUtils;
import asemon.xmenu.TablePopupFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class TabularCntrPanel
extends JPanel
implements GTabbedPane.DockUndockManagement,
GTabbedPane.ShowProperties,
GTabbedPane.SpecialTabPainter,
ConnectionFactory,
TableModelListener,
ClipboardOwner {
    private static Logger _logger = Logger.getLogger(TabularCntrPanel.class);
    private static final long serialVersionUID = 1L;
    private boolean _migDebug = false;
    private String _displayName = "";
    private String _description = "Used for tool tip";
    private Icon _icon = null;
    private ImageIcon _indicatorIcon = null;
    private boolean _indicatorToLeft = true;
    private JButton _tabDockUndockButton = new JButton();
    private CountersModel _cm = null;
    private CountersModel _cmDisplay = null;
    private boolean _tailMode = true;
    private static String FILTER_NO_COLUMN_IS_SELECTED = "<none>";
    private static final int FILTER_OP_EQ = 0;
    private static final int FILTER_OP_NE = 1;
    private static final int FILTER_OP_GT = 2;
    private static final int FILTER_OP_LT = 3;
    private static final String[] FILTER_OP_STR_ARR = new String[]{"==, Equal", "!=, Not Equal", ">, Greater Than", "<, Less Than"};
    private static final String[] FILTER_OP_STR_ARR_SHORT = new String[]{"EQ", "NE", "GT", "LT"};
    private JPanel _filterPanel;
    private JLabel _filterColumn_lbl = new JLabel("Filter column");
    private JComboBox _filterColumn_cb = new JComboBox();
    private JLabel _filterOperation_lbl = new JLabel("Operation");
    private JComboBox _filterOperation_cb = new JComboBox();
    private JLabel _filterValue_lbl = new JLabel("Value");
    private JTextField _filterValue_tf = new JTextField();
    private JCheckBox _filterNoZeroCounters_chk = new JCheckBox("Do NOT show unchanged counter rows");
    private boolean _tableRowFilterIsSet = false;
    private RowFilter<TableModel, Integer> _tableRowFilter = null;
    private List<RowFilter<TableModel, Integer>> _tableRowFilterList = new ArrayList<RowFilter<TableModel, Integer>>();
    private RowFilterValueAndOp _tableRowFilterValAndOp = null;
    private RowFilterDiffCounterIsZero _tableRowFilterDiffCntIsZero = null;
    private JPanel _counterPanel;
    private JRadioButton _counterAbs_rb = new JRadioButton("Absolute values");
    private JRadioButton _counterDelta_rb = new JRadioButton("Delta values");
    private JRadioButton _counterRate_rb = new JRadioButton("Rate per second");
    private JLabel _counterRows_lbl = new JLabel("");
    private JLabel _counterPct1_lbl = new JLabel("Or PCT");
    private JLabel _counterPct2_lbl = new JLabel("Or PCT");
    private JPanel _timeInfoPanel;
    private String _timeEmptyConstant = "                       ";
    private JLabel _timeClear_lbl = new JLabel("Clear time");
    private JTextField _timeClear_txt = new JTextField(this._timeEmptyConstant);
    private JLabel _timeSample_lbl = new JLabel("Sample time");
    private JTextField _timeSample_txt = new JTextField(this._timeEmptyConstant);
    private JLabel _timeIntervall_lbl = new JLabel("Intervall (ms)");
    private JTextField _timeIntervall_txt = new JTextField();
    private JLabel _timePostpone_lbl = new JLabel("Postpone time");
    private JTextField _timePostpone_txt = new JTextField();
    private JLabel _timeViewStored_lbl = new JLabel("Viewing stored data");
    private JButton _timeOfflineRewind_but = new JButton();
    private JButton _timeOfflineFastForward_but = new JButton();
    private JPanel _optionsPanel;
    private JCheckBox _optionPauseDataPolling_chk = new JCheckBox("Pause data polling");
    private JCheckBox _optionEnableBgPolling_chk = new JCheckBox("Enable background data polling");
    private JLabel _optionHasActiveGraphs_lbl = new JLabel("<html><b>has</b> active graphs</html>");
    private JButton _optionTrendGraphs_but = new JButton();
    private JCheckBox _optionPersistCounters_chk = new JCheckBox("Store Counter Data in a database");
    private JCheckBox _optionPersistCountersAbs_chk = new JCheckBox("Abs");
    private JCheckBox _optionPersistCountersDiff_chk = new JCheckBox("Diff");
    private JCheckBox _optionPersistCountersRate_chk = new JCheckBox("Rate");
    private JCheckBox _optionNegativeDiffCntToZero_chk = new JCheckBox("Reset negative Delta and Rate counters to zero");
    private JPanel _localOptionsPanel;
    private TCPTable _dataTable = new TCPTable();
    private JPopupMenu _tablePopupMenu = null;
    private Watermark _watermark = null;
    private long _lastColWithRefresh = 0L;
    private long _colWithRefreshSec = 60L;
    private HighlightPredicate _highligtIfDelta = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            CountersModel cm = TabularCntrPanel.this._cm;
            if (!TabularCntrPanel.this._tailMode) {
                cm = TabularCntrPanel.this._cmDisplay;
            }
            if (cm == null) {
                return false;
            }
            if (!cm.isDataInitialized()) {
                return false;
            }
            if (cm.discardDiffPctHighlighterOnAbsTable()) {
                return false;
            }
            return cm.isDiffColumn(adapter.convertColumnIndexToModel(adapter.column));
        }
    };
    private HighlightPredicate _highligtIfPct = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            CountersModel cm = TabularCntrPanel.this._cm;
            if (!TabularCntrPanel.this._tailMode) {
                cm = TabularCntrPanel.this._cmDisplay;
            }
            if (cm == null) {
                return false;
            }
            if (!cm.isDataInitialized()) {
                return false;
            }
            if (cm.discardDiffPctHighlighterOnAbsTable()) {
                return false;
            }
            return cm.isPctColumn(adapter.convertColumnIndexToModel(adapter.column));
        }
    };
    private Highlighter[] _highliters = new Highlighter[]{new HighlighterDiffData(this._highligtIfDelta), new HighlighterPctData(this._highligtIfPct)};
    private CountersModel _inMemHistCm = null;
    private Timestamp _inMemHistSampleTime = null;
    private boolean _inMemHistSampleHasBeenRead = false;
    private Timer _inMemHistRefreshTimer = new Timer(200, new InMemHistRefreshTimerAction());
    private CountersModel _offlineCm = null;
    private Timestamp _offlineSampleTime = null;
    private boolean _offlineSampleHasBeenRead = false;
    private Timer _offlineRefreshTimer = new Timer(200, new OfflineRefreshTimerAction());

    public TabularCntrPanel(String displayName) {
        this._displayName = displayName;
        this._tableRowFilterValAndOp = new RowFilterValueAndOp((JTable)((Object)this._dataTable));
        this._tableRowFilterDiffCntIsZero = new RowFilterDiffCounterIsZero((JTable)((Object)this._dataTable));
        this._tableRowFilterList.add(this._tableRowFilterValAndOp);
        this._tableRowFilterList.add(this._tableRowFilterDiffCntIsZero);
        this._tableRowFilter = RowFilter.andFilter(this._tableRowFilterList);
        this.initComponents();
        String lookAndFeelName = UIManager.getLookAndFeel().getName();
        this._indicatorToLeft = true;
        if (lookAndFeelName != null && lookAndFeelName.equals("GTK look and feel")) {
            this._indicatorToLeft = false;
        }
    }

    public void setGraphTimeLineMarker(CountersModel cm) {
        if (cm == null) {
            return;
        }
        _logger.trace((Object)("TabularCntrlPanel.setGraphTimeLineMarker(): name='" + this._displayName + "'."));
        if (this._cm.hasTrendGraph()) {
            for (TrendGraph tg : this._cm.getTrendGraphs().values()) {
                tg.setTimeLineMarker(cm.getSampleTime());
            }
        }
    }

    public void setDisplayCm(CountersModel cm, boolean tailMode) {
        _logger.trace((Object)("-------------- setDisplayCm(cm=" + (cm == null ? "null" : cm.getName()) + ", tailMode=" + tailMode + ")-----------"));
        this._cmDisplay = cm;
        this._tailMode = tailMode;
        if (this._tailMode) {
            CountersModel summaryCm;
            this._timePostpone_lbl.setVisible(true);
            this._timePostpone_txt.setVisible(true);
            this._timeViewStored_lbl.setVisible(false);
            this._timeOfflineRewind_but.setVisible(false);
            this._timeOfflineFastForward_but.setVisible(false);
            this._cmDisplay = null;
            try {
                this.setCm(this._cm);
            }
            catch (Throwable e) {
                _logger.info((Object)(this.getName() + " had some issues when doing setCm(_cm) back to the original cm. Caught and ignored: " + e));
            }
            this.loadFilterProps();
            if (this._cm.hasTrendGraph()) {
                for (TrendGraph tg : this._cm.getTrendGraphs().values()) {
                    tg.setTimeLineMarker(null);
                }
            }
            if ((summaryCm = GetCounters.getCmByName("CMsummary")) != null && summaryCm.hasTrendGraph()) {
                for (TrendGraph tg : summaryCm.getTrendGraphs().values()) {
                    tg.setTimeLineMarker(null);
                }
            }
        } else {
            this._timePostpone_lbl.setVisible(false);
            this._timePostpone_txt.setVisible(false);
            this._timeViewStored_lbl.setVisible(true);
            if (MainFrame.isOfflineConnected()) {
                this._timeOfflineRewind_but.setVisible(true);
                this._timeOfflineFastForward_but.setVisible(true);
            }
            if (this._cmDisplay != null) {
                CountersModel summaryCm;
                if (this._counterAbs_rb.isSelected()) {
                    this._cmDisplay.setDataSource(1);
                }
                if (this._counterDelta_rb.isSelected()) {
                    this._cmDisplay.setDataSource(2);
                }
                if (this._counterRate_rb.isSelected()) {
                    this._cmDisplay.setDataSource(3);
                }
                this._dataTable.setModel(this._cmDisplay);
                this.loadFilterProps();
                if (this._cm.hasTrendGraph()) {
                    for (TrendGraph tg : this._cm.getTrendGraphs().values()) {
                        tg.setTimeLineMarker(this._cmDisplay.getSampleTime());
                    }
                }
                if ((summaryCm = GetCounters.getCmByName("CMsummary")) != null && summaryCm.hasTrendGraph()) {
                    for (TrendGraph tg : summaryCm.getTrendGraphs().values()) {
                        tg.setTimeLineMarker(this._cmDisplay.getSampleTime());
                    }
                }
            } else {
                this._dataTable.setModel(new DefaultTableModel());
            }
            this.adjustTableColumnWidth();
            if (this._cmDisplay != null) {
                this.setTimeInfo(this._cmDisplay.getCounterClearTime(), this._cmDisplay.getSampleTime(), this._cmDisplay.getSampleInterval());
            } else {
                this.setTimeInfo(null, null, 0L);
            }
        }
        this.setWatermark();
    }

    public CountersModel getDisplayCm() {
        return this._cmDisplay;
    }

    public void setCm(CountersModel cm) {
        if (this._cm != null) {
            this._cm.removeTableModelListener(this);
        }
        this._cm = cm;
        if (this._cm != null) {
            this._dataTable.setName(this._cm.getName());
            this._filterNoZeroCounters_chk.setSelected(this._cm.isFilterAllZero());
            this._optionPauseDataPolling_chk.setSelected(this._cm.isDataPollingPaused());
            this._optionEnableBgPolling_chk.setSelected(this._cm.isBackgroundDataPollingEnabled());
            this._optionHasActiveGraphs_lbl.setVisible(this._cm.hasActiveGraphs());
            this._optionTrendGraphs_but.setVisible(this._cm.hasTrendGraph());
            this._optionPersistCounters_chk.setSelected(this._cm.isPersistCountersEnabled());
            this._optionPersistCountersAbs_chk.setSelected(this._cm.isPersistCountersAbsEnabled());
            this._optionPersistCountersDiff_chk.setSelected(this._cm.isPersistCountersDiffEnabled());
            this._optionPersistCountersRate_chk.setSelected(this._cm.isPersistCountersRateEnabled());
            this._optionNegativeDiffCntToZero_chk.setSelected(this._cm.isNegativeDiffCountersToZero());
            this._optionPersistCountersAbs_chk.setEnabled(this._cm.isPersistCountersAbsEditable());
            this._optionPersistCountersDiff_chk.setEnabled(this._cm.isPersistCountersDiffEditable());
            this._optionPersistCountersRate_chk.setEnabled(this._cm.isPersistCountersRateEditable());
            int dataSource = this._cm.getDataSource();
            if (dataSource == 1) {
                this._counterAbs_rb.setSelected(true);
            }
            if (dataSource == 2) {
                this._counterDelta_rb.setSelected(true);
            }
            if (dataSource == 3) {
                this._counterRate_rb.setSelected(true);
            }
            if (!this._cm.isDiffCalcEnabled()) {
                this.setEnableCounterChoice(false);
                this._counterAbs_rb.setSelected(true);
            }
            this.setPostponeTime(this._cm.getPostponeTime());
            this._dataTable.setModel(this._cm);
            this._cm.addTableModelListener(this);
            this.adjustTableColumnWidth();
            this._cm.removeTableModelListener((TableModelListener)((Object)this._dataTable));
        }
    }

    public CountersModel getCm() {
        return this._cm;
    }

    public void setOptionPauseDataPolling(boolean b) {
        this._optionPauseDataPolling_chk.setSelected(b);
    }

    public void setOptionEnableBgPolling(boolean b) {
        this._optionEnableBgPolling_chk.setSelected(b);
    }

    public void setOptionPersistCountersAbs(boolean b) {
        this._optionPersistCountersAbs_chk.setSelected(b);
    }

    public void setOptionPersistCountersDiff(boolean b) {
        this._optionPersistCountersDiff_chk.setSelected(b);
    }

    public void setOptionPersistCountersRate(boolean b) {
        this._optionPersistCountersRate_chk.setSelected(b);
    }

    public void setOptionNegativeDiffCntToZero(boolean b) {
        this._optionNegativeDiffCntToZero_chk.setSelected(b);
    }

    public void setOptionPersistCounters(boolean b) {
        this._optionPersistCounters_chk.setSelected(b);
        this._optionPersistCountersAbs_chk.setEnabled(b && this._cm.isPersistCountersAbsEditable());
        this._optionPersistCountersDiff_chk.setEnabled(b && this._cm.isPersistCountersDiffEditable());
        this._optionPersistCountersRate_chk.setEnabled(b && this._cm.isPersistCountersRateEditable());
    }

    public void enableOptionPersistCounters(boolean b) {
        this._optionPersistCounters_chk.setEnabled(b);
        this._optionPersistCountersAbs_chk.setEnabled(b && this._cm.isPersistCountersAbsEditable());
        this._optionPersistCountersDiff_chk.setEnabled(b && this._cm.isPersistCountersDiffEditable());
        this._optionPersistCountersRate_chk.setEnabled(b && this._cm.isPersistCountersRateEditable());
    }

    public void onCmInit() {
        if (this._cm == null) {
            return;
        }
    }

    @Override
    public String getName() {
        return this._cm != null ? this._cm.getName() : null;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        TableModel tm = (TableModel)e.getSource();
        if (this._tailMode) {
            this._dataTable.tableChanged(e);
        }
        if (SwingUtils.isStructureChanged(e)) {
            this.refreshFilterColumns(tm);
            if (tm.getColumnCount() > 0) {
                this.loadFilterProps();
            }
            this.adjustTableColumnWidth();
        }
        this.setWatermark();
        if (this._tailMode) {
            if (System.currentTimeMillis() - this._lastColWithRefresh > this._colWithRefreshSec * 1000L || this._dataTable.getRowCount() < 20) {
                this.adjustTableColumnWidth();
            }
            if (this._dataTable.getRowCount() == 0) {
                this._lastColWithRefresh = 0L;
            }
            if (this._cm != null) {
                this.setTimeInfo(this._cm.getCounterClearTime(), this._cm.getSampleTime(), this._cm.getSampleInterval());
            }
        }
    }

    public void refreshFilterColumns(TableModel tm) {
        this._filterColumn_cb.removeAllItems();
        this._filterColumn_cb.addItem(FILTER_NO_COLUMN_IS_SELECTED);
        if (tm != null) {
            for (int i = 0; i < tm.getColumnCount(); ++i) {
                this._filterColumn_cb.addItem(tm.getColumnName(i));
            }
        }
    }

    public String getPanelName() {
        return this._displayName;
    }

    public void setEnableBgPollingCheckbox(boolean b) {
        this._optionEnableBgPolling_chk.setEnabled(b);
    }

    public void setEnableCounterChoice(boolean b) {
        this._counterPanel.setEnabled(b);
        for (int i = 0; i < this._counterPanel.getComponentCount(); ++i) {
            this._counterPanel.getComponent(i).setEnabled(b);
        }
    }

    public void setEnableFilter(boolean b) {
        this._filterPanel.setEnabled(b);
        for (int i = 0; i < this._filterPanel.getComponentCount(); ++i) {
            this._filterPanel.getComponent(i).setEnabled(b);
        }
    }

    public void adjustTableColumnWidth() {
        if (!this.doAutoAdjustTableColumnWidth()) {
            return;
        }
        Runnable doWork = new Runnable(){

            @Override
            public void run() {
                TabularCntrPanel.this._lastColWithRefresh = System.currentTimeMillis();
                TabularCntrPanel.this._dataTable.packAll();
            }
        };
        SwingUtilities.invokeLater(doWork);
    }

    public boolean isTableInitialized() {
        return this._dataTable.getColumnCount(true) > 0;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public String getDescription() {
        return this._description;
    }

    public void setTimeInfo(Timestamp clearTime, Timestamp sampleTime, long intervall) {
        String timeClear = clearTime == null ? this._timeEmptyConstant : clearTime.toString();
        this._timeClear_txt.setText(timeClear);
        String timeSample = sampleTime == null ? this._timeEmptyConstant : sampleTime.toString();
        this._timeSample_txt.setText(timeSample);
        String timeIntervall = intervall == 0L ? "" : Long.toString(intervall);
        this._timeIntervall_txt.setText(timeIntervall);
    }

    public void setPostponeTime(int postponeTime) {
        if (postponeTime == 0) {
            this._timePostpone_txt.setText("");
        } else {
            this._timePostpone_txt.setText(Integer.toString(postponeTime));
        }
    }

    public void setTableToolTipText(String tip) {
        if (this._dataTable != null) {
            this._dataTable.setToolTipText(tip);
        }
    }

    public void reset() {
        this.setTimeInfo(null, null, 0L);
    }

    public void putTableClientProperty(Object key, Object value) {
        if (this._dataTable != null) {
            this._dataTable.putClientProperty(key, value);
        }
    }

    public Object getTableClientProperty(Object key) {
        if (this._dataTable != null) {
            return this._dataTable.getClientProperty(key);
        }
        return null;
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        JSplitPane _mainSplitPan = new JSplitPane();
        _mainSplitPan.setOrientation(0);
        _mainSplitPan.setBorder(null);
        _mainSplitPan.add((Component)this.createExtendedInfoPanel(), "top");
        _mainSplitPan.add((Component)this.createTablePanel(), "bottom");
        _mainSplitPan.setDividerSize(3);
        this.add((Component)this.createTopPanel(), "North");
        this.add((Component)_mainSplitPan, "Center");
        this._tablePopupMenu = this.createDataTablePopupMenu();
        this._dataTable.setComponentPopupMenu(this._tablePopupMenu);
        this.initComponentActions();
    }

    private JPanel createTopPanel() {
        JPanel panel = SwingUtils.createPanel("Top", false);
        panel.setLayout((LayoutManager)new MigLayout(this._migDebug ? "debug" : "ins 3 10 3 3", "[] [] [] []", ""));
        JLabel title = new JLabel(this._displayName);
        title.setFont(new Font("Dialog", 1, 16));
        this._filterPanel = this.createFilterPanel();
        this._counterPanel = this.createCounterTypePanel();
        this._timeInfoPanel = this.createTimePanel();
        this._optionsPanel = this.createOptionsPanel();
        this._localOptionsPanel = this.createLocalOptionsPanel();
        panel.add((Component)title, "span 1 1, split 2, top, flowy");
        panel.add((Component)this._counterPanel, "flowx, grow");
        panel.add((Component)this._filterPanel, "top, grow");
        panel.add((Component)this._timeInfoPanel, "top, grow");
        panel.add((Component)this._optionsPanel, "top, grow");
        if (this._localOptionsPanel != null) {
            panel.add((Component)this._localOptionsPanel, "top, grow");
        }
        panel.add((Component)this._tabDockUndockButton, "top, right, push");
        return panel;
    }

    @Override
    public Connection getConnection(String connName) {
        try {
            return AseConnectionFactory.getConnection(null, connName, null);
        }
        catch (Exception e) {
            _logger.error((Object)"Problems getting a new Connection", (Throwable)e);
            return null;
        }
    }

    public JPopupMenu getDataTablePopupMenu() {
        return this._tablePopupMenu;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        _logger.info((Object)(this._displayName + ": lostOwnership(Clipboard='" + clipboard + "', Transferable='" + contents + "')."));
    }

    public void copyCell(boolean stripHtml) {
        Object cellValueObj;
        if (this._dataTable == null || this._dataTable != null && this._dataTable.getRowCount() == 0) {
            _logger.debug((Object)"copyCell(): no rows in the data table, return.");
            return;
        }
        String cellValueStr = null;
        if (this._dataTable.isLastMousePressedAtModelRowColValid() && (cellValueObj = this._dataTable.getModel().getValueAt(this._dataTable.getLastMousePressedAtModelRow(), this._dataTable.getLastMousePressedAtModelCol())) != null) {
            cellValueStr = cellValueObj.toString();
        }
        if (cellValueStr != null) {
            String data = stripHtml ? StringUtil.stripHtml(cellValueStr) : cellValueStr;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(data), this);
        }
    }

    public void copyRow(String columnSeparator, boolean withColNames, boolean stripHtml) {
        int c;
        if (this._dataTable == null || this._dataTable != null && this._dataTable.getRowCount() == 0) {
            _logger.debug((Object)"copyRow(): no rows in the data table, return.");
            return;
        }
        int row = this._dataTable.getLastMousePressedAtModelRow();
        if (row < 0) {
            _logger.debug((Object)"copyRow(): You are not pointing at a row, return.");
            return;
        }
        String rowTerminator = "\n";
        StringBuilder sb = new StringBuilder();
        TableModel tm = this._dataTable.getModel();
        int colCnt = this._dataTable.getColumnCount();
        if (withColNames) {
            for (c = 0; c < colCnt; ++c) {
                sb.append(tm.getColumnName(c));
                if (c >= tm.getColumnCount() - 1) continue;
                sb.append(columnSeparator);
            }
            sb.append(rowTerminator);
        }
        for (c = 0; c < colCnt; ++c) {
            sb.append(tm.getValueAt(row, c));
            if (c >= colCnt - 1) continue;
            sb.append(columnSeparator);
        }
        String data = stripHtml ? StringUtil.stripHtml(sb.toString()) : sb.toString();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(data), this);
    }

    public void copyTable(int formatType, boolean copySampleInfo, boolean copyTableHeaders, String columnSeparator) {
        if (this._dataTable == null || this._dataTable != null && this._dataTable.getRowCount() == 0) {
            _logger.debug((Object)"copyTable(): no rows in the data table, return.");
            return;
        }
        TableModel tm = this._dataTable.getModel();
        CountersModel cm = this._cm;
        if (!this._tailMode) {
            cm = this._cmDisplay;
        }
        String rowTerminator = "\n";
        String rowStart = "";
        StringBuilder sb = new StringBuilder();
        if (formatType == 1) {
            if (copySampleInfo) {
                rowStart = cm.getServerName() + columnSeparator + cm.getSampleTime() + columnSeparator + cm.getSampleInterval() + columnSeparator;
            }
            if (copyTableHeaders) {
                sb.append("Collector Name").append(columnSeparator).append(this._displayName).append(rowTerminator);
                sb.append(rowTerminator);
                sb.append("ServerName").append(columnSeparator).append(cm.getServerName()).append(rowTerminator);
                sb.append("SampleTime").append(columnSeparator).append(cm.getSampleTime()).append(rowTerminator);
                sb.append("SampleIntervall").append(columnSeparator).append(cm.getSampleInterval()).append(rowTerminator);
                sb.append(rowTerminator);
                if (copySampleInfo) {
                    sb.append("ServerName").append(columnSeparator).append("SampleTime").append(columnSeparator).append("SampleIntervall").append(columnSeparator);
                }
                for (int c = 0; c < tm.getColumnCount(); ++c) {
                    sb.append(tm.getColumnName(c));
                    if (c < tm.getColumnCount() - 1) {
                        sb.append(columnSeparator);
                        continue;
                    }
                    sb.append(rowTerminator);
                }
            }
            int tableCnt = this._dataTable.getRowCount();
            int colCnt = this._dataTable.getColumnCount();
            for (int r = 0; r < tableCnt; ++r) {
                int tmRow = this._dataTable.convertRowIndexToModel(r);
                sb.append(rowStart);
                for (int c = 0; c < colCnt; ++c) {
                    sb.append(tm.getValueAt(tmRow, c));
                    if (c < colCnt - 1) {
                        sb.append(columnSeparator);
                        continue;
                    }
                    sb.append(rowTerminator);
                }
            }
        } else {
            if (copyTableHeaders) {
                sb.append("Collector Name").append(columnSeparator).append(this._displayName).append(rowTerminator);
                sb.append(rowTerminator);
                sb.append("ServerName").append(columnSeparator).append(cm.getServerName()).append(rowTerminator);
                sb.append("SampleTime").append(columnSeparator).append(cm.getSampleTime()).append(rowTerminator);
                sb.append("SampleIntervall").append(columnSeparator).append(cm.getSampleInterval()).append(rowTerminator);
                sb.append(rowTerminator);
            }
            String[] extraColNames = null;
            String[] extraColData = null;
            if (copySampleInfo) {
                extraColNames = new String[]{"ServerName", "SampleTime", "SampleIntervall"};
                extraColData = new String[]{cm.getServerName(), cm.getSampleTime() + "", cm.getSampleInterval() + ""};
            }
            sb.append(SwingUtils.tableToString(tm, true, extraColNames, extraColData));
        }
        String data = sb.toString();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(data), this);
    }

    public void createColumnControlMenu(JPopupMenu popup) {
        JMenuItem menuItem = null;
        menuItem = new JMenuItem("Open 'Column Control' Menu");
        menuItem.setActionCommand("alwaysEnabled");
        popup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent comp = TabularCntrPanel.this._dataTable.getColumnControl();
                if (comp instanceof ColumnControlButton) {
                    ((ColumnControlButton)comp).doClick();
                }
            }
        });
        menuItem = new JMenuItem("Reset to Original Column Layout");
        menuItem.setActionCommand("alwaysEnabled");
        popup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this._dataTable.setOriginalColumnLayout();
            }
        });
        menuItem = new JMenuItem("Adjust Column Width");
        menuItem.setActionCommand("alwaysEnabled");
        popup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this._dataTable.packAll();
            }
        });
        JMenu autoAdjust = new JMenu("Automatically Adjust Column Width");
        popup.add(autoAdjust);
        autoAdjust.setActionCommand("alwaysEnabled");
        JRadioButtonMenuItem useGlobal = new JRadioButtonMenuItem("Use Global settings (in Preferences)");
        JRadioButtonMenuItem autoOn = new JRadioButtonMenuItem("Automatically Adjust Column Width");
        JRadioButtonMenuItem autoOff = new JRadioButtonMenuItem("Use Saved Column Width");
        autoAdjust.add(useGlobal);
        autoAdjust.add(autoOn);
        autoAdjust.add(autoOff);
        ButtonGroup group = new ButtonGroup();
        group.add(useGlobal);
        group.add(autoOn);
        group.add(autoOff);
        String key = this.getPanelName() + ".autoAdjustTableColumnWidth";
        Configuration conf = Configuration.getCombinedConfiguration();
        String autoAdjustTableColumnWidth = conf.getProperty("", AutoAdjustTableColumnWidth.GLOBAL.toString());
        if (autoAdjustTableColumnWidth.equals(AutoAdjustTableColumnWidth.GLOBAL.toString())) {
            useGlobal.setSelected(true);
        } else if (autoAdjustTableColumnWidth.equals(AutoAdjustTableColumnWidth.AUTO_ON.toString())) {
            autoOn.setSelected(true);
        } else if (autoAdjustTableColumnWidth.equals(AutoAdjustTableColumnWidth.AUTO_OFF.toString())) {
            autoOff.setSelected(true);
        } else {
            _logger.warn((Object)(this.getPanelName() + " Can't find appropriate value for " + key + " = '" + autoAdjustTableColumnWidth + "'."));
        }
        useGlobal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.setAutoAdjustTableColumnWidth(AutoAdjustTableColumnWidth.GLOBAL);
            }
        });
        autoOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.setAutoAdjustTableColumnWidth(AutoAdjustTableColumnWidth.AUTO_ON);
            }
        });
        autoOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.setAutoAdjustTableColumnWidth(AutoAdjustTableColumnWidth.AUTO_OFF);
            }
        });
        popup.addSeparator();
    }

    public void createCopyPasteMenu(JPopupMenu popup) {
        JMenuItem menuItem = null;
        menuItem = new JMenuItem("Copy Cell to clipboard");
        menuItem.setActionCommand("enabledIfOnrow");
        popup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyCell(true);
            }
        });
        JMenu copyRow = new JMenu("Copy Row to clipboard");
        copyRow.setActionCommand("enabledIfOnrow");
        popup.add(copyRow);
        menuItem = new JMenuItem("Tab separator (\\t), With Column Names");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyRow("\t", true, true);
            }
        });
        copyRow.add(menuItem);
        menuItem = new JMenuItem("Tab separator (\\t)");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyRow("\t", false, true);
            }
        });
        copyRow.add(menuItem);
        menuItem = new JMenuItem("Comma separator (,), With Column Names");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyRow(",", true, true);
            }
        });
        copyRow.add(menuItem);
        menuItem = new JMenuItem("Comma separator (,)");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyRow(",", false, true);
            }
        });
        copyRow.add(menuItem);
        JMenu copyTab = new JMenu("Copy Table to clipboard");
        JMenu copyFmtTab = new JMenu("Ascii Table Format");
        JMenu copySepTab = new JMenu("Tab separator (\\t)");
        JMenu copySepComma = new JMenu("Comma separator (,)");
        popup.add(copyTab);
        copyTab.add(copyFmtTab);
        copyTab.add(copySepTab);
        copyTab.add(copySepComma);
        copyTab.setActionCommand("alwaysEnabled");
        menuItem = new JMenuItem("Header Info + Prefixed Data Rows with(ServerName, SampleTime, SampleIntervall)");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyTable(2, true, true, ": ");
            }
        });
        copyFmtTab.add(menuItem);
        menuItem = new JMenuItem("Header Info + Data Rows in the Table");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyTable(2, false, true, ": ");
            }
        });
        copyFmtTab.add(menuItem);
        menuItem = new JMenuItem("Only Data Rows in the Table");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyTable(2, false, false, ": ");
            }
        });
        copyFmtTab.add(menuItem);
        menuItem = new JMenuItem("Header Info + Prefixed Data Rows with(ServerName, SampleTime, SampleIntervall)");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyTable(1, true, true, "\t");
            }
        });
        copySepTab.add(menuItem);
        menuItem = new JMenuItem("Header Info + Data Rows in the Table");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyTable(1, false, true, "\t");
            }
        });
        copySepTab.add(menuItem);
        menuItem = new JMenuItem("Only Data Rows in the Table");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyTable(1, false, false, "\t");
            }
        });
        copySepTab.add(menuItem);
        menuItem = new JMenuItem("Header Info + Prefixed Data Rows with(ServerName, SampleTime, SampleIntervall)");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyTable(1, true, true, ",");
            }
        });
        copySepComma.add(menuItem);
        menuItem = new JMenuItem("Header Info + Data Rows in the Table");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyTable(1, false, true, ",");
            }
        });
        copySepComma.add(menuItem);
        menuItem = new JMenuItem("Only Data Rows in the Table");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.copyTable(1, false, false, ",");
            }
        });
        copySepComma.add(menuItem);
    }

    public JPopupMenu createDataTablePopupMenu() {
        _logger.debug((Object)"createDataTablePopupMenu(): called.");
        JPopupMenu popup = new JPopupMenu();
        this.createColumnControlMenu(popup);
        this.createCopyPasteMenu(popup);
        TablePopupFactory.createMenu(popup, "table.menu.", Configuration.getCombinedConfiguration(), (JTable)((Object)this._dataTable), this);
        TablePopupFactory.createMenu(popup, this._displayName.replaceAll(" ", "") + "." + "table.menu.", Configuration.getCombinedConfiguration(), (JTable)((Object)this._dataTable), this);
        if (popup.getComponentCount() == 0) {
            _logger.warn((Object)("No PopupMenu has been assigned for the data table in the panel '" + this._displayName + "'."));
            return null;
        }
        return popup;
    }

    @Override
    public void showProperties() {
        if (!this._cm.isRuntimeInitialized()) {
            SwingUtils.showInfoMessage(this, "Show Properties", "Not yet connected to any ASE Server, try later.");
            return;
        }
        new ShowPropertiesDialog(null);
    }

    @Override
    public JButton getDockUndockButton() {
        _logger.debug((Object)"getDockUndockButton() called.");
        return this._tabDockUndockButton;
    }

    @Override
    public boolean beforeDock() {
        return true;
    }

    @Override
    public boolean beforeUndock() {
        return true;
    }

    @Override
    public void afterDock() {
    }

    @Override
    public void afterUndock() {
    }

    @Override
    public void saveWindowProps(GTabbedPaneWindowProps wp) {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            return;
        }
        _logger.trace((Object)(this._displayName + ": saveWindowProps(wp): " + wp));
        String base = this._displayName + ".";
        conf.setProperty(base + "window.active", wp.undocked);
        if (wp.width > 0) {
            conf.setProperty(base + "window.width", wp.width);
        }
        if (wp.height > 0) {
            conf.setProperty(base + "window.height", wp.height);
        }
        if (wp.posX > 0) {
            conf.setProperty(base + "window.pos.x", wp.posX);
        }
        if (wp.posY > 0) {
            conf.setProperty(base + "window.pos.y", wp.posY);
        }
        conf.save();
    }

    @Override
    public GTabbedPaneWindowProps getWindowProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            return null;
        }
        GTabbedPaneWindowProps wp = new GTabbedPaneWindowProps();
        String base = this._displayName + ".";
        wp.undocked = conf.getBooleanProperty(base + "window.active", false);
        wp.width = conf.getIntProperty(base + "window.width", -1);
        wp.height = conf.getIntProperty(base + "window.height", -1);
        wp.posX = conf.getIntProperty(base + "window.pos.x", -1);
        wp.posY = conf.getIntProperty(base + "window.pos.y", -1);
        _logger.trace((Object)(this._displayName + ": getWindowProps(): return " + wp));
        return wp;
    }

    private JPanel createFilterPanel() {
        JPanel panel = SwingUtils.createPanel("Filter", true);
        panel.setLayout((LayoutManager)new MigLayout(this._migDebug ? "debug, " : "ins 0", "[] [grow]", ""));
        this._filterColumn_cb.addItem(FILTER_NO_COLUMN_IS_SELECTED);
        this._filterOperation_cb.addItem(FILTER_OP_STR_ARR[0]);
        this._filterOperation_cb.addItem(FILTER_OP_STR_ARR[1]);
        this._filterOperation_cb.addItem(FILTER_OP_STR_ARR[2]);
        this._filterOperation_cb.addItem(FILTER_OP_STR_ARR[3]);
        AutoCompleteDecorator.decorate((JComboBox)this._filterColumn_cb);
        AutoCompleteDecorator.decorate((JComboBox)this._filterOperation_cb);
        this._filterColumn_cb.setToolTipText("Column that you want to filter on.");
        this._filterOperation_cb.setToolTipText("Operation to use when filtering data.");
        this._filterValue_tf.setToolTipText("Value to filter on. If column is 'string' then regexp will be used for operator 'Equal' and 'Not Equal'.");
        this._filterNoZeroCounters_chk.setToolTipText("Filter out rows where all 'diff/rate' counters are 0.");
        panel.add((Component)this._filterColumn_lbl, "");
        panel.add((Component)this._filterColumn_cb, "growx, wrap");
        panel.add((Component)this._filterOperation_lbl, "");
        panel.add((Component)this._filterOperation_cb, "growx, wrap");
        panel.add((Component)this._filterValue_lbl, "");
        panel.add((Component)this._filterValue_tf, "growx, wrap");
        panel.add((Component)this._filterNoZeroCounters_chk, "span, wrap");
        return panel;
    }

    private JPanel createCounterTypePanel() {
        JPanel panel = SwingUtils.createPanel("Show Counter Type", true);
        panel.setLayout((LayoutManager)new MigLayout(this._migDebug ? "debug, " : "wrap 2, ins 0", "", "0[0]0"));
        this._counterDelta_rb.setForeground(Color.BLUE);
        this._counterRate_rb.setForeground(Color.BLUE);
        this._counterPct1_lbl.setForeground(Color.RED);
        this._counterPct2_lbl.setForeground(Color.RED);
        this._counterRows_lbl.setToolTipText("Number of rows in the actual/visible. Where acual is numer of rows in the data model, and visible is rows after filtering...");
        this._counterAbs_rb.setToolTipText("Absolute values of the counters.");
        this._counterDelta_rb.setToolTipText("What is the difference since previous sample. Displayed with blue color.");
        this._counterRate_rb.setToolTipText("Divide the difference between two samples with time elipsed since last sample, then we get diff or rate per second. Displayed with blue color");
        ButtonGroup group = new ButtonGroup();
        group.add(this._counterAbs_rb);
        group.add(this._counterDelta_rb);
        group.add(this._counterRate_rb);
        panel.add((Component)this._counterAbs_rb, "");
        panel.add((Component)this._counterRows_lbl, "wrap");
        panel.add((Component)this._counterDelta_rb, "");
        panel.add((Component)this._counterPct1_lbl, "wrap");
        panel.add((Component)this._counterRate_rb, "");
        panel.add((Component)this._counterPct2_lbl, "wrap");
        return panel;
    }

    private JPanel createTimePanel() {
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText() {
                CountersModel cm = TabularCntrPanel.this._cmDisplay;
                if (cm == null) {
                    cm = TabularCntrPanel.this._cm;
                }
                if (cm == null) {
                    return null;
                }
                return "<html>SQL Refresh time: " + cm.getSqlRefreshTime() + " ms.<br>" + "GUI Refresh Time: " + cm.getGuiRefreshTime() + " ms.<br>" + "Local Calculation Time: " + cm.getLcRefreshTime() + " ms.<br>" + "</html>";
            }
        };
        panel.setToolTipText("");
        panel.setBorder(BorderFactory.createTitledBorder("Sample Information"));
        panel.setLayout((LayoutManager)new MigLayout("wrap 2, ins 0", "[fill] [fill]", ""));
        this._timeClear_txt.setEditable(false);
        this._timeSample_txt.setEditable(false);
        this._timeIntervall_txt.setEditable(false);
        this._timeViewStored_lbl.setVisible(false);
        this._timeViewStored_lbl.setFont(this._timeViewStored_lbl.getFont().deriveFont(1));
        this._timeViewStored_lbl.setHorizontalTextPosition(0);
        this._timeClear_txt.setToolTipText("If sp_sysmon is executed and clears the counters, it could be nice to know that...");
        this._timeSample_txt.setToolTipText("Date when the data showned in the table was sampled.");
        this._timeIntervall_txt.setToolTipText("Milliseconds since last sample period.");
        this._timePostpone_txt.setToolTipText("<html>If you want to skip some intermidiate samples, Here you can specify minimum seconds between samples.<br>tip: '10m' is 10 minutes, '24h' is 24 hours</html>");
        this._timeViewStored_lbl.setToolTipText("You are viewing data that has been stored in the In Memory Counter Storage or the Persistent Counter Storage");
        this._timeOfflineRewind_but.setToolTipText("Get privious sample with data");
        this._timeOfflineRewind_but.setIcon(SwingUtils.readImageIcon(Version.class, "images/offline_rewind.png"));
        this._timeOfflineRewind_but.setText(null);
        this._timeOfflineRewind_but.setContentAreaFilled(false);
        this._timeOfflineRewind_but.setMargin(new Insets(0, 0, 0, 0));
        this._timeOfflineRewind_but.setVisible(false);
        this._timeOfflineFastForward_but.setToolTipText("Get next sample with data");
        this._timeOfflineFastForward_but.setIcon(SwingUtils.readImageIcon(Version.class, "images/offline_fastforward.png"));
        this._timeOfflineFastForward_but.setText(null);
        this._timeOfflineFastForward_but.setContentAreaFilled(false);
        this._timeOfflineFastForward_but.setMargin(new Insets(0, 0, 0, 0));
        this._timeOfflineFastForward_but.setVisible(false);
        panel.add((Component)this._timeClear_lbl, "");
        panel.add((Component)this._timeClear_txt, "width 132lp!, growx, wrap");
        panel.add((Component)this._timeSample_lbl, "");
        panel.add((Component)this._timeSample_txt, "width 132lp!, growx, wrap");
        panel.add((Component)this._timeIntervall_lbl, "");
        panel.add((Component)this._timeIntervall_txt, "width 132lp!, growx, wrap");
        panel.add((Component)this._timePostpone_lbl, "hidemode 3");
        panel.add((Component)this._timePostpone_txt, "hidemode 3, growx, wrap");
        panel.add((Component)this._timeOfflineRewind_but, "hidemode 3, left, bottom, span 2, split 3");
        panel.add((Component)this._timeViewStored_lbl, "hidemode 3, growx, center, bottom");
        panel.add((Component)this._timeOfflineFastForward_but, "hidemode 3, right,  bottom");
        return panel;
    }

    private JPanel createOptionsPanel() {
        JPanel panel = SwingUtils.createPanel("Options", true);
        panel.setLayout((LayoutManager)new MigLayout("ins 0, gap 0", "", "0[0]0"));
        this._optionPauseDataPolling_chk.setToolTipText("<html>Pause data polling for this Tab. This makes the values easier to read...</html>");
        this._optionEnableBgPolling_chk.setToolTipText("<html>Sample this panel even when this Tab is not active.<br><b>Note:</b> If there are active graphs attached, it implies that data will be sampled even if this option is <b>not</b> enabled.</html>");
        this._optionHasActiveGraphs_lbl.setToolTipText("<html>Just an indicator if any Graphs are active or not, if this is true it means that this Performance Counter will be refreshed.</html>");
        this._optionPersistCounters_chk.setToolTipText("<html>Save this counter set to a Persistent storage, even when we are in GUI mode.<br>Note: This is only enabled/available if you specified a Counter Storage when you connected.</html>");
        this._optionPersistCountersAbs_chk.setToolTipText("<html>Store Absolute Counter values.</html>");
        this._optionPersistCountersDiff_chk.setToolTipText("<html>Store Difference Calculation between two samples.</html>");
        this._optionPersistCountersRate_chk.setToolTipText("<html>Store the Calculated Numers per Second.</html>");
        this._optionNegativeDiffCntToZero_chk.setToolTipText("<html>If the differance between 'this' and 'previous' data sample has negative counter values, reset them to be <b>zero</b><p>This is good for most data tables, meaning if sp_sysmon resets the counters or counters wrap...<p>It's not good for data tables where we want to watch counters that grows and shrinks, for example \"procedure cache memory usage\".</html>");
        TrendGraph.createGraphAccessButton(this._optionTrendGraphs_but, this._displayName);
        this._optionHasActiveGraphs_lbl.setVisible(false);
        this._optionTrendGraphs_but.setVisible(false);
        panel.add((Component)this._optionPauseDataPolling_chk, "push, grow, left, split");
        panel.add((Component)this._optionHasActiveGraphs_lbl, "top");
        panel.add((Component)this._optionTrendGraphs_but, "top, wrap");
        panel.add((Component)this._optionEnableBgPolling_chk, "wrap");
        panel.add((Component)this._optionPersistCounters_chk, "split 4");
        panel.add((Component)this._optionPersistCountersAbs_chk, "");
        panel.add((Component)this._optionPersistCountersDiff_chk, "");
        panel.add((Component)this._optionPersistCountersRate_chk, "wrap");
        panel.add((Component)this._optionNegativeDiffCntToZero_chk, "wrap");
        return panel;
    }

    protected JPanel createLocalOptionsPanel() {
        return null;
    }

    private JPanel createExtendedInfoPanel() {
        JPanel panel = SwingUtils.createPanel("Extended Information", false);
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JScrollPane(this.createTreeSpSysmon()), "Center");
        panel.setPreferredSize(new Dimension(0, 0));
        panel.setMinimumSize(new Dimension(0, 0));
        return panel;
    }

    private JTree createTreeSpSysmon() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("sp_sysmon");
        DefaultMutableTreeNode heading = new DefaultMutableTreeNode("");
        DefaultMutableTreeNode subHead = new DefaultMutableTreeNode("");
        heading = new DefaultMutableTreeNode("Kernel Utilization");
        top.add(heading);
        subHead = new DefaultMutableTreeNode("Config");
        heading.add(subHead);
        subHead.add(new DefaultMutableTreeNode("Runnable Process Search Count"));
        subHead.add(new DefaultMutableTreeNode("I/O Polling Process Count"));
        subHead = new DefaultMutableTreeNode("Engine Busy Utilization");
        heading.add(subHead);
        subHead.add(new DefaultMutableTreeNode("Engine 0"));
        subHead = new DefaultMutableTreeNode("CPU Yields by Engine");
        heading.add(subHead);
        subHead.add(new DefaultMutableTreeNode("Engine 0"));
        subHead = new DefaultMutableTreeNode("Network Checks");
        heading.add(subHead);
        subHead.add(new DefaultMutableTreeNode("Non-Blocking"));
        subHead.add(new DefaultMutableTreeNode("Blocking"));
        subHead.add(new DefaultMutableTreeNode("Total Network I/O Checks"));
        subHead.add(new DefaultMutableTreeNode("Avg Net I/Os per Check"));
        subHead = new DefaultMutableTreeNode("Disk I/O Checks");
        heading.add(subHead);
        subHead.add(new DefaultMutableTreeNode("Total Disk I/O Checks"));
        subHead.add(new DefaultMutableTreeNode("Checks Returning I/O"));
        subHead.add(new DefaultMutableTreeNode("Avg Disk I/Os Returned"));
        heading = new DefaultMutableTreeNode("Worker Process Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Parallel Query Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Task Management");
        top.add(heading);
        subHead = new DefaultMutableTreeNode("Task Context Switches by Engine");
        heading.add(subHead);
        subHead.add(new DefaultMutableTreeNode("Engine 0"));
        subHead = new DefaultMutableTreeNode("Task Context Switches Due To");
        heading.add(subHead);
        subHead.add(new DefaultMutableTreeNode("Voluntary Yields"));
        subHead.add(new DefaultMutableTreeNode("Cache Search Misses"));
        subHead.add(new DefaultMutableTreeNode("Exceeding I/O batch size"));
        subHead.add(new DefaultMutableTreeNode("System Disk Writes"));
        subHead.add(new DefaultMutableTreeNode("Logical Lock Contention"));
        subHead.add(new DefaultMutableTreeNode("Address Lock Contention"));
        subHead.add(new DefaultMutableTreeNode("Latch Contention"));
        subHead.add(new DefaultMutableTreeNode("Log Semaphore Contention"));
        subHead.add(new DefaultMutableTreeNode("PLC Lock Contention"));
        subHead.add(new DefaultMutableTreeNode("Group Commit Sleeps"));
        subHead.add(new DefaultMutableTreeNode("Last Log Page Writes"));
        subHead.add(new DefaultMutableTreeNode("Modify Conflicts"));
        subHead.add(new DefaultMutableTreeNode("I/O Device Contention"));
        subHead.add(new DefaultMutableTreeNode("Network Packet Received"));
        subHead.add(new DefaultMutableTreeNode("Network Packet Sent"));
        subHead.add(new DefaultMutableTreeNode("Network services"));
        subHead.add(new DefaultMutableTreeNode("Other Causes"));
        heading = new DefaultMutableTreeNode("Application Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("ESP Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Transaction Profile");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Transaction Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Index Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Metadata Cache Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Lock Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Data Cache Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Procedure Cache Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Memory Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Recovery Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Disk I/O Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Network I/O Management");
        top.add(heading);
        heading = new DefaultMutableTreeNode("Replication Agent");
        top.add(heading);
        return new JTree(new DefaultTreeModel(top));
    }

    private JPanel createTablePanel() {
        JPanel panel = SwingUtils.createPanel("Actual Data Table", false);
        panel.setLayout(new BorderLayout());
        this._dataTable.setSelectionMode(0);
        this._dataTable.setAutoResizeMode(0);
        this._dataTable.packAll();
        this._dataTable.setSortable(true);
        this._dataTable.setColumnControlVisible(true);
        this._dataTable.setHighlighters(this._highliters);
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf != null) {
            if (conf.getBooleanProperty("table.setSelectionBackground", true)) {
                Color newBg = new Color(conf.getIntProperty("table.setSelectionBackground.r", 178), conf.getIntProperty("table.setSelectionBackground.g", 180), conf.getIntProperty("table.setSelectionBackground.b", 191));
                _logger.debug((Object)("table.setSelectionBackground(" + newBg + ")."));
                this._dataTable.setSelectionBackground(newBg);
            }
        } else {
            Color bgc = this._dataTable.getSelectionBackground();
            if (bgc.getRed() != 178 || bgc.getGreen() != 180 || bgc.getBlue() != 191) {
                Color newBg = new Color(178, 180, 191);
                _logger.debug((Object)("table.setSelectionBackground(" + newBg + "). Config could not be read, trusting defaults..."));
                this._dataTable.setSelectionBackground(newBg);
            }
        }
        JScrollPane scroll = new JScrollPane((Component)((Object)this._dataTable));
        this._watermark = new Watermark(scroll, "Not Connected...");
        panel.add(scroll);
        return panel;
    }

    private void initComponentActions() {
        this._filterColumn_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.filterAction(e, "COLUMN");
                TabularCntrPanel.this.saveFilterProps();
            }
        });
        this._filterOperation_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.filterAction(e, "OPERATION");
                TabularCntrPanel.this.saveFilterProps();
            }
        });
        this._filterValue_tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.filterAction(e, "VALUE");
                TabularCntrPanel.this.saveFilterProps();
            }
        });
        this._filterNoZeroCounters_chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.filterAction(e, "NO_ZERO_COUNTERS");
                TabularCntrPanel.this.saveFilterProps();
            }
        });
        this._counterAbs_rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CountersModel cm = TabularCntrPanel.this._cm;
                if (!TabularCntrPanel.this._tailMode) {
                    cm = TabularCntrPanel.this._cmDisplay;
                }
                if (cm != null) {
                    cm.setDataSource(1);
                }
            }
        });
        this._counterDelta_rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CountersModel cm = TabularCntrPanel.this._cm;
                if (!TabularCntrPanel.this._tailMode) {
                    cm = TabularCntrPanel.this._cmDisplay;
                }
                if (cm != null) {
                    cm.setDataSource(2);
                }
            }
        });
        this._counterRate_rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CountersModel cm = TabularCntrPanel.this._cm;
                if (!TabularCntrPanel.this._tailMode) {
                    cm = TabularCntrPanel.this._cmDisplay;
                }
                if (cm != null) {
                    cm.setDataSource(3);
                }
            }
        });
        this._timePostpone_txt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CountersModel cm;
                int postponeTime = TabularCntrPanel.parsePostponeTime(TabularCntrPanel.this._timePostpone_txt.getText(), true);
                if (postponeTime >= 0 && (cm = TabularCntrPanel.this._cm) != null) {
                    cm.setPostponeTime(postponeTime, true);
                }
            }
        });
        this._timeOfflineRewind_but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Timestamp sampleId = null;
                Timestamp currentSampleTime = null;
                String cmName = null;
                CountersModel cm = TabularCntrPanel.this._cmDisplay;
                if (cm != null) {
                    sampleId = cm.getSampleTimeHead();
                    currentSampleTime = cm.getSampleTimeHead();
                    cmName = cm.getName();
                } else {
                    sampleId = MainFrame.getInstance().getCurrentSliderTs();
                    currentSampleTime = MainFrame.getInstance().getCurrentSliderTs();
                    cmName = TabularCntrPanel.this._cm.getName();
                }
                if (sampleId == null) {
                    return;
                }
                if (currentSampleTime == null) {
                    return;
                }
                if (cmName == null) {
                    return;
                }
                PersistReader reader = PersistReader.getInstance();
                if (reader == null) {
                    throw new RuntimeException("The 'PersistReader' has not been initialized.");
                }
                Timestamp ts = reader.getPrevSample(sampleId, currentSampleTime, cmName);
                if (ts != null) {
                    reader.loadSessionCmIndicators(ts);
                    reader.loadSummaryCm(ts);
                }
            }
        });
        this._timeOfflineFastForward_but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Timestamp sampleId = null;
                Timestamp currentSampleTime = null;
                String cmName = null;
                CountersModel cm = TabularCntrPanel.this._cmDisplay;
                if (cm != null) {
                    sampleId = cm.getSampleTimeHead();
                    currentSampleTime = cm.getSampleTimeHead();
                    cmName = cm.getName();
                } else {
                    sampleId = MainFrame.getInstance().getCurrentSliderTs();
                    currentSampleTime = MainFrame.getInstance().getCurrentSliderTs();
                    cmName = TabularCntrPanel.this._cm.getName();
                }
                if (sampleId == null) {
                    return;
                }
                if (currentSampleTime == null) {
                    return;
                }
                if (cmName == null) {
                    return;
                }
                PersistReader reader = PersistReader.getInstance();
                if (reader == null) {
                    throw new RuntimeException("The 'PersistReader' has not been initialized.");
                }
                Timestamp ts = reader.getNextSample(sampleId, currentSampleTime, cmName);
                if (ts != null) {
                    reader.loadSessionCmIndicators(ts);
                    reader.loadSummaryCm(ts);
                }
            }
        });
        this._optionPauseDataPolling_chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TabularCntrPanel.this._cm != null) {
                    TabularCntrPanel.this._cm.setPauseDataPolling(TabularCntrPanel.this._optionPauseDataPolling_chk.isSelected(), true);
                }
            }
        });
        this._optionEnableBgPolling_chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TabularCntrPanel.this._cm != null) {
                    TabularCntrPanel.this._cm.setBackgroundDataPollingEnabled(TabularCntrPanel.this._optionEnableBgPolling_chk.isSelected(), true);
                }
            }
        });
        this._optionPersistCounters_chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TabularCntrPanel.this._cm != null) {
                    TabularCntrPanel.this._cm.setPersistCounters(TabularCntrPanel.this._optionPersistCounters_chk.isSelected(), true);
                }
            }
        });
        this._optionPersistCountersAbs_chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TabularCntrPanel.this._cm != null) {
                    TabularCntrPanel.this._cm.setPersistCountersAbs(TabularCntrPanel.this._optionPersistCountersAbs_chk.isSelected(), true);
                }
            }
        });
        this._optionPersistCountersDiff_chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TabularCntrPanel.this._cm != null) {
                    TabularCntrPanel.this._cm.setPersistCountersDiff(TabularCntrPanel.this._optionPersistCountersDiff_chk.isSelected(), true);
                }
            }
        });
        this._optionPersistCountersRate_chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TabularCntrPanel.this._cm != null) {
                    TabularCntrPanel.this._cm.setPersistCountersRate(TabularCntrPanel.this._optionPersistCountersRate_chk.isSelected(), true);
                }
            }
        });
        this._optionNegativeDiffCntToZero_chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TabularCntrPanel.this._cm != null) {
                    TabularCntrPanel.this._cm.setNegativeDiffCountersToZero(TabularCntrPanel.this._optionNegativeDiffCntToZero_chk.isSelected(), true);
                }
            }
        });
    }

    private void filterAction(ActionEvent e, String type) {
        if ("NO_ZERO_COUNTERS".equals(type)) {
            if (this._filterNoZeroCounters_chk.isSelected()) {
                CountersModel cm = this._cm;
                if (!this._tailMode) {
                    cm = this._cmDisplay;
                }
                if (cm != null) {
                    this._tableRowFilterIsSet = this._tableRowFilter.equals(this._dataTable.getRowFilter());
                    if (!this._tableRowFilterIsSet) {
                        this._tableRowFilterIsSet = true;
                        _logger.debug((Object)"No table filter was priviously set, so lets set it now.");
                        this._dataTable.setRowFilter(this._tableRowFilter);
                    }
                    this._tableRowFilterDiffCntIsZero.setFilter((JTable)((Object)this._dataTable), cm.getDiffColumns(), cm.getDiffDissColumns());
                }
            } else {
                this._tableRowFilterDiffCntIsZero.resetFilter();
            }
            this.setWatermark();
            return;
        }
        int opIndex = this._filterOperation_cb.getSelectedIndex();
        String column = (String)this._filterColumn_cb.getSelectedItem();
        String opStr = (String)this._filterOperation_cb.getSelectedItem();
        String text = this._filterValue_tf.getText();
        _logger.debug((Object)("FILTER: col='" + column + "', op='" + opStr + "', opIndex=" + opIndex + ", text='" + text + "', clazz='--'."));
        if (this._tableRowFilterValAndOp == null || column == null || text == null) {
            return;
        }
        if (column.equals(FILTER_NO_COLUMN_IS_SELECTED) || text.trim().equals("")) {
            this._tableRowFilterValAndOp.resetFilter();
        } else {
            try {
                int col = ((AbstractTableModel)this._dataTable.getModel()).findColumn(column);
                this._tableRowFilterIsSet = this._tableRowFilter.equals(this._dataTable.getRowFilter());
                if (!this._tableRowFilterIsSet) {
                    this._tableRowFilterIsSet = true;
                    _logger.debug((Object)"No table filter was priviously set, so lets set it now.");
                    this._dataTable.setRowFilter(this._tableRowFilter);
                }
                this._tableRowFilterValAndOp.setFilter(opIndex, col, text);
            }
            catch (IllegalArgumentException ex) {
                _logger.info((Object)("Cant find column '" + column + "' in the datatable '" + this._dataTable.getName() + "'."));
            }
        }
        this.setWatermark();
    }

    public void setAutoAdjustTableColumnWidth(AutoAdjustTableColumnWidth val) {
        if (val == null) {
            return;
        }
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        if (tmpConf != null) {
            tmpConf.setProperty(this.getPanelName() + ".autoAdjustTableColumnWidth", val.toString());
            tmpConf.save();
        }
    }

    public boolean doAutoAdjustTableColumnWidth() {
        String headerProps;
        Configuration conf = Configuration.getCombinedConfiguration();
        boolean doAdjust = false;
        doAdjust = conf.getBooleanProperty("TabularCntrPanel.autoAdjustTableColumnWidth", doAdjust);
        String key = this.getPanelName() + ".autoAdjustTableColumnWidth";
        String autoAdjustTableColumnWidth = conf.getProperty(this.getPanelName() + ".autoAdjustTableColumnWidth", AutoAdjustTableColumnWidth.GLOBAL.toString());
        if (!autoAdjustTableColumnWidth.equals(AutoAdjustTableColumnWidth.GLOBAL.toString())) {
            if (autoAdjustTableColumnWidth.equals(AutoAdjustTableColumnWidth.AUTO_ON.toString())) {
                doAdjust = true;
            } else if (autoAdjustTableColumnWidth.equals(AutoAdjustTableColumnWidth.AUTO_OFF.toString())) {
                doAdjust = false;
            } else {
                _logger.warn((Object)(this.getPanelName() + " Can't find appropriate value for " + key + " = '" + autoAdjustTableColumnWidth + "'."));
            }
        }
        if ((headerProps = conf.getProperty(this.getName() + ".gui.column.header.props")) == null) {
            doAdjust = true;
        }
        return doAdjust;
    }

    public static int parsePostponeTime(String postponeStr, boolean guiError) {
        if (postponeStr == null) {
            return 0;
        }
        if ((postponeStr = postponeStr.trim()).equals("")) {
            return 0;
        }
        try {
            int postponeTime = 0;
            int multiplyBy = 1;
            if (postponeStr.endsWith("M") || postponeStr.endsWith("m")) {
                multiplyBy = 60;
                postponeStr = postponeStr.substring(0, postponeStr.length() - 1);
            }
            if (postponeStr.endsWith("H") || postponeStr.endsWith("h")) {
                multiplyBy = 3600;
                postponeStr = postponeStr.substring(0, postponeStr.length() - 1);
            }
            postponeTime = Integer.parseInt(postponeStr.trim()) * multiplyBy;
            return postponeTime;
        }
        catch (NumberFormatException ex) {
            if (guiError) {
                SwingUtils.showInfoMessage(null, "Not a Number", "The postpone needs to be specified as a number.");
            } else {
                _logger.warn((Object)"The postpone needs to be specified as a number.");
            }
            return -1;
        }
    }

    protected void saveProps() {
    }

    protected void saveFilterProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            return;
        }
        if (this._dataTable.getColumnCount() == 0) {
            return;
        }
        if (this._filterColumn_cb.getItemCount() <= 1) {
            return;
        }
        String cmName = this.getName();
        if (cmName == null) {
            _logger.warn((Object)"Can't save Filters, because the JTable has not been assigned a name. getName() on the JTable is null.");
            return;
        }
        String keyPrefix = cmName + ".filter.";
        conf.setProperty(keyPrefix + "column", this._filterColumn_cb.getSelectedItem().toString());
        conf.setProperty(keyPrefix + "operation", FILTER_OP_STR_ARR_SHORT[this._filterOperation_cb.getSelectedIndex()]);
        conf.setProperty(keyPrefix + "value", this._filterValue_tf.getText());
        conf.setProperty(keyPrefix + "noZeroCounter", this._filterNoZeroCounters_chk.isSelected());
        conf.save();
    }

    protected void loadFilterProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            return;
        }
        String cmName = this.getName();
        if (cmName == null) {
            _logger.warn((Object)"Can't load Filters, because the JTable has not been assigned a name. getName() on the JTable is null.");
            return;
        }
        String keyPrefix = cmName + ".filter.";
        String column = conf.getProperty(keyPrefix + "column");
        String operation = conf.getProperty(keyPrefix + "operation");
        String value = conf.getProperty(keyPrefix + "value");
        String noZeroCounter = conf.getProperty(keyPrefix + "noZeroCounter");
        if (column != null) {
            this._filterColumn_cb.setSelectedItem(column);
        }
        if (operation != null) {
            int opIndex = 0;
            for (int i = 0; i < FILTER_OP_STR_ARR_SHORT.length; ++i) {
                if (!operation.equals(FILTER_OP_STR_ARR_SHORT[i])) continue;
                opIndex = i;
            }
            this._filterOperation_cb.setSelectedIndex(opIndex);
        }
        if (value != null) {
            this._filterValue_tf.setText(value);
        }
        if (noZeroCounter != null) {
            this._filterNoZeroCounters_chk.setSelected(noZeroCounter.equalsIgnoreCase("true"));
        }
        if (column != null || operation != null || value != null) {
            this.filterAction(null, "COLUMN,OPERATION,VALUE");
        }
        if (noZeroCounter != null) {
            this.filterAction(null, "NO_ZERO_COUNTERS");
        }
    }

    public void addHighlighter(Highlighter highlighter) {
        this._dataTable.addHighlighter(highlighter);
    }

    public void setWatermarkText(String str) {
        _logger.debug((Object)(this._displayName + ".setWatermarkText('" + str + "')"));
        this._watermark.setWatermarkText(str);
    }

    public void setWatermark() {
        if (MainFrame.isOfflineConnected()) {
            PersistReader read = PersistReader.getInstance();
            if (read == null) {
                this.setWatermarkText("No 'PersistReader' instance.");
            } else if (this._offlineCm == null) {
                if (this._offlineSampleTime == null) {
                    this.setWatermarkText("Choose a sample period from the\nOffline Sessions Viewer first.");
                } else if (this._offlineSampleHasBeenRead) {
                    this.setWatermarkText("No offline data for this tab exists.");
                } else {
                    this.setWatermarkText("Reading offline data...");
                }
            } else {
                this.setWatermarkText("O f f l i n e  - D a t a");
            }
        } else if (this._tailMode) {
            this._optionHasActiveGraphs_lbl.setVisible(this._cm.hasActiveGraphs());
            this._optionTrendGraphs_but.setVisible(this._cm.hasTrendGraph());
            if (!this._cm.isConnected()) {
                this.setWatermarkText("Not Connected...");
            } else if (this._cm.isDataPollingPaused()) {
                this.setWatermarkText("Paused...");
            } else if (!this._cm.isActive()) {
                this.setWatermarkText(this._cm.getProblemDesc());
            } else if (this._cm.getSampleException() != null) {
                this.setWatermarkText(this._cm.getSampleException().toString().replaceFirst(": ", ": \n").replaceAll("\\. ", "\\. \n"));
            } else if (this._cm.getTimeToNextPostponedRefresh() > 0L) {
                this.setWatermarkText("Postponing next sample refresh until '" + TimeUtils.msToTimeStr("%HH:%MM:%SS", this._cm.getTimeToNextPostponedRefresh()) + "'.");
            } else if (this._cm.getDependantCmThatHasPostponeTime() != null) {
                CountersModel dcm = this._cm.getDependantCmThatHasPostponeTime();
                this.setWatermarkText("Postponing next sample refresh until '" + TimeUtils.msToTimeStr("%HH:%MM:%SS", dcm.getTimeToNextPostponedRefresh()) + "'.\n" + "Waiting for dependant Performance Counter '" + dcm.getDisplayName() + "'.");
            } else if (!this._cm.hasAbsData()) {
                this.setWatermarkText("Waiting for first data sample...");
            } else if (this._cm.isDiffCalcEnabled() && !this._cm.hasDiffData()) {
                this.setWatermarkText("Waiting for second sample, before DIFF and RATE can be calculated...");
            } else if (this._dataTable.getColumnCount() == 0) {
                this.setWatermarkText("No columns in the table...");
            } else if (this._dataTable.getModel().getRowCount() == 0) {
                this.setWatermarkText("No rows in the table model...");
            } else if (this._dataTable.getRowCount() == 0) {
                this.setWatermarkText("No visible rows in the table... Is filtering on?");
            } else {
                this.setWatermarkText(null);
            }
        } else if (this._cmDisplay == null) {
            this.setWatermarkText("No Stored data for the intervall was found.");
        } else if (!this._cmDisplay.hasDiffData()) {
            this.setWatermarkText("No DIFF and RATE data, this might be first sample?");
        } else if (this._dataTable.getModel().getRowCount() == 0) {
            this.setWatermarkText("No rows in the table model...");
        } else if (this._dataTable.getRowCount() == 0) {
            this.setWatermarkText("No visible rows in the table... Is filtering on?");
        } else {
            this.setWatermarkText(null);
        }
        this.paintTabHeader(null);
        this._counterRows_lbl.setText(this._dataTable.getModel().getRowCount() + " / " + this._dataTable.getRowCount());
    }

    public void tabSelected() {
        if (MainFrame.isOfflineConnected()) {
            if (!this._offlineSampleHasBeenRead) {
                this.readOfflineSample_withProgressDialog();
            }
        } else if (!this._tailMode && !this._inMemHistSampleHasBeenRead) {
            this.readInMemHistSample();
        }
    }

    public void setInMemHistSampleTime(CountersModel cm, Timestamp ts) {
        this._inMemHistSampleTime = ts;
        this._inMemHistSampleHasBeenRead = false;
        if (cm != null) {
            this._inMemHistCm = cm;
        } else {
            InMemoryCounterHandler imch = InMemoryCounterHandler.getInstance();
            if (imch == null) {
                return;
            }
            this._inMemHistCm = imch.getCmForSample(this.getName(), this._inMemHistSampleTime);
        }
    }

    public void readInMemHistSample() {
        InMemoryCounterHandler imch = InMemoryCounterHandler.getInstance();
        if (imch == null) {
            return;
        }
        if (this._inMemHistSampleTime == null) {
            _logger.warn((Object)"In Memory History Sample Time has not been set...");
            return;
        }
        this._inMemHistRefreshTimer.start();
        this.setDisplayCm(this._inMemHistCm, false);
        if (this._inMemHistCm == null) {
            _logger.debug((Object)("readInMemHistSample('" + this._inMemHistSampleTime + "'): cm=null"));
        }
        this._inMemHistSampleHasBeenRead = true;
        this._inMemHistRefreshTimer.stop();
        this.setWatermark();
    }

    public void setOfflineSampleTime(Timestamp ts) {
        this._offlineSampleTime = ts;
        this._offlineSampleHasBeenRead = false;
    }

    public void readOfflineSample_withProgressDialog() {
        final String name = this.getName();
        final PersistReader read = PersistReader.getInstance();
        if (read == null) {
            return;
        }
        if (this._offlineSampleTime == null) {
            _logger.warn((Object)"Offline Sample Time has not been set...");
            return;
        }
        SwingWorker<String, Object> readOfflineThread = new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                TabularCntrPanel.this._offlineCm = read.getCmForSample(name, TabularCntrPanel.this._offlineSampleTime);
                return TabularCntrPanel.this._offlineCm == null ? "FAILED" : "SUCCEED";
            }
        };
        JDialog dialog = new JDialog((Frame)null, "Waiting for offline read...", true);
        JLabel label = new JLabel("Reading data from offline storage", 0);
        label.setFont(new Font("Dialog", 1, 16));
        dialog.add(label);
        dialog.pack();
        dialog.setSize(dialog.getSize().width + 100, dialog.getSize().height + 70);
        dialog.setLocationRelativeTo(this);
        readOfflineThread.addPropertyChangeListener(new SwingWorkerCompletionWaiter(dialog));
        readOfflineThread.execute();
        dialog.setVisible(true);
        System.out.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.setDisplayCm(this._offlineCm, false);
        if (this._offlineCm == null) {
            _logger.debug((Object)("readOfflineSample('" + this._offlineSampleTime + "'): _cmOffline=null"));
        }
        this._offlineSampleHasBeenRead = true;
        this.setWatermark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readOfflineSample() {
        PersistReader read = PersistReader.getInstance();
        if (read == null) {
            return;
        }
        if (this._offlineSampleTime == null) {
            _logger.warn((Object)"Offline Sample Time has not been set...");
            return;
        }
        try {
            this.setWatermarkText("Getting offline data...");
            this.setCursor(Cursor.getPredefinedCursor(3));
            this._offlineCm = read.getCmForSample(this.getName(), this._offlineSampleTime);
            this.setDisplayCm(this._offlineCm, false);
            if (this._offlineCm == null) {
                _logger.debug((Object)("readOfflineSample('" + this._offlineSampleTime + "'): _cmOffline=null"));
            }
            this._offlineSampleHasBeenRead = true;
        }
        finally {
            this.setWatermark();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void paintTabHeader(Graphics2D g) {
        if (this._icon == null) {
            return;
        }
        if (this.hasValidSampleData()) {
            JTabbedPane jtp;
            int jtpIndex;
            if (this._indicatorIcon == null) {
                BufferedImage im = new BufferedImage(this._icon.getIconWidth() + 2, this._icon.getIconHeight(), 3);
                Graphics2D img = im.createGraphics();
                img.setColor(Color.GREEN);
                if (this._indicatorToLeft) {
                    this._icon.paintIcon(null, img, 2, 0);
                    img.fillRect(0, 0, 2, this._icon.getIconHeight());
                } else {
                    this._icon.paintIcon(null, img, 0, 0);
                    img.fillRect(this._icon.getIconWidth(), 0, 2, this._icon.getIconHeight());
                }
                this._indicatorIcon = new ImageIcon(im);
            }
            if ((jtpIndex = (jtp = MainFrame.getTabbedPane()).indexOfTab(this._icon)) != -1) {
                jtp.setIconAt(jtpIndex, this._indicatorIcon);
            }
        } else {
            JTabbedPane jtp = MainFrame.getTabbedPane();
            int jtpIndex = jtp.indexOfTab(this._indicatorIcon);
            if (jtpIndex != -1) {
                jtp.setIconAt(jtpIndex, this._icon);
            }
        }
    }

    public boolean hasValidSampleData() {
        if (MainFrame.isOfflineConnected()) {
            PersistReader reader = PersistReader.getInstance();
            if (reader == null) {
                return false;
            }
            return reader.hasCountersForCm(this._cm.getName());
        }
        if (this._tailMode) {
            return this._cm.hasValidSampleData();
        }
        return this._inMemHistCm != null && this._inMemHistCm.hasValidSampleData();
    }

    public void checkLocalComponents() {
    }

    public void sortDatatable() {
        RowSorter rowSorter = this._dataTable.getRowSorter();
        if (rowSorter instanceof DefaultRowSorter) {
            DefaultRowSorter drs = (DefaultRowSorter)rowSorter;
            drs.sort();
        } else {
            rowSorter.allRowsChanged();
        }
    }

    private class OfflineRefreshTimerAction
    implements ActionListener {
        private OfflineRefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            TabularCntrPanel.this.setWatermarkText("Getting offline data...");
        }
    }

    private class SwingWorkerCompletionWaiter
    implements PropertyChangeListener {
        private JDialog _dialog;

        public SwingWorkerCompletionWaiter(JDialog dialog) {
            this._dialog = dialog;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE == event.getNewValue()) {
                this._dialog.setVisible(false);
                this._dialog.dispose();
            }
        }
    }

    private class InMemHistRefreshTimerAction
    implements ActionListener {
        private InMemHistRefreshTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            TabularCntrPanel.this.setWatermarkText("Getting In-Memory data...");
        }
    }

    private class ShowPropertiesDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private JButton _ok_but;

        private ShowPropertiesDialog(Frame owner) {
            super(owner);
            this._ok_but = new JButton("OK");
            if (TabularCntrPanel.this._icon != null && TabularCntrPanel.this._icon instanceof ImageIcon) {
                ((Frame)this.getOwner()).setIconImage(((ImageIcon)TabularCntrPanel.this._icon).getImage());
            }
            this.initComponents();
            this.pack();
            Dimension size = this.getPreferredSize();
            size.width = 700;
            this.setPreferredSize(size);
            this.setSize(size);
            this.setLocationRelativeTo(owner);
            this.setVisible(true);
        }

        protected void initComponents() {
            this.setTitle("Properties: " + TabularCntrPanel.this._cm.getName());
            JPanel panel = new JPanel();
            panel.setLayout((LayoutManager)new MigLayout("ins 0", "[fill]", ""));
            panel.add((Component)this.init(), "height 100%, wrap 15");
            panel.add((Component)this._ok_but, "tag ok, gapright 15, bottom, right, pushx, wrap 15");
            this.setContentPane(panel);
            this._ok_but.addActionListener(this);
        }

        protected JPanel init() {
            JPanel panel = new JPanel();
            panel.setLayout((LayoutManager)new MigLayout("insets 20 20 20 20", "[grow]", ""));
            String sqlInit = TabularCntrPanel.this._cm.getSqlInit();
            String sqlExec = TabularCntrPanel.this._cm.getSql();
            String sqlWhere = TabularCntrPanel.this._cm.getSqlWhere();
            String sqlClose = TabularCntrPanel.this._cm.getSqlClose();
            if (sqlInit != null) {
                sqlInit = sqlInit.replaceAll("\\n", "<br>");
            }
            if (sqlExec != null) {
                sqlExec = sqlExec.replaceAll("\\n", "<br>");
            }
            if (sqlWhere != null) {
                sqlWhere = sqlWhere.replaceAll("\\n", "<br>");
            }
            if (sqlClose != null) {
                sqlClose = sqlClose.replaceAll("\\n", "<br>");
            }
            if (sqlInit == null) {
                sqlInit = "";
            }
            if (sqlExec == null) {
                sqlExec = "";
            }
            if (sqlWhere == null) {
                sqlWhere = "";
            }
            if (sqlClose == null) {
                sqlClose = "";
            }
            List<String> pkList = TabularCntrPanel.this._cm.getPk();
            Object[] diffCols = TabularCntrPanel.this._cm.getDiffColumns();
            Object[] pctCols = TabularCntrPanel.this._cm.getPctColumns();
            if (pkList != null) {
                for (String col : pkList) {
                    sqlExec = sqlExec.replaceFirst(col, "<b>" + col + "</b>");
                }
            }
            for (String string : diffCols) {
                sqlExec = sqlExec.replaceFirst(string, "<font color=\"#0000FF\">" + string + "</font>");
            }
            for (String string : pctCols) {
                sqlExec = sqlExec.replaceFirst(string, "<font color=\"#FF0000\">" + string + "</font>");
            }
            String str = "<html><HEAD> <style type=\"text/css\"> <!-- body {font-family: Arial, Helvetica, sans-serif;} --> </style> </HEAD> <H1>" + TabularCntrPanel.this._cm.getName() + "</H1>" + "<H2>SQL Init</H2>" + sqlInit + "<H2>SQL</H2>" + sqlExec + "<br><b>Color Code Explanation:</b> <br>" + "- Primary Key Columns in <b>BOLD</b><br>" + "- Diff Columns in <font color=\"#0000FF\">BLUE</font><br>" + "- Pct Columns in <font color=\"#FF0000\">RED</font>)" + "<H2>Extra Where clauses</H2>" + sqlWhere + "<H2>SQL Close</H2>" + sqlClose + "<H2>Primary Key Columns</H2>" + pkList + "<H2>Diff Columns</H2>" + Arrays.deepToString(diffCols) + "<H2>Pct Columns</H2>" + Arrays.deepToString(pctCols) + "</html>";
            JEditorPane feedback = new JEditorPane("text/html", str);
            feedback.setEditable(false);
            feedback.setOpaque(false);
            panel.add((Component)feedback, "wrap 20");
            return panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._ok_but.equals(e.getSource())) {
                this.dispose();
            }
        }
    }

    private class Watermark
    extends AbstractComponentDecorator {
        private String _restartText;
        private String[] _textBr;
        private String _textSave;
        private Graphics2D g;
        private Rectangle r;

        public Watermark(JComponent target, String text) {
            super(target);
            this._restartText = "Note: Restart Asemon after you have enabled the configuration.";
            this._textBr = null;
            this._textSave = null;
            this.g = null;
            this.r = null;
            if (text == null) {
                text = "";
            }
            this._textSave = text;
            this._textBr = text.split("\n");
        }

        @Override
        public void paint(Graphics graphics) {
            if (this._textBr == null || this._textBr != null && this._textBr.length < 0) {
                return;
            }
            this.r = this.getDecorationBounds();
            this.g = (Graphics2D)graphics;
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font f = this.g.getFont();
            this.g.setFont(f.deriveFont(1, (float)f.getSize() * 2.0f));
            this.g.setColor(new Color(128, 128, 128, 128));
            FontMetrics fm = this.g.getFontMetrics();
            int maxStrWidth = 0;
            int maxStrHeight = fm.getHeight();
            for (int i = 0; i < this._textBr.length; ++i) {
                int CurLineStrWidth = fm.stringWidth(this._textBr[i]);
                maxStrWidth = Math.max(maxStrWidth, CurLineStrWidth);
            }
            int xPos = (this.r.width - maxStrWidth) / 2;
            int yPos = (int)((double)this.r.height - (double)((this.r.height - fm.getHeight()) / 2) * 1.3);
            int spConfigureCount = 0;
            for (int i = 0; i < this._textBr.length; ++i) {
                this.g.drawString(this._textBr[i], xPos, yPos + maxStrHeight * i);
                if (!this._textBr[i].startsWith("sp_configure")) continue;
                ++spConfigureCount;
            }
            if (spConfigureCount > 0) {
                int yPosRestartText = yPos + maxStrHeight * (this._textBr.length + 1);
                this.g.drawString(this._restartText, xPos, yPosRestartText);
            }
        }

        public void setWatermarkText(String text) {
            if (text == null) {
                text = "";
            }
            if (text.equals(this._textSave)) {
                return;
            }
            this._textSave = text;
            this._textBr = text.split("\n");
            _logger.debug((Object)("setWatermarkText: to '" + text + "'."));
            this.repaint();
        }
    }

    private static class HighlighterPctData
    extends AbstractHighlighter {
        public HighlighterPctData(HighlightPredicate predicate) {
            super(predicate);
        }

        protected Component doHighlight(Component comp, ComponentAdapter adapter) {
            Object value = adapter.getFilteredValueAt(adapter.row, adapter.convertColumnIndexToModel(adapter.column));
            if (value instanceof Number) {
                comp.setForeground(Color.RED);
                if (((Number)value).doubleValue() != 0.0) {
                    comp.setFont(comp.getFont().deriveFont(1));
                }
            }
            return comp;
        }
    }

    private static class HighlighterDiffData
    extends AbstractHighlighter {
        public HighlighterDiffData(HighlightPredicate predicate) {
            super(predicate);
        }

        protected Component doHighlight(Component comp, ComponentAdapter adapter) {
            Object value = adapter.getFilteredValueAt(adapter.row, adapter.convertColumnIndexToModel(adapter.column));
            if (value instanceof Number) {
                comp.setForeground(Color.BLUE);
                if (((Number)value).doubleValue() != 0.0) {
                    comp.setFont(comp.getFont().deriveFont(1));
                }
            }
            return comp;
        }
    }

    public class TCPTable
    extends JXTable {
        private static final long serialVersionUID = 8891472887299452415L;
        private int _lastMousePressedAtModelCol;
        private int _lastMousePressedAtModelRow;
        private TCPTable _thisTable;
        private boolean _tableStructureChangedFlag;
        protected Timer _columnLayoutTimer;

        private TCPTable() {
            this._lastMousePressedAtModelCol = -1;
            this._lastMousePressedAtModelRow = -1;
            this._thisTable = null;
            this._tableStructureChangedFlag = true;
            this._columnLayoutTimer = null;
            this.init();
        }

        private TCPTable(TableModel tm) {
            super(tm);
            this._lastMousePressedAtModelCol = -1;
            this._lastMousePressedAtModelRow = -1;
            this._thisTable = null;
            this._tableStructureChangedFlag = true;
            this._columnLayoutTimer = null;
            this.init();
        }

        public int getLastMousePressedAtModelCol() {
            return this._lastMousePressedAtModelCol;
        }

        public int getLastMousePressedAtModelRow() {
            return this._lastMousePressedAtModelRow;
        }

        public boolean isLastMousePressedAtModelRowColValid() {
            return this._lastMousePressedAtModelRow >= 0 && this._lastMousePressedAtModelCol >= 0;
        }

        public void setModel(TableModel newModel) {
            super.setModel(newModel);
            this.loadColumnLayout();
        }

        private void init() {
            this._columnLayoutTimer = new Timer(1000, new ColumnLayoutTimerAction(this));
            this._thisTable = this;
            StringValue sv = new StringValue(){
                NumberFormat nf = null;
                {
                    try {
                        this.nf = new DecimalFormat();
                        this.nf.setMinimumFractionDigits(1);
                    }
                    catch (Throwable t) {
                        this.nf = NumberFormat.getInstance();
                    }
                }

                public String getString(Object value) {
                    if (!(value instanceof BigDecimal)) {
                        return StringValues.TO_STRING.getString(value);
                    }
                    return this.nf.format(value);
                }
            };
            this.setDefaultRenderer(BigDecimal.class, (TableCellRenderer)new DefaultTableRenderer(sv, 4));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    TCPTable.this._lastMousePressedAtModelCol = -1;
                    TCPTable.this._lastMousePressedAtModelRow = -1;
                    Point p = new Point(e.getX(), e.getY());
                    int col = TCPTable.this.columnAtPoint(p);
                    int row = TCPTable.this.rowAtPoint(p);
                    if (row >= 0 && col >= 0) {
                        TCPTable.this._lastMousePressedAtModelCol = TCPTable.this.convertColumnIndexToModel(col);
                        TCPTable.this._lastMousePressedAtModelRow = TCPTable.this.convertRowIndexToModel(row);
                    }
                }
            });
            TableColumnModelExtListener columnModelListener = new TableColumnModelExtListener(){

                public void columnPropertyChange(PropertyChangeEvent e) {
                }

                public void columnMarginChanged(ChangeEvent e) {
                    this.columnMovedOrRemoved(null);
                }

                public void columnSelectionChanged(ListSelectionEvent e) {
                }

                public void columnAdded(TableColumnModelEvent e) {
                    if (TCPTable.this._tableStructureChangedFlag && TCPTable.this.getModel().getColumnCount() - 1 == e.getToIndex()) {
                        _logger.debug((Object)("columnAdded(): tabName='" + TCPTable.this.getName() + "', TIME TO LOAD COL ORDER."));
                        TCPTable.this._tableStructureChangedFlag = false;
                        TCPTable.this._thisTable.loadColumnLayout();
                    }
                }

                public void columnRemoved(TableColumnModelEvent e) {
                    this.columnMovedOrRemoved(e);
                }

                public void columnMoved(TableColumnModelEvent e) {
                    this.columnMovedOrRemoved(e);
                }

                private void columnMovedOrRemoved(TableColumnModelEvent e) {
                    if (TCPTable.this._columnLayoutTimer.isRunning()) {
                        TCPTable.this._columnLayoutTimer.restart();
                    } else {
                        TCPTable.this._columnLayoutTimer.start();
                    }
                }
            };
            this.getColumnModel().addColumnModelListener((TableColumnModelListener)columnModelListener);
            this._thisTable.getTableHeader().setDefaultRenderer(new MultiSortTableCellHeaderRenderer());
            this._thisTable.setSortOrderCycle(new SortOrder[]{SortOrder.DESCENDING, SortOrder.ASCENDING, SortOrder.UNSORTED});
        }

        public void printColumnLayout(String prefix) {
            if (this.getColumnCount() == 0) {
                return;
            }
            String cmName = this.getName();
            if (cmName == null) {
                _logger.debug((Object)"Can't print Column Layout, because the JTable has not been assigned a name. getName() on the JTable is null.");
                return;
            }
            TableColumnModel tcm = this.getColumnModel();
            for (TableColumn tc : this.getColumns(true)) {
                TableColumnExt tcx = (TableColumnExt)tc;
                String colName = tc.getHeaderValue().toString();
                boolean colIsVisible = tcx.isVisible();
                SortOrder colSort = this.getSortOrder(colName);
                int colModelPos = tcx.getModelIndex();
                int colViewPos = -1;
                try {
                    colViewPos = tcm.getColumnIndex(colName);
                }
                catch (IllegalArgumentException ignore) {
                    // empty catch block
                }
                System.out.println(prefix + "printColumnLayout() cm='" + cmName + "': colName=" + StringUtil.left(colName, 30) + ", modelPos=" + colModelPos + ", viewPos=" + colViewPos + ", isVisible=" + colIsVisible + ", sort=" + (Object)((Object)colSort) + ", identifier='" + tcx.getIdentifier() + "', toString=" + tc);
            }
        }

        public void loadColumnLayout() {
            int i;
            Configuration conf = Configuration.getCombinedConfiguration();
            if (conf == null) {
                return;
            }
            if (this.getColumnCount() == 0) {
                return;
            }
            String cmName = this.getName();
            if (cmName == null) {
                _logger.debug((Object)"Can't load Column Layout, because the JTable has not been assigned a name. getName() on the JTable is null.");
                return;
            }
            String confKey = cmName + ".gui.column.header.props";
            String confVal = conf.getProperty(confKey);
            if (confVal == null) {
                return;
            }
            LinkedHashMap<String, ColumnHeaderPropsEntry> colProps = new LinkedHashMap<String, ColumnHeaderPropsEntry>();
            String[] strArr = confVal.split("; ");
            for (i = 0; i < strArr.length; ++i) {
                try {
                    ColumnHeaderPropsEntry chpe = ColumnHeaderPropsEntry.parseKeyValue(strArr[i]);
                    colProps.put(chpe._colName, chpe);
                    continue;
                }
                catch (ParseException e) {
                    _logger.info((Object)("Problems parsing '" + confKey + "' with string '" + strArr[i] + "'. Caught: " + e));
                }
            }
            if (colProps.size() != this.getModel().getColumnCount()) {
                _logger.info((Object)(confKey + " has '" + colProps.size() + "' values and the table model has '" + this.getModel().getColumnCount() + "' columns. I will skip moving columns around, the original column layout will be used."));
                return;
            }
            for (i = 0; i < colProps.size() && this.loadColumnLayout(colProps) != 0; ++i) {
            }
            int maxSortOrderPos = -1;
            for (ColumnHeaderPropsEntry chpe : colProps.values()) {
                maxSortOrderPos = Math.max(maxSortOrderPos, chpe._sortOrderPos);
            }
            for (int i2 = maxSortOrderPos; i2 > 0; --i2) {
                for (ColumnHeaderPropsEntry chpe : colProps.values()) {
                    if (chpe._sortOrderPos != i2) continue;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)(i2 + ": Setting '" + StringUtil.left(chpe._colName, 20) + "', viewPos=" + chpe._viewPos + ",  to " + (Object)((Object)chpe._sortOrder) + ", sortOrderPos=" + chpe._sortOrderPos + ", ModelColumnCount=" + this.getModel().getColumnCount() + ", RowSorterModelColumnCount=" + ((TableModel)this.getRowSorter().getModel()).getColumnCount() + ", name=" + this.getName()));
                    }
                    if (chpe._viewPos < ((TableModel)this.getRowSorter().getModel()).getColumnCount()) {
                        this.setSortOrder(chpe._viewPos, chpe._sortOrder);
                        continue;
                    }
                    _logger.debug((Object)("Can't set the sort order for column '" + chpe._colName + "'. viewPos < RowSorterModelColumnCount, this will be retried later? Info RowSorterModelColumnCount=" + ((TableModel)this.getRowSorter().getModel()).getColumnCount() + ", TableModelColumnCount=" + this.getModel().getColumnCount() + ", viewPos=" + chpe._viewPos + ", TableName=" + this.getName()));
                }
            }
        }

        protected int loadColumnLayout(Map<String, ColumnHeaderPropsEntry> colProps) {
            int fixCount = 0;
            TableColumnModelExt tcmx = (TableColumnModelExt)this.getColumnModel();
            for (Map.Entry<String, ColumnHeaderPropsEntry> entry : colProps.entrySet()) {
                int colWidth;
                String colName = entry.getKey();
                ColumnHeaderPropsEntry chpe = entry.getValue();
                TableColumnExt tcx = tcmx.getColumnExt((Object)colName);
                if (tcx != null) {
                    if (!chpe._isVisible && tcx.isVisible()) {
                        _logger.trace((Object)("loadColumnLayout() cm='" + this.getName() + "': ACTION -> HIDE '" + colName + "'."));
                        tcx.setVisible(false);
                        ++fixCount;
                    }
                    if (chpe._isVisible && !tcx.isVisible()) {
                        _logger.trace((Object)("loadColumnLayout() cm='" + this.getName() + "': ACTION -> SHOW '" + colName + "'."));
                        tcx.setVisible(true);
                        ++fixCount;
                    }
                }
                int colViewPos = -1;
                try {
                    colViewPos = tcmx.getColumnIndex((Object)colName);
                }
                catch (IllegalArgumentException ignore) {
                    // empty catch block
                }
                int propViewPos = chpe._viewPos;
                _logger.trace((Object)("loadColumnLayout() cm='" + this.getName() + "': info '" + StringUtil.left(colName, 30) + "' colViewPos(from)='" + colViewPos + "', chpe._viewPos(to)='" + chpe._viewPos + "'."));
                if (colViewPos >= 0 && propViewPos >= 0 && colViewPos != propViewPos) {
                    _logger.trace((Object)("loadColumnLayout() cm='" + this.getName() + "': ACTION -> MOVE '" + colName + "' from '" + colViewPos + "' -> '" + propViewPos + "'."));
                    tcmx.moveColumn(colViewPos, propViewPos);
                    ++fixCount;
                }
                if ((colWidth = chpe._width) > 0 && tcx != null) {
                    tcx.setPreferredWidth(colWidth);
                    tcx.setWidth(colWidth);
                }
                if (colViewPos < 0 || this.getSortOrder(colViewPos) == SortOrder.UNSORTED) continue;
                this.setSortOrder(colViewPos, SortOrder.UNSORTED);
            }
            return fixCount;
        }

        public void saveColumnLayout() {
            this.saveColumnLayout(false);
        }

        public void saveColumnLayout(boolean toOriginalLayout) {
            Configuration conf = Configuration.getInstance("USER_TEMP");
            if (conf == null) {
                return;
            }
            if (this.getColumnCount() == 0) {
                return;
            }
            String cmName = this.getName();
            if (cmName == null) {
                _logger.debug((Object)"Can't load Column Layout, because the JTable has not been assigned a name. getName() on the JTable is null.");
                return;
            }
            String confKey = cmName + ".gui.column.header.props";
            String confVal = "";
            TableColumnModel tcm = this.getColumnModel();
            for (TableColumn tc : this.getColumns(true)) {
                TableColumnExt tcx = (TableColumnExt)tc;
                String colName = tc.getHeaderValue().toString();
                boolean colIsVisible = tcx.isVisible();
                int colModelPos = tcx.getModelIndex();
                int colViewPos = -1;
                try {
                    colViewPos = tcm.getColumnIndex(colName);
                }
                catch (IllegalArgumentException ignore) {
                    // empty catch block
                }
                int colWidth = tc.getWidth();
                SortOrder colSort = this.getSortOrder(colName);
                int colSortPos = this.getSortOrderIndex(colName);
                _logger.debug((Object)("saveColumnLayout() cm='" + cmName + "': colName=" + StringUtil.left(colName, 30) + ", modelPos=" + colModelPos + ", viewPos=" + colViewPos + ", isVisible=" + colIsVisible + ", sort=" + (Object)((Object)colSort) + ", sortPos=" + colSortPos + ", identifier='" + tcx.getIdentifier() + "', width=" + colWidth + ", toString=" + tc));
                ColumnHeaderPropsEntry chpe = new ColumnHeaderPropsEntry(colName, colModelPos, colViewPos, colIsVisible, colSort, colSortPos, colWidth);
                if (toOriginalLayout) {
                    chpe._viewPos = colModelPos;
                    chpe._isVisible = true;
                    chpe._sortOrder = SortOrder.UNSORTED;
                    chpe._sortOrderPos = 0;
                    chpe._width = -1;
                }
                confVal = confVal + chpe + "; ";
            }
            confVal = confVal.substring(0, confVal.length() - 2);
            _logger.debug((Object)("saveColumnLayout() SAVE PROPERTY: " + confKey + "=" + confVal));
            conf.setProperty(confKey, confVal);
            conf.save();
        }

        public void setOriginalColumnLayout() {
            this.saveColumnLayout(true);
            this.loadColumnLayout();
        }

        public int getSortOrderIndex(int colModelIndex) {
            List<RowSorter.SortKey> sortKeys = this.getRowSorter().getSortKeys();
            if (sortKeys == null || sortKeys.size() == 0) {
                return -1;
            }
            int sortIndex = 1;
            for (RowSorter.SortKey sortKey : sortKeys) {
                if (sortKey.getSortOrder() == SortOrder.UNSORTED) continue;
                if (sortKey.getColumn() == colModelIndex) {
                    return sortIndex;
                }
                ++sortIndex;
            }
            return -1;
        }

        public int getSortOrderIndex(String colName) {
            try {
                int colModelIndex = this.getColumn(colName).getModelIndex();
                return this.getSortOrderIndex(colModelIndex);
            }
            catch (IllegalArgumentException ignore) {
                return -1;
            }
        }

        public void changeSelection(int row, int column, boolean toggle, boolean extend) {
            _logger.debug((Object)("changeSelection(row=" + row + ", column=" + column + ", toggle=" + toggle + ", extend=" + extend + "), getSelectedRow()=" + this.getSelectedRow() + ", getSelectedColumn()=" + this.getSelectedColumn()));
            if (row == this.getSelectedRow() && (column == this.getSelectedColumn() || this.getSelectedColumn() < 0)) {
                toggle = true;
                _logger.debug((Object)("changeSelection(): change toggle to " + toggle + "."));
            }
            super.changeSelection(row, column, toggle, extend);
        }

        public void tableChanged(final TableModelEvent e) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            TCPTable.this.privateTableChanged(e);
                        }
                    });
                }
                catch (InterruptedException e1) {
                    _logger.info((Object)("SwingUtilities.invokeAndWait(privateTableChanged), Caught: " + e1));
                }
                catch (InvocationTargetException e1) {
                    _logger.info((Object)("SwingUtilities.invokeAndWait(privateTableChanged), threw exception: " + e1), (Throwable)e1);
                }
            } else {
                this.privateTableChanged(e);
            }
        }

        private void privateTableChanged(TableModelEvent e) {
            int viewRowNow;
            int viewSelectedRow = this.getSelectedRow();
            int modelRowBefore = -1;
            if (viewSelectedRow >= 0) {
                modelRowBefore = this.convertRowIndexToModel(this.getSelectedRow());
            }
            super.tableChanged(e);
            if (modelRowBefore >= 0 && (viewRowNow = this.convertRowIndexToView(modelRowBefore)) >= 0) {
                this.getSelectionModel().setSelectionInterval(viewRowNow, viewRowNow);
            }
            if (SwingUtils.isStructureChanged(e)) {
                this._tableStructureChangedFlag = true;
                this.loadColumnLayout();
            }
        }

        protected JTableHeader createDefaultTableHeader() {
            return new JXTableHeader(this.getColumnModel()){
                private static final long serialVersionUID = -4987530843165661043L;

                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    int index = this.getColumnModel().getColumnIndexAtX(p.x);
                    if (index < 0) {
                        return null;
                    }
                    Object colNameObj = this.getColumnModel().getColumn(index).getHeaderValue();
                    String toolTip = null;
                    if (colNameObj instanceof String) {
                        String colName = (String)colNameObj;
                        if (TabularCntrPanel.this._cm != null) {
                            toolTip = TabularCntrPanel.this._cm.getToolTipTextOnTableColumn(colName);
                        }
                    }
                    return toolTip;
                }
            };
        }

        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int row = this.rowAtPoint(p);
            int col = this.columnAtPoint(p);
            if (row >= 0 && col >= 0) {
                col = super.convertColumnIndexToModel(col);
                row = super.convertRowIndexToModel(row);
                TableModel model = this.getModel();
                String colName = model.getColumnName(col);
                Object cellValue = model.getValueAt(row, col);
                if (model instanceof CountersModel) {
                    CountersModel cm = (CountersModel)model;
                    tip = cm.getToolTipTextOnTableCell(e, colName, cellValue, row, col);
                }
            }
            if (tip != null) {
                return tip;
            }
            return this.getToolTipText();
        }
    }

    private class ColumnLayoutTimerAction
    implements ActionListener {
        private TCPTable _tab = null;

        ColumnLayoutTimerAction(TCPTable tab) {
            this._tab = tab;
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            this._tab.saveColumnLayout();
            this._tab._columnLayoutTimer.stop();
        }
    }

    public static enum AutoAdjustTableColumnWidth {
        GLOBAL,
        AUTO_ON,
        AUTO_OFF;

    }
}

