/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.GetCounters;
import asemon.GetCountersGui;
import asemon.cm.CounterSetTemplates;
import asemon.cm.CountersModel;
import asemon.gui.MainFrame;
import asemon.gui.OfflineSessionVeiwer;
import asemon.gui.TabularCntrPanel;
import asemon.utils.Configuration;
import asemon.utils.PropPropEntry;
import asemon.utils.StringUtil;
import asemon.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

public class TcpConfigDialog
extends JDialog
implements ActionListener,
TableModelListener {
    private static Logger _logger = Logger.getLogger(OfflineSessionVeiwer.class);
    private static final long serialVersionUID = -8717629657711689568L;
    private JLabel _templateLoad_lbl = new JLabel("Available Templates");
    private JComboBox _templateLoad_cbx = new JComboBox();
    private JButton _templateSave_but = new JButton("Save...");
    private JButton _templateRm_but = new JButton("Remove...");
    private LocalTable _table = null;
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private JButton _apply = new JButton("Apply");
    private static final String DIALOG_TITLE = "Settings for All Collector Tabs";
    private PropPropEntry _initialPpe = null;
    private LinkedHashMap<String, PropPropEntry> _templatePpeMap = new LinkedHashMap();
    private static final String NO_TEMPLATE_IS_SELECTED = "<unknown template>";
    private String _lastChoosenTemplate = "";
    private boolean _isLoadingFromTemplate = false;
    private String[] _templateSystemArr = new String[]{"System Template - PCS ON - small", "System Template - PCS ON - medium", "System Template - PCS ON - large", "System Template - PCS ON - all", "System Template - PCS OFF - <for all types>"};
    private static final String[] TAB_HEADER = new String[]{"Icon", "Tab Name", "Postpone", "Paused", "Background", "Reset NC20", "Store PCS", "Abs", "Diff", "Rate"};
    private static final int TAB_POS_ICON = 0;
    private static final int TAB_POS_TAB_NAME = 1;
    private static final int TAB_POS_POSTPONE = 2;
    private static final int TAB_POS_PAUSED = 3;
    private static final int TAB_POS_BG = 4;
    private static final int TAB_POS_RNC20 = 5;
    private static final int TAB_POS_STORE_PCS = 6;
    private static final int TAB_POS_STORE_ABS = 7;
    private static final int TAB_POS_STORE_DIFF = 8;
    private static final int TAB_POS_STORE_RATE = 9;
    private static final Color TAB_PCS_COL_BG = new Color(240, 240, 240);

    private TcpConfigDialog(Frame owner) {
        super(owner, DIALOG_TITLE, true);
        this.initComponents();
    }

    public static void showDialog(Frame owner) {
        TcpConfigDialog params = new TcpConfigDialog(owner);
        params.setLocationRelativeTo(owner);
        params.setVisible(true);
        params.dispose();
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0, wrap 1", "", ""));
        panel.add((Component)this.createTopPanel(), "grow, push");
        panel.add((Component)this.createTablePanel(), "grow, push, height 100%");
        panel.add((Component)this.createOkCancelPanel(), "bottom, right, push");
        this.loadProps();
        this.setContentPane(panel);
        this.initComponentActions();
        this._initialPpe = this.getPpeFromTable();
        this.setReflectedTemplateName();
        this.setFocus(this._cancel);
    }

    private JPanel createTopPanel() {
        JPanel panel = SwingUtils.createPanel("Templates", true);
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        panel.setToolTipText("<html>Templates will help you to set/restore values in the below table...<br><UL><li> To <b>Load</b> a template, just choose one from the drop down list. </li><li> To <b>Save</b> current settings as a template, just press the 'Save..' button and choose a name to save as. </li><li> To <b>Remove</b> a template, just press the 'Remove..' button and button and choose a template name to deleted. </li></UL>If all selected values in the table is matching a template, that template name will be displayed in the drop down list.<br></html>");
        String tooltip = "<html>Load values into the below table from any of the templates in the drop down list.<br><UL><li> If all selected values in the table is matching a template, that template name will be displayed in the drop down list.</li><li> If template name is '<unknown template>', it means that the current selection can't be found within any of the templates.</li></UL></html>";
        this._templateLoad_lbl.setToolTipText(tooltip);
        this._templateLoad_cbx.setToolTipText(tooltip);
        tooltip = "<html>Save values from the below table as a template, which can be used/loaded later.<br>A popup will be displayed, where you can give the name to save as.<br>Note: Reusing any of the 'system' template names is not allowed.</html>";
        this._templateSave_but.setToolTipText(tooltip);
        tooltip = "<html>A popup will be displayed, where you can choose the template you want to delete.<br>Note: Deleting 'system' templates is not allowed.</html>";
        this._templateRm_but.setToolTipText(tooltip);
        this._templateLoad_cbx.setEditable(false);
        AutoCompleteDecorator.decorate((JComboBox)this._templateLoad_cbx);
        panel.add((Component)this._templateLoad_lbl, "");
        panel.add((Component)this._templateLoad_cbx, "growx, pushx");
        panel.add((Component)this._templateSave_but, "");
        panel.add((Component)this._templateRm_but, "wrap");
        this.loadSystemAndUserDefinedTemplateNames();
        this._templateLoad_cbx.addActionListener(this);
        this._templateSave_but.addActionListener(this);
        this._templateRm_but.addActionListener(this);
        return panel;
    }

    private JPanel createOkCancelPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        panel.add((Component)this._ok, "tag ok, right");
        panel.add((Component)this._cancel, "tag cancel");
        panel.add((Component)this._apply, "tag apply");
        this._apply.setEnabled(false);
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        this._apply.addActionListener(this);
        return panel;
    }

    private JPanel createTablePanel() {
        JPanel panel = SwingUtils.createPanel("Actual Data Table", false);
        panel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "", ""));
        this._table = new LocalTable();
        this._table.getModel().addTableModelListener(this);
        JScrollPane scroll = new JScrollPane((Component)((Object)this._table));
        panel.add((Component)scroll, "push, grow, height 100%, wrap");
        return panel;
    }

    private void initComponentActions() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TcpConfigDialog.this.saveProps();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String currentTemplateName;
        Object source = e.getSource();
        if (this._cancel.equals(source)) {
            this.setVisible(false);
        }
        if (this._ok.equals(source)) {
            this.doApply();
            this.saveProps();
            this.setVisible(false);
        }
        if (this._apply.equals(source)) {
            this.doApply();
            this.saveProps();
        }
        if (this._templateLoad_cbx.equals(source)) {
            String templateName = this._templateLoad_cbx.getSelectedItem().toString().trim();
            this._isLoadingFromTemplate = true;
            if (this.loadTemplate(templateName)) {
                this.setReflectedTemplateName();
            }
            this._isLoadingFromTemplate = false;
        }
        if (this._templateSave_but.equals(source)) {
            String newName;
            currentTemplateName = this._templateLoad_cbx.getSelectedItem().toString().trim();
            if (currentTemplateName.equals(NO_TEMPLATE_IS_SELECTED)) {
                currentTemplateName = this._lastChoosenTemplate;
            }
            if ((newName = SaveOrRemoveTemplateDialog.showDialog(this, SaveOrRemoveTemplateDialog.SAVE_AS_DIALOG, currentTemplateName, this.getUserDefinedTemplateNames())) != null) {
                int res;
                String currentSelectionExistsAsName = this.currentSelectionIsRefectedInTemplate();
                if (currentSelectionExistsAsName != null && !newName.equals(currentSelectionExistsAsName) && !currentTemplateName.equals(newName) && (res = JOptionPane.showConfirmDialog(this, "Current selection is already saved as the template '" + currentSelectionExistsAsName + "'.\n" + "Do you still want to save it as '" + newName + "'.\n" + "\n" + "Note: It could be difficult to access the template from the drop down list.\n" + "\n" + "A better way to do this is:\n" + "- First make the selection you intend to do\n" + "- Then press 'Save...' and choose a new name for the template :)", "Template Duplicate Detected", 0)) == 1) {
                    return;
                }
                if (this.saveTemplate(newName)) {
                    if (!currentTemplateName.equals(newName)) {
                        this._templateLoad_cbx.insertItemAt(newName, 1);
                        this._templateLoad_cbx.setSelectedItem(newName);
                    }
                    this.setReflectedTemplateName();
                }
            }
        }
        if (this._templateRm_but.equals(source)) {
            boolean isSystemTemplate;
            currentTemplateName = this._templateLoad_cbx.getSelectedItem().toString().trim();
            boolean bl = isSystemTemplate = currentTemplateName.indexOf("System Template") >= 0;
            if (isSystemTemplate) {
                SwingUtils.showErrorMessage(this, "Can't remove template", "Can't remove a System Template.", null);
                return;
            }
            String name = SaveOrRemoveTemplateDialog.showDialog(this, SaveOrRemoveTemplateDialog.REMOVE_DIALOG, currentTemplateName, this.getUserDefinedTemplateNames());
            if (name != null && this.removeTemplate(name)) {
                this._templateLoad_cbx.removeItem(name);
                this.setReflectedTemplateName();
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this._isLoadingFromTemplate) {
            this.setReflectedTemplateName();
        }
    }

    private void setReflectedTemplateName() {
        PropPropEntry ppeNow = this.getPpeFromTable();
        String foundInTemplate = this.currentSelectionIsRefectedInTemplate();
        if (foundInTemplate != null) {
            this._templateLoad_cbx.setSelectedItem(foundInTemplate);
        } else {
            if (!NO_TEMPLATE_IS_SELECTED.equals(this._templateLoad_cbx.getSelectedItem())) {
                this._lastChoosenTemplate = this._templateLoad_cbx.getSelectedItem().toString();
            }
            this._templateLoad_cbx.setSelectedItem(NO_TEMPLATE_IS_SELECTED);
        }
        boolean hasChanged = !ppeNow.toString().equals(this._initialPpe.toString());
        this._apply.setEnabled(hasChanged);
    }

    private String currentSelectionIsRefectedInTemplate() {
        PropPropEntry ppeNow = this.getPpeFromTable();
        for (Map.Entry<String, PropPropEntry> entry : this._templatePpeMap.entrySet()) {
            String tname = entry.getKey();
            PropPropEntry ppe = entry.getValue();
            if (!ppeNow.toString().equals(ppe.toString())) continue;
            return tname;
        }
        return null;
    }

    private void doApply() {
        for (int r = 0; r < this._table.getRowCount(); ++r) {
            String tabName = (String)this._table.getValueAt(r, 1);
            int postpone = (Integer)this._table.getValueAt(r, 2);
            boolean paused = (Boolean)this._table.getValueAt(r, 3);
            boolean bgPoll = (Boolean)this._table.getValueAt(r, 4);
            boolean rnc20 = (Boolean)this._table.getValueAt(r, 5);
            boolean storePcs = (Boolean)this._table.getValueAt(r, 6);
            boolean storeAbs = (Boolean)this._table.getValueAt(r, 7);
            boolean storeDiff = (Boolean)this._table.getValueAt(r, 8);
            boolean storeRate = (Boolean)this._table.getValueAt(r, 9);
            CountersModel cm = GetCounters.getCmByDisplayName(tabName);
            if (cm == null) {
                _logger.warn((Object)("The cm named '" + tabName + "' cant be found in the 'GetCounters' object."));
                continue;
            }
            if (_logger.isDebugEnabled()) {
                String debugStr = "doApply() name=" + StringUtil.left("'" + tabName + "'", 30) + " postpone=" + (this._table.isCellChanged(r, 2) ? "X" : " ") + " paused=" + (this._table.isCellChanged(r, 3) ? "X" : " ") + " bg=" + (this._table.isCellChanged(r, 4) ? "X" : " ") + " rnc20=" + (this._table.isCellChanged(r, 5) ? "X" : " ") + " pcs=" + (this._table.isCellChanged(r, 6) ? "X" : " ") + " pcsAbs=" + (this._table.isCellChanged(r, 7) ? "X" : " ") + " pcsDiff=" + (this._table.isCellChanged(r, 8) ? "X" : " ") + " pcsRate=" + (this._table.isCellChanged(r, 9) ? "X" : " ");
                _logger.debug((Object)debugStr);
            }
            if (this._table.isCellChanged(r, 2)) {
                cm.setPostponeTime(postpone, true);
            }
            if (this._table.isCellChanged(r, 3)) {
                cm.setPauseDataPolling(paused, true);
            }
            if (this._table.isCellChanged(r, 4)) {
                cm.setBackgroundDataPollingEnabled(bgPoll, true);
            }
            if (this._table.isCellChanged(r, 5)) {
                cm.setNegativeDiffCountersToZero(rnc20, true);
            }
            if (this._table.isCellChanged(r, 6)) {
                cm.setPersistCounters(storePcs, true);
            }
            if (this._table.isCellChanged(r, 7)) {
                cm.setPersistCountersAbs(storeAbs, true);
            }
            if (this._table.isCellChanged(r, 8)) {
                cm.setPersistCountersDiff(storeDiff, true);
            }
            if (!this._table.isCellChanged(r, 9)) continue;
            cm.setPersistCountersRate(storeRate, true);
        }
        this._table.resetCellChanges();
        this._apply.setEnabled(false);
    }

    private void setFocus(final JComponent comp) {
        Runnable deferredAction = new Runnable(){

            @Override
            public void run() {
                comp.requestFocus();
            }
        };
        SwingUtilities.invokeLater(deferredAction);
    }

    private void saveProps() {
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        String base = "tcpConfigDialog.";
        if (tmpConf != null) {
            tmpConf.setProperty(base + "window.width", this.getSize().width);
            tmpConf.setProperty(base + "window.height", this.getSize().height);
            tmpConf.setProperty(base + "window.pos.x", this.getLocationOnScreen().x);
            tmpConf.setProperty(base + "window.pos.y", this.getLocationOnScreen().y);
            tmpConf.save();
        }
    }

    private void loadProps() {
        int width = 675;
        int height = 630;
        int x = -1;
        int y = -1;
        Configuration tmpConf = Configuration.getCombinedConfiguration();
        String base = "tcpConfigDialog.";
        this.setSize(width, height);
        if (tmpConf == null) {
            return;
        }
        width = tmpConf.getIntProperty(base + "window.width", width);
        height = tmpConf.getIntProperty(base + "window.height", height);
        x = tmpConf.getIntProperty(base + "window.pos.x", -1);
        y = tmpConf.getIntProperty(base + "window.pos.y", -1);
        if (width != -1 && height != -1) {
            this.setSize(width, height);
        }
        if (x != -1 && y != -1) {
            this.setLocation(x, y);
        } else {
            SwingUtils.centerWindow(this);
        }
    }

    private List<String> getUserDefinedTemplateNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this._templateLoad_cbx.getItemCount(); ++i) {
            String tname = this._templateLoad_cbx.getItemAt(i).toString();
            if (tname.startsWith(NO_TEMPLATE_IS_SELECTED) || tname.startsWith("System Template")) continue;
            list.add(tname);
        }
        return list;
    }

    private void loadSystemAndUserDefinedTemplateNames() {
        Configuration tmpConf = Configuration.getCombinedConfiguration();
        if (tmpConf == null) {
            return;
        }
        this._templateLoad_cbx.addItem(NO_TEMPLATE_IS_SELECTED);
        String propKey = "tcpConfigDialog.template.name.";
        List<String> userTemplates = tmpConf.getKeys(propKey);
        Collections.sort(userTemplates);
        for (String key : tmpConf.getKeys(propKey)) {
            String userTemplate = key.substring(propKey.length());
            this._templateLoad_cbx.addItem(userTemplate);
            String propVal = tmpConf.getProperty(key);
            PropPropEntry ppe = new PropPropEntry(propVal);
            this._templatePpeMap.put(userTemplate, ppe);
        }
        for (String systemTemplate : this._templateSystemArr) {
            this._templateLoad_cbx.addItem(systemTemplate);
            String[] sa = systemTemplate.split(" - ");
            String type = sa[1];
            String name = sa[2];
            if ("PCS ON".equals(type)) {
                if ("small".equals(name)) {
                    this._templatePpeMap.put(systemTemplate, CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_SMALL);
                    continue;
                }
                if ("medium".equals(name)) {
                    this._templatePpeMap.put(systemTemplate, CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_MEDIUM);
                    continue;
                }
                if ("large".equals(name)) {
                    this._templatePpeMap.put(systemTemplate, CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_LARGE);
                    continue;
                }
                if (!"all".equals(name)) continue;
                this._templatePpeMap.put(systemTemplate, CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_ALL);
                continue;
            }
            if (!"PCS OFF".equals(type)) continue;
            if ("small".equals(name)) {
                this._templatePpeMap.put(systemTemplate, CounterSetTemplates.SYSTEM_TEMPLATE_PCS_OFF_SMALL);
                continue;
            }
            if ("medium".equals(name)) {
                this._templatePpeMap.put(systemTemplate, CounterSetTemplates.SYSTEM_TEMPLATE_PCS_OFF_MEDIUM);
                continue;
            }
            if ("large".equals(name)) {
                this._templatePpeMap.put(systemTemplate, CounterSetTemplates.SYSTEM_TEMPLATE_PCS_OFF_LARGE);
                continue;
            }
            if ("all".equals(name)) {
                this._templatePpeMap.put(systemTemplate, CounterSetTemplates.SYSTEM_TEMPLATE_PCS_OFF_ALL);
                continue;
            }
            this._templatePpeMap.put(systemTemplate, CounterSetTemplates.SYSTEM_TEMPLATE_PCS_OFF_SMALL);
        }
    }

    private boolean loadTemplate(String templateName) {
        if (templateName == null) {
            return false;
        }
        if (templateName.trim().equals("")) {
            return false;
        }
        if (templateName.trim().equals(NO_TEMPLATE_IS_SELECTED)) {
            return false;
        }
        Configuration tmpConf = Configuration.getCombinedConfiguration();
        if (tmpConf == null) {
            return false;
        }
        PropPropEntry ppe = null;
        if (templateName.startsWith("System Template")) {
            String[] sa = templateName.split(" - ");
            String type = sa[1];
            String name = sa[2];
            if ("PCS ON".equals(type)) {
                if ("small".equals(name)) {
                    ppe = CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_SMALL;
                } else if ("medium".equals(name)) {
                    ppe = CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_MEDIUM;
                } else if ("large".equals(name)) {
                    ppe = CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_LARGE;
                } else if ("all".equals(name)) {
                    ppe = CounterSetTemplates.SYSTEM_TEMPLATE_PCS_ON_ALL;
                }
            } else if ("PCS OFF".equals(type)) {
                ppe = "small".equals(name) ? CounterSetTemplates.SYSTEM_TEMPLATE_PCS_OFF_SMALL : ("medium".equals(name) ? CounterSetTemplates.SYSTEM_TEMPLATE_PCS_OFF_MEDIUM : ("large".equals(name) ? CounterSetTemplates.SYSTEM_TEMPLATE_PCS_OFF_LARGE : ("all".equals(name) ? CounterSetTemplates.SYSTEM_TEMPLATE_PCS_OFF_ALL : CounterSetTemplates.SYSTEM_TEMPLATE_PCS_OFF_SMALL)));
            }
            if (ppe == null) {
                throw new RuntimeException("Can't find the SYSTEM TEMPLATE named '" + templateName + "'.");
            }
        } else {
            String propKey = "tcpConfigDialog.template.name." + templateName;
            String propVal = tmpConf.getProperty(propKey);
            if (propVal == null) {
                _logger.warn((Object)("The key '" + propKey + "', can't be found in the file '" + tmpConf.getFilename() + "'."));
                SwingUtils.showErrorMessage(this, "Error loading Template", "Can't load the Template Named '" + templateName + "'\n\n" + "The key '" + propKey + "', can't be found in the file '" + tmpConf.getFilename() + "'.", null);
                return false;
            }
            ppe = new PropPropEntry(propVal);
        }
        for (String name : ppe) {
            try {
                int postpone = ppe.getIntMandatoryProperty(name, "postpone");
                boolean paused = ppe.getBooleanMandatoryProperty(name, "paused");
                boolean bg = ppe.getBooleanMandatoryProperty(name, "bg");
                boolean resetNC20 = ppe.getBooleanMandatoryProperty(name, "resetNC20");
                boolean storePcs = ppe.getBooleanMandatoryProperty(name, "storePcs");
                boolean pcsAbs = ppe.getBooleanMandatoryProperty(name, "pcsAbs");
                boolean pcsDiff = ppe.getBooleanMandatoryProperty(name, "pcsDiff");
                boolean pcsRate = ppe.getBooleanMandatoryProperty(name, "pcsRate");
                for (int r = 0; r < this._table.getRowCount(); ++r) {
                    String tabName = this._table.getValueAt(r, 1).toString();
                    if (!tabName.equals(name)) continue;
                    this._table.setValueAt(postpone, r, 2);
                    this._table.setValueAt(paused, r, 3);
                    this._table.setValueAt(bg, r, 4);
                    this._table.setValueAt(resetNC20, r, 5);
                    this._table.setValueAt(storePcs, r, 6);
                    this._table.setValueAt(pcsAbs, r, 7);
                    this._table.setValueAt(pcsDiff, r, 8);
                    this._table.setValueAt(pcsRate, r, 9);
                }
            }
            catch (Exception e) {
                _logger.error((Object)("Problem when loading Template '" + templateName + "', for tab '" + name + "', caught: " + e.getMessage()));
                return false;
            }
        }
        return true;
    }

    private PropPropEntry getPpeFromTable() {
        PropPropEntry ppe = new PropPropEntry();
        for (int r = 0; r < this._table.getRowCount(); ++r) {
            String tabName = this._table.getValueAt(r, 1).toString();
            ppe.put(tabName, "postpone", this._table.getValueAt(r, 2).toString());
            ppe.put(tabName, "paused", this._table.getValueAt(r, 3).toString());
            ppe.put(tabName, "bg", this._table.getValueAt(r, 4).toString());
            ppe.put(tabName, "resetNC20", this._table.getValueAt(r, 5).toString());
            ppe.put(tabName, "storePcs", this._table.getValueAt(r, 6).toString());
            ppe.put(tabName, "pcsAbs", this._table.getValueAt(r, 7).toString());
            ppe.put(tabName, "pcsDiff", this._table.getValueAt(r, 8).toString());
            ppe.put(tabName, "pcsRate", this._table.getValueAt(r, 9).toString());
        }
        return ppe;
    }

    private boolean saveTemplate(String templateName) {
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        if (tmpConf == null) {
            return false;
        }
        String propKey = "tcpConfigDialog.template.name." + templateName;
        PropPropEntry ppe = this.getPpeFromTable();
        this._templatePpeMap.put(templateName, ppe);
        tmpConf.setProperty(propKey, ppe.toString());
        tmpConf.save();
        return true;
    }

    private boolean removeTemplate(String templateName) {
        if (templateName == null) {
            return false;
        }
        if (templateName.trim().equals("")) {
            return false;
        }
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        if (tmpConf == null) {
            return false;
        }
        String propKey = "tcpConfigDialog.template.name." + templateName;
        String propVal = tmpConf.getProperty(propKey);
        if (propVal == null) {
            _logger.warn((Object)("The key '" + propKey + "', can't be found in the file '" + tmpConf.getFilename() + "'."));
            SwingUtils.showErrorMessage(this, "Error Removing Template", "Can't remove the Template Named '" + templateName + "'\n\n" + "The key '" + propKey + "', can't be found in the file '" + tmpConf.getFilename() + "'.", null);
            return false;
        }
        this._templatePpeMap.remove(templateName);
        tmpConf.remove(propKey);
        tmpConf.save();
        return true;
    }

    public static void main(String[] args) {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "INFO, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        Configuration conf = new Configuration("c:\\OfflineSessionsViewer.tmp.deleteme.properties");
        Configuration.setInstance("USER_TEMP", conf);
        MainFrame frame = new MainFrame();
        GetCountersGui getCnt = new GetCountersGui();
        try {
            ((GetCounters)getCnt).init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        frame.pack();
        TcpConfigDialog.showDialog(frame);
    }

    private class LocalTable
    extends JXTable {
        private static final long serialVersionUID = 0L;
        protected int _lastTableHeaderColumn = -1;
        private JPopupMenu _popupMenu = null;
        private JPopupMenu _headerPopupMenu = null;

        LocalTable() {
            this.setModel(new LocalTableModel());
            this.setShowGrid(false);
            this.setSortable(true);
            this.setSelectionMode(0);
            this.setAutoResizeMode(0);
            this.packAll();
            this.setColumnControlVisible(true);
            this._popupMenu = this.createDataTablePopupMenu();
            this.setComponentPopupMenu(this.getDataTablePopupMenu());
            this._headerPopupMenu = this.createDataTableHeaderPopupMenu();
            this.getTableHeader().setComponentPopupMenu(this.getDataTableHeaderPopupMenu());
            this.refreshTable();
        }

        public int getLastTableHeaderColumn() {
            return this._lastTableHeaderColumn;
        }

        protected JTableHeader createDefaultTableHeader() {
            JXTableHeader tabHeader = new JXTableHeader(this.getColumnModel()){
                private static final long serialVersionUID = 0L;

                public String getToolTipText(MouseEvent e) {
                    String tip = null;
                    int col = this.getColumnModel().getColumnIndexAtX(e.getPoint().x);
                    if (col < 0) {
                        return null;
                    }
                    switch (col) {
                        case 0: {
                            tip = null;
                            break;
                        }
                        case 1: {
                            tip = "Name of Tab/Collector.";
                            break;
                        }
                        case 2: {
                            tip = "If you want to skip some intermediate samples, Here you can specify minimum seconds between samples.";
                            break;
                        }
                        case 3: {
                            tip = "Pause data polling for this Tab. This makes the values easier to read...";
                            break;
                        }
                        case 4: {
                            tip = "Sample this panel even when this Tab is not active.";
                            break;
                        }
                        case 5: {
                            tip = "If the difference between 'this' and 'previous' data sample has negative counter values, reset them to be <b>zero</b>";
                            break;
                        }
                        case 6: {
                            tip = "Save this Counter Set to a Persistent Storage, even when we are in GUI mode.<br>Note: This is only enabled/available if you specified a Counter Storage when you connected.";
                            break;
                        }
                        case 7: {
                            tip = "Save the Absolute Counters in the Persistent Counter Storage";
                            break;
                        }
                        case 8: {
                            tip = "Save the Difference Counters in the Persistent Counter Storage";
                            break;
                        }
                        case 9: {
                            tip = "Save the Rate Counters in the Persistent Counter Storage";
                        }
                    }
                    if (tip == null) {
                        return null;
                    }
                    return "<html>" + tip + "</html>";
                }
            };
            tabHeader.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    LocalTable.this._lastTableHeaderColumn = LocalTable.this.getColumnModel().getColumnIndexAtX(e.getX());
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            return tabHeader;
        }

        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int row = super.convertRowIndexToModel(this.rowAtPoint(p) < 0 ? 0 : this.rowAtPoint(p));
            int col = super.convertColumnIndexToModel(this.columnAtPoint(p));
            if (col > 2) {
                tip = "Right click on the header column to mark or unmark all rows.";
            }
            if (row >= 0) {
                // empty if block
            }
            if (tip == null) {
                return null;
            }
            return "<html>" + tip + "</html>";
        }

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (column == 4) {
                c.setEnabled(this.isCellEditable(row, column));
            }
            if (column >= 6) {
                c.setBackground(TAB_PCS_COL_BG);
                if (column > 6) {
                    c.setEnabled(this.isCellEditable(row, column));
                }
            }
            return c;
        }

        protected void refreshTable() {
            Vector<Object> row = new Vector<Object>();
            DefaultTableModel tm = (DefaultTableModel)this.getModel();
            JTabbedPane tabPane = MainFrame.getTabbedPane();
            if (tabPane == null) {
                return;
            }
            while (tm.getRowCount() > 0) {
                tm.removeRow(0);
            }
            int tabCount = tabPane.getTabCount();
            for (int t = 0; t < tabCount; ++t) {
                TabularCntrPanel tcp;
                CountersModel cm;
                Component comp = tabPane.getComponentAt(t);
                if (!(comp instanceof TabularCntrPanel) || (cm = (tcp = (TabularCntrPanel)comp).getCm()) == null) continue;
                row = new Vector();
                row.add(cm.getTabPanel() == null ? null : cm.getTabPanel().getIcon());
                row.add(cm.getDisplayName());
                row.add(new Integer(cm.getPostponeTime()));
                row.add(new Boolean(cm.isDataPollingPaused()));
                row.add(new Boolean(cm.isBackgroundDataPollingEnabled()));
                row.add(new Boolean(cm.isNegativeDiffCountersToZero()));
                row.add(new Boolean(cm.isPersistCountersEnabled()));
                row.add(new Boolean(cm.isPersistCountersAbsEnabled()));
                row.add(new Boolean(cm.isPersistCountersDiffEnabled()));
                row.add(new Boolean(cm.isPersistCountersRateEnabled()));
                tm.addRow(row);
            }
            this.resetCellChanges();
            this.packAll();
        }

        public boolean isCellChanged(int row, int col) {
            int mrow = super.convertRowIndexToModel(row);
            int mcol = super.convertColumnIndexToModel(col);
            LocalTableModel tm = (LocalTableModel)this.getModel();
            return tm.isCellChanged(mrow, mcol);
        }

        public void resetCellChanges() {
            LocalTableModel tm = (LocalTableModel)this.getModel();
            tm.resetCellChanges();
            this.repaint();
        }

        public JPopupMenu getDataTablePopupMenu() {
            return this._popupMenu;
        }

        public JPopupMenu createDataTablePopupMenu() {
            _logger.debug((Object)"createDataTablePopupMenu(): called.");
            JPopupMenu popup = new JPopupMenu();
            JMenuItem show = new JMenuItem("XXX");
            popup.add(show);
            show.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            if (popup.getComponentCount() == 0) {
                _logger.warn((Object)"No PopupMenu has been assigned for the data table in the panel.");
                return null;
            }
            return popup;
        }

        public JPopupMenu getDataTableHeaderPopupMenu() {
            return this._headerPopupMenu;
        }

        public JPopupMenu createDataTableHeaderPopupMenu() {
            _logger.debug((Object)"createDataTableHeaderPopupMenu(): called.");
            JPopupMenu popup = new JPopupMenu();
            JMenuItem mark = new JMenuItem("Mark all rows for this column");
            JMenuItem unmark = new JMenuItem("UnMark all rows for this column");
            popup.add(mark);
            popup.add(unmark);
            mark.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int col = LocalTable.this.getLastTableHeaderColumn();
                    if (col > 2) {
                        TableModel tm = LocalTable.this.getModel();
                        for (int r = 0; r < tm.getRowCount(); ++r) {
                            if (!tm.isCellEditable(r, col)) continue;
                            tm.setValueAt(new Boolean(true), r, col);
                        }
                    }
                }
            });
            unmark.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int col = LocalTable.this.getLastTableHeaderColumn();
                    if (col > 2) {
                        TableModel tm = LocalTable.this.getModel();
                        for (int r = 0; r < tm.getRowCount(); ++r) {
                            if (!tm.isCellEditable(r, col)) continue;
                            tm.setValueAt(new Boolean(false), r, col);
                        }
                    }
                }
            });
            if (popup.getComponentCount() == 0) {
                _logger.warn((Object)"No PopupMenu has been assigned for the data table in the panel.");
                return null;
            }
            return popup;
        }
    }

    private static class LocalTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        private Vector<Vector<Boolean>> _changeIndicator = new Vector();

        LocalTableModel() {
            this.setColumnIdentifiers(TAB_HEADER);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Boolean changed;
            Vector<Boolean> changeRowIndicator;
            super.setValueAt(value, row, column);
            if (this._changeIndicator.size() < this.getRowCount()) {
                this._changeIndicator.setSize(this.getRowCount());
            }
            if ((changeRowIndicator = this._changeIndicator.get(row)) == null) {
                changeRowIndicator = new Vector(this.getColumnCount());
                this._changeIndicator.set(row, changeRowIndicator);
            }
            if (changeRowIndicator.size() < this.getColumnCount()) {
                changeRowIndicator.setSize(this.getColumnCount());
            }
            if ((changed = changeRowIndicator.get(column)) == null) {
                changeRowIndicator.set(column, new Boolean(true));
            } else if (!changed.booleanValue()) {
                changeRowIndicator.set(column, new Boolean(true));
            }
        }

        public boolean isCellChanged(int row, int col) {
            Vector<Boolean> changeRowIndicator = this._changeIndicator.get(row);
            if (changeRowIndicator == null) {
                return false;
            }
            Boolean changed = changeRowIndicator.get(col);
            if (changed == null) {
                return false;
            }
            return changed;
        }

        public void resetCellChanges() {
            this._changeIndicator = new Vector(this.getRowCount());
            this._changeIndicator.setSize(this.getRowCount());
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return Icon.class;
            }
            if (column == 2) {
                return Integer.class;
            }
            if (column > 2) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 4 || col > 6) {
                CountersModel cm;
                boolean storePcs = (Boolean)this.getValueAt(row, 6);
                String tabName = (String)this.getValueAt(row, 1);
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("isCellEditable: row=" + row + ", col=" + col + ", storePcs=" + storePcs + ", tabName='" + tabName + "'."));
                }
                if ((cm = GetCounters.getCmByDisplayName(tabName)) != null) {
                    if (col == 4) {
                        return cm.isBackgroundDataPollingEditable();
                    }
                    if (col == 7) {
                        return storePcs && cm.isPersistCountersAbsEditable();
                    }
                    if (col == 8) {
                        return storePcs && cm.isPersistCountersDiffEditable();
                    }
                    if (col == 9) {
                        return storePcs && cm.isPersistCountersRateEditable();
                    }
                }
            }
            return col >= 2;
        }
    }

    private static class SaveOrRemoveTemplateDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        public int _dialogType = -1;
        public static int SAVE_AS_DIALOG = 1;
        public static int REMOVE_DIALOG = 2;
        private JLabel _templates_lbl = new JLabel();
        private JComboBox _templates_cbx = new JComboBox();
        private JButton _ok = new JButton("OK");
        private JButton _cancel = new JButton("Cancel");
        private String _return = null;
        private List<String> _templateList = null;
        private String _saveAs = null;

        private SaveOrRemoveTemplateDialog(JDialog owner, int dialogType, String saveAs, List<String> templateList) {
            super(owner, "", true);
            this._dialogType = dialogType;
            this._saveAs = saveAs;
            this._templateList = templateList;
            this.initComponents();
            this.pack();
        }

        public static String showDialog(JDialog owner, int dialogType, String saveAs, List<String> templates) {
            SaveOrRemoveTemplateDialog dialog = new SaveOrRemoveTemplateDialog(owner, dialogType, saveAs, templates);
            dialog.setLocationRelativeTo(owner);
            dialog.setVisible(true);
            dialog.dispose();
            return dialog._return;
        }

        protected void initComponents() {
            boolean isSystemTemplate;
            JPanel panel = new JPanel();
            panel.setLayout((LayoutManager)new MigLayout("insets 20 20", "[][grow]", ""));
            this._templates_lbl.setToolTipText("Type a template name, or choose one from the drop down list");
            this._templates_cbx.setToolTipText("Type a template name, or choose one from the drop down list");
            if (this._dialogType == SAVE_AS_DIALOG) {
                this.setTitle("Save Template");
                this._templates_lbl.setText("Save as Template");
                this._templates_cbx.setEditable(true);
            } else if (this._dialogType == REMOVE_DIALOG) {
                this.setTitle("Remove Template");
                this._templates_lbl.setText("Remove Template");
                this._templates_cbx.setEditable(true);
            } else {
                throw new RuntimeException("Unknown Dialog Type");
            }
            AutoCompleteDecorator.decorate((JComboBox)this._templates_cbx);
            panel.add((Component)this._templates_lbl, "");
            panel.add((Component)this._templates_cbx, "grow, wrap");
            panel.add((Component)this._ok, "tag ok,     gap top 20, skip, split, bottom, right, push");
            panel.add((Component)this._cancel, "tag cancel,                   split, bottom");
            this.setContentPane(panel);
            for (String tname : this._templateList) {
                this._templates_cbx.addItem(tname);
            }
            String ctname = this._saveAs;
            boolean bl = isSystemTemplate = ctname.indexOf("System Template") >= 0;
            if (isSystemTemplate || ctname.equals("") || ctname.equals(TcpConfigDialog.NO_TEMPLATE_IS_SELECTED)) {
                ctname = "write template name here";
            }
            this._templates_cbx.setSelectedItem(ctname);
            this._ok.addActionListener(this);
            this._cancel.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this._ok.equals(source)) {
                this._return = this._templates_cbx.getSelectedItem().toString();
                this.setVisible(false);
            }
            if (this._cancel.equals(source)) {
                this._return = null;
                this.setVisible(false);
            }
        }
    }
}

