/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.gui.TrendGraph;
import asemon.pcs.InMemoryCounterHandler;
import asemon.utils.Configuration;
import asemon.utils.StringUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class TrendGraphDashboardPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static Logger _logger = Logger.getLogger(TrendGraphDashboardPanel.class);
    private JLabel _maxChartHistoryInMinutes_lbl = new JLabel();
    private SpinnerNumberModel _maxChartHistoryInMinutes_spm = new SpinnerNumberModel(TrendGraph.getChartMaxHistoryTimeInMinutes(), 1, 999, 1);
    private JSpinner _maxChartHistoryInMinutes_sp = new JSpinner(this._maxChartHistoryInMinutes_spm);
    private JLabel _maxInMemHistoryInMinutes_lbl = new JLabel();
    private SpinnerNumberModel _maxInMemHistoryInMinutes_spm = new SpinnerNumberModel(TrendGraph.getChartMaxHistoryTimeInMinutes(), 1, 999, 1);
    private JSpinner _maxInMemHistoryInMinutes_sp = new JSpinner(this._maxInMemHistoryInMinutes_spm);
    private JCheckBox _maxInMemHistoryInMinutes_chk = new JCheckBox("Same as Graph History", true);
    private List<String> _savedGraphNameOrder = new ArrayList<String>();
    private LinkedHashMap<String, TrendGraph> _graphOriginOrderMap = new LinkedHashMap();
    private LinkedHashMap<String, TrendGraph> _graphCurrentOrderMap = new LinkedHashMap();
    private final String GRAPH_LAYOUT_PROP = "push, grow, hidemode 3, wrap";

    public TrendGraphDashboardPanel() {
        this.initComponents();
        this.loadProps();
        this.initComponentActions();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "", ""));
        this._maxChartHistoryInMinutes_lbl.setText("Trends Graph History in Minutes");
        this._maxChartHistoryInMinutes_lbl.setToolTipText("How many minutes should be represented in the graphs.");
        this._maxChartHistoryInMinutes_sp.setToolTipText("How many minutes should be represented in the graphs.");
        this._maxInMemHistoryInMinutes_lbl.setText("In-Memory History in Minutes");
        this._maxInMemHistoryInMinutes_lbl.setToolTipText("<html>How many minutes should be available in the in-memory history.<br>To view in-memory history, click the magnifying/db button on the tool bar.</html>");
        this._maxInMemHistoryInMinutes_sp.setToolTipText("<html>How many minutes should be available in the in-memory history.<br>To view in-memory history, click the magnifying/db button on the tool bar.</html>");
        this._maxInMemHistoryInMinutes_chk.setToolTipText("Use same value for 'In-Memory History' as for 'Trends Graph History'.");
        this.add((Component)this._maxChartHistoryInMinutes_lbl, "gaptop 10, center, split 5");
        this.add((Component)this._maxChartHistoryInMinutes_sp, "");
        this.add((Component)this._maxInMemHistoryInMinutes_lbl, "gap 10");
        this.add((Component)this._maxInMemHistoryInMinutes_sp, "gap 5");
        this.add((Component)this._maxInMemHistoryInMinutes_chk, "wrap 10");
        String tooltip = "";
        this.setToolTipText(tooltip);
    }

    private void initComponentActions() {
        this._maxChartHistoryInMinutes_spm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int minutes = TrendGraphDashboardPanel.this._maxChartHistoryInMinutes_spm.getNumber().intValue();
                _logger.debug((Object)("maxChartHistoryInMinutes: " + minutes));
                TrendGraphDashboardPanel.this.setChartMaxHistoryTimeInMinutes(minutes);
                TrendGraphDashboardPanel.this.saveProps();
            }
        });
        this._maxInMemHistoryInMinutes_spm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int minutes = TrendGraphDashboardPanel.this._maxInMemHistoryInMinutes_spm.getNumber().intValue();
                _logger.debug((Object)("maxInMemHistoryInMinutes: " + minutes));
                TrendGraphDashboardPanel.this.setInMemMaxHistoryTimeInMinutes(minutes);
                TrendGraphDashboardPanel.this.saveProps();
            }
        });
        this._maxInMemHistoryInMinutes_chk.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                boolean inSync = TrendGraphDashboardPanel.this._maxInMemHistoryInMinutes_chk.isSelected();
                TrendGraphDashboardPanel.this._maxInMemHistoryInMinutes_sp.setEnabled(!inSync);
                if (inSync) {
                    int minutes = TrendGraphDashboardPanel.this._maxChartHistoryInMinutes_spm.getNumber().intValue();
                    TrendGraphDashboardPanel.this.setInMemMaxHistoryTimeInMinutes(minutes);
                }
                TrendGraphDashboardPanel.this.saveProps();
            }
        });
    }

    private void setChartMaxHistoryTimeInMinutes(int minutes) {
        _logger.debug((Object)("set-Chart-MaxHistoryTimeInMinutes(minutes=" + minutes + ")"));
        this._maxChartHistoryInMinutes_spm.setValue(new Integer(minutes));
        for (TrendGraph tg : this._graphCurrentOrderMap.values()) {
            if (tg == null) continue;
            tg.setChartMaxHistoryTimeInMinutes(minutes);
        }
        if (this._maxInMemHistoryInMinutes_chk.isSelected()) {
            this.setInMemMaxHistoryTimeInMinutes(minutes);
        }
    }

    private void setInMemMaxHistoryTimeInMinutes(int minutes) {
        _logger.debug((Object)("set-In-Mem-MaxHistoryTimeInMinutes(minutes=" + minutes + ")"));
        this._maxInMemHistoryInMinutes_spm.setValue(new Integer(minutes));
        InMemoryCounterHandler imch = InMemoryCounterHandler.getInstance();
        if (imch != null) {
            imch.setHistoryLengthInMinutes(minutes);
        }
    }

    public void refreshHistoryTimeInMinutes() {
        Integer minutes = (Integer)this._maxChartHistoryInMinutes_spm.getValue();
        this.setChartMaxHistoryTimeInMinutes(minutes);
    }

    public void clearGraph() {
        for (TrendGraph tg : this._graphCurrentOrderMap.values()) {
            if (tg == null) continue;
            tg.clearGraph();
        }
    }

    public void add(TrendGraph tg) {
        this._graphOriginOrderMap.put(tg.getName(), tg);
        this._graphCurrentOrderMap.put(tg.getName(), tg);
        Integer minutes = (Integer)this._maxChartHistoryInMinutes_spm.getValue();
        tg.setChartMaxHistoryTimeInMinutes(minutes);
        if (this._savedGraphNameOrder.contains(tg.getName())) {
            this.setGraphOrder(this._savedGraphNameOrder, false);
        } else {
            this.add((Component)tg.getPanel(), "push, grow, hidemode 3, wrap");
        }
    }

    private void saveProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        String str = this._maxChartHistoryInMinutes_spm.getNumber().toString();
        conf.setProperty("graph.history", str);
        str = this._maxInMemHistoryInMinutes_spm.getNumber().toString();
        conf.setProperty("in-memory.history", str);
        str = this._maxInMemHistoryInMinutes_chk.isSelected() + "";
        conf.setProperty("in-memory.history.in-sync-with-graph-history", str);
        str = StringUtil.toCommaStr(this.getGraphOrderStrList());
        conf.setProperty("graph.order", str);
        conf.save();
    }

    private void loadProps() {
        int hist;
        Configuration conf = Configuration.getCombinedConfiguration();
        boolean inMemHistSync = conf.getBooleanProperty("in-memory.history.in-sync-with-graph-history", true);
        this._maxInMemHistoryInMinutes_chk.setSelected(inMemHistSync);
        this._maxInMemHistoryInMinutes_sp.setEnabled(!inMemHistSync);
        int inMemHist = conf.getIntProperty("in-memory.history", -1);
        if (inMemHist != -1) {
            this.setInMemMaxHistoryTimeInMinutes(inMemHist);
        }
        if ((hist = conf.getIntProperty("graph.history", -1)) != -1) {
            this.setChartMaxHistoryTimeInMinutes(hist);
        }
        String str = conf.getProperty("graph.order", "");
        this._savedGraphNameOrder = StringUtil.parseCommaStrToList(str);
    }

    public void setEnableGraph(String graphName, Boolean enabled) {
        TrendGraph tg = this._graphCurrentOrderMap.get(graphName);
        if (tg == null) {
            throw new RuntimeException("Couldn't find graph name '" + graphName + "' in the list of graphs: " + this._graphCurrentOrderMap);
        }
        tg.setEnable(enabled);
    }

    public void setGraphOrder(Collection<String> newGraphOrder, boolean printWarnings) {
        for (TrendGraph tg : this._graphCurrentOrderMap.values()) {
            this.remove(tg.getPanel());
        }
        this._graphCurrentOrderMap.clear();
        for (String graphName : newGraphOrder) {
            TrendGraph tg = this._graphOriginOrderMap.get(graphName);
            if (tg == null) {
                if (!printWarnings) continue;
                _logger.warn((Object)("Graph name '" + graphName + "' could not be found in the original map."));
                continue;
            }
            this._graphCurrentOrderMap.put(tg.getName(), tg);
            if (!tg.isGraphEnabled()) continue;
            this.add((Component)tg.getPanel(), "push, grow, hidemode 3, wrap");
        }
    }

    public void setGraphOrder(LinkedHashMap<String, Boolean> newGraphOrderMap) {
        for (TrendGraph trendGraph : this._graphCurrentOrderMap.values()) {
            this.remove(trendGraph.getPanel());
        }
        this._graphCurrentOrderMap.clear();
        for (Map.Entry entry : newGraphOrderMap.entrySet()) {
            String graphName = (String)entry.getKey();
            boolean enabled = (Boolean)entry.getValue();
            TrendGraph tg = this._graphOriginOrderMap.get(graphName);
            if (tg == null) {
                _logger.warn((Object)("Graph name '" + graphName + "' could not be found in the original map."));
                continue;
            }
            this._graphCurrentOrderMap.put(tg.getName(), tg);
            tg.setEnable(enabled);
            if (!enabled) continue;
            this.add((Component)tg.getPanel(), "push, grow, hidemode 3, wrap");
        }
    }

    public List<String> getGraphOrderStrList() {
        return this.getGraphOrder(this._graphCurrentOrderMap);
    }

    public List<String> getOriginGraphOrderStrList() {
        return this.getGraphOrder(this._graphOriginOrderMap);
    }

    private List<String> getGraphOrder(Map<String, TrendGraph> in) {
        ArrayList<String> list = new ArrayList<String>();
        for (TrendGraph tg : in.values()) {
            list.add(tg.getName());
        }
        return list;
    }

    public Collection<TrendGraph> getGraphOrder() {
        return this._graphCurrentOrderMap.values();
    }

    public Collection<TrendGraph> getOriginGraphOrder() {
        return this._graphOriginOrderMap.values();
    }

    public void saveOrderAndVisibility() {
        this.saveProps();
    }

    public void removeOrderAndVisibility() {
        this.setGraphOrder(this.getOriginGraphOrderStrList(), true);
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf != null) {
            conf.remove("graph.order");
            conf.save();
        }
    }
}

