/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.swing;

import asemon.gui.swing.AbstractComponentDecorator;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class AbstractComponentDecoratorDemo {
    static Timer timer = new Timer();
    private static final int SIZE = 1000;
    private static final int BLOCK = 20;
    private static final int LINE = 20;

    private static JPanel createDecoratedPanel(int margin) {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(margin, margin, margin, margin));
        JLabel banner = new JLabel("Decorator Demo");
        banner.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 8, 0), new LineBorder(Color.black)));
        Font f = banner.getFont();
        banner.setFont(f.deriveFont(1, f.getSize() * 2));
        GradientBackground g = new GradientBackground(banner);
        p.add((Component)banner, "North");
        JPanel box = new JPanel(new GridLayout(0, 1));
        p.add((Component)box, "South");
        Lines lines = new Lines(){
            Labeler labeler = new Labeler(this);

            @Override
            public void setBounds(Rectangle bounds) {
                super.setBounds(bounds);
                this.labeler.revalidate();
                this.labeler.repaint();
            }
        };
        JScrollPane scroll = new JScrollPane(lines);
        scroll.setBorder(new TitledBorder("Partially-hovering labels"));
        p.add((Component)scroll, "Center");
        JTextField tf = new JTextField("Badge decoration");
        tf.setBorder(new TitledBorder("Draw a badge icon with tooltip"));
        WarningBadge w = new WarningBadge(tf);
        w.setToolTipText("The tooltip is tied to the decoration");
        box.add(tf);
        JLabel draftLabel = new JLabel("Stamp Over");
        draftLabel.setBorder(new TitledBorder("Watermark"));
        DraftWatermark draft = new DraftWatermark(draftLabel);
        box.add(draftLabel);
        JLabel label = new JLabel("This component has been dimmed");
        label.setBorder(new TitledBorder("Dim the entire component"));
        Dimmer d = new Dimmer(label);
        box.add(label);
        JLabel selection = new JLabel("Click and drag to select");
        selection.setBorder(new TitledBorder("Marquee Selection"));
        Marquee band = new Marquee(selection);
        box.add(selection);
        JLabel bgLabel = new JLabel("This background is decorated");
        bgLabel.setBorder(new TitledBorder("Dynamic Background"));
        Background bg = new Background(bgLabel);
        box.add(bgLabel);
        JLabel spot = new JLabel("A common screensaver theme");
        spot.setBorder(new TitledBorder("Dynamic Decoration"));
        Spotlight s = new Spotlight(spot, 20);
        box.add(spot);
        return p;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Decorator Demo");
        frame.setDefaultCloseOperation(3);
        int MARGIN = 10;
        JPanel p = AbstractComponentDecoratorDemo.createDecoratedPanel(10);
        boolean asTab = false;
        if (asTab) {
            JTabbedPane tp = new JTabbedPane();
            tp.add("blank", new JLabel("blank"));
            tp.add("decorators", p);
            tp.add("scrolled", new JScrollPane(AbstractComponentDecoratorDemo.createDecoratedPanel(10)));
            frame.getContentPane().add(tp);
        } else {
            frame.getContentPane().add(p);
        }
        frame.pack();
        frame.setVisible(true);
    }

    static class FocusHandler {
        private FocusBorder border;

        public FocusHandler() {
            KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            mgr.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (FocusHandler.this.border != null) {
                        FocusHandler.this.border.dispose();
                    }
                    if (e.getNewValue() instanceof JComponent) {
                        FocusHandler.this.border = new FocusBorder((JComponent)e.getNewValue());
                    }
                }
            });
        }

        private class FocusBorder
        extends AbstractComponentDecorator {
            final int WIDTH = 5;

            public FocusBorder(JComponent c) {
                super(c);
                this.WIDTH = 5;
            }

            @Override
            protected Rectangle getDecorationBounds() {
                Rectangle b = super.getDecorationBounds();
                b.x -= 5;
                b.y -= 5;
                b.width += 10;
                b.height += 10;
                return b;
            }

            @Override
            public void paint(Graphics g) {
                Rectangle r = this.getDecorationBounds();
                g = g.create();
                g.setColor(new Color(0, 255, 0, 128));
                ((Graphics2D)g).setStroke(new BasicStroke(5.0f));
                g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
                g.dispose();
            }
        }
    }

    static class GradientBackground
    extends AbstractComponentDecorator {
        public GradientBackground(JComponent c) {
            super(c, -1);
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            JComponent jc = this.getComponent();
            int h = jc.getHeight() / 2;
            Color c = jc.getBackground().darker();
            GradientPaint gp = new GradientPaint(0.0f, h, c, jc.getWidth() / 2, h, jc.getBackground());
            g.setPaint(gp);
            Insets insets = jc.getInsets();
            g.fillRect(insets.left, insets.top, jc.getWidth() - insets.right, jc.getHeight() - insets.bottom);
        }
    }

    static class DraftWatermark
    extends AbstractComponentDecorator {
        public DraftWatermark(JComponent target) {
            super(target);
        }

        @Override
        public void paint(Graphics graphics) {
            Rectangle r = this.getDecorationBounds();
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font f = g.getFont();
            g.setFont(f.deriveFont(1, (float)f.getSize() * 2.0f));
            g.setColor(new Color(128, 128, 128, 128));
            double theta = -0.5235987755982988;
            g.rotate(theta);
            int dx = (int)Math.abs((double)r.height * Math.sin(theta));
            g.translate(dx, r.height);
            g.drawString("DRAFT", 0, r.height * 3 / 4);
        }
    }

    static class Marquee
    extends AbstractComponentDecorator
    implements MouseListener,
    MouseMotionListener {
        final int LINE_WIDTH = 4;
        private float phase = 0.0f;
        private Point origin = new Point(0, 0);

        public Marquee(JComponent target) {
            super(target, 100);
            this.setDecorationBounds(new Rectangle(0, 0, 0, 0));
            target.addMouseListener(this);
            target.addMouseMotionListener(this);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Marquee.this.phase += 1.0f;
                    Marquee.this.repaint();
                }
            }, 0L, 50L);
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            g.setColor(Color.red);
            Rectangle r = this.getDecorationBounds();
            g.setStroke(new BasicStroke(4.0f, 0, 1, 10.0f, new float[]{4.0f}, this.phase));
            g.drawRect(r.x, r.y, r.width, r.height);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.setDecorationBounds(new Rectangle(e.getX() - 2, e.getY() - 2, 0, 0));
            this.origin.setLocation(e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.setDecorationBounds(new Rectangle(0, 0, 0, 0));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int width = Math.abs(this.origin.x - e.getX());
            int height = Math.abs(this.origin.y - e.getY());
            int x = Math.min(e.getX(), this.origin.x);
            int y = Math.min(e.getY(), this.origin.y);
            this.setDecorationBounds(new Rectangle(x, y, width, height));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    static class Spotlight
    extends AbstractComponentDecorator {
        private Point where;
        private int size;
        private int delta;
        private int dx;
        private int dy;

        public Spotlight(JComponent t, final int size) {
            super(t);
            this.dx = this.delta = 1;
            this.dy = this.delta;
            this.where = new Point(t.getWidth() / 2, t.getHeight() / 2);
            this.size = size;
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (((Spotlight)Spotlight.this).where.x + size >= Spotlight.this.getComponent().getWidth()) {
                        Spotlight.this.dx = -Spotlight.this.delta;
                    } else if (((Spotlight)Spotlight.this).where.x < 0) {
                        Spotlight.this.dx = Spotlight.this.delta;
                    }
                    if (((Spotlight)Spotlight.this).where.y + size >= Spotlight.this.getComponent().getHeight()) {
                        Spotlight.this.dy = -Spotlight.this.delta;
                    } else if (((Spotlight)Spotlight.this).where.y < 0) {
                        Spotlight.this.dy = Spotlight.this.delta;
                    }
                    ((Spotlight)Spotlight.this).where.x += Spotlight.this.dx;
                    ((Spotlight)Spotlight.this).where.y += Spotlight.this.dy;
                    Spotlight.this.repaint();
                }
            }, 0L, 20L);
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle r = this.getDecorationBounds();
            Color c = new Color(20, 20, 20, 196);
            g.setColor(c);
            Ellipse2D.Float spot = new Ellipse2D.Float(r.x + this.where.x, r.y + this.where.y, this.size, this.size);
            Area area = new Area(r);
            area.subtract(new Area(spot));
            g.fill(area);
            g.setColor(new Color(255, 255, 0, 128));
            g.fill(spot);
        }
    }

    static final class Background
    extends AbstractComponentDecorator {
        private float angle;

        public Background(JComponent target) {
            super(target, -1);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Background.this.angle = (float)((double)Background.this.angle + 0.06981317007977318);
                    Background.this.repaint();
                }
            }, 0L, 50L);
        }

        @Override
        public void paint(Graphics graphics) {
            Rectangle r = this.getDecorationBounds();
            Graphics2D g = (Graphics2D)graphics;
            float x1 = (float)((double)(r.width / 2) + Math.cos(this.angle) * 100.0);
            float x2 = (float)((double)(r.width / 2) + Math.cos((double)this.angle + Math.PI) * 100.0);
            float y1 = (float)((double)(r.height / 2) + Math.sin(this.angle) * 100.0);
            float y2 = (float)((double)(r.height / 2) + Math.sin((double)this.angle + Math.PI) * 100.0);
            GradientPaint p = new GradientPaint(x1, y1, Color.green, x2, y2, Color.blue, true);
            g.setPaint(p);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    static class Lines
    extends JComponent
    implements Scrollable {
        Lines() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(100, 60);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(1000, 1000);
        }

        @Override
        public void paintComponent(Graphics g) {
            for (int i = 0; i < 1000; i += 20) {
                g.drawLine(0, i, 999, i);
                for (int dot = 0; dot < 1000; dot += 20) {
                    g.fillRect(i - 2, dot - 2, 5, 5);
                }
            }
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 1;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 6;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    static class Labeler
    extends AbstractComponentDecorator {
        private Point location = new Point(0, 0);

        public Labeler(JComponent target) {
            super(target);
        }

        public void revalidate() {
            if (this.isVisible()) {
                Point location = this.getLocation();
                Dimension size = this.getPreferredSize();
                this.setDecorationBounds(location.x, location.y, size.width, size.height);
            }
        }

        public Point getLocation() {
            return this.location;
        }

        public void setLocation(int x, int y) {
            if (!new Point(x, y).equals(this.location)) {
                this.location = new Point(x, y);
                Dimension d = this.getPreferredSize();
                this.setDecorationBounds(x, y, d.width, d.height);
            }
        }

        public Dimension getPreferredSize() {
            return this.getComponent().getPreferredSize();
        }

        @Override
        public Rectangle getDecorationBounds() {
            Rectangle r = new Rectangle(super.getDecorationBounds());
            Rectangle visible = this.getComponent().getVisibleRect();
            if (r.x < visible.x) {
                r.x = visible.x;
            }
            return r;
        }

        @Override
        public void paint(Graphics g) {
            Rectangle r = this.getDecorationBounds();
            for (int i = 0; i < 1000; i += 20) {
                g.drawString("label " + (i / 20 + 1), r.x, r.y + i + g.getFontMetrics().getAscent() + 2);
            }
        }
    }

    static class Dimmer
    extends AbstractComponentDecorator {
        public Dimmer(JComponent target) {
            super(target);
        }

        @Override
        public void paint(Graphics g) {
            g = g.create();
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.75f));
            Color bg = this.getComponent().getBackground();
            g.setColor(bg);
            Rectangle r = this.getDecorationBounds();
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    static class WarningBadge
    extends AbstractComponentDecorator {
        private final int SIZE = 16;

        public WarningBadge(JTextField f) {
            super(f);
        }

        @Override
        public Rectangle getDecorationBounds() {
            Rectangle r = super.getDecorationBounds();
            r.x = this.getComponent().getWidth() - 16 - 1;
            Insets insets = this.getComponent().getInsets();
            if (insets != null) {
                r.x -= insets.right;
            }
            r.y = (this.getComponent().getHeight() - 16) / 2;
            return r;
        }

        @Override
        public void paint(Graphics graphics) {
            Rectangle r = this.getDecorationBounds();
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath triangle = new GeneralPath();
            triangle.moveTo(r.x + 8, r.y);
            triangle.lineTo(r.x + 16 - 1, r.y + 16 - 1);
            triangle.lineTo(r.x, r.y + 16 - 1);
            triangle.closePath();
            g.setColor(Color.yellow);
            g.fill(triangle);
            g.setColor(Color.black);
            g.draw(triangle);
            g.drawLine(r.x + 8, r.y + 4, r.x + 8, r.y + 12 - 2);
            g.drawLine(r.x + 8, r.y + 12 + 1, r.x + 8, r.y + 16 - 4);
        }
    }
}

