/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.swing;

import asemon.gui.swing.GTabbedPaneViewDialog;
import asemon.gui.swing.GTabbedPaneWindowProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class GTabbedPane
extends JTabbedPane
implements MouseListener {
    private static Logger _logger = Logger.getLogger(GTabbedPane.class);
    private static final long serialVersionUID = 6963407617181792852L;
    private ImageIcon _undockedFrameIcon = new ImageIcon(GTabbedPane.class.getResource("images/undocked_frame_icon.gif"));
    private ImageIcon _iconWinPlus = new ImageIcon(GTabbedPane.class.getResource("images/window_plus.gif"));
    private ImageIcon _iconWinMinus = new ImageIcon(GTabbedPane.class.getResource("images/window_minus.gif"));
    private JPopupMenu _tabMenu = null;
    private Vector _extEntry = new Vector();
    private int _lastMouseClickAtTabIndex = -1;
    private GTabbedPane _thisGTabbedPane = null;
    private TabOrderAndVisibilityListener _tabOrderAndVisibilityListener = null;

    public GTabbedPane() {
        this.init();
    }

    public GTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.init();
    }

    public GTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.init();
    }

    private synchronized void init() {
        this._thisGTabbedPane = this;
        this.addMouseListener(this);
        this._tabMenu = this.createTabPopupMenu();
        this.setTabLayoutPolicy(super.getTabLayoutPolicy());
    }

    public JMenuItem getMenuItemNamed(String name) {
        JPopupMenu tabMenu = this.getTabPopupMenu();
        if (tabMenu != null) {
            for (int i = 0; i < tabMenu.getComponentCount(); ++i) {
                JMenuItem mi;
                Component comp = tabMenu.getComponent(i);
                if (!(comp instanceof JMenuItem) || !name.equals((mi = (JMenuItem)comp).getName())) continue;
                _logger.debug((Object)("Found JMenuItem for name '" + name + "'."));
                return mi;
            }
        }
        return null;
    }

    public JMenu getMenuNamed(String name) {
        JPopupMenu tabMenu = this.getTabPopupMenu();
        if (tabMenu != null) {
            for (int i = 0; i < tabMenu.getComponentCount(); ++i) {
                JMenu m;
                Component comp = tabMenu.getComponent(i);
                if (!(comp instanceof JMenu) || (m = this.getMenuNamed((JMenu)comp, name)) == null) continue;
                return m;
            }
        }
        return null;
    }

    private JMenu getMenuNamed(JMenu menu, String name) {
        _logger.trace((Object)("getMenuNamed(): name='" + name + "', jmenu.getName()='" + menu.getName() + "'."));
        if (name.equals(menu.getName())) {
            _logger.debug((Object)("Found JMenu for name '" + name + "'."));
            return menu;
        }
        _logger.trace((Object)("getMenuNamed(): name='" + name + "', menu.getMenuComponentCount()='" + menu.getMenuComponentCount() + "'."));
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            JMenu m;
            Component comp = menu.getMenuComponent(i);
            if (!(comp instanceof JMenu) || (m = this.getMenuNamed((JMenu)comp, name)) == null) continue;
            return m;
        }
        return null;
    }

    public ImageIcon getUndockedFrameIcon() {
        return this._undockedFrameIcon;
    }

    public ImageIcon getWindowUndockIcon() {
        return this._iconWinPlus;
    }

    public ImageIcon getWindowDockIcon() {
        return this._iconWinMinus;
    }

    public void setUndockedFrameIcon(ImageIcon icon) {
        this._undockedFrameIcon = icon;
    }

    public void setWindowUndockIcon(ImageIcon icon) {
        this._iconWinPlus = icon;
    }

    public void setWindowDockIcon(ImageIcon icon) {
        this._iconWinMinus = icon;
    }

    public JButton getDockOrUndockButton(int viewIndex) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        return xe == null ? null : xe._winOpenCloseButton;
    }

    public JButton getDockOrUndockButton(String tabName) {
        TabExtendedEntry xe = this.getExtendedEntry(tabName);
        return xe == null ? null : xe._winOpenCloseButton;
    }

    public void setDockOrUndockButtonGui(JButton button) {
        button.setIcon(this.getWindowUndockIcon());
        button.setText(null);
        button.setContentAreaFilled(false);
        button.setMargin(new Insets(3, 3, 3, 3));
        button.setToolTipText("Show the content of this panel in it's own window (and disappear from the TabbedPane).\n To put the panel back on the TabbedPane, just close the window.");
    }

    public void setDockOrUndockButton(int index, JButton button, boolean setDefaultGui) {
        TabExtendedEntry xe = this.getViewExtendedEntry(index);
        if (xe == null) {
            return;
        }
        xe._winOpenCloseButton = button;
        if (xe._winOpenCloseButton == null) {
            return;
        }
        if (setDefaultGui) {
            this.setDockOrUndockButtonGui(xe._winOpenCloseButton);
        }
        xe._winOpenCloseButton.putClientProperty("TabExtendedEntry", xe);
        xe._winOpenCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton button = (JButton)e.getSource();
                TabExtendedEntry xe = (TabExtendedEntry)button.getClientProperty("TabExtendedEntry");
                if (xe != null) {
                    GTabbedPane.this.windowOpenClose(xe._tabIndex);
                }
            }
        });
    }

    public void setDockOrUndockButton(String tabName, JButton button, boolean setDefaultGui) {
        this.setDockOrUndockButton(this.getModelExtendedEntryIndex(tabName), button, setDefaultGui);
    }

    public JButton createDockOrUndockButton() {
        JButton button = new JButton();
        this.setDockOrUndockButtonGui(button);
        return button;
    }

    public JPopupMenu getTabPopupMenu() {
        return this._tabMenu;
    }

    public JPopupMenu createTabPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem undock_mi = new JMenuItem("Un Dock, show content in a window");
        JMenuItem dock_mi = new JMenuItem("Dock, bring back the window into the tab");
        JMenuItem ontop_mi = new JMenuItem("On Top, bring un docked window to front");
        JRadioButtonMenuItem tabScroll_mi = new JRadioButtonMenuItem("Tab Layout Scroll");
        JRadioButtonMenuItem tabWrap_mi = new JRadioButtonMenuItem("Tab Layout Wrap");
        JMenu tabOptions_m = new JMenu("Tab Options");
        JMenuItem tabViewDialog_mi = new JMenuItem("Open Tab View Dialog...");
        JMenuItem hideThisTab_mi = new JMenuItem("Hide this Tab");
        JMenu showHideTab_m = new JMenu("Show or Hide Tab Named");
        JMenu gotoTab_m = new JMenu("Goto Tab Name");
        JMenuItem props_mi = new JMenuItem("Properties...");
        undock_mi.setName("UNDOCK");
        dock_mi.setName("DOCK");
        ontop_mi.setName("ONTOP");
        tabScroll_mi.setName("SCROLL");
        tabWrap_mi.setName("WRAP");
        tabOptions_m.setName("TAB_OPTIONS");
        gotoTab_m.setName("GOTO");
        props_mi.setName("PROPS");
        tabViewDialog_mi.setName("OPEN_TAB_VIEW_DIALOG");
        hideThisTab_mi.setName("HIDE_THIS_TAB");
        showHideTab_m.setName("SHOW_OR_HIDE");
        ActionListener dockAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTabbedPane.this.windowOpenClose(GTabbedPane.this._lastMouseClickAtTabIndex);
            }
        };
        undock_mi.addActionListener(dockAl);
        dock_mi.addActionListener(dockAl);
        ontop_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabExtendedEntry xe = GTabbedPane.this.getViewExtendedEntry(GTabbedPane.this._lastMouseClickAtTabIndex);
                if (xe == null) {
                    return;
                }
                if (xe._undockedFrame != null && !xe._isDocked) {
                    xe._undockedFrame.setVisible(true);
                }
            }
        });
        tabScroll_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTabbedPane.this.setTabLayoutPolicy(1);
            }
        });
        tabWrap_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTabbedPane.this.setTabLayoutPolicy(0);
            }
        });
        tabViewDialog_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTabbedPaneViewDialog.showDialog(null, GTabbedPane.this._thisGTabbedPane);
            }
        });
        hideThisTab_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabExtendedEntry xe = GTabbedPane.this.getViewExtendedEntry(GTabbedPane.this._lastMouseClickAtTabIndex);
                if (xe == null) {
                    return;
                }
                GTabbedPane.this.setVisibleAtModel(xe._modelIndex, false);
            }
        });
        props_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabExtendedEntry xe = GTabbedPane.this.getViewExtendedEntry(GTabbedPane.this._lastMouseClickAtTabIndex);
                if (xe == null) {
                    return;
                }
                if (xe._comp != null && xe._comp instanceof ShowProperties) {
                    ShowProperties sp = (ShowProperties)((Object)xe._comp);
                    sp.showProperties();
                }
            }
        });
        popupMenu.add(undock_mi);
        popupMenu.add(dock_mi);
        popupMenu.add(ontop_mi);
        popupMenu.addSeparator();
        popupMenu.add(tabScroll_mi);
        popupMenu.add(tabWrap_mi);
        popupMenu.addSeparator();
        popupMenu.add(tabOptions_m);
        popupMenu.add(gotoTab_m);
        popupMenu.add(props_mi);
        tabOptions_m.add(tabViewDialog_mi);
        tabOptions_m.add(hideThisTab_mi);
        tabOptions_m.add(showHideTab_m);
        return popupMenu;
    }

    private void windowOpenClose(int viewIndex) {
        _logger.debug((Object)("windowOpenClose(viewIndex=" + viewIndex + "): title='" + this.getTitleAt(viewIndex) + "'."));
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe == null) {
            _logger.debug((Object)("windowOpenClose(viewIndex=" + viewIndex + "): title='" + this.getTitleAt(viewIndex) + "'. NO TabExtendedEntry WAS FOUND, leaving method at top."));
            return;
        }
        if (xe._isDocked) {
            boolean allowed;
            if (xe._comp instanceof DockUndockManagement && !(allowed = ((DockUndockManagement)((Object)xe._comp)).beforeUndock())) {
                JOptionPane.showMessageDialog(this, "The tab named '" + xe._tabName + "' Can't be UnDocked.\n" + "The decision for this was taken by the underlying component.", "Un Dock", 1);
                return;
            }
            if (xe._winOpenCloseButton != null) {
                xe._winOpenCloseButton.setIcon(this.getWindowDockIcon());
            }
            if (xe._undockedFrame == null) {
                xe._undockedFrame = new JFrame(xe._tabName);
                xe._undockedFrame.setName(xe._tabName);
                xe._undockedFrame.setTitle(xe._tabName);
                boolean noIcon = true;
                if (xe._icon != null && xe._icon instanceof ImageIcon) {
                    xe._undockedFrame.setIconImage(((ImageIcon)xe._icon).getImage());
                    noIcon = false;
                }
                if (noIcon) {
                    xe._undockedFrame.setIconImage(this.getUndockedFrameIcon().getImage());
                }
                if (xe._comp != null) {
                    GTabbedPaneWindowProps wp = null;
                    if (xe._comp instanceof DockUndockManagement) {
                        wp = ((DockUndockManagement)((Object)xe._comp)).getWindowProps();
                    }
                    if (wp == null) {
                        wp = new GTabbedPaneWindowProps();
                    }
                    if (wp.width == -1 && wp.height == -1) {
                        Dimension dim = xe._comp.getPreferredSize();
                        if (dim.height < 100) {
                            dim.height = 100;
                        }
                        if (dim.width < 300) {
                            dim.width = 300;
                        }
                        wp.height = dim.height;
                        wp.width = dim.width;
                    }
                    xe._undockedFrame.setSize(wp.width, wp.height);
                    if (wp.posX != -1 && wp.posY != -1) {
                        xe._undockedFrame.setLocation(wp.posX, wp.posY);
                    }
                }
                xe._undockedFrame.addWindowListener(new WindowAdapter(){

                    private void saveWindowSize(boolean open, WindowEvent e) {
                        String name = e.getWindow().getName();
                        TabExtendedEntry xe = GTabbedPane.this.getExtendedEntry(name);
                        if (xe != null && xe._comp instanceof DockUndockManagement) {
                            GTabbedPaneWindowProps wp = new GTabbedPaneWindowProps();
                            wp.undocked = open;
                            wp.height = e.getWindow().getSize().height;
                            wp.width = e.getWindow().getSize().width;
                            wp.posX = e.getWindow().getX();
                            wp.posY = e.getWindow().getY();
                            ((DockUndockManagement)((Object)xe._comp)).saveWindowProps(wp);
                        }
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                        this.saveWindowSize(true, e);
                    }

                    @Override
                    public void windowOpened(WindowEvent e) {
                        this.saveWindowSize(true, e);
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        String name = e.getWindow().getName();
                        _logger.debug((Object)("FRAME.windowClosing: name = '" + name + "'."));
                        TabExtendedEntry xe = GTabbedPane.this.getExtendedEntry(name);
                        if (xe == null) {
                            _logger.info((Object)("The internal ExtendedEntry for '" + name + "' Can't be found. Can't undock the window..."));
                        } else {
                            this.saveWindowSize(false, e);
                            GTabbedPane.this.removeTabAt(xe._tabIndex);
                            GTabbedPane.this.insertTab(xe._tabName, xe._icon, xe, xe._toolTip, xe._tabIndex);
                            GTabbedPane.this.setSelectedIndex(xe._tabIndex);
                            xe._isDocked = true;
                            if (xe._winOpenCloseButton != null) {
                                xe._winOpenCloseButton.setIcon(GTabbedPane.this.getWindowUndockIcon());
                            }
                            if (xe._comp instanceof DockUndockManagement) {
                                ((DockUndockManagement)((Object)xe._comp)).afterDock();
                            }
                        }
                    }
                });
            }
            xe._isDocked = false;
            xe._undockedFrame.getContentPane().add(xe._comp);
            xe._undockedFrame.setVisible(true);
            UndockedTabHolder holder = new UndockedTabHolder(xe);
            this.insertTab(xe._tabName, xe._icon, holder, xe._toolTip, xe._tabIndex);
            this.setEnabledAt(xe._tabIndex, false);
            boolean foundOneActive = false;
            for (int i = xe._tabIndex; i < this.getTabCount(); ++i) {
                if (!this.isEnabledAt(i)) continue;
                foundOneActive = true;
                this.setSelectedIndex(i);
                break;
            }
            if (!foundOneActive && this.getTabCount() > 0) {
                this.setSelectedIndex(0);
            }
            if (xe._comp instanceof DockUndockManagement) {
                ((DockUndockManagement)((Object)xe._comp)).afterUndock();
            }
        } else {
            boolean allowed;
            if (xe._comp instanceof DockUndockManagement && !(allowed = ((DockUndockManagement)((Object)xe._comp)).beforeDock())) {
                JOptionPane.showMessageDialog(this, "The tab named '" + xe._tabName + "' Can't be Docked.\n" + "The decision for this was taken by the underlying component.", "Dock", 1);
                return;
            }
            xe._undockedFrame.dispatchEvent(new WindowEvent(xe._undockedFrame, 201));
        }
    }

    private TabExtendedEntry getViewExtendedEntry(int viewIndex) {
        _logger.trace((Object)("getViewExtendedEntry(index=" + viewIndex + "), _extEntry.size() = " + this._extEntry.size()));
        Enumeration iter = this._extEntry.elements();
        while (iter.hasMoreElements()) {
            Object o = iter.nextElement();
            TabExtendedEntry xe = null;
            xe = o instanceof UndockedTabHolder ? ((UndockedTabHolder)o)._xe : (TabExtendedEntry)o;
            if (xe == null) continue;
            _logger.debug((Object)("getViewExtendedEntry(viewIndex=" + viewIndex + ") - xe._saveName='" + xe._tabName + "'."));
            if (xe._tabIndex != viewIndex) continue;
            _logger.debug((Object)("getViewExtendedEntry(viewIndex=" + viewIndex + ") - FOUND ENTRY: " + xe));
            return xe;
        }
        _logger.debug((Object)("getViewExtendedEntry(viewIndex=" + viewIndex + ") - NOT FOUND -"));
        return null;
    }

    private TabExtendedEntry getModelExtendedEntry(int modelIndex) {
        Object o = this._extEntry.get(modelIndex);
        TabExtendedEntry xe = null;
        xe = o instanceof UndockedTabHolder ? ((UndockedTabHolder)o)._xe : (TabExtendedEntry)o;
        _logger.trace((Object)("getModelExtendedEntry(modelIndex=" + modelIndex + "), found entry(" + (o instanceof UndockedTabHolder ? "UndockedTabHolder" : "TabExtendedEntry") + "): " + xe));
        return xe;
    }

    private int getModelExtendedEntryIndex(String name) {
        Enumeration iter = this._extEntry.elements();
        while (iter.hasMoreElements()) {
            Object o = iter.nextElement();
            TabExtendedEntry xe = null;
            xe = o instanceof UndockedTabHolder ? ((UndockedTabHolder)o)._xe : (TabExtendedEntry)o;
            _logger.debug((Object)("getExtendedEntryIndex(name='" + name + "') - xe._saveName='" + xe._tabName + "'."));
            if (!name.equals(xe._tabName)) continue;
            _logger.debug((Object)("getExtendedEntryIndex(name='" + name + "') - FOUND ENTRY: " + xe));
            return xe._modelIndex;
        }
        _logger.debug((Object)("getExtendedEntryIndex(name='" + name + "') - NOT FOUND -"));
        return -1;
    }

    private TabExtendedEntry getExtendedEntry(String name) {
        if (name == null) {
            return null;
        }
        Enumeration iter = this._extEntry.elements();
        while (iter.hasMoreElements()) {
            Object o = iter.nextElement();
            TabExtendedEntry xe = null;
            xe = o instanceof UndockedTabHolder ? ((UndockedTabHolder)o)._xe : (TabExtendedEntry)o;
            if (xe == null) continue;
            _logger.debug((Object)("getExtendedEntry(name='" + name + "') - xe._saveName='" + xe._tabName + "'."));
            if (!name.equals(xe._tabName)) continue;
            _logger.debug((Object)("getExtendedEntry(name='" + name + "') - FOUND ENTRY: " + xe));
            return xe;
        }
        _logger.debug((Object)("getExtendedEntry(name='" + name + "') - NOT FOUND -"));
        return null;
    }

    public boolean isTabUnDocked(String name) {
        TabExtendedEntry xe = this.getExtendedEntry(name);
        if (xe == null) {
            return false;
        }
        return !xe._isDocked;
    }

    public boolean isTabUnDocked(int viewIndex) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe == null) {
            return false;
        }
        return !xe._isDocked;
    }

    public JFrame getTabUnDockedFrame(String name) {
        TabExtendedEntry xe = this.getExtendedEntry(name);
        if (xe == null) {
            return null;
        }
        return !xe._isDocked ? xe._undockedFrame : null;
    }

    public JFrame getTabUnDockedFrame(int viewIndex) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe == null) {
            return null;
        }
        return !xe._isDocked ? xe._undockedFrame : null;
    }

    private void printExtendedEntryTable(String preStr) {
        Enumeration iter = this._extEntry.elements();
        while (iter.hasMoreElements()) {
            Object o = iter.nextElement();
            System.out.println(preStr + o);
        }
    }

    public void setVisibleAtModel(List<String> tabNameList, boolean toVisible) {
        for (String tabName : tabNameList) {
            this.setVisibleAtModel(tabName, toVisible);
        }
    }

    public void setVisibleAtModel(String tabName, boolean toVisible) {
        int modelIndex = this.getModelExtendedEntryIndex(tabName);
        if (modelIndex < 0) {
            _logger.warn((Object)("setVisibleAtModel(tabName='" + tabName + "', toVisible=" + toVisible + ") Couldn't find tabName. modelIndex=" + modelIndex));
            return;
        }
        this.setVisibleAtModel(modelIndex, toVisible);
    }

    public void setVisibleAtModel(int modelIndex, boolean toVisible) {
        TabExtendedEntry xe = this.getModelExtendedEntry(modelIndex);
        if (xe == null) {
            return;
        }
        if (xe._isVisible == toVisible) {
            return;
        }
        if (toVisible) {
            int atIndex = this.getInvisibleTabInsertionPoint(this.getTabOrder(), xe);
            super.insertTab(xe._tabName, xe._icon, xe._comp, xe._toolTip, atIndex);
            xe._isVisible = true;
            this.fixTabExtendedEntry();
        } else {
            int nextIndex = this.indexOfTab(xe._tabName) + 1;
            xe._rmBeforeTab = nextIndex >= this.getTabCount() ? null : this.getTitleAt(nextIndex);
            super.removeTabAt(xe._tabIndex);
            xe._isVisible = false;
            this.fixTabExtendedEntry();
        }
    }

    private void fixTabExtendedEntry() {
        List<String> visibleTabs = this.getTabOrder();
        for (int i = 0; i < this._extEntry.size(); ++i) {
            TabExtendedEntry xe = this.getModelExtendedEntry(i);
            if (xe == null) continue;
            xe._modelIndex = i;
            xe._tabIndex = visibleTabs.indexOf(xe._tabName);
        }
    }

    private int getInvisibleTabInsertionPoint(List<String> colList, TabExtendedEntry xe) {
        if (colList == null) {
            throw new RuntimeException("getInvisibleTabInsertionPoint() colList, can't be null.");
        }
        if (xe == null || xe != null && xe._rmBeforeTab == null) {
            return colList.size();
        }
        String rmBeforeTab = xe._rmBeforeTab;
        int atIndex = -1;
        for (int m = 0; m < 256 && rmBeforeTab != null && (atIndex = colList.indexOf(rmBeforeTab)) < 0; ++m) {
            TabExtendedEntry x1 = this.getExtendedEntry(rmBeforeTab);
            rmBeforeTab = x1 != null ? x1._rmBeforeTab : null;
        }
        if (atIndex < 0 || atIndex > colList.size()) {
            atIndex = colList.size();
        }
        return atIndex;
    }

    public boolean isVisibleAtModel(String tabName) {
        int modelIndex = this.getModelExtendedEntryIndex(tabName);
        if (modelIndex < 0) {
            _logger.warn((Object)("isVisibleAtModel(tabName='" + tabName + "') Couldn't find tabName. modelIndex=" + modelIndex));
            return false;
        }
        return this.isVisibleAtModel(modelIndex);
    }

    public boolean isVisibleAtModel(int modelIndex) {
        TabExtendedEntry xe = this.getModelExtendedEntry(modelIndex);
        if (xe == null) {
            return false;
        }
        return xe._isVisible;
    }

    public int getVisibleTabCount() {
        return this.getTabCount();
    }

    public int getModelTabCount() {
        return this._extEntry.size();
    }

    public String getTitleAtModel(int modelIndex) {
        return ((TabExtendedEntry)this._extEntry.get(modelIndex))._tabName;
    }

    public Icon getIconAtModel(int modelIndex) {
        return ((TabExtendedEntry)this._extEntry.get(modelIndex))._icon;
    }

    public String getToolTipTextAtModel(int modelIndex) {
        return ((TabExtendedEntry)this._extEntry.get(modelIndex))._toolTip;
    }

    public Component getComponentAtModel(int modelIndex) {
        return ((TabExtendedEntry)this._extEntry.get(modelIndex))._comp;
    }

    public List<String> getModelTabOrder() {
        ArrayList<String> tabOrder = new ArrayList<String>();
        for (int t = 0; t < this.getModelTabCount(); ++t) {
            tabOrder.add(this.getTitleAtModel(t));
        }
        return tabOrder;
    }

    public List<String> getTabOrder() {
        return this.getTabOrder(false);
    }

    public List<String> getTabOrder(boolean includeNonVisible) {
        int t;
        ArrayList<String> tabOrder = new ArrayList<String>();
        for (t = 0; t < this.getTabCount(); ++t) {
            tabOrder.add(this.getTitleAt(t));
        }
        if (includeNonVisible) {
            for (t = 0; t < this.getModelTabCount(); ++t) {
                TabExtendedEntry xe = this.getModelExtendedEntry(t);
                if (xe == null || xe._isVisible) continue;
                int atIndex = this.getInvisibleTabInsertionPoint(tabOrder, xe);
                tabOrder.add(atIndex, this.getTitleAtModel(t));
            }
        }
        return tabOrder;
    }

    public void setTabOrder(String[] newTabOrder) {
        ArrayList<String> newTabOrderList = new ArrayList<String>();
        for (String str : newTabOrder) {
            newTabOrderList.add(str);
        }
        this.setTabOrder(newTabOrderList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTabOrder(List<String> newTabOrder) {
        ChangeListener[] saveListeners;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("New tab order START: " + newTabOrder));
        }
        List<String> currentTabOrder = this.getTabOrder();
        currentTabOrder.removeAll(newTabOrder);
        newTabOrder.addAll(currentTabOrder);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("New tab order FIXED: " + newTabOrder));
        }
        for (ChangeListener cl : saveListeners = this.getChangeListeners()) {
            this.removeChangeListener(cl);
        }
        try {
            int tabCount = this.getTabCount();
            while (tabCount-- > 0) {
                super.removeTabAt(tabCount);
            }
            int newIndex = 0;
            for (String tabName : newTabOrder) {
                TabExtendedEntry xe = this.getExtendedEntry(tabName);
                if (xe == null) {
                    _logger.info((Object)("Can't find tab named '" + tabName + "' in the current tab pane, skipping this one when setting tab order."));
                    continue;
                }
                if (!xe._isVisible) continue;
                super.insertTab(xe._tabName, xe._icon, xe._comp, xe._toolTip, newIndex++);
            }
            this.fixTabExtendedEntry();
        }
        catch (Throwable t) {
            _logger.warn((Object)("While remove/restoring all the tabs an Exception occurred, which will be discarded. Now I will restore all ChangeListeners. Caught: " + t), t);
        }
        finally {
            for (ChangeListener cl : saveListeners) {
                this.addChangeListener(cl);
            }
        }
    }

    public void setTabOrderAndVisibility(String entries) {
        if (entries == null) {
            return;
        }
        ArrayList<String> listEntries = new ArrayList<String>();
        String[] sa = entries.split(",");
        for (int i = 0; i < sa.length; ++i) {
            listEntries.add(sa[i].trim());
        }
        this.setTabOrderAndVisibility(listEntries);
    }

    public void setTabOrderAndVisibility(String[] entries) {
        if (entries == null) {
            return;
        }
        ArrayList<String> entryList = new ArrayList<String>();
        for (String str : entries) {
            entryList.add(str);
        }
        this.setTabOrderAndVisibility(entryList);
    }

    public void setTabOrderAndVisibility(List<String> entryList) {
        if (entryList == null) {
            return;
        }
        ArrayList<String> tabOrder = new ArrayList<String>();
        ArrayList<String> showTabs = new ArrayList<String>();
        ArrayList<String> hideTabs = new ArrayList<String>();
        showTabs.addAll(this.getTabOrder(true));
        for (String entry : entryList) {
            String[] sa = entry.split("=");
            String tabName = sa[0].trim();
            String tabOpt = "true";
            if (sa.length >= 2) {
                tabOpt = sa[1].trim();
            }
            tabOrder.add(tabName);
            if (!tabOpt.equalsIgnoreCase("false")) continue;
            showTabs.remove(tabName);
            hideTabs.add(tabName);
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)("setTabOrderAndVisibility(List): showTabs=" + showTabs));
            _logger.trace((Object)("setTabOrderAndVisibility(List): tabOrder=" + tabOrder));
            _logger.trace((Object)("setTabOrderAndVisibility(List): hideTabs=" + hideTabs));
        }
        this.setVisibleAtModel(showTabs, true);
        this.setTabOrder(tabOrder);
        this.setVisibleAtModel(hideTabs, false);
    }

    public String getTabOrderAndVisibility() {
        List<String> tabOrderList = this.getTabOrder(true);
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = tabOrderList.iterator();
        while (it.hasNext()) {
            String tabName = it.next();
            sb.append(tabName).append("=").append(this.isVisibleAtModel(tabName));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public void setTabLayoutPolicy(int policy) {
        JMenuItem wrap = this.getMenuItemNamed("WRAP");
        JMenuItem scroll = this.getMenuItemNamed("SCROLL");
        if (wrap != null && wrap instanceof JRadioButtonMenuItem) {
            ((JRadioButtonMenuItem)wrap).setSelected(policy == 0);
        }
        if (scroll != null && scroll instanceof JRadioButtonMenuItem) {
            ((JRadioButtonMenuItem)scroll).setSelected(policy == 1);
        }
        super.setTabLayoutPolicy(policy);
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        GTabbedPaneWindowProps wp;
        TabExtendedEntry xe;
        _logger.trace((Object)("insertTab(title, icon, comp, tip, index): index=" + index + ", title=" + title + ", icon='" + icon + "', component=" + component + ", tip=" + tip));
        boolean newComponent = false;
        if (component instanceof UndockedTabHolder) {
            this._extEntry.insertElementAt(component, index);
        } else if (component instanceof TabExtendedEntry) {
            xe = (TabExtendedEntry)component;
            component = xe._comp;
            this._extEntry.set(index, xe);
        } else {
            JButton button;
            xe = new TabExtendedEntry();
            this._extEntry.insertElementAt(xe, index);
            newComponent = true;
            xe._isDocked = true;
            xe._tabIndex = index;
            xe._tabName = title;
            xe._icon = icon;
            xe._toolTip = tip;
            xe._comp = component;
            xe._undockedFrame = null;
            xe._isVisible = true;
            xe._rmBeforeTab = null;
            xe._modelIndex = index;
            xe._winOpenCloseButton = this.createDockOrUndockButton();
            if (xe._winOpenCloseButton != null) {
                this.setDockOrUndockButton(index, xe._winOpenCloseButton, true);
            }
            if (component instanceof DockUndockManagement && (button = ((DockUndockManagement)((Object)component)).getDockUndockButton()) != null) {
                this.setDockOrUndockButton(index, button, true);
            }
        }
        super.insertTab(title, icon, component, tip, index);
        this.fixTabExtendedEntry();
        if (newComponent && component instanceof DockUndockManagement && (wp = ((DockUndockManagement)((Object)component)).getWindowProps()) != null && wp.undocked) {
            this.windowOpenClose(index);
        }
    }

    @Override
    public void removeTabAt(int viewIndex) {
        _logger.trace((Object)("removeTabAt(index): viewIndex=" + viewIndex));
        Component component = this.getComponentAt(viewIndex);
        if (!(component instanceof UndockedTabHolder) && !(component instanceof TabExtendedEntry)) {
            _logger.trace((Object)("removeTabAt(index): viewIndex=" + viewIndex + ", comp='" + component.getClass().getName() + "', REMOVING TabExtendedEntry."));
            this._extEntry.removeElementAt(viewIndex);
            this.fixTabExtendedEntry();
        }
        super.removeTabAt(viewIndex);
    }

    @Override
    public void setIconAt(int viewIndex, Icon icon) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe != null) {
            xe._icon = icon;
        }
        super.setIconAt(viewIndex, icon);
    }

    @Override
    public void setToolTipTextAt(int viewIndex, String toolTipText) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe != null) {
            xe._toolTip = toolTipText;
        }
        super.setToolTipTextAt(viewIndex, toolTipText);
    }

    @Override
    public void setComponentAt(int viewIndex, Component component) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe != null) {
            xe._comp = component;
        }
        super.setComponentAt(viewIndex, component);
    }

    @Override
    public void setTitleAt(int viewIndex, String title) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe != null) {
            xe._tabName = title;
        }
        super.setTitleAt(viewIndex, title);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String tabName = null;
        Component tabComp = null;
        int tabIndex = -1;
        Point p = e.getPoint();
        tabIndex = this.indexAtLocation(p.x, p.y);
        if (tabIndex != -1) {
            tabName = this.getTitleAt(tabIndex);
            tabComp = this.getComponentAt(tabIndex);
        }
        this._lastMouseClickAtTabIndex = tabIndex;
        if (SwingUtilities.isRightMouseButton(e)) {
            if (e.getClickCount() == 1) {
                _logger.debug((Object)"SINGLE-RIGHT-CLICK");
                JPopupMenu tabMenu = this.getTabPopupMenu();
                if (tabMenu != null) {
                    JMenu showHideMenu;
                    JMenuItem dock = this.getMenuItemNamed("DOCK");
                    JMenuItem undock = this.getMenuItemNamed("UNDOCK");
                    JMenuItem ontop = this.getMenuItemNamed("ONTOP");
                    JMenuItem props = this.getMenuItemNamed("PROPS");
                    if (tabIndex == -1) {
                        _logger.debug((Object)"SINGLE-RIGHT-CLICK: NOT OVER TAB: Disables menu items 'dock, undock, show'");
                        this.setEnabledX(dock, false);
                        this.setEnabledX(undock, false);
                        this.setEnabledX(ontop, false);
                    } else {
                        if (this.isEnabledAt(tabIndex)) {
                            _logger.debug((Object)("SINGLE-RIGHT-CLICK: OVER ENABLED TAB: " + tabName));
                            this.setEnabledX(dock, false);
                            this.setEnabledX(undock, true);
                            this.setEnabledX(ontop, false);
                        } else {
                            _logger.debug((Object)("SINGLE-RIGHT-CLICK: OVER UN-ENABLED TAB: " + tabName));
                            this.setEnabledX(dock, true);
                            this.setEnabledX(undock, false);
                            this.setEnabledX(ontop, true);
                        }
                        if (tabComp instanceof ShowProperties) {
                            this.setEnabledX(props, true);
                        } else {
                            this.setEnabledX(props, false);
                        }
                    }
                    JMenu gotoMenu = this.getMenuNamed("GOTO");
                    if (gotoMenu != null) {
                        gotoMenu.removeAll();
                        for (int i = 0; i < this.getTabCount(); ++i) {
                            JMenuItem mi = new JMenuItem(this.getTitleAt(i), this.getIconAt(i));
                            mi.putClientProperty("tabIndex", new Integer(i));
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Object o = e.getSource();
                                    if (o instanceof JMenuItem) {
                                        JMenuItem mi = (JMenuItem)o;
                                        Object cp = mi.getClientProperty("tabIndex");
                                        if (cp != null && cp instanceof Integer) {
                                            int viewIndex = (Integer)cp;
                                            if (GTabbedPane.this.isEnabledAt(viewIndex)) {
                                                GTabbedPane.this.setSelectedIndex(viewIndex);
                                            } else {
                                                TabExtendedEntry xe = GTabbedPane.this.getViewExtendedEntry(viewIndex);
                                                if (xe == null) {
                                                    return;
                                                }
                                                if (xe._undockedFrame != null && !xe._isDocked) {
                                                    xe._undockedFrame.setVisible(true);
                                                }
                                            }
                                        }
                                        _logger.debug((Object)("GOTO: " + mi.getText()));
                                    }
                                }
                            });
                            gotoMenu.add(mi);
                        }
                    }
                    if ((showHideMenu = this.getMenuNamed("SHOW_OR_HIDE")) != null) {
                        System.out.println("SHOW_OR_HIDE: ");
                        showHideMenu.removeAll();
                        for (int modelIndex = 0; modelIndex < this.getModelTabCount(); ++modelIndex) {
                            TabExtendedEntry xe = this.getModelExtendedEntry(modelIndex);
                            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(xe._tabName, xe._icon, xe._isVisible);
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Object o = e.getSource();
                                    if (o instanceof JCheckBoxMenuItem) {
                                        JCheckBoxMenuItem cmi = (JCheckBoxMenuItem)o;
                                        TabExtendedEntry xei = GTabbedPane.this.getExtendedEntry(cmi.getText());
                                        GTabbedPane.this.setVisibleAtModel(xei._modelIndex, cmi.isSelected());
                                    }
                                }
                            });
                            showHideMenu.add(mi);
                        }
                    }
                    tabMenu.show(e.getComponent(), e.getX(), e.getY() - 10);
                }
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.getClickCount() == 1) {
                _logger.debug((Object)("GTabbedPane.MouseListener: SINGLE-Click on index=" + tabIndex + ", name='" + tabName + "', tabComp=" + tabComp));
                if (tabComp instanceof UndockedTabHolder) {
                    UndockedTabHolder undocked = (UndockedTabHolder)tabComp;
                    TabExtendedEntry xe = undocked._xe;
                    if (xe._undockedFrame != null) {
                        xe._undockedFrame.setVisible(true);
                    }
                    return;
                }
            } else {
                if (_logger.isDebugEnabled()) {
                    String className = "";
                    if (tabComp != null) {
                        className = tabComp.getClass().getName();
                    }
                    _logger.debug((Object)("GTabbedPane.MouseListener: DOUBLE-Click on index=" + tabIndex + ", name='" + tabName + "', tabCompClassName='" + className + "', tabComp=" + tabComp));
                }
                if (tabComp instanceof UndockedTabHolder) {
                    this.windowOpenClose(tabIndex);
                    return;
                }
                if (tabComp instanceof JPanel) {
                    this.windowOpenClose(tabIndex);
                    return;
                }
                if (tabComp instanceof TabExtendedEntry) {
                    TabExtendedEntry xe = (TabExtendedEntry)tabComp;
                    this.windowOpenClose(xe._tabIndex);
                    return;
                }
                JOptionPane.showMessageDialog(this, "The tab named '" + tabName + "' Can't be UnDocked.\n" + "It needs to be a JPanel or implements the interface 'GTabbedPane.DockUndockManagement'.", "UnDock", 0);
                return;
            }
        }
    }

    private void setEnabledX(JComponent comp, boolean enable) {
        if (comp != null) {
            comp.setEnabled(enable);
        }
    }

    public void setTabOrderAndVisibilityListener(TabOrderAndVisibilityListener listener) {
        this._tabOrderAndVisibilityListener = listener;
    }

    public TabOrderAndVisibilityListener getTabOrderAndVisibilityListener() {
        return this._tabOrderAndVisibilityListener;
    }

    public void removeTabOrderAndVisibility() {
        if (this._tabOrderAndVisibilityListener == null) {
            _logger.warn((Object)"The 'removeTabOrderAndVisibilityListener' has not been set, can't do this action. at removeTabOrderAndVisibility()");
            return;
        }
        this._tabOrderAndVisibilityListener.removeTabOrderAndVisibility();
    }

    public void saveTabOrderAndVisibility() {
        if (this._tabOrderAndVisibilityListener == null) {
            _logger.warn((Object)"The 'tabOrderAndVisibilityListener' has not been set, can't do this action. at saveTabOrderAndVisibility()");
            return;
        }
        this._tabOrderAndVisibilityListener.saveTabOrderAndVisibility(this.getTabOrderAndVisibility());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintSpecial();
    }

    private void paintSpecial() {
        int tabCount = this.getTabCount();
        for (int tabIndex = 0; tabIndex < tabCount; ++tabIndex) {
            Component tabComp = this.getComponentAt(tabIndex);
            if (!(tabComp instanceof SpecialTabPainter)) continue;
            SpecialTabPainter stp = (SpecialTabPainter)((Object)tabComp);
            Rectangle r = this.getUI().getTabBounds(this, tabIndex);
            Graphics g = this.getGraphics().create(r.x, r.y, r.width, r.height);
            stp.paintTabHeader((Graphics2D)g);
        }
    }

    public static interface SpecialTabPainter {
        public void paintTabHeader(Graphics2D var1);
    }

    public static interface DockUndockManagement {
        public JButton getDockUndockButton();

        public boolean beforeDock();

        public void afterDock();

        public boolean beforeUndock();

        public void afterUndock();

        public void saveWindowProps(GTabbedPaneWindowProps var1);

        public GTabbedPaneWindowProps getWindowProps();
    }

    public static interface TabOrderAndVisibilityListener {
        public void saveTabOrderAndVisibility(String var1);

        public void removeTabOrderAndVisibility();
    }

    public static interface ShowProperties {
        public void showProperties();
    }

    private class UndockedTabHolder
    extends JComponent {
        private static final long serialVersionUID = 1L;
        TabExtendedEntry _xe = null;

        private UndockedTabHolder(TabExtendedEntry xe) {
            this._xe = xe;
        }
    }

    private class TabExtendedEntry
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private JFrame _undockedFrame = null;
        private boolean _isDocked = true;
        private int _tabIndex = -1;
        private String _tabName = null;
        private Icon _icon = null;
        private String _toolTip = null;
        private Component _comp = null;
        private int _modelIndex = -1;
        private String _rmBeforeTab = null;
        private boolean _isVisible = true;
        private JButton _winOpenCloseButton = null;

        private TabExtendedEntry() {
        }

        @Override
        public String getText() {
            return "The content for the tab '" + this._tabName + "' is undocked.";
        }

        @Override
        public String toString() {
            return "_tabIndex=" + this._tabIndex + ", _modelIndex=" + this._modelIndex + ", _rmBeforeTab=" + this._rmBeforeTab + ", _isVisible=" + this._isVisible + ", _isDocked=" + this._isDocked + ", _tabName='" + this._tabName + "', _icon='" + this._icon + "', _comp=" + this._comp;
        }
    }
}

