/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.swing;

import asemon.gui.TabularCntrPanel;
import asemon.gui.swing.GTabbedPane;
import asemon.gui.swing.MultiLineLabel;
import asemon.utils.Configuration;
import asemon.utils.StringUtil;
import asemon.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.PropertyConfigurator;
import org.jdesktop.swingx.JXTable;

public class GTabbedPaneViewDialog
extends JDialog
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private ImageIcon _iconTab = new ImageIcon(GTabbedPaneViewDialog.class.getResource("images/tab.gif"));
    private ImageIcon _iconUp = new ImageIcon(GTabbedPaneViewDialog.class.getResource("images/up.png"));
    private ImageIcon _iconDown = new ImageIcon(GTabbedPaneViewDialog.class.getResource("images/down.png"));
    private MultiLineLabel _description1 = new MultiLineLabel("Choose in what order the Tabs 'Title names' will be arranged on the Tab Pane.");
    private MultiLineLabel _description2 = new MultiLineLabel("You can also hide some Tabs, which you think you may never use.");
    private JButton _up = new JButton();
    private JButton _down = new JButton();
    private JButton _toStartOrder = new JButton("To Start Order");
    private JButton _toOriginOrder = new JButton("To Original Order");
    private JButton _rmTabOrderVis = new JButton("Clear saved info");
    private DefaultTableModel _tableModel = null;
    private JXTable _table = null;
    private GTabbedPane _gTabbedPane = null;
    private List<String> _modelOrder = new ArrayList<String>();
    private List<String> _orderAtStart = new ArrayList<String>();
    private DefaultTableModel _tableModelAtStart = null;
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private JButton _apply = new JButton("Apply");
    private int _dialogReturnSt = 2;

    private GTabbedPaneViewDialog(Frame owner, GTabbedPane gTabbedPane) {
        super(owner, "Change Tabs Order and Visibility", true);
        this._gTabbedPane = gTabbedPane;
        this._modelOrder = gTabbedPane.getModelTabOrder();
        this._orderAtStart = gTabbedPane.getTabOrder(true);
        this.initComponents();
        this._tableModelAtStart = SwingUtils.copyTableModel(this._tableModel);
        this.pack();
        Dimension size = this.getSize();
        size.height += (this._table.getRowCount() - 6) * 18;
        size.width = Math.min(size.width, 700);
        this.setSize(size);
    }

    public static int showDialog(Frame owner, GTabbedPane gTabbedPane) {
        GTabbedPaneViewDialog dialog = new GTabbedPaneViewDialog(owner, gTabbedPane);
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        dialog.dispose();
        return dialog._dialogReturnSt;
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add((Component)this._description1, "grow, wrap");
        panel.add((Component)this._description2, "grow, wrap 10");
        this._table = this.createTable();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._table);
        panel.add((Component)jScrollPane, "span, grow, height 100%, push, wrap");
        panel.add((Component)this._up, "tag left, span, split");
        panel.add((Component)this._down, "tag left");
        panel.add((Component)this._toStartOrder, "tag left");
        panel.add((Component)this._toOriginOrder, "tag left");
        panel.add((Component)this._rmTabOrderVis, "tag right, wrap push");
        panel.add((Component)this.createOkPanel(), "gap top 20, right");
        this._apply.setEnabled(false);
        this.setContentPane(panel);
        this._up.addActionListener(this);
        this._down.addActionListener(this);
        this._toStartOrder.addActionListener(this);
        this._toOriginOrder.addActionListener(this);
        this._rmTabOrderVis.addActionListener(this);
        this._up.setToolTipText("Move the tab up (or to left in the TabbedPane)");
        this._down.setToolTipText("Move the tab down (or to right in the TabbedPane)");
        this._toStartOrder.setToolTipText("Restore the tabs to the order it had when this dialog was opened.");
        this._toOriginOrder.setToolTipText("Restore the tabs to the order it originally was when TabbedPane was created.");
        this._rmTabOrderVis.setToolTipText("<html>Remove/clear the persisted values for TabTitles order and the visibility.<br>This is usually stored in the configuration or properties file.</html>");
        this._up.setIcon(this._iconUp);
        this._down.setIcon(this._iconDown);
        if (this._iconTab != null) {
            this.setIconImage(this._iconTab.getImage());
        }
        if (this._up.getIcon() == null) {
            this._up.setText("Move Up");
        }
        if (this._down.getIcon() == null) {
            this._down.setText("Move Down");
        }
        this.pack();
    }

    JPanel createOkPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0 0", "", ""));
        panel.add((Component)this._ok, "tag ok");
        panel.add((Component)this._cancel, "tag cancel");
        panel.add((Component)this._apply, "tag apply");
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        this._apply.addActionListener(this);
        return panel;
    }

    private void apply() {
        this._table.clearSelection();
        ArrayList<String> newTabOrder = new ArrayList<String>();
        for (int r = 0; r < this._table.getRowCount(); ++r) {
            String tabName = (String)this._table.getValueAt(r, TabPos.Name.ordinal());
            Boolean visible = (Boolean)this._table.getValueAt(r, TabPos.Visible.ordinal());
            this._gTabbedPane.setVisibleAtModel(tabName, (boolean)visible);
            if (!visible.booleanValue()) continue;
            newTabOrder.add(tabName);
        }
        this._gTabbedPane.setTabOrder(newTabOrder);
        this._gTabbedPane.saveTabOrderAndVisibility();
        this._apply.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultTableModel dtm;
        int toRow;
        int row;
        Object source = e.getSource();
        if (this._up.equals(source)) {
            row = this._table.getSelectedRow();
            if (row < 0) {
                SwingUtils.showInfoMessage(this, "Select a row", "No row in the table is selected.");
                return;
            }
            toRow = row - 1;
            dtm = (DefaultTableModel)this._table.getModel();
            if (toRow >= 0) {
                dtm.moveRow(row, row, toRow);
                this._table.getSelectionModel().setSelectionInterval(toRow, toRow);
            }
        }
        if (this._down.equals(source)) {
            row = this._table.getSelectedRow();
            if (row < 0) {
                SwingUtils.showInfoMessage(this, "Select a row", "No row in the table is selected.");
                return;
            }
            toRow = row + 1;
            dtm = (DefaultTableModel)this._table.getModel();
            if (toRow < dtm.getRowCount()) {
                dtm.moveRow(row, row, toRow);
                this._table.getSelectionModel().setSelectionInterval(toRow, toRow);
            }
        }
        if (this._toStartOrder.equals(source)) {
            this.toTabOrder(this._tableModel, this._orderAtStart);
        }
        if (this._toOriginOrder.equals(source)) {
            this.toTabOrder(this._tableModel, this._modelOrder);
        }
        if (this._rmTabOrderVis.equals(source)) {
            this._gTabbedPane.removeTabOrderAndVisibility();
        }
        if (this._ok.equals(source)) {
            this.apply();
            this._dialogReturnSt = 0;
            this.setVisible(false);
        }
        if (this._cancel.equals(source)) {
            this._dialogReturnSt = 2;
            this.setVisible(false);
        }
        if (this._apply.equals(source)) {
            this.apply();
        }
    }

    private void toTabOrder(DefaultTableModel tm, List<String> originTabOrder) {
        for (int oi = 0; oi < originTabOrder.size(); ++oi) {
            String tabName = originTabOrder.get(oi);
            int moveRow = -1;
            for (int tr = 0; tr < tm.getRowCount(); ++tr) {
                if (!tabName.equals(tm.getValueAt(tr, TabPos.Name.ordinal()))) continue;
                moveRow = tr;
                break;
            }
            if (moveRow < 0 || oi == moveRow) continue;
            tm.moveRow(moveRow, moveRow, oi);
        }
    }

    private void checkForChanges() {
        boolean enabled = false;
        for (int r = 0; r < this._table.getRowCount(); ++r) {
            String rowTabName = (String)this._table.getValueAt(r, TabPos.Name.ordinal());
            Boolean rowVisible = (Boolean)this._table.getValueAt(r, TabPos.Visible.ordinal());
            String startTabName = (String)this._tableModelAtStart.getValueAt(r, TabPos.Name.ordinal());
            Boolean startVisible = (Boolean)this._tableModelAtStart.getValueAt(r, TabPos.Visible.ordinal());
            if (!rowTabName.equals(startTabName)) {
                enabled = true;
            }
            if (!rowVisible.equals(startVisible)) {
                enabled = true;
            }
            if (enabled) break;
        }
        this._apply.setEnabled(enabled);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.checkForChanges();
    }

    public JXTable createTable() {
        Vector<String> tabHead = new Vector<String>();
        tabHead.setSize(TabPos.values().length);
        tabHead.set(TabPos.Icon.ordinal(), "Icon");
        tabHead.set(TabPos.Visible.ordinal(), "Visible");
        tabHead.set(TabPos.Name.ordinal(), "Name");
        tabHead.set(TabPos.Description.ordinal(), "Description");
        Vector<Vector<Object>> tabData = this.populateTable();
        this._tableModel = new DefaultTableModel(tabData, tabHead){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == TabPos.Icon.ordinal()) {
                    return Icon.class;
                }
                if (column == TabPos.Visible.ordinal()) {
                    return Boolean.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == TabPos.Visible.ordinal();
            }
        };
        this.toTabOrder(this._tableModel, this._orderAtStart);
        this._tableModel.addTableModelListener(this);
        JXTable table = new JXTable((TableModel)this._tableModel);
        table.setSortable(false);
        table.setAutoResizeMode(0);
        table.setShowGrid(false);
        table.setSelectionMode(0);
        SwingUtils.calcColumnWidths((JTable)table);
        return table;
    }

    private Vector<Vector<Object>> populateTable() {
        Vector<Vector<Object>> tab = new Vector<Vector<Object>>();
        Vector<Object> row = new Vector<Object>();
        for (int t = 0; t < this._gTabbedPane.getModelTabCount(); ++t) {
            row = new Vector();
            row.setSize(TabPos.values().length);
            row.set(TabPos.Icon.ordinal(), this._gTabbedPane.getIconAtModel(t));
            row.set(TabPos.Visible.ordinal(), this._gTabbedPane.isVisibleAtModel(t));
            row.set(TabPos.Name.ordinal(), this._gTabbedPane.getTitleAtModel(t));
            row.set(TabPos.Description.ordinal(), StringUtil.stripHtml(this._gTabbedPane.getToolTipTextAtModel(t)));
            tab.add(row);
        }
        return tab;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "TRACE, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        Configuration conf2 = new Configuration("c:\\projects\\asemon\\asemon.properties");
        Configuration.setInstance("SYSTEM_CONF", conf2);
        TestClass testme = new TestClass();
        testme.setVisible(true);
    }

    private static class TestClass
    extends JFrame
    implements ChangeListener {
        GTabbedPane _gtabs = new GTabbedPane();

        TestClass() {
            this.setTitle("MigLayout Samples");
            this.setDefaultCloseOperation(3);
            this._gtabs.add("0-Summary", new TabularCntrPanel("0-Summary"));
            this._gtabs.add("1-Object", new TabularCntrPanel("1-Object"));
            this._gtabs.add("2-Processes", new TabularCntrPanel("2-Processes"));
            this._gtabs.add("3-Databases", new TabularCntrPanel("3-Databases"));
            this._gtabs.add("4-Waits", new TabularCntrPanel("4-Waits"));
            this._gtabs.add("5-Engines", new TabularCntrPanel("5-Engines"));
            this._gtabs.add("6-Data Caches", new TabularCntrPanel("6-Data Caches"));
            this._gtabs.add("7-Pools", new TabularCntrPanel("7-Pools"));
            this._gtabs.add("8-Devices", new TabularCntrPanel("8-Devices"));
            this.add(this._gtabs);
            this._gtabs.addChangeListener(this);
            JMenuBar main_mb = new JMenuBar();
            this.setJMenuBar(main_mb);
            JMenu menu = new JMenu("Test Cases");
            main_mb.add(menu);
            JMenuItem mi = null;
            mi = new JMenuItem("Show Counter View Dialog");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("ACTION: Show Counter View Dialog.");
                    int ret = GTabbedPaneViewDialog.showDialog(null, TestClass.this._gtabs);
                    System.out.println("RESPONSE: GTabbedPaneViewDialog.showDialog(...) returned=" + ret);
                }
            });
            menu.add(mi);
            mi = new JMenuItem("Hide all columns");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("ACTION: Hide all columns.");
                    TestClass.this._gtabs.setVisibleAtModel(TestClass.this._gtabs.getTabOrder(false), false);
                }
            });
            menu.add(mi);
            final String[] sa1 = new String[]{"1-Object", "4-Waits", "7-Pools"};
            mi = new JMenuItem("setTabOrder(String[]: '" + Arrays.asList(sa1) + "'.");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("ACTION: setTabOrder(String[]: '" + Arrays.asList(sa1) + "'.");
                    TestClass.this._gtabs.setTabOrder(sa1);
                }
            });
            menu.add(mi);
            final String[] sa2 = new String[]{"1-Object=true", "4-Waits=false", "7-Pools"};
            mi = new JMenuItem("setTabOrderAndVisibility(String[]: '" + Arrays.asList(sa2) + "'.");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("ACTION: setTabOrderAndVisibility(String[]: '" + Arrays.asList(sa2) + "'.");
                    TestClass.this._gtabs.setTabOrderAndVisibility(sa2);
                }
            });
            menu.add(mi);
            String str = "1-Object=true, 4-Waits,7-Pools=FALSE";
            mi = new JMenuItem("setTabOrderAndVisibility(String: '1-Object=true, 4-Waits,7-Pools=FALSE')");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("ACTION: setTabOrderAndVisibility(String: '1-Object=true, 4-Waits,7-Pools=FALSE')");
                    TestClass.this._gtabs.setTabOrderAndVisibility("1-Object=true, 4-Waits,7-Pools=FALSE");
                }
            });
            menu.add(mi);
            mi = new JMenuItem("getTabOrderAndVisibility()");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("ACTION: getTabOrderAndVisibility()");
                    System.out.println("RESULT STRING: '" + TestClass.this._gtabs.getTabOrderAndVisibility() + "'.");
                }
            });
            menu.add(mi);
            this.pack();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            System.out.println("TestClass: stateChanged() source=" + source + ", ChangeEvent=" + e);
            if (source.equals(this._gtabs)) {
                int selectedTab = this._gtabs.getSelectedIndex();
                if (selectedTab < 0) {
                    System.out.println("TestClass: stateChanged(): NO TAB was selected.");
                    return;
                }
                String currentTab = this._gtabs.getTitleAt(selectedTab);
                System.out.println("TestClass: stateChanged(): selected tab = '" + currentTab + "'.");
            }
        }
    }

    private static enum TabPos {
        Icon,
        Visible,
        Name,
        Description;

    }
}

