/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.swing;

import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class RowFilterDiffCounterIsZero
extends RowFilter<TableModel, Integer> {
    private static Logger _logger = Logger.getLogger(RowFilterDiffCounterIsZero.class);
    private int[] _colIds = null;
    private boolean _filterIsActive = false;
    private JTable _table = null;

    public RowFilterDiffCounterIsZero(JTable table) {
        this._table = table;
    }

    public void resetFilter() {
        _logger.debug((Object)"Resetting filter, all data will be shown in table.");
        this._filterIsActive = false;
        this._colIds = null;
        if (this._table.getRowSorter() != null) {
            this._table.getRowSorter().allRowsChanged();
        }
    }

    private int getColumnPos(JTable table, String colname) {
        TableModel tm = table.getModel();
        if (tm == null) {
            return -1;
        }
        for (int c = 0; c < tm.getColumnCount(); ++c) {
            if (!colname.equals(tm.getColumnName(c))) continue;
            return c;
        }
        return -1;
    }

    public void setFilter(JTable table, String[] colNames, String[] disregardCols) {
        _logger.trace((Object)("Setting filter: colNames=" + colNames));
        if (table == null || colNames == null) {
            return;
        }
        if (table.getModel().getColumnCount() == 0) {
            return;
        }
        int[] cols = new int[colNames.length];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = this.getColumnPos(table, colNames[i]);
            if (cols[i] == -1) {
                _logger.warn((Object)("Cant find column name '" + colNames[i] + "' in JTable when setting filter."));
                continue;
            }
            if (disregardCols != null) {
                for (int d = 0; d < disregardCols.length; ++d) {
                    if (!disregardCols[d].equals(colNames[i])) continue;
                    cols[i] = -1;
                    _logger.trace((Object)("setFilter(table, colnames[]): -dissRegard- cols[" + i + "]=" + cols[i] + ", for colName '" + colNames[i] + "'."));
                    break;
                }
            }
            _logger.trace((Object)("setFilter(table, colnames[]): cols[" + i + "]=" + cols[i] + ", for colName '" + colNames[i] + "'."));
        }
        this.setFilter(cols);
    }

    public void setFilter(int[] cols) {
        _logger.trace((Object)("Setting filter: cols=" + cols));
        if (cols == null) {
            return;
        }
        this._filterIsActive = true;
        this._colIds = cols;
        if (this._table.getRowSorter() != null) {
            this._table.getRowSorter().allRowsChanged();
        }
    }

    private boolean showInView(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
        boolean showRow = false;
        for (int c = 0; c < this._colIds.length; ++c) {
            if (this._colIds[c] < 0) continue;
            Object cellValue = entry.getValue(this._colIds[c]);
            if (cellValue instanceof Number) {
                Number num = (Number)cellValue;
                if (num.doubleValue() == 0.0) continue;
                return true;
            }
            if (cellValue == null) continue;
            String className = cellValue.getClass().getName();
            _logger.trace((Object)(" > Column position " + c + " is NOT a Number, the class type is '" + className + "'."));
        }
        return showRow;
    }

    @Override
    public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
        if (!this._filterIsActive) {
            return true;
        }
        return this.showInView(entry);
    }
}

