/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.swing;

import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.apache.log4j.lf5.LogLevel;

public class RowFilterValueAndLogLevel
extends RowFilter<TableModel, Integer> {
    private static Logger _logger = Logger.getLogger(RowFilterValueAndLogLevel.class);
    private boolean _filterIsActive = false;
    private String _traceStr = null;
    private int _levelColId = -1;
    private int _threadNameColId = -1;
    private int _classNameColId = -1;
    private int _messageColId = -1;
    private int _level = 0;
    private String _threadName = null;
    private String _className = null;
    private String _message = null;
    private Pattern _threadNamePattern = null;
    private Pattern _classNamePattern = null;
    private Pattern _messagePattern = null;
    private JTable _table = null;

    public RowFilterValueAndLogLevel(JTable table) {
        if (table == null) {
            throw new IllegalArgumentException("table can't be null.");
        }
        this._table = table;
    }

    public void resetFilter() {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"DEBUG: Resetting filter, all data will be shown in table.");
        }
        this._filterIsActive = false;
        this._level = 0;
        this._threadName = null;
        this._className = null;
        this._message = null;
        this._threadNamePattern = null;
        this._classNamePattern = null;
        this._messagePattern = null;
        if (this._table.getRowSorter() != null) {
            this._table.getRowSorter().allRowsChanged();
        }
    }

    public void setFilter(int level, String threadName, String className, String message) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("DEBUG: Setting filter: level=" + level + ", threadName='" + threadName + "', className='" + className + "', message='" + message + "'."));
        }
        this._filterIsActive = true;
        this._level = level;
        this._threadName = threadName;
        this._className = className;
        this._message = message;
        this._threadNamePattern = this._threadName == null || this._threadName != null && this._threadName.trim().equals("") ? Pattern.compile(".*") : Pattern.compile(this._threadName);
        this._classNamePattern = this._className == null || this._className != null && this._className.trim().equals("") ? Pattern.compile(".*") : Pattern.compile(this._className);
        this._messagePattern = this._message == null || this._message != null && this._message.trim().equals("") ? Pattern.compile(".*") : Pattern.compile(this._message);
        if (this._table.getRowSorter() != null) {
            this._table.getRowSorter().allRowsChanged();
        }
    }

    public void setFilterColId(int levelColId, int threadNameColId, int classNameColId, int messageColId) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("DEBUG: Setting filter ColId's: level=" + levelColId + ", threadName=" + threadNameColId + ", className=" + classNameColId + ", message=" + messageColId + "."));
        }
        this._levelColId = levelColId;
        this._threadNameColId = threadNameColId;
        this._classNameColId = classNameColId;
        this._messageColId = messageColId;
    }

    private boolean showInView(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
        Object levelCellVal = entry.getValue(this._levelColId);
        Object threadNameCellVal = entry.getValue(this._threadNameColId);
        Object classNameCellVal = entry.getValue(this._classNameColId);
        Object messageCellVal = entry.getValue(this._messageColId);
        if (_logger.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer();
            Object o = levelCellVal;
            sb.append(" levelCellVal.class=");
            sb.append(o == null ? "null" : o.getClass().toString());
            sb.append(", levelCellVal='");
            sb.append(o);
            sb.append("',");
            o = threadNameCellVal;
            sb.append(" threadNameCellVal.class=");
            sb.append(o == null ? "null" : o.getClass().toString());
            sb.append(", threadNameCellVal='");
            sb.append(o);
            sb.append("',");
            o = classNameCellVal;
            sb.append(" classNameCellVal.class=");
            sb.append(o == null ? "null" : o.getClass().toString());
            sb.append(", classNameCellVal='");
            sb.append(o);
            sb.append("',");
            o = messageCellVal;
            sb.append(" messageCellVal.class=");
            sb.append(o == null ? "null" : o.getClass().toString());
            sb.append(", messageCellVal='");
            sb.append(o);
            sb.append("'.");
            this.setTraceStr(sb.toString());
        }
        if (this._level == 0) {
            return false;
        }
        if (this._level > 0 && levelCellVal instanceof LogLevel) {
            int level = 0;
            LogLevel ll = (LogLevel)levelCellVal;
            if (LogLevel.INFO.equals((Object)ll)) {
                level |= 8;
            } else if (LogLevel.DEBUG.equals((Object)ll)) {
                level |= 0x10;
            } else if (ll.getLabel().equals("TRACE")) {
                level |= 0x20;
            } else if (LogLevel.WARN.equals((Object)ll)) {
                level |= 4;
            } else if (LogLevel.ERROR.equals((Object)ll)) {
                level |= 2;
            } else if (LogLevel.FATAL.equals((Object)ll)) {
                level |= 1;
            }
            if ((this._level & level) == 0) {
                return false;
            }
        }
        if (threadNameCellVal != null && this._threadName != null && !this._threadNamePattern.matcher(threadNameCellVal.toString()).find()) {
            return false;
        }
        if (classNameCellVal != null && this._className != null && !this._classNamePattern.matcher(classNameCellVal.toString()).find()) {
            return false;
        }
        return messageCellVal == null || this._message == null || this._messagePattern.matcher(messageCellVal.toString()).find();
    }

    public void setTraceStr(String str) {
        this._traceStr = str;
    }

    public String getTraceStr() {
        return this._traceStr == null ? "" : this._traceStr;
    }

    @Override
    public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
        if (!this._filterIsActive) {
            return true;
        }
        boolean include = this.showInView(entry);
        if (_logger.isTraceEnabled()) {
            if (include) {
                _logger.trace((Object)("TRACE: VISIBLE, row=" + entry.getIdentifier() + ", " + this.getTraceStr()));
            } else {
                _logger.trace((Object)("TRACE:    HIDE, row=" + entry.getIdentifier() + ", " + this.getTraceStr()));
            }
        }
        return include;
    }
}

