/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.log4j.Logger;

public class Screenshot {
    private static Logger _logger = Logger.getLogger(Screenshot.class);
    private static final long serialVersionUID = 1L;

    public static String windowScreenshot(Window window, String dir, String baseFilename, boolean doTimeStamp, String extraInfo) {
        String fileSeparator = System.getProperty("file.separator");
        String filename = baseFilename;
        if (dir == null) {
            dir = System.getProperty("user.home");
        }
        if (!dir.endsWith(fileSeparator)) {
            dir = dir + fileSeparator;
        }
        if (doTimeStamp) {
            Date timeNow = new Date(System.currentTimeMillis());
            String timeStamp = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss").format(timeNow);
            filename = filename + "_" + timeStamp;
        }
        filename = filename + ".jpg";
        filename = dir + filename;
        if (Screenshot.windowScreenshot(window, filename, extraInfo)) {
            return filename;
        }
        return null;
    }

    public static boolean windowScreenshot(Window window, String filename, String extraInfo) {
        Iterator<ImageWriter> writers;
        ImageWriter writer;
        if (window == null) {
            new IllegalArgumentException("Window can't be null");
        }
        if (filename == null) {
            new IllegalArgumentException("Filename can't be null");
        }
        File file = new File(filename);
        _logger.info((Object)("Saving screen capture to file '" + file + "'."));
        if (file.exists()) {
            _logger.info((Object)("The file '" + file + "' exists and will be overwritten."));
            file.delete();
        }
        if ((writer = (writers = ImageIO.getImageWritersByFormatName("jpg")).next()) == null) {
            _logger.error((Object)("Problems creating a writer for file '" + file + "'."));
            return false;
        }
        BufferedImage bi = Screenshot.capture(window);
        if (extraInfo != null) {
            Graphics2D g2d = (Graphics2D)bi.getGraphics();
            g2d.setColor(Color.GRAY);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setFont(new Font("Arial", 1, 20));
            FontMetrics fontMetrics = g2d.getFontMetrics();
            Rectangle2D rect = fontMetrics.getStringBounds(extraInfo, g2d);
            int posX = bi.getWidth() - (int)rect.getWidth() - 10;
            int posY = 3 + (int)rect.getHeight();
            g2d.drawString(extraInfo, posX, posY);
            g2d.dispose();
        }
        try {
            ImageOutputStream ios = ImageIO.createImageOutputStream(file);
            writer.setOutput(ios);
            writer.write(bi);
            ios.flush();
            ios.close();
        }
        catch (IOException e) {
            _logger.error((Object)("Problems writing screen capture to file '" + file + "'."), (Throwable)e);
            return false;
        }
        return true;
    }

    protected static BufferedImage capture(Window window) {
        BufferedImage bi = new BufferedImage(window.getWidth(), window.getHeight(), 1);
        window.paintAll(bi.createGraphics());
        return bi;
    }
}

