/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.gui.swing.MultiLineLabel;
import asemon.gui.wizard.WizardOffline;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;

public class WizardOfflinePage2
extends WizardPage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(WizardOfflinePage2.class);
    private static final String WIZ_NAME = "connection";
    private static final String WIZ_DESC = "JDBC Connection information";
    private static final String WIZ_HELP = "This is the JDBC Connectivity information to a datastore where the sampled data will be stored.\nIf desired tables are not created in the destination database, they will be created be the offline sampler.";
    private JTextField _jdbcDriver = new JTextField("org.h2.Driver");
    private JTextField _jdbcUrl = new JTextField("jdbc:h2:file:[<path>]<dbname>");
    private JButton _jdbcUrl_but = new JButton("...");
    private JTextField _jdbcUsername = new JTextField("sa");
    private JTextField _jdbcPassword = new JPasswordField();
    private JCheckBox _pcsH2Option_startH2NetworkServer_chk = new JCheckBox("Start H2 Database as a Network Server", false);

    public static String getDescription() {
        return WIZ_DESC;
    }

    public Dimension getPreferredSize() {
        return WizardOffline.preferredSize;
    }

    public WizardOfflinePage2() {
        super(WIZ_NAME, WIZ_DESC);
        this.setLayout((LayoutManager)new MigLayout("", "[] [grow] []", ""));
        this._jdbcDriver.setName("jdbcDriver");
        this._jdbcUrl.setName("jdbcUrl");
        this._jdbcUsername.setName("jdbcUser");
        this._jdbcPassword.setName("jdbcPasswd");
        this._jdbcUrl_but.setToolTipText("Open a File chooser dialog to get a filename, for some templates values are replaced");
        this._pcsH2Option_startH2NetworkServer_chk.setToolTipText("Start the H2 database engine in 'server' mode, so we can connect to the server while the PCS is storing information...");
        this.add(new MultiLineLabel(WIZ_HELP), "wmin 100, span, growx, gapbottom 15, wrap");
        this.add(new JLabel("JDBC Driver"));
        this.add(this._jdbcDriver, "growx, wrap");
        this.add(new JLabel("JDBC Url"));
        this.add(this._jdbcUrl, "growx, split");
        this.add(this._jdbcUrl_but, "wrap");
        this.add(new JLabel("Username"));
        this.add(this._jdbcUsername, "growx, wrap");
        this.add(new JLabel("Password"));
        this.add(this._jdbcPassword, "growx, wrap");
        this.add(this._pcsH2Option_startH2NetworkServer_chk, "skip, hidemode 3, wrap");
        JButton button = new JButton("Test Connection");
        button.addActionListener(this);
        button.putClientProperty("NAME", "BUTTON_CONN_TEST_JDBC");
        this.add(button, "span, align right, wrap 20");
        String remember = "<html>Remember that you can use variables <code>${DATE}</code>, <code>${SERVERNAME}</code>, <code>${ASEHOSTNAME}<code>, <code>${ASEMON_HOME}<code> and <code>${ASEMON_SAVE_DIR}<code> in the 'JDBC Url' specification above.</html>";
        MultiLineLabel mll = new MultiLineLabel(remember);
        mll.setToolTipText("<html>URL for the above JDBC drivername to connect to a datastore, a couple of template URL for H2 and Sybase JDBC driver<br><br>For H2 you can use the following variables: <code>${DATE}, ${SERVERNAME}, ${ASEHOSTNAME}, ${ASEMON_HOME}, ${ASEMON_SAVE_DIR}</code><br>Explanation of the above variables<br><ul>  <li><code>${DATE[:format=fmt[;roll=true|false]]}</code><br>    The DATE will be substituted with a timestamp, the format of the timestamp is specified by modifier 'format'.<br>    <br>    The DATE variable has modifiers, which means you can change the behaviour of the variable.<br>    <ul>      <li>modifier: <code>format=formatSpecification</code><br>          Is how the DATE string should be built.<br>          The specification is according to <code>java.text.SimpleDateFormat</code>.<br>          The default value is <code>yyyy-MM-dd</code>      </li>      <li>modifier: <code>roll=true|false</code><br>          This means: start/create a new database if we roll over into a new DATE string.<br>          With the format=<code>yyyy-MM-dd</code> a new DB will be created every midnight.<br>          With the format=<code>yyyy-MM-dd_HH</code> a new DB will be created every hour.<br>          The default value for <code>roll</code> is <code>false</code>.       </li>    </ul>    The default value for <code>format</code> can be changed with in the Configuration file with property <code>PersistWriterJdbc.h2DateParseFormat=formatString</code> <br>    The default value for <code>roll</code>   can be changed with in the Configuration file with property <code>PersistWriterJdbc.h2NewDbOnDateChange=true|false</code> <br>  </li>  <li><code>${SERVERNAME} </code> <br>    The SERVERNAME will be substituted with the content of the ASE global variable <code>@@servername</code> of which ASE server we are monitoring.<br>  </li>  <li><code>${ASEHOSTNAME}</code> <br>    The ASEHOSTNAME will be substituted with the output from ASE function <code>asehostname()</code> of which ASE server we are monitoring.<br>  </li>  <li><code>${ASEMON_HOME}</code> <br>    The ASEMON_HOME will be substituted with the installation path of AseMon.<br>  </li>  <li><code>${ASEMON_SAVE_DIR}</code> <br>    The ASEMON_SAVE_DIR will be substituted with ${ASEMON_HOME}/data or whatever the environment variable is set to.<br>  </li></ul>Example:<br><code>${ASEMON_SAVE_DIR}/xxx.${ASEHOSTNAME}.${DATE:format=yyyy-MM-dd.HH;roll=true}</code><br><br>The above example, does:<ul>  <li>H2 dbname would be '<i>asemonInstallDir</i>/data/xxx.host1.2011-05-31.21'. <br>      Every hour a new database will be created.  </li></ul></html>");
        mll.setEnabled(true);
        this.add(mll, "span, push, bottom, wrap");
        JTextField urlExample_txt = new JTextField("jdbc:h2:file:${ASEMON_SAVE_DIR}/${ASEHOSTNAME}_${DATE}");
        urlExample_txt.setEditable(false);
        urlExample_txt.setToolTipText("<html>URL for the above JDBC drivername to connect to a datastore, a couple of template URL for H2 and Sybase JDBC driver<br><br>For H2 you can use the following variables: <code>${DATE}, ${SERVERNAME}, ${ASEHOSTNAME}, ${ASEMON_HOME}, ${ASEMON_SAVE_DIR}</code><br>Explanation of the above variables<br><ul>  <li><code>${DATE[:format=fmt[;roll=true|false]]}</code><br>    The DATE will be substituted with a timestamp, the format of the timestamp is specified by modifier 'format'.<br>    <br>    The DATE variable has modifiers, which means you can change the behaviour of the variable.<br>    <ul>      <li>modifier: <code>format=formatSpecification</code><br>          Is how the DATE string should be built.<br>          The specification is according to <code>java.text.SimpleDateFormat</code>.<br>          The default value is <code>yyyy-MM-dd</code>      </li>      <li>modifier: <code>roll=true|false</code><br>          This means: start/create a new database if we roll over into a new DATE string.<br>          With the format=<code>yyyy-MM-dd</code> a new DB will be created every midnight.<br>          With the format=<code>yyyy-MM-dd_HH</code> a new DB will be created every hour.<br>          The default value for <code>roll</code> is <code>false</code>.       </li>    </ul>    The default value for <code>format</code> can be changed with in the Configuration file with property <code>PersistWriterJdbc.h2DateParseFormat=formatString</code> <br>    The default value for <code>roll</code>   can be changed with in the Configuration file with property <code>PersistWriterJdbc.h2NewDbOnDateChange=true|false</code> <br>  </li>  <li><code>${SERVERNAME} </code> <br>    The SERVERNAME will be substituted with the content of the ASE global variable <code>@@servername</code> of which ASE server we are monitoring.<br>  </li>  <li><code>${ASEHOSTNAME}</code> <br>    The ASEHOSTNAME will be substituted with the output from ASE function <code>asehostname()</code> of which ASE server we are monitoring.<br>  </li>  <li><code>${ASEMON_HOME}</code> <br>    The ASEMON_HOME will be substituted with the installation path of AseMon.<br>  </li>  <li><code>${ASEMON_SAVE_DIR}</code> <br>    The ASEMON_SAVE_DIR will be substituted with ${ASEMON_HOME}/data or whatever the environment variable is set to.<br>  </li></ul>Example:<br><code>${ASEMON_SAVE_DIR}/xxx.${ASEHOSTNAME}.${DATE:format=yyyy-MM-dd.HH;roll=true}</code><br><br>The above example, does:<ul>  <li>H2 dbname would be '<i>asemonInstallDir</i>/data/xxx.host1.2011-05-31.21'. <br>      Every hour a new database will be created.  </li></ul></html>");
        this.add(new JLabel("Example:"), "span, split");
        this.add(urlExample_txt, "pushx, growx, wrap");
        this._jdbcUrl_but.addActionListener(this);
        this._jdbcDriver.addActionListener(this);
        this.initData();
    }

    private void initData() {
        this._jdbcDriver.setText(this._jdbcDriver.getText());
    }

    protected String validateContents(Component comp, Object event) {
        String problem = "";
        if (this._jdbcDriver.getText().trim().length() <= 0) {
            problem = problem + "Driver, ";
        }
        if (this._jdbcUrl.getText().trim().length() <= 0) {
            problem = problem + "Url, ";
        }
        if (this._jdbcUsername.getText().trim().length() <= 0) {
            problem = problem + "User, ";
        }
        if (problem.length() > 0 && problem.endsWith(", ")) {
            problem = problem.substring(0, problem.length() - 2);
        }
        if (problem.length() > 0) {
            return "Following fields cant be empty: " + problem;
        }
        if (this._jdbcDriver.getText().trim().equals("org.h2.Driver")) {
            if (this._jdbcUrl.getText().indexOf("<>") > 0) {
                problem = "Please replace the <dbname> with a real database name string.";
            }
            if (this._jdbcUrl.getText().indexOf("[<path>]") > 0) {
                problem = "Please replace the [<path>] with a real pathname or delete it.";
            }
        }
        if (problem.length() > 0) {
            return problem;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JComponent source = (JComponent)ae.getSource();
        String name = (String)source.getClientProperty("NAME");
        if (name == null) {
            name = "-null-";
        }
        if (name.equals("BUTTON_CONN_TEST_JDBC")) {
            this.testJdbcConnection("testConnect", this._jdbcDriver.getText(), this._jdbcUrl.getText(), this._jdbcUsername.getText(), this._jdbcPassword.getText());
        }
        if (this._jdbcUrl_but.equals(source)) {
            int returnVal;
            JFileChooser fc = new JFileChooser();
            if (System.getProperty("ASEMON_SAVE_DIR") != null) {
                fc.setCurrentDirectory(new File(System.getProperty("ASEMON_SAVE_DIR")));
            }
            if ((returnVal = fc.showOpenDialog((Component)((Object)this))) == 0) {
                String url = this._jdbcUrl.getText();
                String path = fc.getSelectedFile().getAbsolutePath().replace('\\', '/');
                if (path.matches(".*\\.h2\\.db.*")) {
                    path = path.replaceAll("\\.h2\\.db", "");
                }
                if (path.matches(".*\\.data\\.db.*")) {
                    path = path.replaceAll("\\.data\\.db", "");
                }
                if (path.matches(".*\\.index\\.db.*")) {
                    path = path.replaceAll("\\.index\\.db", "");
                }
                if (path.matches(".*\\.[0-9]*\\.log\\.db.*")) {
                    path = path.replaceAll("\\.[0-9]*\\.log\\.db", "");
                }
                url = url.matches(".*\\[<path>\\]<dbname>.*") ? url.replaceFirst("\\[<path>\\]<dbname>", path) : url + path;
                this._jdbcUrl.setText(url);
            }
        }
        if (this._jdbcDriver.equals(source)) {
            String jdbcDriver = this._jdbcDriver.getText();
            if ("org.h2.Driver".equals(jdbcDriver)) {
                this._pcsH2Option_startH2NetworkServer_chk.setVisible(true);
            } else {
                this._pcsH2Option_startH2NetworkServer_chk.setVisible(false);
            }
        }
    }

    private boolean testJdbcConnection(String appname, String driver, String url, String user, String passwd) {
        try {
            Class.forName(driver).newInstance();
            Properties props = new Properties();
            props.put("user", user);
            props.put("password", passwd);
            _logger.debug((Object)("Try getConnection to driver='" + driver + "', url='" + url + "', user='" + user + "'."));
            Connection conn = DriverManager.getConnection(url, props);
            conn.close();
            JOptionPane.showMessageDialog((Component)((Object)this), "Connection succeeded.", "asemon - connect check", 1);
            return true;
        }
        catch (SQLException e) {
            StringBuffer sb = new StringBuffer();
            while (e != null) {
                sb.append("\n");
                sb.append(e.getMessage());
                e = e.getNextException();
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "Connection FAILED.\n\n" + sb.toString(), "asemon - connect check", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Connection FAILED.\n\n" + e.toString(), "asemon - connect check", 0);
        }
        return false;
    }

    private void saveWizardData() {
        this.putWizardData("startH2NetworkServer", this._pcsH2Option_startH2NetworkServer_chk.isSelected() + "");
    }

    public WizardPanelNavResult allowBack(String stepName, Map settings, Wizard wizard) {
        this.saveWizardData();
        return WizardPanelNavResult.PROCEED;
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        this.saveWizardData();
        return WizardPanelNavResult.PROCEED;
    }
}

