/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.GetCounters;
import asemon.Version;
import asemon.cm.CounterModelHostMonitor;
import asemon.cm.CountersModel;
import asemon.gui.swing.MultiLineLabel;
import asemon.gui.wizard.WizardOffline;
import asemon.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.UUID;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.netbeans.spi.wizard.WizardPage;

public class WizardOfflinePage3
extends WizardPage
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private static final String WIZ_NAME = "offline-sessions";
    private static final String WIZ_DESC = "What should be offline sampled";
    private static final String WIZ_HELP = "What panels/tabs do we want to be offline sampled.";
    private static final int TAB_POS_ICON = 0;
    private static final int TAB_POS_TAB_NAME = 1;
    private static final int TAB_POS_POSTPONE = 2;
    private static final int TAB_POS_STORE_PCS = 3;
    private static final int TAB_POS_STORE_ABS = 4;
    private static final int TAB_POS_STORE_DIFF = 5;
    private static final int TAB_POS_STORE_RATE = 6;
    private static final int TAB_POS_LONG_DESC = 7;
    private static final int TAB_POS_CM_NAME = 8;
    private static final int TAB_POS_MAX = 9;
    private static final Color TAB_PCS_COL_BG = new Color(240, 240, 240);
    private JXTable _sessionTable = new JXTable(){
        private static final long serialVersionUID = 1L;

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (column >= 3 && column <= 6) {
                c.setBackground(TAB_PCS_COL_BG);
                if (column >= 4 && column <= 6 || row == 0) {
                    c.setEnabled(this.isCellEditable(row, column));
                }
            }
            return c;
        }
    };

    public static String getDescription() {
        return WIZ_DESC;
    }

    public Dimension getPreferredSize() {
        return WizardOffline.preferredSize;
    }

    public WizardOfflinePage3() {
        super(WIZ_NAME, WIZ_DESC);
        this.setLayout((LayoutManager)new MigLayout("", "[] [grow] []", ""));
        this.add(new MultiLineLabel(WIZ_HELP), "wmin 100, span, growx, gapbottom 15, wrap");
        Vector<String> tabHead = new Vector<String>();
        tabHead.setSize(9);
        tabHead.set(2, "Postpone");
        tabHead.set(3, "Sample");
        tabHead.set(4, "Abs");
        tabHead.set(5, "Diff");
        tabHead.set(6, "Rate");
        tabHead.set(0, "Icon");
        tabHead.set(1, "Short Desc");
        tabHead.set(8, "CM Name");
        tabHead.set(7, "Long Description");
        Vector<Vector<Object>> tabData = this.populateTable();
        DefaultTableModel defaultTabModel = new DefaultTableModel(tabData, tabHead){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 2) {
                    return Integer.class;
                }
                if (column == 3) {
                    return Boolean.class;
                }
                if (column == 4) {
                    return Boolean.class;
                }
                if (column == 5) {
                    return Boolean.class;
                }
                if (column == 6) {
                    return Boolean.class;
                }
                if (column == 0) {
                    return Icon.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                if (row == 0) {
                    return false;
                }
                if (col == 2) {
                    return true;
                }
                if (col == 3) {
                    return true;
                }
                if (col <= 6) {
                    boolean storePcs = (Boolean)this.getValueAt(row, 3);
                    String tabName = (String)this.getValueAt(row, 1);
                    CountersModel cm = GetCounters.getCmByDisplayName(tabName);
                    if (cm != null) {
                        if (col == 4) {
                            return storePcs && cm.isPersistCountersAbsEditable();
                        }
                        if (col == 5) {
                            return storePcs && cm.isPersistCountersDiffEditable();
                        }
                        if (col == 6) {
                            return storePcs && cm.isPersistCountersRateEditable();
                        }
                    }
                }
                return false;
            }
        };
        defaultTabModel.addTableModelListener(this);
        this._sessionTable.setModel((TableModel)defaultTabModel);
        this._sessionTable.setSortable(false);
        this._sessionTable.setAutoResizeMode(0);
        this._sessionTable.setShowGrid(false);
        SwingUtils.calcColumnWidths((JTable)this._sessionTable);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._sessionTable);
        this.add(jScrollPane, "span, grow, height 100%, wrap");
        JButton button = null;
        button = new JButton("Select All");
        button.addActionListener(this);
        button.putClientProperty("NAME", "BUTTON_SELECT_ALL");
        this.add(button, "");
        button = new JButton("Deselect All");
        button.addActionListener(this);
        button.putClientProperty("NAME", "BUTTON_DESELECT_ALL");
        this.add(button, "split");
        button = new JButton("Set to Template");
        button.setToolTipText("Use current setting of the tabs as a template.");
        button.addActionListener(this);
        button.putClientProperty("NAME", "BUTTON_TEMPLATE");
        this.add(button, "split");
        this.initData();
    }

    private void initData() {
    }

    private Vector<Vector<Object>> populateTable() {
        Vector<Vector<Object>> tab = new Vector<Vector<Object>>();
        Vector<Object> row = new Vector<Object>();
        boolean debug = false;
        if (!debug) {
            for (CountersModel cm : GetCounters.getCmList()) {
                if (cm == null) continue;
                row = new Vector();
                row.setSize(9);
                row.set(2, new Integer(cm.getPostponeTime()));
                row.set(3, new Boolean(cm.isPersistCountersEnabled() || cm.isBackgroundDataPollingEnabled()));
                row.set(4, new Boolean(cm.isPersistCountersAbsEnabled()));
                row.set(5, new Boolean(cm.isPersistCountersDiffEnabled()));
                row.set(6, new Boolean(cm.isPersistCountersRateEnabled()));
                row.set(0, cm.getTabPanel() == null ? null : cm.getTabPanel().getIcon());
                row.set(1, cm.getDisplayName());
                row.set(8, cm.getName());
                row.set(7, cm.getDescription().replaceAll("\\<.*?\\>", ""));
                tab.add(row);
                if (!cm.getName().equals("CMsummary")) continue;
                row.set(0, SwingUtils.readImageIcon(Version.class, "images/summary_tab.png"));
            }
            this.setToTemplate();
        } else {
            row = new Vector();
            row.setSize(9);
            row.set(2, new Integer(0));
            row.set(3, new Boolean(true));
            row.set(4, new Boolean(true));
            row.set(5, new Boolean(true));
            row.set(6, new Boolean(true));
            row.set(0, SwingUtils.readImageIcon(Version.class, "images/cm_summary_activity.png"));
            row.set(1, "Summary");
            row.set(8, "cmSummary");
            row.set(7, "All the fields on the left hand side of the graphs.");
            tab.add(row);
            row = new Vector();
            row.setSize(9);
            row.set(2, new Integer(0));
            row.set(3, new Boolean(true));
            row.set(4, new Boolean(true));
            row.set(5, new Boolean(true));
            row.set(6, new Boolean(true));
            row.set(0, SwingUtils.readImageIcon(Version.class, "images/cm_engine_activity.png"));
            row.set(1, "CPU Usage");
            row.set(8, "cmCpu");
            row.set(7, "bla bla bla... asfdha dkjfg askj gfakj gfkajgshd fagsakgdfakdfhs kjfhgoiqay edatfshjghv kfdsjhgaks dfajhdfskjdf glkash df.");
            tab.add(row);
            row = new Vector();
            row.setSize(9);
            row.set(2, new Integer(0));
            row.set(3, new Boolean(true));
            row.set(4, new Boolean(true));
            row.set(5, new Boolean(true));
            row.set(6, new Boolean(true));
            row.set(0, SwingUtils.readImageIcon(Version.class, "images/cm_device_activity.png"));
            row.set(1, "Device Usage");
            row.set(8, "cmDevice");
            row.set(7, "wwwwwwwwwwwwwwww wwww ttttt uuuuuu bla bla bla... hhhhhhhhhhhhh  kkkkkkkkkkkk yyyyyyy ssssssssssssssssss ggggggggggggg w wwww aaaaa.");
            tab.add(row);
            for (int i = 0; i < 40; ++i) {
                row = new Vector();
                row.setSize(9);
                row.set(2, new Integer(0));
                row.set(3, new Boolean(true));
                row.set(4, new Boolean(true));
                row.set(5, new Boolean(true));
                row.set(6, new Boolean(true));
                row.set(0, SwingUtils.readImageIcon(Version.class, "images/ud_counter_activity.png"));
                row.set(1, "Dummy Tab " + i);
                row.set(8, "cmDummy" + i);
                row.set(7, UUID.randomUUID().toString() + " : " + UUID.randomUUID().toString());
                tab.add(row);
            }
        }
        return tab;
    }

    protected String validateContents(Component comp, Object event) {
        this.putWizardData("to-be-discarded.HostMonitorIsSelected", "false");
        int rows = 0;
        TableModel tm = this._sessionTable.getModel();
        for (int r = 0; r < tm.getRowCount(); ++r) {
            Integer postpone = (Integer)tm.getValueAt(r, 2);
            boolean storePcs = (Boolean)tm.getValueAt(r, 3);
            boolean storeAbs = (Boolean)tm.getValueAt(r, 4);
            boolean storeDiff = (Boolean)tm.getValueAt(r, 5);
            boolean storeRate = (Boolean)tm.getValueAt(r, 6);
            String cmName = (String)tm.getValueAt(r, 8);
            if (storePcs) {
                ++rows;
            }
            this.putWizardData("to-be-discarded." + cmName, cmName);
            this.putWizardData(cmName + "." + "postponeTime", postpone.toString());
            this.putWizardData(cmName + "." + "persistCounters", storePcs + "");
            this.putWizardData(cmName + "." + "persistCounters.abs", storeAbs + "");
            this.putWizardData(cmName + "." + "persistCounters.diff", storeDiff + "");
            this.putWizardData(cmName + "." + "persistCounters.rate", storeRate + "");
            CountersModel cm = GetCounters.getCmByName(cmName);
            if (cm == null || !(cm instanceof CounterModelHostMonitor) || !storePcs) continue;
            this.putWizardData("to-be-discarded.HostMonitorIsSelected", "true");
        }
        return rows > 1 ? null : "Atleast one session needs to be checked (except Summary).";
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int r;
        TableModel tm;
        JComponent src = (JComponent)ae.getSource();
        String name = (String)src.getClientProperty("NAME");
        if (name == null) {
            name = "-null-";
        }
        if (name.equals("BUTTON_SELECT_ALL")) {
            tm = this._sessionTable.getModel();
            for (r = 0; r < tm.getRowCount(); ++r) {
                if (!this._sessionTable.isCellEditable(r, 3)) continue;
                tm.setValueAt(new Boolean(true), r, 3);
            }
        }
        if (name.equals("BUTTON_DESELECT_ALL")) {
            tm = this._sessionTable.getModel();
            for (r = 0; r < tm.getRowCount(); ++r) {
                if (this._sessionTable.isCellEditable(r, 3)) {
                    tm.setValueAt(new Boolean(false), r, 3);
                }
                if (!this._sessionTable.isCellEditable(r, 2)) continue;
                tm.setValueAt(new Integer(0), r, 2);
            }
        }
        if (name.equals("BUTTON_TEMPLATE")) {
            this.setToTemplate();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.setProblem(this.validateContents(null, null));
    }

    private void setToTemplate() {
        TableModel tm = this._sessionTable.getModel();
        for (int r = 0; r < tm.getRowCount(); ++r) {
            String cmName = (String)tm.getValueAt(r, 8);
            CountersModel cm = GetCounters.getCmByName(cmName);
            if (cm == null) continue;
            tm.setValueAt(new Integer(cm.getPostponeTime()), r, 2);
            tm.setValueAt(new Boolean(cm.isPersistCountersEnabled() || cm.isBackgroundDataPollingEnabled()), r, 3);
            tm.setValueAt(new Boolean(cm.isPersistCountersAbsEnabled()), r, 4);
            tm.setValueAt(new Boolean(cm.isPersistCountersDiffEnabled()), r, 5);
            tm.setValueAt(new Boolean(cm.isPersistCountersRateEnabled()), r, 6);
        }
    }
}

