/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.gui.swing.MultiLineLabel;
import asemon.gui.wizard.WizardOffline;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.netbeans.spi.wizard.WizardPage;

public class WizardOfflinePage6
extends WizardPage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String WIZ_NAME = "sample-time";
    private static final String WIZ_DESC = "Sample time";
    private static final String WIZ_HELP = "How long should we sleep between samples.\nThis is specified in seconds.";
    private JTextField _sampleTime = new JTextField("60");
    private JTextField _shutdownAfterXHours = new JTextField("");

    public static String getDescription() {
        return WIZ_DESC;
    }

    public Dimension getPreferredSize() {
        return WizardOffline.preferredSize;
    }

    public WizardOfflinePage6() {
        super(WIZ_NAME, WIZ_DESC);
        this.setLayout((LayoutManager)new MigLayout("", "[] [grow] []", ""));
        this._sampleTime.setName("sampleTime");
        this._shutdownAfterXHours.setName("shutdownAfterXHours");
        this.add(new MultiLineLabel(WIZ_HELP), "wmin 100, span, growx, gapbottom 15, wrap");
        this.add(new JLabel(WIZ_DESC));
        this.add(this._sampleTime, "growx");
        this.add(new JLabel("Seconds"), "wrap 40");
        String label = "<html>Shutdown or stop the no-gui process after X number after it has been started.</html>";
        this.add(new MultiLineLabel(label), "span, wrap 10");
        this.add(new JLabel("Shutdown after # hours"));
        this.add(this._shutdownAfterXHours, "growx");
        this.add(new JLabel("Hours"));
        this.initData();
    }

    private void initData() {
    }

    protected String validateContents(Component comp, Object event) {
        String problem = "";
        if (this._sampleTime.getText().trim().length() <= 0) {
            problem = problem + "Sample time, ";
        }
        if (this._sampleTime.getText().trim().length() > 0) {
            try {
                Integer.parseInt(this._sampleTime.getText().trim());
            }
            catch (NumberFormatException e) {
                return "Sample time needs to be a number.";
            }
        }
        if (this._shutdownAfterXHours.getText().trim().length() > 0) {
            try {
                Integer.parseInt(this._shutdownAfterXHours.getText().trim());
            }
            catch (NumberFormatException e) {
                return "'Shutdown after # hours' needs to be a number or empty.";
            }
        }
        if (problem.length() > 0) {
            problem = problem.substring(0, problem.length() - 2);
        }
        return problem.length() == 0 ? null : "Following fields cant be empty: " + problem;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JComponent src = (JComponent)ae.getSource();
        String name = (String)src.getClientProperty("NAME");
        if (name == null) {
            name = "-null-";
        }
    }
}

