/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.GetCounters;
import asemon.MonTablesDictionary;
import asemon.cm.CountersModel;
import asemon.cm.SamplingCnt;
import asemon.gui.TrendGraph;
import asemon.gui.swing.MultiLineLabel;
import asemon.gui.wizard.WizardUserDefinedCm;
import asemon.utils.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;

public class WizardUserDefinedCmPage6
extends WizardPage
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private static final String WIZ_NAME = "Graph-info";
    private static final String WIZ_DESC = "Graph information";
    private static final String WIZ_HELP = "A graph can be attached to the Counter Data, the graph will be displaied in the Summary panel.";
    private static final String WIZ_HELP1 = "Name of the Graph.";
    private static final String WIZ_HELP2 = "The label that will be writen above the Graph.";
    private static final String WIZ_HELP3 = "In the view menu you can enable disable the graph, this is the text for that menu.";
    private static final String[] TAB_HEADER = new String[]{"PK", "Diff", "Pct", "Use", "Column Name", "Data Type", "Axis Label", "Method", "Column Num"};
    private static final int TAB_POS_COL_PK = 0;
    private static final int TAB_POS_COL_DIFF = 1;
    private static final int TAB_POS_COL_PCT = 2;
    private static final int TAB_POS_CHECK = 3;
    private static final int TAB_POS_COL_NAME = 4;
    private static final int TAB_POS_DATA_TYPE = 5;
    private static final int TAB_POS_AXIS_LABEL = 6;
    private static final int TAB_POS_METHOD = 7;
    private static final int TAB_POS_COL_NUM = 8;
    private static final String NO_METHOD = "<choose one>";
    private static final String TOOLTIP_METHOD = "<html>ABS values are taken from the Absolute counter data set<ul><li> absVal: The value in the cell (only if type is 'By Row')<li> absMax: Maximum value for this column (only if type is 'By Column')<li> absMin: Minimum value for this column (only if type is 'By Column')<li> absAvg: Average value for this column (only if type is 'By Column')<li> absAvgGtZero: Average value for this column, cells with zero will be discarded in the calculation (only if type is 'By Column')<li> absSum: The summary of all cells in this column (only if type is 'By Column')</ul>DIFF values are taken from the data set which is the difference by two sample interwalls <ul><li> diffVal: The value in the cell (only if type is 'By Row')<li> diffMax: Maximum value for this column (only if type is 'By Column')<li> diffMin: Minimum value for this column (only if type is 'By Column')<li> diffAvg: Average value for this column (only if type is 'By Column')<li> diffAvgGtZero: Average value for this column, cells with zero will be discarded in the calculation (only if type is 'By Column')<li> diffSum: The summary of all cells in this column (only if type is 'By Column')</ul>RATE values are the calculated delta values / sample time <ul><li> rateVal: The value in the cell (only if type is 'By Row')<li> rateMax: Maximum value for this column (only if type is 'By Column')<li> rateMin: Minimum value for this column (only if type is 'By Column')<li> rateAvg: Average value for this column (only if type is 'By Column')<li> rateAvgGtZero: Average value for this column, cells with zero will be discarded in the calculation (only if type is 'By Column')<li> rateSum: The summary of all cells in this column (only if type is 'By Column')</ul></html>";
    private static final String TOOLTIP_AXIS_LABEL = "<html><html><p>Double click to edit the Label, which will be displayed below the Graph.</p><p>If graph type is 'By Row' and Label is '-pk-' the Label will consist of all the columns in the PrimaryKey for this row.</p></html>";
    private boolean _firtsTimeRender = true;
    private String[] _toolTipMonTables = new String[0];
    private String[] _validGraphTypesStr = new String[]{"byCol", "byRow"};
    private String[] _validGraphTypesBoxStr = new String[]{"By Column", "By Row"};
    private JCheckBox _crGraph_chk = new JCheckBox("Create a User Defined Graph", false);
    private JLabel _graphType_lbl = new JLabel("Graph Type");
    private JComboBox _graphType_cbx = new JComboBox<String>(this._validGraphTypesBoxStr);
    private JLabel _name_lbl = new JLabel("Graph Name");
    private JTextField _name_txt = new JTextField("");
    private JLabel _graphLabel_lbl = new JLabel("Graph Label");
    private JTextField _graphLabel_txt = new JTextField("");
    private JLabel _menuDesc_lbl = new JLabel("Menu Description");
    private JTextField _menuDesc_txt = new JTextField("");
    private JXTable _table = null;

    public static String getDescription() {
        return WIZ_DESC;
    }

    public Dimension getPreferredSize() {
        return WizardUserDefinedCm.preferredSize;
    }

    public WizardUserDefinedCmPage6() {
        super(WIZ_NAME, WIZ_DESC);
        this.setLayout((LayoutManager)new MigLayout("", "[] [grow] []", ""));
        this._crGraph_chk.setName("graph");
        this._name_txt.setName("graph.name");
        this._graphLabel_txt.setName("graph.label");
        this._menuDesc_txt.setName("graph.menuLabel");
        this.add(new MultiLineLabel(WIZ_HELP), "wmin 100, span, pushx, growx, wrap");
        this.add(this._crGraph_chk, "span, growx, pushx, wrap");
        this._name_lbl.setToolTipText(WIZ_HELP1);
        this._name_txt.setToolTipText(WIZ_HELP1);
        this.add(this._name_lbl);
        this.add(this._name_txt, "growx, pushx, wrap");
        this._graphLabel_lbl.setToolTipText(WIZ_HELP2);
        this._graphLabel_txt.setToolTipText(WIZ_HELP2);
        this.add(this._graphLabel_lbl);
        this.add(this._graphLabel_txt, "growx, pushx, wrap");
        this._menuDesc_lbl.setToolTipText(WIZ_HELP3);
        this._menuDesc_txt.setToolTipText(WIZ_HELP3);
        this.add(this._menuDesc_lbl);
        this.add(this._menuDesc_txt, "growx, pushx, wrap");
        String toolTip = "<html>The graph type can be:<p>By Column: \"max/min/avg/sum\" over 1 column, meaning one graph-line for each specified column</p><p>By Row: One graph-line per row in the counter data showing the point value for each row.</p><html>";
        this._graphType_lbl.setToolTipText(toolTip);
        this._graphType_cbx.setToolTipText(toolTip);
        this.add(this._graphType_lbl);
        this.add(this._graphType_cbx, "growx, pushx, wrap");
        Vector<String> tabHead = new Vector<String>();
        tabHead.add(TAB_HEADER[0]);
        tabHead.add(TAB_HEADER[1]);
        tabHead.add(TAB_HEADER[2]);
        tabHead.add(TAB_HEADER[3]);
        tabHead.add(TAB_HEADER[4]);
        tabHead.add(TAB_HEADER[5]);
        tabHead.add(TAB_HEADER[6]);
        tabHead.add(TAB_HEADER[7]);
        tabHead.add(TAB_HEADER[8]);
        Vector tabData = new Vector();
        AbstractHighlighter disableSomeRows = new AbstractHighlighter(){

            protected Component doHighlight(Component comp, ComponentAdapter adapter) {
                if (WizardUserDefinedCmPage6.this._crGraph_chk.isSelected()) {
                    if (adapter.column < 3) {
                        comp.setEnabled(false);
                    } else {
                        comp.setEnabled(WizardUserDefinedCmPage6.this._table.isCellEditable(adapter.row, 3));
                    }
                } else {
                    comp.setEnabled(false);
                }
                return comp;
            }
        };
        DefaultTableModel defaultTabModel = new DefaultTableModel(tabData, tabHead){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 0) {
                    return Boolean.class;
                }
                if (column == 1) {
                    return Boolean.class;
                }
                if (column == 2) {
                    return Boolean.class;
                }
                if (column == 3) {
                    return Boolean.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column == 3) {
                    Object o = this.getValueAt(row, 0);
                    if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                        return false;
                    }
                    String datatype = (String)this.getValueAt(row, 5);
                    return SamplingCnt.isDiffAllowedForDatatype(datatype);
                }
                Object o = this.getValueAt(row, 3);
                if (o instanceof Boolean && !((Boolean)o).booleanValue()) {
                    return false;
                }
                if (column == 6 && WizardUserDefinedCmPage6.this._graphType_cbx.getSelectedIndex() == 0) {
                    return true;
                }
                return column == 7;
            }
        };
        defaultTabModel.addTableModelListener(this);
        this._table = new JXTable(){
            private static final long serialVersionUID = 0L;

            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                int col = this.columnAtPoint(p);
                if (row > 0 && col > 0) {
                    TableModel model;
                    Object cellVal;
                    col = this.convertColumnIndexToModel(col);
                    row = this.convertRowIndexToModel(row);
                    if (col == 6) {
                        return WizardUserDefinedCmPage6.TOOLTIP_AXIS_LABEL;
                    }
                    if (col == 7) {
                        return WizardUserDefinedCmPage6.TOOLTIP_METHOD;
                    }
                    if (col == 4 && (cellVal = (model = this.getModel()).getValueAt(row, col)) instanceof String) {
                        tip = MonTablesDictionary.getInstance().getDescription(WizardUserDefinedCmPage6.this._toolTipMonTables, (String)cellVal);
                    }
                }
                return tip;
            }
        };
        this._table.setHighlighters(new Highlighter[]{disableSomeRows});
        this._table.setModel((TableModel)defaultTabModel);
        this._table.setShowGrid(false);
        this._table.setSortable(true);
        this._table.setSelectionMode(0);
        this._table.setAutoResizeMode(0);
        this._table.packAll();
        this._table.setSortable(true);
        this._table.setColumnControlVisible(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._table);
        this.add(jScrollPane, "span, push, grow, height 100%, wrap");
        this._graphType_cbx.addActionListener(this);
    }

    private void refreshComboBox(JComboBox cbx) {
        int typeInt = this._graphType_cbx.getSelectedIndex();
        String typeStr = "";
        typeStr = typeInt == 0 ? "byCol" : (typeInt == 1 ? "byRow" : "-unknown-");
        boolean allMethods = true;
        String[] m = CountersModel.getValidGraphMethods(typeStr, allMethods);
        cbx.removeAllItems();
        cbx.addItem(NO_METHOD);
        for (int i = 0; i < m.length; ++i) {
            cbx.addItem(m[i]);
        }
    }

    private void refreshTable() {
        Vector<Object> row = new Vector<Object>();
        DefaultTableModel tm = (DefaultTableModel)this._table.getModel();
        SamplingCnt sc = (SamplingCnt)this.getWizardData("SamplingCnt");
        if (sc != null) {
            int r;
            List<String> names = sc.getColNames();
            boolean refresh = false;
            if (tm.getRowCount() == names.size()) {
                for (r = 0; r < tm.getRowCount(); ++r) {
                    String cntName;
                    String colName = (String)tm.getValueAt(r, 4);
                    if (colName.equals(cntName = names.get(r))) continue;
                    refresh = true;
                    break;
                }
            } else {
                refresh = true;
            }
            if (refresh) {
                while (tm.getRowCount() > 0) {
                    tm.removeRow(0);
                }
                r = 0;
                for (String col : names) {
                    ++r;
                    String label = col;
                    if (this._graphType_cbx.getSelectedIndex() == 1) {
                        label = "-pk-";
                    }
                    if (col == null) continue;
                    String datatype = sc.getColSqlTypeName(r - 1);
                    row = new Vector();
                    row.add(new Boolean(false));
                    row.add(new Boolean(false));
                    row.add(new Boolean(false));
                    row.add(new Boolean(false));
                    row.add(col);
                    row.add(datatype);
                    row.add(label);
                    row.add(NO_METHOD);
                    row.add(new Integer(r));
                    tm.addRow(row);
                }
                JComboBox comboBox = new JComboBox();
                this.refreshComboBox(comboBox);
                TableColumn tc = this._table.getColumnModel().getColumn(7);
                tc.setCellEditor(new DefaultCellEditor(comboBox));
            }
            String pkStr = (String)this.getWizardData("pk") + ", ";
            String diffStr = (String)this.getWizardData("diff") + ", ";
            String pctStr = (String)this.getWizardData("pct") + ", ";
            String gColStr = (String)this.getWizardData("graph.data.cols") + ", ";
            String gMthStr = (String)this.getWizardData("graph.data.methods") + ", ";
            String gLblStr = (String)this.getWizardData("graph.data.labels") + ", ";
            block3: for (int r2 = 0; r2 < tm.getRowCount(); ++r2) {
                String colName = (String)tm.getValueAt(r2, 4);
                boolean isPkCol = pkStr.indexOf(colName + ", ") != -1;
                boolean isDiffCol = diffStr.indexOf(colName + ", ") != -1;
                boolean isPctCol = pctStr.indexOf(colName + ", ") != -1;
                boolean isGraphCol = gColStr.indexOf(colName + ", ") != -1;
                tm.setValueAt(new Boolean(isPkCol), r2, 0);
                tm.setValueAt(new Boolean(isDiffCol), r2, 1);
                tm.setValueAt(new Boolean(isPctCol), r2, 2);
                tm.setValueAt(new Boolean(isGraphCol), r2, 3);
                if (!isGraphCol) continue;
                String[] gColStrArr = gColStr.split(",");
                String[] gMthStrArr = gMthStr.split(",");
                String[] gLblStrArr = gLblStr.split(",");
                for (int a = 0; a < gColStrArr.length; ++a) {
                    if (!colName.equals(gColStrArr[a].trim())) continue;
                    String method = gMthStrArr[a].trim();
                    String label = gLblStrArr[a].trim();
                    tm.setValueAt(method, r2, 7);
                    tm.setValueAt(label, r2, 6);
                    continue block3;
                }
            }
        }
        this._table.packAll();
    }

    private void setEnabledAll(boolean b) {
        this._graphType_lbl.setEnabled(b);
        this._graphType_cbx.setEnabled(b);
        this._name_lbl.setEnabled(b);
        this._name_txt.setEnabled(b);
        this._graphLabel_lbl.setEnabled(b);
        this._graphLabel_txt.setEnabled(b);
        this._menuDesc_lbl.setEnabled(b);
        this._menuDesc_txt.setEnabled(b);
        this._table.setEnabled(b);
    }

    private void applyFromTemplate() {
        boolean hasTrendGraph;
        String cmName = (String)this.getWizardData("cmTemplate");
        if (cmName == null) {
            return;
        }
        CountersModel cm = GetCounters.getCmByName(cmName);
        if (cm != null && (hasTrendGraph = cm.hasTrendGraph())) {
            this._crGraph_chk.setSelected(true);
            String gn = cm.getTrendGraphs().keySet().iterator().next();
            TrendGraph tg = cm.getTrendGraph(gn);
            this._name_txt.setText(tg.getName());
            this._graphLabel_txt.setText(tg.getLabel());
            this._menuDesc_txt.setText(tg.getViewMenuItem().getText());
            int graphType = tg.getGraphType();
            if (graphType == 1) {
                this._graphType_cbx.setSelectedIndex(0);
            }
            if (graphType == 2) {
                this._graphType_cbx.setSelectedIndex(1);
            }
            Object[] colNames = tg.getDataColNames();
            String[] methods = tg.getDataMethods();
            String[] labels = tg.getDataLabels();
            TableModel tm = this._table.getModel();
            block0: for (int r = 0; r < tm.getRowCount(); ++r) {
                String colName = (String)tm.getValueAt(r, 4);
                boolean isGraphCol = StringUtil.arrayContains(colNames, colName);
                tm.setValueAt(new Boolean(isGraphCol), r, 3);
                if (!isGraphCol) continue;
                for (int a = 0; a < colNames.length; ++a) {
                    if (!colName.equals(((String)colNames[a]).trim())) continue;
                    String method = methods[a].trim();
                    String label = labels[a].trim();
                    tm.setValueAt(method, r, 7);
                    tm.setValueAt(label, r, 6);
                    continue block0;
                }
            }
        }
    }

    protected void renderingPage() {
        this.refreshTable();
        if (this._firtsTimeRender) {
            this.applyFromTemplate();
            if (this._name_txt.getText().length() == 0) {
                this._name_txt.setText(this.getWizardData("name").toString() + "Graph");
            }
            if (this._graphLabel_txt.getText().length() == 0) {
                this._graphLabel_txt.setText(this.getWizardData("name").toString() + " Graph");
            }
            if (this._menuDesc_txt.getText().length() == 0) {
                this._menuDesc_txt.setText(this.getWizardData("name").toString() + " Graph");
            }
        }
        this._toolTipMonTables = StringUtil.commaStrToArray((String)this.getWizardData("toolTipMonTables"));
        this._firtsTimeRender = false;
    }

    protected String validateContents(Component comp, Object event) {
        if (!this._crGraph_chk.isSelected()) {
            this.setEnabledAll(false);
            return null;
        }
        this.setEnabledAll(true);
        String problem = "";
        if (this._name_txt.getText().trim().length() <= 0) {
            problem = problem + "Name, ";
        }
        if (this._graphLabel_txt.getText().trim().length() <= 0) {
            problem = problem + "Graph Label, ";
        }
        if (this._menuDesc_txt.getText().trim().length() <= 0) {
            problem = problem + "Menu Description, ";
        }
        if (problem.length() > 0) {
            problem = problem.substring(0, problem.length() - 2);
        }
        if (problem.length() > 0) {
            problem = "Following fields cant be empty: " + problem;
        }
        if (this._name_txt.getText().trim().indexOf(" ") >= 0) {
            problem = "The field 'Name' cant contain spaces.";
        }
        if (problem.length() > 0) {
            return problem;
        }
        if (this._graphType_cbx.getSelectedIndex() == 0) {
            int rows = 0;
            TableModel tm = this._table.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                String methodStr;
                if (!((Boolean)tm.getValueAt(r, 3)).booleanValue()) continue;
                if (tm.getValueAt(r, 7).equals(NO_METHOD)) {
                    return "Row " + (r + 1) + " is selected, but no 'Method' has been choosen.";
                }
                if (!((Boolean)tm.getValueAt(r, 1)).booleanValue() && !(methodStr = (String)tm.getValueAt(r, 7)).startsWith("abs")) {
                    return "Row " + (r + 1) + " is selected, but no 'Method' can only be 'abs*'. Diff/Rate is not available.";
                }
                ++rows;
            }
            return rows > 0 ? null : "Atleast one session needs to be checked.";
        }
        if (this._graphType_cbx.getSelectedIndex() != 0) {
            int rows = 0;
            TableModel tm = this._table.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                String methodStr;
                if (!((Boolean)tm.getValueAt(r, 3)).booleanValue()) continue;
                if (tm.getValueAt(r, 7).equals(NO_METHOD)) {
                    return "Row " + (r + 1) + " is selected, but no 'Method' has been choosen.";
                }
                if (!((Boolean)tm.getValueAt(r, 1)).booleanValue() && !(methodStr = (String)tm.getValueAt(r, 7)).startsWith("abs")) {
                    return "Row " + (r + 1) + " is selected, but no 'Method' can only be 'abs*'. Diff/Rate is not available.";
                }
                ++rows;
            }
            return rows == 1 ? null : "One, and only one, must be selected.";
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JComponent src = (JComponent)ae.getSource();
        String name = (String)src.getClientProperty("NAME");
        if (name == null) {
            name = "-null-";
        }
        if (this._graphType_cbx.equals(src)) {
            JComboBox comboBox = new JComboBox();
            this.refreshComboBox(comboBox);
            TableColumn tc = this._table.getColumnModel().getColumn(7);
            tc.setCellEditor(new DefaultCellEditor(comboBox));
            TableModel tm = this._table.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                String label = (String)tm.getValueAt(r, 4);
                if (this._graphType_cbx.getSelectedIndex() == 1) {
                    label = "-pk-";
                }
                tm.setValueAt(label, r, 6);
                tm.setValueAt(NO_METHOD, r, 7);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        TableModel tm = this._table.getModel();
        if (e.getType() == 0) {
            boolean hasMethod;
            int row = e.getFirstRow();
            int col = e.getColumn();
            boolean isChecked = (Boolean)tm.getValueAt(row, 3);
            boolean bl = hasMethod = !tm.getValueAt(row, 7).equals(NO_METHOD);
            if (col == 3 && !isChecked) {
                tm.setValueAt(NO_METHOD, row, 7);
            }
            if (col == 7 && isChecked != hasMethod) {
                tm.setValueAt(new Boolean(hasMethod), row, 3);
            }
        }
        this.setProblem(this.validateContents(null, null));
    }

    private void saveWizardData() {
        if (this._crGraph_chk.isSelected()) {
            String str1 = "";
            String str2 = "";
            String str3 = "";
            TableModel tm = this._table.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                if (!((Boolean)tm.getValueAt(r, 3)).booleanValue()) continue;
                str1 = str1 + tm.getValueAt(r, 4) + ", ";
                str2 = str2 + tm.getValueAt(r, 7) + ", ";
                str3 = str3 + tm.getValueAt(r, 6) + ", ";
            }
            if (str1.length() > 0) {
                str1 = str1.substring(0, str1.length() - 2);
            }
            if (str2.length() > 0) {
                str2 = str2.substring(0, str2.length() - 2);
            }
            if (str3.length() > 0) {
                str3 = str3.substring(0, str3.length() - 2);
            }
            String graphType = this._validGraphTypesStr[this._graphType_cbx.getSelectedIndex()];
            this.putWizardData("graph.type", graphType);
            this.putWizardData("graph.data.cols", str1);
            this.putWizardData("graph.data.methods", str2);
            this.putWizardData("graph.data.labels", str3);
        }
    }

    public WizardPanelNavResult allowBack(String stepName, Map settings, Wizard wizard) {
        this.saveWizardData();
        return WizardPanelNavResult.PROCEED;
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        this.saveWizardData();
        return WizardPanelNavResult.PROCEED;
    }
}

