/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.gui.swing.MultiLineLabel;
import asemon.gui.wizard.WizardUserDefinedCm;
import asemon.gui.wizard.WizardUserDefinedCmResultProducer;
import asemon.utils.Configuration;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.netbeans.spi.wizard.WizardPage;

public class WizardUserDefinedCmPageSummary
extends WizardPage {
    private static final long serialVersionUID = 1L;
    private static final String WIZ_NAME = "Apply";
    private static final String WIZ_DESC = "Apply or Store";
    private static final String WIZ_HELP1 = "Here is the property entries you need to add to the configuration file to create a User Defined Counter Model.\nYou can either copy paste the text into the configuration file or you can check the 'Append to Config File' checkbox to append the text at the end of the config file.";
    private boolean _firtsTimeRender = true;
    private JTextArea _props_txt = new JTextArea();
    private JCheckBox _appendToCfg_chk = new JCheckBox("Append to Config file", false);
    private JCheckBox _addTmpToCfg_chk = new JCheckBox("Add Temporary to GUI", false);

    public static String getDescription() {
        return WIZ_DESC;
    }

    public Dimension getPreferredSize() {
        return WizardUserDefinedCm.preferredSize;
    }

    public WizardUserDefinedCmPageSummary() {
        super(WIZ_NAME, WIZ_DESC);
        String cfgFile = Configuration.getInstance("USER_CONF").getFilename();
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", ""));
        this._props_txt.setName("propText");
        this._appendToCfg_chk.setName("appendToCfg");
        this._addTmpToCfg_chk.setName("addTmpToCfg");
        this.add(new MultiLineLabel(WIZ_HELP1), "wmin 100, span, pushx, growx, wrap");
        this.add(new JScrollPane(this._props_txt), "growx, pushx, height 100%, wrap");
        this._appendToCfg_chk.setToolTipText("Append the above text to the end of the configuration file '" + cfgFile + "'. The GUI has to be restarted for the changes to take affect.");
        this.add(this._appendToCfg_chk, "wrap");
        this._addTmpToCfg_chk.setToolTipText("Add the Counter Model to the GUI, NOTE: this will NOT be saved in the configuration file.");
        this.add(this._addTmpToCfg_chk, "wrap");
    }

    protected String validateContents(Component comp, Object event) {
        if (!this._appendToCfg_chk.isSelected() && !this._addTmpToCfg_chk.isSelected()) {
            return "One of the check boxes must be selected.";
        }
        if (this._appendToCfg_chk.isSelected()) {
            Configuration conf = Configuration.getCombinedConfiguration();
            String cfgFile = conf.getFilename();
            if (cfgFile == null || cfgFile != null && cfgFile.trim().length() == 0) {
                return "The Configuration has no config file attatched.";
            }
            String udcName = (String)this.getWizardDataMap().get("name");
            String key = "udc." + udcName + ".name";
            String exists = conf.getProperty(key);
            if (exists != null) {
                return "The key '" + key + "' already exists in the file '" + cfgFile + "'.";
            }
        }
        return null;
    }

    protected void renderingPage() {
        this._props_txt.setText(WizardUserDefinedCmResultProducer.createPropsStr(this.getWizardDataMap()));
        if (this._firtsTimeRender) {
            // empty if block
        }
        this._firtsTimeRender = false;
    }
}

