/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.GetCounters;
import asemon.gui.MainFrame;
import asemon.utils.Configuration;
import asemon.utils.StringUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPage;

public class WizardUserDefinedCmResultProducer
implements WizardPage.WizardResultProducer {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(WizardUserDefinedCmResultProducer.class);

    public boolean cancel(Map arg0) {
        return true;
    }

    public Object finish(Map wizardData) throws WizardException {
        boolean append = false;
        boolean tmpAdd = false;
        String summaryMessage = "";
        String propText = (String)wizardData.get("propText");
        Boolean tmp = (Boolean)wizardData.get("appendToCfg");
        if (tmp != null) {
            append = tmp;
        }
        if ((tmp = (Boolean)wizardData.get("addTmpToCfg")) != null) {
            tmpAdd = tmp;
        }
        Configuration conf = Configuration.getInstance("USER_CONF");
        String cfgFile = conf.getFilename();
        if (append) {
            if (propText == null || propText != null && propText.trim().length() == 0) {
                propText = WizardUserDefinedCmResultProducer.createPropsStr(wizardData);
            }
            try {
                conf.append(propText, this.getClass().getName());
                conf.reload();
                summaryMessage = summaryMessage + "\n\n##################################\n";
                summaryMessage = summaryMessage + "The below information was appended to config file '" + cfgFile + "'.\n";
                summaryMessage = summaryMessage + "--------------------------------------------------------\n";
                summaryMessage = summaryMessage + propText;
                summaryMessage = summaryMessage + "--------------------------------------------------------\n";
            }
            catch (IOException e) {
                summaryMessage = summaryMessage + "\n\n##################################\n";
                summaryMessage = summaryMessage + "Problems when APPENDING User Defined Counter the to file '" + cfgFile + "'.\n";
                summaryMessage = summaryMessage + e.getMessage() + "\n";
                summaryMessage = summaryMessage + "Opening the 'log viewer' so you can check other log messages.\n";
            }
        } else {
            summaryMessage = summaryMessage + "\n\n##################################\n";
            summaryMessage = summaryMessage + "NOTE: The information was NOT saved to the config file '" + cfgFile + "'.\n";
        }
        if (tmpAdd) {
            try {
                Configuration tmpConf = WizardUserDefinedCmResultProducer.createConf(wizardData);
                int failCount = GetCounters.createUserDefinedCounterModels(tmpConf);
                if (failCount == 0) {
                    summaryMessage = summaryMessage + "\n\n##################################\n";
                    summaryMessage = summaryMessage + "ADDED the User Defined Counter to the GUI\n";
                } else {
                    summaryMessage = summaryMessage + "\n\n##################################\n";
                    summaryMessage = summaryMessage + "Problems when ADDING User Defined Counter the to GUI\n";
                    summaryMessage = summaryMessage + "Opening the 'log viewer' so you can check for problems.\n";
                    MainFrame.openLogViewer();
                }
            }
            catch (Throwable t) {
                summaryMessage = summaryMessage + "\n\n##################################\n";
                summaryMessage = summaryMessage + "Problems when ADDING User Defined Counter the to GUI\n";
                summaryMessage = summaryMessage + t.getMessage() + "\n";
                summaryMessage = summaryMessage + StringUtil.stackTraceToString(t) + "\n";
                summaryMessage = summaryMessage + "Opening the 'log viewer' so you can check other log messages.\n";
                _logger.error((Object)t.getMessage(), t);
                MainFrame.openLogViewer();
            }
        }
        if (_logger.isDebugEnabled()) {
            summaryMessage = summaryMessage + "\n\n";
            summaryMessage = summaryMessage + "--------------------------------------------------------\n";
            summaryMessage = summaryMessage + "DEBUG, MAP: \n";
            summaryMessage = summaryMessage + "--------------------------------------------------------\n";
            for (String key : wizardData.keySet()) {
                String val = wizardData.get(key).toString();
                summaryMessage = summaryMessage + key + ": " + val + "\n";
            }
        }
        Summary summary = Summary.create((String)summaryMessage, (Object)wizardData);
        return summary;
    }

    private static boolean hasVal(String str) {
        if (str == null) {
            return false;
        }
        return str.trim().length() != 0;
    }

    private static String getKey(String key, Map<String, String> wizdata) {
        String o = wizdata.get(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static String createPropsStr(Map<String, String> wizdata) {
        String name = WizardUserDefinedCmResultProducer.getKey("name", wizdata);
        String displayName = WizardUserDefinedCmResultProducer.getKey("displayName", wizdata);
        String description = WizardUserDefinedCmResultProducer.getKey("description", wizdata);
        String sqlOpen = WizardUserDefinedCmResultProducer.getKey("sqlOpen", wizdata);
        String sql = WizardUserDefinedCmResultProducer.getKey("sql", wizdata);
        String sqlClose = WizardUserDefinedCmResultProducer.getKey("sqlClose", wizdata);
        String needVersion = WizardUserDefinedCmResultProducer.getKey("needVersion", wizdata);
        String needRole = WizardUserDefinedCmResultProducer.getKey("needRole", wizdata);
        String needConfig = WizardUserDefinedCmResultProducer.getKey("needConfig", wizdata);
        String ttMonTab = WizardUserDefinedCmResultProducer.getKey("toolTipMonTables", wizdata);
        String pk = WizardUserDefinedCmResultProducer.getKey("pk", wizdata);
        String diff = WizardUserDefinedCmResultProducer.getKey("diff", wizdata);
        String pct = WizardUserDefinedCmResultProducer.getKey("pct", wizdata);
        String negDiffCntToZero = WizardUserDefinedCmResultProducer.getKey("negativeDiffCountersToZero", wizdata);
        String graph = WizardUserDefinedCmResultProducer.getKey("graph", wizdata);
        String graphType = WizardUserDefinedCmResultProducer.getKey("graph.type", wizdata);
        String graphName = WizardUserDefinedCmResultProducer.getKey("graph.name", wizdata);
        String graphLabel = WizardUserDefinedCmResultProducer.getKey("graph.label", wizdata);
        String graphMenuLabel = WizardUserDefinedCmResultProducer.getKey("graph.menuLabel", wizdata);
        String graphDataCols = WizardUserDefinedCmResultProducer.getKey("graph.data.cols", wizdata);
        String graphDataMethods = WizardUserDefinedCmResultProducer.getKey("graph.data.methods", wizdata);
        String graphDataLabels = WizardUserDefinedCmResultProducer.getKey("graph.data.labels", wizdata);
        if (negDiffCntToZero == null) {
            negDiffCntToZero = "true";
        }
        String out = "";
        String prefix = "udc." + name + ".";
        out = "\n\n";
        out = out + "### ================================================================================\n";
        out = out + "### BEGIN: UDC(User Defined Counter) - " + name + "\n";
        out = out + "### --------------------------------------------------------------------------------\n";
        out = out + prefix + "name              = " + name;
        out = out + "\n" + prefix + "displayName       = " + displayName;
        out = out + "\n" + prefix + "description       = " + description;
        if (WizardUserDefinedCmResultProducer.hasVal(sqlOpen)) {
            out = out + "\n" + prefix + "sqlOpen           = " + sqlOpen.replaceAll("\n", " \\\\\n");
        }
        out = out + "\n" + prefix + "sql               = " + sql.replaceAll("\n", " \\\\\n");
        if (WizardUserDefinedCmResultProducer.hasVal(sqlClose)) {
            out = out + "\n" + prefix + "sqlClose          = " + sqlClose.replaceAll("\n", " \\\\\n");
        }
        if (WizardUserDefinedCmResultProducer.hasVal(needVersion)) {
            out = out + "\n" + prefix + "needVersion       = " + needVersion;
        }
        if (WizardUserDefinedCmResultProducer.hasVal(needRole)) {
            out = out + "\n" + prefix + "needRole          = " + needRole;
        }
        if (WizardUserDefinedCmResultProducer.hasVal(needConfig)) {
            out = out + "\n" + prefix + "needConfig        = " + needConfig;
        }
        if (WizardUserDefinedCmResultProducer.hasVal(ttMonTab)) {
            out = out + "\n" + prefix + "toolTipMonTables  = " + ttMonTab;
        }
        if (WizardUserDefinedCmResultProducer.hasVal(pk)) {
            out = out + "\n" + prefix + "pk                = " + pk;
        }
        if (WizardUserDefinedCmResultProducer.hasVal(diff)) {
            out = out + "\n" + prefix + "diff              = " + diff;
        }
        if (WizardUserDefinedCmResultProducer.hasVal(pct)) {
            out = out + "\n" + prefix + "pct               = " + pct;
        }
        out = out + "\n" + prefix + "negativeDiffCountersToZero = " + negDiffCntToZero;
        if ("true".equals(graph)) {
            out = out + "\n" + prefix + "graph              = " + graph;
            out = out + "\n" + prefix + "graph.type         = " + graphType;
            out = out + "\n" + prefix + "graph.name         = " + graphName;
            out = out + "\n" + prefix + "graph.label        = " + graphLabel;
            out = out + "\n" + prefix + "graph.menuLabel    = " + graphMenuLabel;
            out = out + "\n" + prefix + "graph.data.cols    = " + graphDataCols;
            out = out + "\n" + prefix + "graph.data.methods = " + graphDataMethods;
            out = out + "\n" + prefix + "graph.data.labels  = " + graphDataLabels;
        }
        out = out + "\n";
        out = out + "### ================================================================================\n";
        out = out + "### END: UDC(User Defined Counter) - " + name + "\n";
        out = out + "### --------------------------------------------------------------------------------\n";
        out = out + "\n";
        return out;
    }

    public static Configuration createConf(Map<String, String> wizdata) {
        String name = WizardUserDefinedCmResultProducer.getKey("name", wizdata);
        String displayName = WizardUserDefinedCmResultProducer.getKey("displayName", wizdata);
        String description = WizardUserDefinedCmResultProducer.getKey("description", wizdata);
        String sqlOpen = WizardUserDefinedCmResultProducer.getKey("sqlOpen", wizdata);
        String sql = WizardUserDefinedCmResultProducer.getKey("sql", wizdata);
        String sqlClose = WizardUserDefinedCmResultProducer.getKey("sqlClose", wizdata);
        String needVersion = WizardUserDefinedCmResultProducer.getKey("needVersion", wizdata);
        String needRole = WizardUserDefinedCmResultProducer.getKey("needRole", wizdata);
        String needConfig = WizardUserDefinedCmResultProducer.getKey("needConfig", wizdata);
        String ttMonTab = WizardUserDefinedCmResultProducer.getKey("toolTipMonTables", wizdata);
        String pk = WizardUserDefinedCmResultProducer.getKey("pk", wizdata);
        String diff = WizardUserDefinedCmResultProducer.getKey("diff", wizdata);
        String pct = WizardUserDefinedCmResultProducer.getKey("pct", wizdata);
        String negDiffCntToZero = WizardUserDefinedCmResultProducer.getKey("negativeDiffCountersToZero", wizdata);
        String graph = WizardUserDefinedCmResultProducer.getKey("graph", wizdata);
        String graphType = WizardUserDefinedCmResultProducer.getKey("graph.type", wizdata);
        String graphName = WizardUserDefinedCmResultProducer.getKey("graph.name", wizdata);
        String graphLabel = WizardUserDefinedCmResultProducer.getKey("graph.label", wizdata);
        String graphMenuLabel = WizardUserDefinedCmResultProducer.getKey("graph.menuLabel", wizdata);
        String graphDataCols = WizardUserDefinedCmResultProducer.getKey("graph.data.cols", wizdata);
        String graphDataMethods = WizardUserDefinedCmResultProducer.getKey("graph.data.methods", wizdata);
        String graphDataLabels = WizardUserDefinedCmResultProducer.getKey("graph.data.labels", wizdata);
        if (negDiffCntToZero == null) {
            negDiffCntToZero = "true";
        }
        Configuration out = new Configuration();
        String prefix = "udc." + name + ".";
        out.setProperty(prefix + "name", name);
        out.setProperty(prefix + "displayName", displayName);
        out.setProperty(prefix + "description", description);
        if (WizardUserDefinedCmResultProducer.hasVal(sqlOpen)) {
            out.setProperty(prefix + "sqlOpen", sqlOpen);
        }
        out.setProperty(prefix + "sql", sql);
        if (WizardUserDefinedCmResultProducer.hasVal(sqlClose)) {
            out.setProperty(prefix + "sqlClose", sqlClose);
        }
        if (WizardUserDefinedCmResultProducer.hasVal(needVersion)) {
            out.setProperty(prefix + "needVersion", needVersion);
        }
        if (WizardUserDefinedCmResultProducer.hasVal(needRole)) {
            out.setProperty(prefix + "needRole", needRole);
        }
        if (WizardUserDefinedCmResultProducer.hasVal(needConfig)) {
            out.setProperty(prefix + "needConfig", needConfig);
        }
        if (WizardUserDefinedCmResultProducer.hasVal(ttMonTab)) {
            out.setProperty(prefix + "toolTipMonTables", ttMonTab);
        }
        if (WizardUserDefinedCmResultProducer.hasVal(pk)) {
            out.setProperty(prefix + "pk", pk);
        }
        if (WizardUserDefinedCmResultProducer.hasVal(diff)) {
            out.setProperty(prefix + "diff", diff);
        }
        if (WizardUserDefinedCmResultProducer.hasVal(pct)) {
            out.setProperty(prefix + "pct", pct);
        }
        out.setProperty(prefix + "negativeDiffCountersToZero", negDiffCntToZero);
        if ("true".equals(graph)) {
            out.setProperty(prefix + "graph", graph);
            out.setProperty(prefix + "graph.type", graphType);
            out.setProperty(prefix + "graph.name", graphName);
            out.setProperty(prefix + "graph.label", graphLabel);
            out.setProperty(prefix + "graph.menuLabel", graphMenuLabel);
            out.setProperty(prefix + "graph.data.cols", graphDataCols);
            out.setProperty(prefix + "graph.data.methods", graphDataMethods);
            out.setProperty(prefix + "graph.data.labels", graphDataLabels);
        }
        return out;
    }
}

