/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.OsRecordParseException;
import asemon.hostmon.OsTable;
import asemon.hostmon.OsTableRow;
import asemon.hostmon.OsTableSampleHolder;
import asemon.hostmon.SshConnection;
import asemon.utils.Configuration;
import asemon.utils.StringUtil;
import ch.ethz.ssh2.Session;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public abstract class HostMonitor
implements Runnable {
    private static Logger _logger = Logger.getLogger(HostMonitor.class);
    public static final String PROPERTY_NAME = "HostMonitor";
    private Thread _thread = null;
    private boolean _running = false;
    private boolean _paused = false;
    private SshConnection _conn = null;
    private HostMonitorMetaData _metaData = null;
    private OsTableSampleHolder _sampleHolder = null;
    private OsTable _currentSample = null;
    private Timer _closeSampleTimeout = null;
    private int _closeSampleTimeoutDelay = 500;
    private boolean _firstTimeSample = true;
    private ArrayList<Exception> _exceptionList = new ArrayList();

    public HostMonitor() {
        this.setMetaData(this.createMetaData());
        this._sampleHolder = new OsTableSampleHolder(this.getMetaData());
        this._currentSample = new OsTable(this.getMetaData());
    }

    public void setConnection(SshConnection conn) {
        this._conn = conn;
    }

    public SshConnection getConnection() {
        return this._conn;
    }

    public String getHostname() {
        if (this._conn != null) {
            return this._conn.getHost();
        }
        return null;
    }

    public void setCloseSampleTimeoutDelay(int delayInMs) {
        this._closeSampleTimeoutDelay = delayInMs;
    }

    public int getCloseSampleTimeoutDelay() {
        return this._closeSampleTimeoutDelay;
    }

    public Exception getException() {
        if (this._exceptionList.isEmpty()) {
            return null;
        }
        Exception ex = this._exceptionList.get(0);
        this._exceptionList.clear();
        return ex;
    }

    public void addException(Exception ex) {
        this._exceptionList.add(ex);
    }

    public OsTableSampleHolder getSampleHolder() {
        return this._sampleHolder;
    }

    public OsTable getCurrentSample() {
        return this._currentSample;
    }

    public OsTable getSummaryTable() {
        OsTable summary = this.getSampleHolder().getTableSummary();
        return summary;
    }

    public abstract HostMonitorMetaData createMetaData();

    public HostMonitorMetaData getMetaData() {
        return this._metaData;
    }

    public void setMetaData(HostMonitorMetaData metaData) {
        this._metaData = metaData;
        if (this._sampleHolder != null) {
            this._sampleHolder.setMetaData(this._metaData);
        }
        if (this._currentSample != null) {
            this._currentSample.setMetaData(this._metaData);
        }
    }

    public boolean isOsCommandStreaming() {
        return this._metaData.isOsCommandStreaming();
    }

    public boolean isFirstTimeSample() {
        return this._firstTimeSample;
    }

    public void closeCurrentSample() {
        int rows = this._currentSample.getRowCount();
        if (rows > 0) {
            this._firstTimeSample = false;
            _logger.trace((Object)("Closing current sample, that has '" + rows + "' rows."));
            this._sampleHolder.add(this._currentSample);
            this._currentSample = new OsTable(this.getMetaData());
        } else {
            _logger.debug((Object)("SKIPPING: Closing current sample, it had '" + rows + "' rows."));
        }
    }

    public boolean skipRow(HostMonitorMetaData md, String row, String[] preParsed, int type) {
        Map<String, Integer> skipRows = md.getSkipRowsMap();
        if (skipRows == null) {
            return false;
        }
        for (Map.Entry<String, Integer> entry : skipRows.entrySet()) {
            String skipVal = entry.getKey();
            int skipPos = entry.getValue();
            if (!preParsed[skipPos].matches(skipVal)) continue;
            return true;
        }
        return false;
    }

    public boolean allowRow(HostMonitorMetaData md, String row, String[] preParsed, int type) {
        Map<String, Integer> allowRows = md.getAllowRowsMap();
        if (allowRows == null) {
            return true;
        }
        for (Map.Entry<String, Integer> entry : allowRows.entrySet()) {
            String allowVal = entry.getKey();
            int allowPos = entry.getValue();
            if (!preParsed[allowPos].matches(allowVal)) continue;
            return true;
        }
        return false;
    }

    public String[] parseRow(HostMonitorMetaData md, String row, String[] preParsed, int type) {
        if (preParsed.length != md.getParseColumnCount()) {
            return null;
        }
        if (this.skipRow(md, row, preParsed, type)) {
            return null;
        }
        if (!this.allowRow(md, row, preParsed, type)) {
            return null;
        }
        return preParsed;
    }

    public void parseAndApply(HostMonitorMetaData md, String row, int type) {
        if (row == null) {
            return;
        }
        String trimedRow = row.trim();
        Object[] isa = trimedRow.split(md.getParseRegexp());
        Object[] strArr = this.parseRow(md, row, (String[])isa, type);
        if (strArr != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("++ALLOW++: this row has '" + strArr.length + "' entries parseCount='" + md.getParseColumnCount() + "'. Row '" + row + "'. The Input/PreParsed String Array, size(" + isa.length + ")=[" + StringUtil.toCommaStr(isa) + "], The parseRow() returned String Array, size(" + strArr.length + ")=[" + StringUtil.toCommaStr(strArr) + "]."));
            }
            try {
                OsTableRow entry = new OsTableRow(md, (String[])strArr);
                this._currentSample.addRow(entry);
                if (this._closeSampleTimeout != null) {
                    this._closeSampleTimeout.restart();
                }
            }
            catch (OsRecordParseException e) {
                this.addException(e);
                _logger.error((Object)("Problems when applying the parsed String Array [" + StringUtil.toCommaStr(strArr) + "]."), (Throwable)e);
            }
        } else {
            _logger.debug((Object)("-DISCARD-: This row has '" + isa.length + "' entries parseCount='" + md.getParseColumnCount() + "'. Row '" + row + "'. The Input/PreParsed String Array, size(" + isa.length + ")=[" + StringUtil.toCommaStr(isa) + "]."));
        }
    }

    public int getSleepTime() {
        int sleepTime = 2;
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf != null) {
            sleepTime = conf.getIntProperty("hostmon." + this.getModuleName() + ".sleep", sleepTime);
        }
        return sleepTime;
    }

    public String getCommand() {
        String oscmd = null;
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf != null) {
            oscmd = conf.getProperty("hostmon." + this.getModuleName() + ".cmd");
        }
        if (oscmd != null) {
            _logger.debug((Object)(this.getModuleName() + " found OS Command '" + oscmd + "' in the configuration file."));
        }
        return oscmd;
    }

    protected String getThreadName() {
        return this.getModuleName();
    }

    public abstract String getModuleName();

    protected void printStartMessage() {
        _logger.info((Object)("Starting the Host Monitoring module '" + this.getModuleName() + "'."));
    }

    protected void printStopMessage() {
        _logger.info((Object)("Stopped the Host Monitoring module '" + this.getModuleName() + "'."));
    }

    public void start() throws Exception {
        if (!this.isOsCommandStreaming()) {
            _logger.warn((Object)(this.getModuleName() + " the command '" + this.getCommand() + "' is not marked as a streaming command, therefore you should not a background thread for this, instead use the method executeAndParse() to get a sample. Optionally use method getCurrentSample() to get the last sample results."));
            return;
        }
        if (this.isPaused()) {
            _logger.warn((Object)(this.getModuleName() + " has been paused, to be able to start the Host Monitor '" + this.getModuleName() + "' you need to invoke the method setPaused(false)."));
            return;
        }
        if (this.getMetaData() == null) {
            this.setMetaData(this.createMetaData());
        }
        if (this.getMetaData() == null) {
            throw new Exception("No MetaData Description has been created, this must be done before starting. This can be done by overriding method createMetaData() or use setMetaData().");
        }
        this._thread = new Thread((Runnable)this, this.getThreadName());
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public void shutdown() {
        _logger.info((Object)(this.getModuleName() + " Was asked to to a shutdown."));
        this._running = false;
        this._thread.interrupt();
    }

    public boolean isRunning() {
        if (this._thread != null && !this._thread.isAlive()) {
            this._running = false;
        }
        return this._running;
    }

    public void setPaused(boolean pause) {
        this._paused = pause;
    }

    public boolean isPaused() {
        return this._paused;
    }

    @Override
    public void run() {
        this.printStartMessage();
        this._running = true;
        Session sess = null;
        try {
            _logger.info((Object)("Executing command '" + this.getCommand() + "' for the module '" + this.getModuleName() + "'."));
            sess = this._conn.execCommand(this.getCommand());
        }
        catch (IOException e) {
            this.addException(e);
            _logger.error((Object)("Problems when executing OS Command '" + this.getCommand() + "', Caught: " + e.getMessage()), (Throwable)e);
            this._running = false;
            return;
        }
        if (this._closeSampleTimeoutDelay > 0) {
            _logger.debug((Object)("Creating 'Close-Sample-Timeout' with the timeout value of '" + this._closeSampleTimeoutDelay + "' ms."));
            this._closeSampleTimeout = new Timer(this._closeSampleTimeoutDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HostMonitor.this._closeSampleTimeout.stop();
                    HostMonitor.this.closeCurrentSample();
                }
            });
        }
        InputStream stdout = sess.getStdout();
        InputStream stderr = sess.getStderr();
        Charset osCharset = Charset.forName(this._conn.getOsCharset());
        byte[] buffer = new byte[16384];
        while (this._running) {
            try {
                BufferedReader sr;
                String row;
                int len;
                if (stdout.available() == 0 && stderr.available() == 0) {
                    int conditions = sess.waitForCondition(28, 30000L);
                    if ((conditions & 1) != 0) {
                        throw new IOException("Timeout while waiting for data from peer.");
                    }
                    if ((conditions & 0x10) != 0 && (conditions & 0xC) == 0) {
                        _logger.info((Object)(this.getModuleName() + " Received EOF from the command '" + this.getCommand() + "'."));
                        this.addException(new Exception("Received EOF from the command at time: " + new Timestamp(System.currentTimeMillis()) + ", \nThe module will be restarted, and the command '" + this.getCommand() + "' re-executed."));
                        break;
                    }
                }
                while (stdout.available() > 0) {
                    len = stdout.read(buffer);
                    if (len <= 0) continue;
                    row = null;
                    sr = new BufferedReader(new StringReader(new String(buffer, 0, len, osCharset)));
                    while ((row = sr.readLine()) != null) {
                        this.parseAndApply(this.getMetaData(), row, 4);
                    }
                }
                while (stderr.available() > 0) {
                    len = stderr.read(buffer);
                    if (len <= 0) continue;
                    row = null;
                    sr = new BufferedReader(new StringReader(new String(buffer, 0, len, osCharset)));
                    while ((row = sr.readLine()) != null) {
                        if (row != null && row.toLowerCase().indexOf("command not found") >= 0) {
                            _logger.error((Object)(this.getModuleName() + " was the command '" + this.getCommand() + "' in current $PATH, got following message on STDERR: " + row));
                            this.addException(new Exception("Was the command '" + this.getCommand() + "' in current $PATH, got following message on STDERR: " + row));
                        }
                        this.parseAndApply(this.getMetaData(), row, 8);
                    }
                }
            }
            catch (IOException e) {
                this.addException(e);
                _logger.error((Object)("Problems when reading output from the OS Command '" + this.getCommand() + "', Caught: " + e.getMessage()), (Throwable)e);
                this._running = false;
            }
        }
        if (sess != null) {
            sess.close();
        }
        this._running = false;
        this.printStopMessage();
    }

    /*
     * Exception decompiling
     */
    public OsTable executeAndParse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 9[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

