/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitor;
import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.MonitorIoAix;
import asemon.hostmon.MonitorIoHp;
import asemon.hostmon.MonitorIoLinux;
import asemon.hostmon.MonitorIoSolaris;
import asemon.hostmon.MonitorIoVeritas;
import asemon.hostmon.OsTable;
import asemon.hostmon.SshConnection;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public abstract class MonitorIo
extends HostMonitor {
    public static HostMonitor createMonitor(String host, String user, String passwd, boolean start) throws Exception {
        return MonitorIo.createMonitor(host, 22, user, passwd, start);
    }

    public static HostMonitor createMonitor(String host, int port, String user, String passwd, boolean start) throws Exception {
        SshConnection conn = new SshConnection(host, port, user, passwd);
        return MonitorIo.createMonitor(conn, start);
    }

    public static HostMonitor createMonitor(SshConnection conn, boolean start) throws Exception {
        if (!conn.isConnected()) {
            conn.connect();
        }
        if (!conn.isConnected()) {
            throw new Exception("Failed to connect to the remote host. conn=" + conn);
        }
        String osname = conn.getOsName();
        boolean hasVeritas = conn.hasVeritas();
        if (hasVeritas) {
            osname = "VERITAS";
        }
        MonitorIo mon = null;
        if (osname.equals("SunOS")) {
            mon = new MonitorIoSolaris();
        } else if (osname.equals("Linux")) {
            mon = new MonitorIoLinux();
        } else if (osname.equals("AIX")) {
            mon = new MonitorIoAix();
        } else if (osname.equals("HP-UX")) {
            mon = new MonitorIoHp();
        } else if (osname.equals("VERITAS")) {
            mon = new MonitorIoVeritas();
        } else {
            throw new Exception("The Unix system '" + osname + "', is not supported by the module 'MonitorIo' for the moment.");
        }
        mon.setConnection(conn);
        if (start) {
            mon.start();
        }
        return mon;
    }

    public static HostMonitorMetaData[] createOfflineMetaData() {
        HostMonitorMetaData[] mdArr = new HostMonitorMetaData[]{new MonitorIoSolaris().createMetaData(), new MonitorIoLinux().createMetaData(), new MonitorIoAix().createMetaData(), new MonitorIoHp().createMetaData(), new MonitorIoVeritas().createMetaData()};
        return mdArr;
    }

    public static void main(String[] args) {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "INFO, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        try {
            SshConnection conn = new SshConnection("sunspot", "gorans", "xxxxx");
            HostMonitor mon = MonitorIo.createMonitor(conn, false);
            while (true) {
                OsTable sample;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if ((sample = mon.getSummaryTable()) == null) continue;
                System.err.println(">>>>>>>>getSummaryTable(): \n" + sample.toTableString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

