/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.MonitorIo;
import asemon.utils.Configuration;

public class MonitorIoAix
extends MonitorIo {
    private boolean _skipEmptyBpsSamples = true;
    private int _pos_X_bps;
    private int _pos_X_bread;
    private int _pos_X_bwrtn;
    private int _pos_R_avgserv;
    private int _pos_R_minserv;
    private int _pos_R_maxserv;
    private int _pos_W_avgserv;
    private int _pos_W_minserv;
    private int _pos_W_maxserv;
    private int _pos_Q_avgtime;
    private int _pos_Q_mintime;
    private int _pos_Q_maxtime;

    @Override
    public String getModuleName() {
        return "MonitorIoAix";
    }

    @Override
    public String getCommand() {
        String cmd = super.getCommand();
        return cmd != null ? cmd : "iostat -Dl " + this.getSleepTime();
    }

    @Override
    public HostMonitorMetaData createMetaData() {
        HostMonitorMetaData md = new HostMonitorMetaData();
        md.setTableName(this.getModuleName());
        md.addStrColumn("Disks", 1, 1, false, 30, "Disk device name");
        md.addIntColumn("samples", 2, 0, true, "Number of 'sub' sample entries of iostat this value is based on");
        md.addStatColumn("X_tm_act", 3, 2, true, 7, 1, "Indicates the percentage of time the physical disk or tape was active (bandwidth utilization for the drive).");
        md.addStatColumn("X_bps", 4, 3, true, 7, 1, "Indicates the amount of data transferred (read or written) per second to the drive. Note: in AseMon this is always presented in KB per second");
        md.addStatColumn("X_tps", 5, 4, true, 7, 1, "Indicates the number of transfers per second that were issued to the physical disk or tape. A transfer is an I/O request to the physical disk or tape. Multiple logical requests can be combined into a single I/O request to the disk. A transfer is of indeterminate size.");
        md.addStatColumn("X_bread", 6, 5, true, 7, 1, "Indicates the amount of data read per second, from the drive. Note: in AseMon this is always presented in KB per second");
        md.addStatColumn("X_bwrtn", 7, 6, true, 7, 1, "Indicates the amount of data written per second, to the drive. Note: in AseMon this is always presented in KB per second");
        md.addStatColumn("R_rps", 8, 7, true, 7, 1, "Indicates the number of read transfers per second.");
        md.addStatColumn("R_avgserv", 9, 8, true, 7, 1, "Indicates the average service time per read transfer. Note: in AseMon this is always presented in in milliseconds.");
        md.addStatColumn("R_minserv", 10, 9, true, 7, 1, "Indicates the minimum read service time. Note: in AseMon this is always presented in in milliseconds.");
        md.addStatColumn("R_maxserv", 11, 10, true, 7, 1, "Indicates the maximum read service time. Note: in AseMon this is always presented in in milliseconds.");
        md.addStatColumn("R_timeouts", 12, 11, true, 7, 1, "Indicates the number of read timeouts per second.");
        md.addStatColumn("R_fails", 13, 12, true, 7, 1, "Indicates the number of failed read requests per second.");
        md.addStatColumn("W_wps", 14, 13, true, 7, 1, "Indicates the number of write transfers per second.");
        md.addStatColumn("W_avgserv", 15, 14, true, 7, 1, "Indicates the average service time per write transfer. Note: in AseMon this is always presented in in milliseconds.");
        md.addStatColumn("W_minserv", 16, 15, true, 7, 1, "Indicates the minimum write service time. Note: in AseMon this is always presented in in milliseconds.");
        md.addStatColumn("W_maxserv", 17, 16, true, 7, 1, "Indicates the maximum write service time. Note: in AseMon this is always presented in in milliseconds.");
        md.addStatColumn("W_timeouts", 18, 17, true, 7, 1, "Indicates the number of write timeouts per second.");
        md.addStatColumn("W_fails", 19, 18, true, 7, 1, "Indicates the number of failed write requests per second.");
        md.addStatColumn("Q_avgtime", 20, 19, true, 7, 1, "Indicates the average time spent by a transfer request in the wait queue. Note: in AseMon this is always presented in in milliseconds.");
        md.addStatColumn("Q_mintime", 21, 20, true, 7, 1, "Indicates the minimum time spent by a transfer request in the wait queue. Note: in AseMon this is always presented in in milliseconds.");
        md.addStatColumn("Q_maxtime", 22, 21, true, 7, 1, "Indicates the maximum time spent by a transfer request in the wait queue. Note: in AseMon this is always presented in in milliseconds.");
        md.addStatColumn("Q_avgwqsz", 23, 22, true, 7, 1, "Indicates the average wait queue size.");
        md.addStatColumn("Q_avgsqsz", 24, 23, true, 7, 1, "Indicates the average service queue size.");
        md.addStatColumn("Q_sqfull", 25, 24, true, 7, 1, "Indicates the number of times the service queue becomes full (that is, the disk is not accepting any more service requests) per second.");
        md.setPkCol("Disks");
        md.setStatusCol("samples", 1);
        md.setPercentCol("X_tm_act");
        md.setParseRegexp("\\s+");
        md.setSkipAndAllowRows(null, Configuration.getCombinedConfiguration());
        md.setSkipAndAllowRows("hostmon.MonitorIo.", Configuration.getCombinedConfiguration());
        this._pos_X_bps = md.getParseColumnArrayPos("X_bps");
        this._pos_X_bread = md.getParseColumnArrayPos("X_bread");
        this._pos_X_bwrtn = md.getParseColumnArrayPos("X_bwrtn");
        this._pos_R_avgserv = md.getParseColumnArrayPos("R_avgserv");
        this._pos_R_minserv = md.getParseColumnArrayPos("R_minserv");
        this._pos_R_maxserv = md.getParseColumnArrayPos("R_maxserv");
        this._pos_W_avgserv = md.getParseColumnArrayPos("W_avgserv");
        this._pos_W_minserv = md.getParseColumnArrayPos("W_minserv");
        this._pos_W_maxserv = md.getParseColumnArrayPos("W_maxserv");
        this._pos_Q_avgtime = md.getParseColumnArrayPos("Q_avgtime");
        this._pos_Q_mintime = md.getParseColumnArrayPos("Q_mintime");
        this._pos_Q_maxtime = md.getParseColumnArrayPos("Q_maxtime");
        return md;
    }

    @Override
    public String[] parseRow(HostMonitorMetaData md, String row, String[] preParsed, int type) {
        if (preParsed.length == md.getParseColumnCount()) {
            if (this.skipRow(md, row, preParsed, type)) {
                return null;
            }
            if (!this.allowRow(md, row, preParsed, type)) {
                return null;
            }
            if (this._skipEmptyBpsSamples && "0.0".equals(preParsed[this._pos_X_bps])) {
                return null;
            }
            preParsed[this._pos_X_bps] = this.recalcSuffixesValues(preParsed[this._pos_X_bps]);
            preParsed[this._pos_X_bread] = this.recalcSuffixesValues(preParsed[this._pos_X_bread]);
            preParsed[this._pos_X_bwrtn] = this.recalcSuffixesValues(preParsed[this._pos_X_bwrtn]);
            preParsed[this._pos_R_avgserv] = this.recalcSuffixesValues(preParsed[this._pos_R_avgserv]);
            preParsed[this._pos_R_minserv] = this.recalcSuffixesValues(preParsed[this._pos_R_minserv]);
            preParsed[this._pos_R_maxserv] = this.recalcSuffixesValues(preParsed[this._pos_R_maxserv]);
            preParsed[this._pos_W_avgserv] = this.recalcSuffixesValues(preParsed[this._pos_W_avgserv]);
            preParsed[this._pos_W_minserv] = this.recalcSuffixesValues(preParsed[this._pos_W_minserv]);
            preParsed[this._pos_W_maxserv] = this.recalcSuffixesValues(preParsed[this._pos_W_maxserv]);
            preParsed[this._pos_Q_avgtime] = this.recalcSuffixesValues(preParsed[this._pos_Q_avgtime]);
            preParsed[this._pos_Q_mintime] = this.recalcSuffixesValues(preParsed[this._pos_Q_mintime]);
            preParsed[this._pos_Q_maxtime] = this.recalcSuffixesValues(preParsed[this._pos_Q_maxtime]);
            return preParsed;
        }
        return null;
    }

    private String recalcSuffixesValues(String str) {
        String lastChar = str.substring(str.length() - 1);
        String numStr = str.substring(0, str.length() - 1);
        if ("K".equals(lastChar)) {
            return numStr;
        }
        if ("M".equals(lastChar)) {
            return Double.toString(Double.parseDouble(numStr) * 1000.0);
        }
        if ("G".equals(lastChar)) {
            return Double.toString(Double.parseDouble(numStr) * 1000000.0);
        }
        if ("T".equals(lastChar)) {
            return Double.toString(Double.parseDouble(numStr) * 1.0E9);
        }
        if ("S".equals(lastChar)) {
            return Double.toString(Double.parseDouble(numStr) * 1000.0);
        }
        if ("H".equals(lastChar)) {
            return Double.toString(Double.parseDouble(numStr) * 1000.0 * 3699.0);
        }
        return str;
    }
}

