/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.MonitorIo;
import asemon.utils.Configuration;

public class MonitorIoHp
extends MonitorIo {
    @Override
    public String getModuleName() {
        return "MonitorIoHp";
    }

    @Override
    public String getCommand() {
        String cmd = super.getCommand();
        return cmd != null ? cmd : "iostat " + this.getSleepTime();
    }

    @Override
    public HostMonitorMetaData createMetaData() {
        HostMonitorMetaData md = new HostMonitorMetaData();
        md.setTableName(this.getModuleName());
        md.addStrColumn("device", 1, 1, false, 30, "Device name");
        md.addIntColumn("samples", 2, 0, true, "Number of 'sub' sample entries of iostat this value is based on");
        md.addStatColumn("bps", 3, 2, true, 10, 1, "Kilobytes transferred per second");
        md.addStatColumn("sps", 4, 3, true, 10, 1, "Number of seeks per second");
        md.addStatColumn("msps", 5, 4, true, 10, 1, "Milliseconds per average seek");
        md.setPkCol("device");
        md.setStatusCol("samples", 1);
        md.setParseRegexp("\\s+");
        md.setSkipRows("device", "device");
        md.setSkipAndAllowRows(null, Configuration.getCombinedConfiguration());
        md.setSkipAndAllowRows("hostmon.MonitorIo.", Configuration.getCombinedConfiguration());
        return md;
    }
}

