/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.MonitorIo;
import asemon.utils.Configuration;

public class MonitorIoVeritas
extends MonitorIo {
    @Override
    public String getModuleName() {
        return "MonitorIoVeritas";
    }

    @Override
    public String getCommand() {
        String cmd = super.getCommand();
        return cmd != null ? cmd : "vxstat -o alldgs -i " + this.getSleepTime() + " -S";
    }

    @Override
    public HostMonitorMetaData createMetaData() {
        HostMonitorMetaData md = new HostMonitorMetaData();
        md.setTableName(this.getModuleName());
        md.addStrColumn("type", 1, 1, false, 30, "Type of Veritas device (vol/disk)");
        md.addStrColumn("name", 2, 2, false, 30, "Name of the disk");
        md.addIntColumn("samples", 3, 0, true, "Number of 'sub' sample entries of vxstat this value is based on");
        md.addStatColumn("OperationsRead", 4, 3, true, 8, 1, "The number of read operations, per seconds");
        md.addStatColumn("OperationsWrite", 5, 4, true, 8, 1, "The number of write operations, per seconds");
        md.addStatColumn("BlocksRead", 6, 5, true, 8, 1, "The number of blocks read, per seconds");
        md.addStatColumn("BlocksWrite", 7, 6, true, 8, 1, "The number of blocks written, per second");
        md.addStatColumn("AvgTimeMsRead", 8, 7, true, 8, 1, "The average time in milliseconds spent on read operations in the interval");
        md.addStatColumn("AvgTimeMsWrite", 9, 8, true, 8, 1, "The average time in milliseconds spent on write operations in the interval");
        md.setPkCol("name");
        md.setStatusCol("samples", 1);
        md.setParseRegexp("\\s+");
        md.setSkipRows("name", "NAME");
        md.setSkipAndAllowRows(null, Configuration.getCombinedConfiguration());
        md.setSkipAndAllowRows("hostmon.MonitorIo.", Configuration.getCombinedConfiguration());
        return md;
    }
}

