/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitor;
import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.MonitorMpstatAix;
import asemon.hostmon.MonitorMpstatLinux;
import asemon.hostmon.MonitorMpstatSolaris;
import asemon.hostmon.MonitorVmstat;
import asemon.hostmon.OsTable;
import asemon.hostmon.SshConnection;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public abstract class MonitorMpstat
extends HostMonitor {
    public static HostMonitor createMonitor(String host, String user, String passwd, boolean start) throws Exception {
        return MonitorMpstat.createMonitor(host, 22, user, passwd, start);
    }

    public static HostMonitor createMonitor(String host, int port, String user, String passwd, boolean start) throws Exception {
        SshConnection conn = new SshConnection(host, port, user, passwd);
        return MonitorMpstat.createMonitor(conn, start);
    }

    public static HostMonitor createMonitor(SshConnection conn, boolean start) throws Exception {
        if (!conn.isConnected()) {
            conn.connect();
        }
        if (!conn.isConnected()) {
            throw new Exception("Failed to connect to the remote host. conn=" + conn);
        }
        String osname = conn.getOsName();
        MonitorVmstat mon = null;
        if (osname.equals("SunOS")) {
            mon = new MonitorMpstatSolaris();
        } else if (osname.equals("Linux")) {
            mon = new MonitorMpstatLinux();
        } else if (osname.equals("AIX")) {
            mon = new MonitorMpstatAix();
        } else {
            throw new Exception("The Unix system '" + osname + "', is not supported by the module 'MonitorMpstat' for the moment.");
        }
        mon.setConnection(conn);
        if (start) {
            mon.start();
        }
        return mon;
    }

    public static HostMonitorMetaData[] createOfflineMetaData() {
        HostMonitorMetaData[] mdArr = new HostMonitorMetaData[]{new MonitorMpstatSolaris().createMetaData(), new MonitorMpstatLinux().createMetaData(), new MonitorMpstatAix().createMetaData()};
        return mdArr;
    }

    public static void main(String[] args) {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "INFO, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        try {
            SshConnection conn = new SshConnection("sunspot", "gorans", "xxxx");
            HostMonitor mon = MonitorMpstat.createMonitor(conn, false);
            mon.start();
            while (true) {
                OsTable sample;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if ((sample = mon.getSummaryTable()) == null) continue;
                System.err.println(">>>>>>>>getSummaryTable(): \n" + sample.toTableString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

