/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.cm.CounterTableModel;
import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.OsTableRow;
import asemon.utils.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OsTable
extends CounterTableModel {
    private static final long serialVersionUID = 1L;
    private HostMonitorMetaData _metaData = null;
    private long _time = System.currentTimeMillis();
    private long _sampleSpanTime = 0L;
    LinkedHashMap<String, OsTableRow> _pkMap = new LinkedHashMap();
    ArrayList<OsTableRow> _rowList = new ArrayList();

    public OsTable(HostMonitorMetaData md) {
        this._metaData = md;
    }

    public void setMetaData(HostMonitorMetaData metaData) {
        this._metaData = metaData;
    }

    public synchronized void addRow(OsTableRow rowEntry) {
        String pk = rowEntry.getPk();
        if (pk != null && !pk.equals("")) {
            this._pkMap.put(rowEntry.getPk(), rowEntry);
        }
        this._rowList.add(rowEntry);
    }

    public OsTableRow getRowByPk(String pk) {
        return this._pkMap.get(pk);
    }

    public OsTableRow getRow(int row) {
        return this._rowList.get(row);
    }

    public Map<String, OsTableRow> getPkMap() {
        return this._pkMap;
    }

    public long getTime() {
        return this._time;
    }

    public void setSampleSpanTime(long timeSpanInMs) {
        this._sampleSpanTime = timeSpanInMs;
    }

    public long getSampleSpanTime() {
        return this._sampleSpanTime;
    }

    public HostMonitorMetaData getMetaData() {
        return this._metaData;
    }

    public String toTableString() {
        StringBuilder sb = new StringBuilder();
        for (HostMonitorMetaData.ColumnEntry ce : this._metaData.getColumns()) {
            if (ce._sqlColNum <= 0) continue;
            sb.append(StringUtil.left(ce._colName, ce._displayLength, false)).append(" ");
        }
        sb.append("\n");
        for (HostMonitorMetaData.ColumnEntry ce : this._metaData.getColumns()) {
            if (ce._sqlColNum <= 0) continue;
            sb.append(StringUtil.replicate("-", ce._displayLength)).append(" ");
        }
        sb.append("\n");
        for (OsTableRow row : this._rowList) {
            for (HostMonitorMetaData.ColumnEntry ce : this._metaData.getColumns()) {
                if (ce._sqlColNum <= 0) continue;
                String str = ce._isNumber ? StringUtil.right("" + row.getValue(ce._sqlColNum), ce._displayLength) : StringUtil.left("" + row.getValue(ce._sqlColNum), ce._displayLength, false);
                sb.append(str).append(" ");
            }
            sb.append("\n");
        }
        sb.append("Number of row(s)in table ").append(this.getRowCount()).append(".\n");
        return sb.toString();
    }

    @Override
    public synchronized int getRowCount() {
        return this._rowList.size();
    }

    @Override
    public int getColumnCount() {
        return this._metaData.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this._metaData.getColumnName(column + 1);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        OsTableRow entry = this.getRow(row);
        return entry.getValue(column + 1);
    }

    @Override
    public void setValueAt(Object val, int row, int column) {
    }

    @Override
    public int getRowNumberForPkValue(String pkStr) {
        OsTableRow row = this.getRowByPk(pkStr);
        return this._rowList.indexOf(row);
    }

    @Override
    public String getPkValue(int rowId) {
        OsTableRow row = this.getRow(rowId);
        return row.getPk();
    }

    @Override
    public List<String> getColNames() {
        return this._metaData.getColumnNames();
    }
}

