/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.OsTable;
import asemon.hostmon.OsTableRow;
import asemon.hostmon.OsTableRowSummary;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class OsTableSampleHolder {
    private HostMonitorMetaData _metaData = null;
    private ArrayList<OsTable> _samples = new ArrayList();
    private LinkedHashMap<String, String> _pkMap = new LinkedHashMap();

    public OsTableSampleHolder(HostMonitorMetaData metaData) {
        this._metaData = metaData;
    }

    public void setMetaData(HostMonitorMetaData metaData) {
        this._metaData = metaData;
    }

    public synchronized void add(OsTable sample) {
        int maxQueueSize = this._metaData.getMaxQueueSize();
        if (this._samples.size() > maxQueueSize) {
            int lastRow = this._samples.size() - 1;
            this._samples.remove(lastRow);
        }
        for (OsTableRow entry : sample.getPkMap().values()) {
            String pk = entry.getPk();
            if (this._pkMap.containsKey(pk)) continue;
            this._pkMap.put(pk, pk);
        }
        this._samples.add(sample);
    }

    public synchronized OsTable getTableSummary() {
        if (this._samples.isEmpty()) {
            return new OsTable(this._metaData);
        }
        OsTable first = this._samples.get(0);
        OsTable last = this._samples.get(this._samples.size() - 1);
        long sampleSpan = last.getTime() - first.getTime();
        OsTable outputTable = new OsTable(this._metaData);
        outputTable.setSampleSpanTime(sampleSpan);
        if (this._pkMap.size() > 0) {
            for (String pk : this._pkMap.keySet()) {
                OsTableRowSummary sumEntry = new OsTableRowSummary(this._metaData, pk);
                for (OsTable tSample : this._samples) {
                    OsTableRow entry = tSample.getRowByPk(pk);
                    if (entry == null) continue;
                    sumEntry.addToSummary(entry);
                }
                sumEntry.calcAverage();
                outputTable.addRow(sumEntry);
            }
        } else {
            for (OsTable tSample : this._samples) {
                for (int r = 0; r < tSample.getRowCount(); ++r) {
                    outputTable.addRow(tSample.getRow(r));
                }
            }
        }
        this._samples.clear();
        return outputTable;
    }
}

