/*
 * Decompiled with CFR 0.152.
 */
package asemon.pcs;

import asemon.cm.CountersModel;
import asemon.pcs.PersistContainer;
import asemon.utils.Configuration;
import asemon.utils.TimeUtils;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class InMemoryCounterHandler
implements Runnable {
    private static Logger _logger = Logger.getLogger(InMemoryCounterHandler.class);
    private static InMemoryCounterHandler _instance = null;
    private boolean _initialized = false;
    private boolean _running = false;
    private Thread _thread = null;
    private Configuration _props;
    private int _warnQueueSizeThresh = 2;
    private int _saveTimeInSec = 600;
    private LinkedList<PersistContainer> _list = new LinkedList();
    private BlockingQueue<PersistContainer> _containerQueue = new LinkedBlockingQueue<PersistContainer>();
    EventListenerList _listenerList = new EventListenerList();

    public InMemoryCounterHandler() throws Exception {
    }

    public InMemoryCounterHandler(Configuration props) throws Exception {
        this.init(props);
    }

    public synchronized void init(Configuration props) throws Exception {
        this._props = props;
        _logger.info((Object)"Initializing the In-Memory Counter Handler functionality.");
        this._warnQueueSizeThresh = this._props.getIntProperty("InMemoryCounterHandler.warnQueueSizeThresh", this._warnQueueSizeThresh);
        int hist = Configuration.getCombinedConfiguration().getIntProperty("InMemoryCounterHandler.history", -1);
        if (hist == -1) {
            _logger.info((Object)("Cant find property 'InMemoryCounterHandler.history', using default '" + this._saveTimeInSec + "'."));
        } else {
            this.setHistoryLengthInSeconds(hist);
        }
        _logger.info((Object)("Saving Counters in memory for '" + this._saveTimeInSec + "' seconds, (Minutes:Seconds = " + TimeUtils.msToTimeStr("%MM:%SS", this._saveTimeInSec * 1000) + ")."));
        this._initialized = true;
    }

    public void addChangeListener(ChangeListener l) {
        this._listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] aobj = this._listenerList.getListenerList();
        for (int i = aobj.length - 2; i >= 0; i -= 2) {
            if (aobj[i] != ChangeListener.class) continue;
            ChangeEvent changeEvent = new ChangeEvent(this);
            ((ChangeListener)aobj[i + 1]).stateChanged(changeEvent);
        }
    }

    public static InMemoryCounterHandler getInstance() {
        return _instance;
    }

    public static boolean hasInstance() {
        return _instance != null;
    }

    public static void setInstance(InMemoryCounterHandler inst) {
        _instance = inst;
    }

    public void setHistoryLengthInSeconds(int seconds) {
        this._saveTimeInSec = seconds;
        Configuration conf = Configuration.getInstance("USER_TEMP");
        conf.setProperty("InMemoryCounterHandler.history", seconds);
        conf.save();
    }

    public void setHistoryLengthInMinutes(int minutes) {
        this.setHistoryLengthInSeconds(minutes * 60);
    }

    public synchronized int getSize() {
        return this._list.size();
    }

    public void add(PersistContainer cont) {
        int qsize = this._containerQueue.size();
        if (qsize > this._warnQueueSizeThresh) {
            _logger.warn((Object)("The 'in box' queue to In Memory Counter Handler has " + qsize + " entries. The handler might not keep in pace."));
        }
        this._containerQueue.add(cont);
    }

    public synchronized int indexOf(PersistContainer pc) {
        return this._list.indexOf(pc);
    }

    public synchronized int indexOf(Timestamp ts) {
        if (ts == null) {
            return -1;
        }
        for (int i = 0; i < this._list.size() - 1; ++i) {
            PersistContainer pc = this._list.get(i);
            if (!pc.equalsApprox(ts)) continue;
            return i;
        }
        return -1;
    }

    public synchronized PersistContainer get(int pos) {
        return this._list.get(pos);
    }

    public synchronized Timestamp getTs(int pos) {
        PersistContainer pc = this._list.get(pos);
        return pc == null ? null : pc.getMainSampleTime();
    }

    public synchronized PersistContainer get(Timestamp ts) {
        int index = this.indexOf(ts);
        if (index >= 0) {
            return this.get(index);
        }
        return null;
    }

    public CountersModel getCmForSample(String name, Timestamp offlineSampleTime) {
        PersistContainer pc = this.get(offlineSampleTime);
        if (pc == null) {
            return null;
        }
        return pc.getCm(name);
    }

    public PersistContainer getRight() {
        return this.getNewest();
    }

    public synchronized PersistContainer getNewest() {
        return this._list.getLast();
    }

    public PersistContainer getLeft() {
        return this.getOldest();
    }

    public synchronized PersistContainer getOldest() {
        return this._list.getFirst();
    }

    private void isInitialized() {
        if (!this._initialized) {
            throw new RuntimeException("The Persistent Counter Handler module has NOT yet been initialized.");
        }
    }

    public void clear(boolean keepLastEntry) {
        try {
            if (this._list == null) {
                return;
            }
            if (this._list.isEmpty()) {
                return;
            }
            PersistContainer last = this._list.getLast();
            this._list.clear();
            if (keepLastEntry) {
                this._list.addLast(last);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("The in-memory history list has " + this._list.size() + " entries."));
            }
            this.fireStateChanged();
        }
        catch (Throwable t) {
            _logger.error((Object)"The In Memory Counter Handler got runtime error.", t);
        }
    }

    private synchronized void consume(PersistContainer cont, long prevConsumeTimeMs) {
        try {
            this._list.addLast(cont);
            Timestamp expireTs = new Timestamp(cont.getMainSampleTime().getTime() - (long)(this._saveTimeInSec * 1000));
            for (int i = 0; i < 1000 && this._list.size() != 0; ++i) {
                PersistContainer oldest = this._list.getFirst();
                if (_logger.isTraceEnabled()) {
                    _logger.trace((Object)("_saveTimeInSec=" + this._saveTimeInSec + ", oldest.ts='" + oldest.getMainSampleTime() + "', exireTs='" + expireTs + "'. last.getSampleTime().before(expireTs)=" + oldest.getMainSampleTime().before(expireTs)));
                }
                if (!oldest.getMainSampleTime().before(expireTs)) break;
                _logger.debug((Object)("Removing oldest entry: " + oldest.getMainSampleTime()));
                this._list.removeFirst();
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("The in-memory history list has " + this._list.size() + " entries."));
            }
            this.fireStateChanged();
        }
        catch (Throwable t) {
            _logger.error((Object)"The In Memory Counter Handler got runtime error.", t);
        }
    }

    @Override
    public void run() {
        _logger.info((Object)("Starting a thread for the module '" + this._thread.getName() + "'."));
        this.isInitialized();
        this._running = true;
        long prevConsumeTimeMs = 0L;
        while (this._running) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Thread '" + this._thread.getName() + "', waiting on queue..."));
            }
            try {
                PersistContainer cont = this._containerQueue.take();
                if (cont == null || cont._counterObjects == null || cont._counterObjects.size() <= 0) continue;
                long startTime = System.currentTimeMillis();
                this.consume(cont, prevConsumeTimeMs);
                long stopTime = System.currentTimeMillis();
                prevConsumeTimeMs = stopTime - startTime;
                _logger.debug((Object)("It took " + prevConsumeTimeMs + " ms to persist the above information."));
            }
            catch (InterruptedException ex) {
                this._running = false;
            }
        }
        _logger.info((Object)("Thread '" + this._thread.getName() + "' was stopped."));
    }

    public boolean isRunning() {
        return this._running;
    }

    public void start() {
        this.isInitialized();
        this._thread = new Thread(this);
        this._thread.setName("InMemoryCounterHandler");
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public void stop() {
        this._running = false;
        if (this._thread != null) {
            this._thread.interrupt();
            this._thread = null;
        }
    }
}

