/*
 * Decompiled with CFR 0.152.
 */
package asemon.pcs;

import asemon.cm.CountersModel;
import asemon.utils.StringUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PersistContainer {
    private static Logger _logger = Logger.getLogger(PersistContainer.class);
    protected Timestamp _sessionStartTime = null;
    protected Timestamp _mainSampleTime = null;
    protected long _sampleInterval = 0L;
    protected String _serverName = null;
    protected String _onHostname = null;
    protected List<CountersModel> _counterObjects = null;
    protected boolean _startNewSample = false;

    public PersistContainer(Timestamp mainSampleTime, String serverName, String onHostname) {
        this._mainSampleTime = mainSampleTime;
        this._serverName = serverName;
        this._onHostname = onHostname;
    }

    public void setSessionStartTime(Timestamp startTime) {
        this._sessionStartTime = startTime;
    }

    public void setMainSampleTime(Timestamp mainSampleTime) {
        this._mainSampleTime = mainSampleTime;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public void setOnHostname(String onHostname) {
        this._onHostname = onHostname;
    }

    public void setStartNewSample(boolean startNew) {
        this._startNewSample = startNew;
    }

    public Timestamp getSessionStartTime() {
        return this._sessionStartTime;
    }

    public Timestamp getMainSampleTime() {
        return this._mainSampleTime;
    }

    public long getSampleInterval() {
        return this._sampleInterval;
    }

    public String getServerName() {
        return this._serverName;
    }

    public String getOnHostname() {
        return this._onHostname;
    }

    public boolean getStartNewSample() {
        return this._startNewSample;
    }

    public CountersModel getCm(String name) {
        if (this._counterObjects == null) {
            return null;
        }
        for (CountersModel cm : this._counterObjects) {
            if (!cm.getName().equals(name)) continue;
            return cm;
        }
        return null;
    }

    public void add(CountersModel cm) {
        long cmInterval;
        if (this._counterObjects == null) {
            this._counterObjects = new ArrayList<CountersModel>(20);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("PersistContainer.add: name=" + StringUtil.left(cm.getName(), 20) + ", timeHead=" + cm.getSampleTimeHead() + ", sampleTime=" + cm.getSampleTime() + ", interval=" + cm.getSampleInterval()));
        }
        if (this._sampleInterval < (cmInterval = cm.getSampleInterval())) {
            this._sampleInterval = cmInterval;
        }
        this._counterObjects.add(cm.copyForStorage());
    }

    public boolean equals(PersistContainer pc) {
        if (pc == null) {
            return false;
        }
        if (this._mainSampleTime == null) {
            return false;
        }
        return this._mainSampleTime.equals(pc.getMainSampleTime());
    }

    public boolean equalsApprox(Timestamp ts) {
        if (ts == null) {
            return false;
        }
        if (this._mainSampleTime == null) {
            return false;
        }
        return this._mainSampleTime.equals(ts) || ts.after(this._mainSampleTime) && ts.getTime() <= this._mainSampleTime.getTime() + this._sampleInterval;
    }
}

