/*
 * Decompiled with CFR 0.152.
 */
package asemon.pcs;

import asemon.GetCounters;
import asemon.cm.CountersModel;
import asemon.gui.MainFrame;
import asemon.gui.TabularCntrPanel;
import asemon.gui.TrendGraph;
import asemon.pcs.PersistWriterBase;
import asemon.utils.Configuration;
import asemon.utils.StringUtil;
import asemon.utils.TimeUtils;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class PersistReader
implements Runnable {
    private static Logger _logger = Logger.getLogger(PersistReader.class);
    private static final String CMD_loadTimelineSlider = "loadTimelineSlider";
    private static final String CMD_loadSessionGraphs = "loadSessionGraphs";
    private static final String CMD_loadSessionCms = "loadSessionCms";
    private static final String CMD_loadSessionCmIndicators = "loadSessionCmIndicators";
    private static final String CMD_loadSummaryCm = "loadSummaryCm";
    private static final String CMD_loadSessions = "loadSessions";
    private Connection _conn = null;
    private static PersistReader _instance = null;
    private HashMap<String, CmIndicator> _currentIndicatorMap = new HashMap();
    private HashMap<String, SessionIndicator> _sessionIndicatorMap = new HashMap();
    private int _execMode = 0;
    public static final int EXEC_MODE_BG = 0;
    public static final int EXEC_MODE_DIRECT = 1;
    private int _numOfSamplesOnLastRefresh = -1;
    private int _numOfSamplesNow = -1;
    private static String GET_ALL_SESSIONS = "select \"SessionStartTime\", \"ServerName\", \"NumOfSamples\", \"LastSampleTime\" from " + PersistWriterBase.getTableName(1, null, true) + " " + "order by \"SessionStartTime\"";
    private static String GET_SESSION = "select \"SessionStartTime\", \"SessionSampleTime\" from " + PersistWriterBase.getTableName(3, null, true) + " " + "where \"SessionStartTime\" = ? " + "order by \"SessionSampleTime\"";
    EventListenerList _listenerList = new EventListenerList();
    private boolean _asynchExec = false;
    private BlockingQueue<QueueCommand> _cmdQueue = new LinkedBlockingQueue<QueueCommand>();
    private Thread _readThread = null;
    private boolean _running = false;
    private int _warnQueueSizeThresh = 10;
    private LinkedHashMap<String, OfflineCm> _offlineCmMap = null;
    private LinkedList<INotificationListener> _notificationListeners = new LinkedList();

    public PersistReader(Connection conn) {
        this._conn = conn;
        this.start();
    }

    public static PersistReader getInstance() {
        return _instance;
    }

    public static boolean hasInstance() {
        return _instance != null;
    }

    public static void setInstance(PersistReader inst) {
        _instance = inst;
    }

    public void setConnection(Connection conn) {
        this._conn = conn;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public void closeConnection() {
        try {
            if (this.isConnected()) {
                this._conn.close();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"Offline connection closed");
                }
            }
        }
        catch (SQLException ev) {
            _logger.error((Object)"Closing Offline connection", (Throwable)ev);
        }
        this._conn = null;
    }

    public boolean isConnected() {
        if (this._conn == null) {
            return false;
        }
        try {
            if (this._conn.isClosed()) {
                return false;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public static boolean isOfflineDb(Connection conn) {
        if (conn == null) {
            return false;
        }
        try {
            if (conn.isClosed()) {
                return false;
            }
        }
        catch (SQLException e) {
            return false;
        }
        try {
            String tabName = PersistWriterBase.getTableName(1, null, false);
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getColumns(null, null, tabName, "%");
            boolean tabExists = rs.next();
            rs.close();
            return tabExists;
        }
        catch (SQLException e) {
            _logger.error((Object)"Problems checking if this is a valid 'offline' database.", (Throwable)e);
            return false;
        }
    }

    public boolean hasCountersForCm(String name) {
        CmIndicator cmInd = this.getIndicatorForCm(name);
        if (cmInd == null) {
            return false;
        }
        int rows = cmInd._absRows + cmInd._diffRows + cmInd._rateRows;
        return rows > 0;
    }

    public CmIndicator getIndicatorForCm(String name) {
        CmIndicator cmInd = this._currentIndicatorMap.get(name);
        return cmInd;
    }

    public boolean hasSessionCountersForCm(String name) {
        SessionIndicator ind = this.getSessionIndicatorForCm(name);
        if (ind == null) {
            return false;
        }
        int rows = ind._absSamples + ind._diffSamples + ind._rateSamples;
        return rows > 0;
    }

    public SessionIndicator getSessionIndicatorForCm(String name) {
        SessionIndicator ind = this._sessionIndicatorMap.get(name);
        return ind;
    }

    public SessionIndicator[] getSessionIndicators() {
        SessionIndicator[] si = new SessionIndicator[this._sessionIndicatorMap.size()];
        int i = 0;
        for (Map.Entry<String, SessionIndicator> entry : this._sessionIndicatorMap.entrySet()) {
            SessionIndicator val = entry.getValue();
            si[i++] = val;
        }
        return si;
    }

    public void addChangeListener(ChangeListener l) {
        this._listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._listenerList.remove(ChangeListener.class, l);
    }

    protected void fireNewSessionsIsAvalilable() {
        Object[] aobj = this._listenerList.getListenerList();
        for (int i = aobj.length - 2; i >= 0; i -= 2) {
            if (aobj[i] != ChangeListener.class) continue;
            ChangeEvent changeEvent = new ChangeEvent(this);
            ((ChangeListener)aobj[i + 1]).stateChanged(changeEvent);
        }
    }

    public void doXXX() {
        this.doXXX(this._asynchExec);
    }

    public void doXXX(boolean asynchExec) {
        if (asynchExec) {
            return;
        }
    }

    private void addCommand(QueueCommand qcmd) {
        int qsize = this._cmdQueue.size();
        if (qsize > this._warnQueueSizeThresh) {
            _logger.warn((Object)("The Command queue has " + qsize + " entries. The CommandExecutor might not keep in pace."));
        }
        this._cmdQueue.add(qcmd);
    }

    public void shutdown() {
        this._running = false;
        if (this._readThread != null) {
            this._readThread.interrupt();
        }
        this._readThread = null;
    }

    public void start() {
        if (this._readThread != null) {
            _logger.info((Object)("The thread '" + this._readThread.getName() + "' is already running. Skipping the start."));
            return;
        }
        this._readThread = new Thread(this);
        this._readThread.setName("OfflineSessionReader");
        this._readThread.setDaemon(true);
        this._readThread.start();
    }

    public boolean isRunning() {
        return this._running;
    }

    @Override
    public void run() {
        String threadName = this._readThread.getName();
        _logger.info((Object)("Starting a thread for the module '" + threadName + "'."));
        this._running = true;
        Configuration conf = Configuration.getCombinedConfiguration();
        boolean checkforNewSamples = conf.getBooleanProperty("pcs.read.checkForNewSessions", false);
        while (this._running) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Thread '" + threadName + "', waiting on queue..."));
            }
            try {
                QueueCommand qo = this._cmdQueue.poll(2000L, TimeUnit.MILLISECONDS);
                if (qo == null) {
                    if (!checkforNewSamples || !this.isConnected() || !this._running) continue;
                    this._numOfSamplesNow = this.getNumberOfSamplesInLastSession(false);
                    if (this._numOfSamplesNow <= this._numOfSamplesOnLastRefresh) continue;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("New samples is available: '" + (this._numOfSamplesNow - this._numOfSamplesOnLastRefresh) + "'. _numOfSamplesNow='" + this._numOfSamplesNow + "', _numOfSamplesOnLastRefresh='" + this._numOfSamplesOnLastRefresh + "'."));
                    }
                    this.setWatermark(this._numOfSamplesNow - this._numOfSamplesOnLastRefresh + " New samples is available.");
                    continue;
                }
                long xStartTime = System.currentTimeMillis();
                String cmdStr = qo._cmd + "(ts1=" + qo._ts1 + ", ts2=" + qo._ts2 + ", ts3=" + qo._ts3 + ")";
                if (CMD_loadTimelineSlider.equals(qo._cmd)) {
                    this.execLoadTimelineSlider(qo._ts1, qo._ts2, qo._ts3);
                } else if (CMD_loadSessionGraphs.equals(qo._cmd)) {
                    this.execLoadSessionGraphs(qo._ts1, qo._ts2, qo._ts3, qo._int1);
                } else if (CMD_loadSessionCms.equals(qo._cmd)) {
                    this.execLoadSessionCms(qo._ts1);
                } else if (CMD_loadSessionCmIndicators.equals(qo._cmd)) {
                    this.execLoadSessionCmIndicators(qo._ts1);
                } else if (CMD_loadSummaryCm.equals(qo._cmd)) {
                    this.execLoadSummaryCm(qo._ts1);
                } else if (CMD_loadSessions.equals(qo._cmd)) {
                    this.execLoadSessions();
                } else {
                    _logger.error((Object)("Unknown command '" + qo._cmd + "' was taken from the queue."));
                }
                long xStopTime = System.currentTimeMillis();
                long consumeTimeMs = xStopTime - xStartTime;
                _logger.debug((Object)("It took " + TimeUtils.msToTimeStr(consumeTimeMs) + " to execute: " + cmdStr));
            }
            catch (InterruptedException ex) {
                this._running = false;
            }
            catch (Throwable t) {
                _logger.error((Object)("The thread '" + threadName + "' ran into unexpected problems, but continues, Caught: " + t), t);
            }
        }
        _logger.info((Object)("Emptying the queue for module '" + threadName + "', which had " + this._cmdQueue.size() + " entries."));
        this._cmdQueue.clear();
        _logger.info((Object)("Thread '" + threadName + "' was stopped."));
    }

    public void setExecMode(int execMode) {
        if (execMode != 0 && execMode != 1) {
            throw new IllegalArgumentException("Setting exec mode to a unknow value of '" + execMode + "'.");
        }
        this._execMode = execMode;
    }

    public int getExecMode() {
        if (this._running && this._execMode == 0) {
            return 0;
        }
        return 1;
    }

    public void loadTimelineSlider(Timestamp sampleId, Timestamp startTime, Timestamp endTime) {
        if (this.getExecMode() == 1) {
            this.execLoadTimelineSlider(sampleId, startTime, endTime);
            return;
        }
        this.addCommand(new QueueCommand(CMD_loadTimelineSlider, sampleId, startTime, endTime));
    }

    public void loadSessionGraphs(Timestamp sampleId, Timestamp startTime, Timestamp endTime, int expectedRows) {
        if (this.getExecMode() == 1) {
            this.execLoadSessionGraphs(sampleId, startTime, endTime, expectedRows);
            return;
        }
        this.addCommand(new QueueCommand(CMD_loadSessionGraphs, sampleId, startTime, endTime, expectedRows));
    }

    public void loadSessionCms(Timestamp sampleId) {
        if (this.getExecMode() == 1) {
            this.execLoadSessionCms(sampleId);
            return;
        }
        this.addCommand(new QueueCommand(CMD_loadSessionCms, sampleId));
    }

    public void loadSessionCmIndicators(Timestamp sampleId) {
        this.execLoadSessionCmIndicators(sampleId);
    }

    public void loadSummaryCm(Timestamp sampleId) {
        if (this.getExecMode() == 1) {
            this.execLoadSummaryCm(sampleId);
            return;
        }
        this.addCommand(new QueueCommand(CMD_loadSummaryCm, sampleId));
    }

    public void loadSessions() {
        if (this.getExecMode() == 1) {
            this.execLoadSessions();
            return;
        }
        this.addCommand(new QueueCommand(CMD_loadSessions));
    }

    public Timestamp getPrevSample(Timestamp sampleId, Timestamp currentSampleTime, String cmName) {
        String sql = "select top 1 \"SessionSampleTime\" \nfrom \"MonSessionSampleDetailes\" \nwhere 1=1 \n  and \"SessionSampleTime\" < '" + currentSampleTime + "' \n" + "  and \"CmName\"            = '" + cmName + "' \n" + "  and (\"absRows\" > 0 or \"diffRows\" > 0 or \"rateRows\" > 0) \n" + "order by \"SessionSampleTime\" desc";
        try {
            Statement stmnt = this._conn.createStatement();
            ResultSet rs = stmnt.executeQuery(sql);
            Timestamp ts = null;
            if (rs.next()) {
                ts = rs.getTimestamp(1);
            }
            rs.close();
            stmnt.close();
            return ts;
        }
        catch (SQLException e) {
            _logger.error((Object)("Problems getting previous sample for '" + cmName + "'."), (Throwable)e);
            return null;
        }
    }

    public Timestamp getNextSample(Timestamp sampleId, Timestamp currentSampleTime, String cmName) {
        String sql = "select top 1 \"SessionSampleTime\" \nfrom \"MonSessionSampleDetailes\" \nwhere 1=1 \n  and \"SessionSampleTime\" > '" + currentSampleTime + "' \n" + "  and \"CmName\"            = '" + cmName + "' \n" + "  and (\"absRows\" > 0 or \"diffRows\" > 0 or \"rateRows\" > 0) \n" + "order by \"SessionSampleTime\" asc";
        try {
            Statement stmnt = this._conn.createStatement();
            ResultSet rs = stmnt.executeQuery(sql);
            Timestamp ts = null;
            if (rs.next()) {
                ts = rs.getTimestamp(1);
            }
            rs.close();
            stmnt.close();
            return ts;
        }
        catch (SQLException e) {
            _logger.error((Object)("Problems getting next sample for '" + cmName + "'."), (Throwable)e);
            return null;
        }
    }

    public int getNumberOfSamplesInLastSession(boolean printErrors) {
        String sql = "select * \nfrom \"MonSessions\" \norder by \"LastSampleTime\" \n";
        try {
            Statement stmnt = this._conn.createStatement();
            ResultSet rs = stmnt.executeQuery(sql);
            Timestamp sessionStartTime = null;
            String serverName = null;
            int numOfSamples = -1;
            Timestamp lastSampleTime = null;
            while (rs.next()) {
                sessionStartTime = rs.getTimestamp(1);
                serverName = rs.getString(2);
                numOfSamples = rs.getInt(3);
                lastSampleTime = rs.getTimestamp(4);
            }
            rs.close();
            stmnt.close();
            return numOfSamples;
        }
        catch (SQLException e) {
            String msg = e.getMessage();
            if (msg != null && msg.toLowerCase().indexOf("timeout") >= 0) {
                _logger.info((Object)"Got 'timeout' when reading the MonSessions table, retrying this later.");
                _logger.debug((Object)("Got 'timeout' when reading the MonSessions table, retrying this later. Message: " + msg));
                return -1;
            }
            if (printErrors) {
                _logger.error((Object)"Problems getting number of samples from last session sample.", (Throwable)e);
            }
            return -1;
        }
    }

    private void addOfflineCm(String name, String type) {
        OfflineCm ocm = this._offlineCmMap.get(name);
        if (ocm == null) {
            ocm = new OfflineCm(name);
            this._offlineCmMap.put(ocm.name, ocm);
        }
        ocm.add(name, type);
    }

    private void getStoredCms(boolean refresh) {
        if (this._offlineCmMap != null && !refresh) {
            return;
        }
        this._offlineCmMap = new LinkedHashMap();
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = this._conn.getMetaData();
            rs = dbmd.getTables(null, null, "%", new String[]{"TABLE"});
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                int sepPos = tableName.indexOf("_");
                if (sepPos < 0) continue;
                String name = tableName.substring(0, sepPos);
                String type = tableName.substring(sepPos + 1);
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("getStoredCms()-rs-row- TYPE='" + tableType + "', NAME='" + tableName + "'. name='" + name + "', type='" + type + "'"));
                }
                this.addOfflineCm(name, type);
            }
            rs.close();
            this.sortOfflineCm();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("_offlineCmMap=" + this._offlineCmMap));
            }
        }
        catch (SQLException e) {
            _logger.error((Object)"Problems getting Offlined table names.", (Throwable)e);
        }
    }

    private void sortOfflineCm() {
        JTabbedPane tabPane = MainFrame.getTabbedPane();
        if (tabPane == null) {
            return;
        }
        LinkedHashMap<String, OfflineCm> originOfflineCmMap = new LinkedHashMap<String, OfflineCm>(this._offlineCmMap);
        LinkedHashMap<String, OfflineCm> sortedOfflineCmMap = new LinkedHashMap<String, OfflineCm>();
        LinkedList misses = new LinkedList();
        int tabCount = tabPane.getTabCount();
        for (int t = 0; t < tabCount; ++t) {
            Map<String, TrendGraph> graphs;
            TabularCntrPanel tcp;
            CountersModel cm;
            Component comp = tabPane.getComponentAt(t);
            String name = comp.getName();
            _logger.debug((Object)("sortOfflineCm() Working on tab " + t + ": " + name));
            OfflineCm ocm = originOfflineCmMap.get(name);
            if (ocm == null) continue;
            sortedOfflineCmMap.put(name, ocm);
            originOfflineCmMap.remove(name);
            if (ocm.graphList == null || ocm.graphList.size() <= 1 || !(comp instanceof TabularCntrPanel) || (cm = (tcp = (TabularCntrPanel)comp).getCm()) == null || (graphs = cm.getTrendGraphs()) == null || graphs.size() <= 1) continue;
            LinkedList<String> originGraphList = new LinkedList<String>(ocm.graphList);
            LinkedList<String> sortedGraphList = new LinkedList<String>();
            for (Map.Entry<String, TrendGraph> entry : graphs.entrySet()) {
                String key = entry.getKey();
                sortedGraphList.add(key);
                originGraphList.remove(key);
            }
            if (originGraphList.size() > 0) {
                _logger.warn((Object)("The sorting of 'ocm.graphList' for ocm '" + name + "' failed. Continuing with old/unsorted List"));
                _logger.debug((Object)("sortOfflineCm() originGraphList: " + originGraphList));
                _logger.debug((Object)("sortOfflineCm() sortedGraphList: " + sortedGraphList));
                _logger.debug((Object)("sortOfflineCm() ocm.graphList:   " + ocm.graphList));
                continue;
            }
            ocm.graphList = sortedGraphList;
        }
        if (misses.size() > 0) {
            Iterator it = misses.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                OfflineCm ocm = originOfflineCmMap.get(name);
                sortedOfflineCmMap.put(name, ocm);
                originOfflineCmMap.remove(name);
                it.remove();
            }
        }
        if (originOfflineCmMap.size() > 0) {
            _logger.warn((Object)"The sorting of '_offlineCmMap' failed. Continuing with old/unsorted Map");
            _logger.debug((Object)("sortOfflineCm() originOfflineCmMap: " + originOfflineCmMap));
            _logger.debug((Object)("sortOfflineCm() sortedOfflineCmMap: " + sortedOfflineCmMap));
            _logger.debug((Object)("sortOfflineCm() misses:             " + misses));
            _logger.debug((Object)("sortOfflineCm() _offlineCmMap:      " + this._offlineCmMap));
        } else {
            this._offlineCmMap = sortedOfflineCmMap;
        }
    }

    private int loadSessionGraph(String cmName, String graphName, Timestamp sampleId, Timestamp startTime, Timestamp endTime, int expectedRows) {
        CountersModel cm = GetCounters.getCmByName(cmName);
        if (cm == null) {
            _logger.warn((Object)("Can't find any CM named '" + cmName + "'."));
            return 0;
        }
        TrendGraph tg = cm.getTrendGraph(graphName);
        if (tg == null) {
            _logger.warn((Object)("Can't find any TrendGraph named '" + graphName + "', for the CM '" + cmName + "'."));
            return 0;
        }
        tg.clearGraph();
        String sql = "select * from \"" + cmName + "_" + graphName + "\" " + "where \"SessionStartTime\" = ? " + "  AND \"SessionSampleTime\" >= ? " + "  AND \"SessionSampleTime\" <= ? " + "order by \"SessionSampleTime\"";
        int loadEveryXRow = expectedRows / 1000 + 1;
        try {
            int d;
            long fetchStartTime = System.currentTimeMillis();
            this.setStatusText("Loading graph '" + graphName + "' for '" + cmName + "'.");
            PreparedStatement pstmnt = this._conn.prepareStatement(sql);
            pstmnt.setString(1, sampleId.toString());
            pstmnt.setString(2, startTime.toString());
            pstmnt.setString(3, endTime.toString());
            _logger.debug((Object)("loadSessionGraph(cmName='" + cmName + "', graphName='" + graphName + "') loadEveryXRow=" + loadEveryXRow + ": " + pstmnt));
            ResultSet rs = pstmnt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            String[] labels = new String[(cols - 3) / 2];
            Double[] datapt = new Double[(cols - 3) / 2];
            boolean firstRow = true;
            int row = 0;
            Timestamp sessionSampleTime = null;
            while (rs.next()) {
                sessionSampleTime = rs.getTimestamp(2);
                int c = 4;
                int ca = 0;
                while (c <= cols) {
                    labels[ca] = rs.getString(c);
                    datapt[ca] = new Double(rs.getDouble(c + 1));
                    c += 2;
                    ++ca;
                }
                if (firstRow) {
                    firstRow = false;
                    Double[] firstDatapt = new Double[datapt.length];
                    for (d = 0; d < firstDatapt.length; ++d) {
                        firstDatapt[d] = new Double(0.0);
                    }
                    tg.addPoint((Date)new Timestamp(sessionSampleTime.getTime() - 10L), firstDatapt, labels, startTime, endTime);
                }
                if (row % loadEveryXRow == 0) {
                    tg.addPoint((Date)sessionSampleTime, datapt, labels, startTime, endTime);
                }
                ++row;
            }
            rs.close();
            pstmnt.close();
            if (sessionSampleTime != null) {
                Double[] lastDatapt = new Double[datapt.length];
                for (d = 0; d < lastDatapt.length; ++d) {
                    lastDatapt[d] = new Double(0.0);
                }
                tg.addPoint((Date)new Timestamp(sessionSampleTime.getTime() + 10L), lastDatapt, labels, startTime, endTime);
            }
            _logger.debug((Object)("Loaded " + row + " rows into TrendGraph named '" + graphName + "', for the CM '" + cmName + "', which took '" + TimeUtils.msToTimeStr(System.currentTimeMillis() - fetchStartTime) + "'."));
            this.setStatusText("");
            return loadEveryXRow;
        }
        catch (SQLException e) {
            _logger.error((Object)("Problems loading graph for cm='" + cmName + "', graph='" + graphName + "'."), (Throwable)e);
            return 0;
        }
    }

    private void execLoadSessionGraphs(Timestamp sampleId, Timestamp startTime, Timestamp endTime, int expectedRows) {
        this.setWatermark("Loading graphs...");
        long xStartTime = System.currentTimeMillis();
        this.getStoredCms(false);
        int loadEveryXRow = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        String graphWatermark = sdf.format(startTime) + " - " + sdf.format(endTime);
        MainFrame.setOfflineSamplePeriodText(graphWatermark);
        for (Map.Entry<String, OfflineCm> entry : this._offlineCmMap.entrySet()) {
            String cmName = entry.getKey();
            OfflineCm ocm = entry.getValue();
            if (ocm == null || ocm.graphList == null) continue;
            for (String graphName : ocm.graphList) {
                loadEveryXRow = this.loadSessionGraph(cmName, graphName, sampleId, startTime, endTime, expectedRows);
            }
        }
        String str = "Loading all TrendGraphs took '" + TimeUtils.msToTimeStr("%SS.%ms", System.currentTimeMillis() - xStartTime) + "' seconds.";
        if (loadEveryXRow > 1) {
            str = str + " Loaded every " + (loadEveryXRow - 1) + " row, graphs was to big.";
        }
        this.setStatusText(str);
        this.setWatermark();
    }

    private void execLoadTimelineSlider(Timestamp sampleId, Timestamp startTime, Timestamp endTime) {
        long xStartTime = System.currentTimeMillis();
        this.setWatermark("Refreshing Timeline slider...");
        MainFrame mf = MainFrame.getInstance();
        if (mf == null) {
            return;
        }
        mf.resetOfflineSlider();
        String sql = "select \"SessionSampleTime\" from " + PersistWriterBase.getTableName(3, null, true) + " " + "where \"SessionStartTime\" = ? " + "  AND \"SessionSampleTime\" >= ? " + "  AND \"SessionSampleTime\" <= ? " + "order by \"SessionSampleTime\"";
        try {
            PreparedStatement pstmnt = this._conn.prepareStatement(sql);
            pstmnt.setString(1, sampleId.toString());
            pstmnt.setString(2, startTime.toString());
            pstmnt.setString(3, endTime.toString());
            ResultSet rs = pstmnt.executeQuery();
            ArrayList<Timestamp> tsList = new ArrayList<Timestamp>();
            while (rs.next()) {
                Timestamp sessionSampleTime = rs.getTimestamp(1);
                tsList.add(sessionSampleTime);
            }
            rs.close();
            pstmnt.close();
            mf.addOfflineSliderEntryList(tsList);
        }
        catch (SQLException e) {
            _logger.error((Object)"Problems loading Timeline slider.", (Throwable)e);
        }
        this.setWatermark();
    }

    private void execLoadSessionCms(Timestamp sampleId) {
        this.setWatermark("Loading Counters...");
        long fetchStartTime = System.currentTimeMillis();
        this.setStatusText("Loading all counters for time '" + sampleId + "'.");
        this.getStoredCms(false);
        for (Map.Entry<String, OfflineCm> entry : this._offlineCmMap.entrySet()) {
            OfflineCm ocm = entry.getValue();
            this.loadSessionCm(ocm, sampleId);
        }
        String str = "Loading took '" + TimeUtils.msToTimeStr(System.currentTimeMillis() - fetchStartTime) + "'.";
        _logger.debug((Object)str);
        this.setStatusText(str);
        this.setWatermark();
    }

    private void loadSessionCm(OfflineCm ocm, Timestamp sampleTs) {
        if (ocm == null || sampleTs == null) {
            throw new IllegalArgumentException("OfflineCm or sampleTs cant be null");
        }
        String cmName = ocm.name;
        CountersModel cm = GetCounters.getCmByName(cmName);
        if (cm == null) {
            _logger.warn((Object)("Cant find any CM named '" + cmName + "'."));
            return;
        }
        cm.clearForRead();
        if (ocm.hasAbs) {
            this.loadSessionCm(cm, 1, sampleTs);
        }
        if (ocm.hasDiff) {
            this.loadSessionCm(cm, 2, sampleTs);
        }
        if (ocm.hasRate) {
            this.loadSessionCm(cm, 3, sampleTs);
        }
        cm.setDataInitialized(true);
        cm.fireTableStructureChanged();
        if (cm.getTabPanel() != null) {
            cm.getTabPanel().adjustTableColumnWidth();
        }
    }

    private void loadSessionCm(CountersModel cm, int type, Timestamp sampleTs) {
        if (cm == null) {
            throw new IllegalArgumentException("CountersModel can't be null");
        }
        if (sampleTs == null) {
            throw new IllegalArgumentException("sampleTs can't be null");
        }
        String cmName = cm.getName();
        String typeStr = null;
        if (type == 1) {
            typeStr = "abs";
        } else if (type == 2) {
            typeStr = "diff";
        } else if (type == 3) {
            typeStr = "rate";
        } else {
            throw new IllegalArgumentException("Unknown type of " + type + ".");
        }
        long fetchStartTime = System.currentTimeMillis();
        this.setStatusText("Loading '" + typeStr + "' counters for '" + cmName + "'.");
        String sql = "select * from \"" + cmName + "_" + typeStr + "\" " + "where \"SessionSampleTime\" = ? ";
        String sql2 = "select * from \"" + cmName + "_" + typeStr + "\" " + "where \"SessionSampleTime\" = '" + sampleTs + "' ";
        try {
            Statement pstmnt = this._conn.createStatement();
            _logger.debug((Object)("loadSessionCm(cmName='" + cmName + "', type='" + typeStr + "', sampleTs='" + sampleTs + "'): " + pstmnt));
            ResultSet rs = pstmnt.executeQuery(sql2);
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            int row = 0;
            int[] colSqlDataType = new int[cols];
            ArrayList<String> colHead = new ArrayList<String>(cols);
            for (int c = 5; c <= cols; ++c) {
                colHead.add(rsmd.getColumnLabel(c));
                colSqlDataType[c - 1] = rsmd.getColumnType(c);
            }
            cm.setColumnNames(type, colHead);
            while (rs.next()) {
                Timestamp sessionStartTime = rs.getTimestamp(1);
                Timestamp sessionSampleTime = rs.getTimestamp(2);
                Timestamp sampleTime = rs.getTimestamp(3);
                int sampleMs = rs.getInt(4);
                cm.setSampleTimeHead(sessionSampleTime);
                cm.setSampleTime(sampleTime);
                cm.setSampleInterval(sampleMs);
                int c = 5;
                int col = 0;
                while (c <= cols) {
                    Object colVal = rs.getObject(c);
                    if (colSqlDataType[c - 1] == 2005) {
                        colVal = rs.getString(c);
                    }
                    cm.setValueAt(type, colVal, row, col);
                    ++c;
                    ++col;
                }
                ++row;
            }
            rs.close();
            pstmnt.close();
            if (row == 0) {
                // empty if block
            }
            _logger.debug((Object)("Loaded " + row + " rows into for the CM '" + cmName + "', type='" + typeStr + "', which took '" + TimeUtils.msToTimeStr(System.currentTimeMillis() - fetchStartTime) + "' for sampleTs '" + sampleTs + "'."));
            this.setStatusText("");
        }
        catch (SQLException e) {
            _logger.error((Object)("Problems loading cm='" + cmName + "', type='" + typeStr + "'."), (Throwable)e);
        }
    }

    private void execLoadSummaryCm(Timestamp sampleTs) {
        if (sampleTs == null) {
            throw new IllegalArgumentException("sampleTs can't be null");
        }
        String cmName = "CMsummary";
        CountersModel cm = GetCounters.getCmByName(cmName);
        if (cm == null) {
            _logger.warn((Object)("Cant find any CM named '" + cmName + "'."));
            return;
        }
        this.loadSessionCm(cm, 1, sampleTs);
        this.loadSessionCm(cm, 2, sampleTs);
        this.loadSessionCm(cm, 3, sampleTs);
        cm.setDataInitialized(true);
        cm.fireTableStructureChanged();
        if (cm.getTabPanel() != null) {
            cm.getTabPanel().adjustTableColumnWidth();
        }
        MainFrame.getInstance().setTimeLinePoint(sampleTs);
    }

    private void execLoadSessionCmIndicators(Timestamp sampleTs) {
        this.setWatermark("Loading Counter Indicators...");
        long fetchStartTime = System.currentTimeMillis();
        this.setStatusText("Loading all counter indicators for time '" + sampleTs + "'.");
        this._currentIndicatorMap.clear();
        String sql = "select * from " + PersistWriterBase.getTableName(5, null, true) + " " + "where \"SessionSampleTime\" = ? ";
        try {
            boolean hasSqlGuiRefreshTime;
            PreparedStatement pstmnt = this._conn.prepareStatement(sql);
            pstmnt.setString(1, sampleTs.toString());
            _logger.debug((Object)("loadSessionCmIndicators(sampleTs='" + sampleTs + "'): " + pstmnt));
            ResultSet rs = pstmnt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            int row = 0;
            boolean bl = hasSqlGuiRefreshTime = cols >= 9;
            while (rs.next()) {
                Timestamp sessionStartTime = rs.getTimestamp(1);
                Timestamp sessionSampleTime = rs.getTimestamp(2);
                String cmName = rs.getString(3);
                int type = rs.getInt(4);
                int graphCount = rs.getInt(5);
                int absRows = rs.getInt(6);
                int diffRows = rs.getInt(7);
                int rateRows = rs.getInt(8);
                int sqlRefreshTime = hasSqlGuiRefreshTime ? rs.getInt(9) : -1;
                int guiRefreshTime = hasSqlGuiRefreshTime ? rs.getInt(10) : -1;
                int lcRefreshTime = hasSqlGuiRefreshTime ? rs.getInt(11) : -1;
                CmIndicator cmInd = new CmIndicator(sessionStartTime, sessionSampleTime, cmName, type, graphCount, absRows, diffRows, rateRows, sqlRefreshTime, guiRefreshTime, lcRefreshTime);
                this._currentIndicatorMap.put(cmName, cmInd);
                ++row;
            }
            rs.close();
            pstmnt.close();
            _logger.debug((Object)("Loaded " + row + " indicators for ts '" + sampleTs + "' , which took '" + TimeUtils.msToTimeStr(System.currentTimeMillis() - fetchStartTime) + "'."));
            this.setStatusText("");
        }
        catch (SQLException e) {
            _logger.error((Object)("Problems loading cm indicators for ts '" + sampleTs + "'."), (Throwable)e);
        }
        String str = "Loading indicators took '" + TimeUtils.msToTimeStr(System.currentTimeMillis() - fetchStartTime) + "'.";
        _logger.debug((Object)str);
        this.setStatusText(str);
        this.setWatermark();
    }

    public void setCurrentSampleTime(Timestamp ts) {
        this.loadSessionCmIndicators(ts);
    }

    public CountersModel getCmForSample(String name, Timestamp sampleTs) {
        CmIndicator cmInd = this.getIndicatorForCm(name);
        if (cmInd == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("No CmIndicator was found in 'map' for cm named '" + name + "' with ts '" + sampleTs + "'."));
                for (Map.Entry<String, CmIndicator> entry : this._currentIndicatorMap.entrySet()) {
                    String key = entry.getKey();
                    CmIndicator val = entry.getValue();
                    _logger.debug((Object)("IndicatorMap: key=" + StringUtil.left(key, 20) + ": CmIndicator=" + val));
                }
            }
            return null;
        }
        return this.loadSessionCm(cmInd, sampleTs);
    }

    public CountersModel loadSessionCm(CmIndicator cmInd, Timestamp sampleTs) {
        if (cmInd == null) {
            throw new IllegalArgumentException("CmIndicator can't be null");
        }
        if (sampleTs == null) {
            throw new IllegalArgumentException("sampleTs can't be null");
        }
        String cmName = cmInd._cmName;
        CountersModel cm = GetCounters.getCmByName(cmName);
        if (cm == null) {
            _logger.warn((Object)("Cant find any CM named '" + cmName + "'."));
            return null;
        }
        cm = cm.copyForOfflineRead();
        if (cmInd._absRows > 0) {
            this.loadSessionCm(cm, 1, sampleTs);
        }
        if (cmInd._diffRows > 0) {
            this.loadSessionCm(cm, 2, sampleTs);
        }
        if (cmInd._rateRows > 0) {
            this.loadSessionCm(cm, 3, sampleTs);
        }
        cm.setSqlRefreshTime(cmInd._sqlRefreshTime);
        cm.setGuiRefreshTime(cmInd._guiRefreshTime);
        cm.setLcRefreshTime(cmInd._lcRefreshTime);
        cm.setDataInitialized(true);
        return cm;
    }

    private void execLoadSessions() {
        this.setWatermark("Loading Sessions...");
        long fetchStartTime = System.currentTimeMillis();
        this.setStatusText("Loading Sessions....");
        List<SessionInfo> sessionList = this.getSessionList();
        for (SessionInfo sessionInfo : sessionList) {
            sessionInfo._sampleList = this.getSessionSamplesList(sessionInfo._sessionId);
            sessionInfo._sampleCmNameSumMap = this.getSessionSampleCmNameSumMap(sessionInfo._sessionId);
        }
        this._numOfSamplesOnLastRefresh = this.getNumberOfSamplesInLastSession(true);
        _logger.debug((Object)"loadSessions(COMPLETED) calling listeners");
        for (INotificationListener nl : this._notificationListeners) {
            nl.setSessionList(sessionList);
        }
        String str = "Loading Sessions took '" + TimeUtils.msToTimeStr(System.currentTimeMillis() - fetchStartTime) + "'.";
        _logger.debug((Object)str);
        this.setStatusText(str);
        this.setWatermark();
    }

    public List<SessionInfo> getSessionList() {
        this.setWatermark("Loading Sessions...");
        long fetchStartTime = System.currentTimeMillis();
        this.setStatusText("Loading Session List....");
        LinkedList<SessionInfo> sessions = new LinkedList<SessionInfo>();
        try {
            Statement stmnt = this._conn.createStatement();
            ResultSet rs = stmnt.executeQuery(GET_ALL_SESSIONS);
            while (rs.next()) {
                Timestamp sessionId = rs.getTimestamp("SessionStartTime");
                Timestamp lastSampleTime = rs.getTimestamp("LastSampleTime");
                int numOfSamples = rs.getInt("NumOfSamples");
                sessions.add(new SessionInfo(sessionId, lastSampleTime, numOfSamples));
            }
            rs.close();
            stmnt.close();
        }
        catch (SQLException e) {
            _logger.error((Object)"Problems inititialize...", (Throwable)e);
        }
        String str = "Loading Session List took '" + TimeUtils.msToTimeStr(System.currentTimeMillis() - fetchStartTime) + "'.";
        _logger.debug((Object)str);
        this.setStatusText(str);
        return sessions;
    }

    public List<Timestamp> getSessionSamplesList(Timestamp sessionId) {
        this.setWatermark("Loading Sessions...");
        long fetchStartTime = System.currentTimeMillis();
        this.setStatusText("Loading Session Samples for sessionId '" + sessionId + "'.");
        LinkedList<Timestamp> list = new LinkedList<Timestamp>();
        try {
            PreparedStatement pstmnt = this._conn.prepareStatement(GET_SESSION);
            pstmnt.setString(1, sessionId.toString());
            ResultSet rs = pstmnt.executeQuery();
            while (rs.next()) {
                list.add(rs.getTimestamp("SessionSampleTime"));
            }
            rs.close();
            pstmnt.close();
        }
        catch (SQLException e) {
            _logger.error((Object)"Problems inititialize...", (Throwable)e);
        }
        String str = "Loading Session Samples for sessionId '" + sessionId + "' took '" + TimeUtils.msToTimeStr(System.currentTimeMillis() - fetchStartTime) + "'.";
        _logger.debug((Object)str);
        this.setStatusText(str);
        return list;
    }

    public Map<String, CmNameSum> getSessionSampleCmNameSumMap(Timestamp sessionStartTime) {
        this.setWatermark("Loading Sessions...");
        long fetchStartTime = System.currentTimeMillis();
        this.setStatusText("Loading Session Samples CM Summy for sessionId '" + sessionStartTime + "'.");
        LinkedHashMap<String, CmNameSum> map = new LinkedHashMap<String, CmNameSum>();
        String sql = "select * from " + PersistWriterBase.getTableName(4, null, true) + " " + "where \"SessionStartTime\" = ? ";
        try {
            PreparedStatement pstmnt = this._conn.prepareStatement(sql);
            pstmnt.setString(1, sessionStartTime.toString());
            ResultSet rs = pstmnt.executeQuery();
            while (rs.next()) {
                Timestamp ssTime = rs.getTimestamp(1);
                String cmName = rs.getString(2);
                int absSamples = rs.getInt(3);
                int diffSamples = rs.getInt(4);
                int rateSamples = rs.getInt(5);
                map.put(cmName, new CmNameSum(ssTime, cmName, absSamples, diffSamples, rateSamples));
            }
            rs.close();
            pstmnt.close();
        }
        catch (SQLException e) {
            _logger.error((Object)("Problems loading 'session sample cm summary' for ts '" + sessionStartTime + "'. sql=" + sql), (Throwable)e);
        }
        String str = "Loading Session Samples for sessionStartTime '" + sessionStartTime + "' took '" + TimeUtils.msToTimeStr(System.currentTimeMillis() - fetchStartTime) + "'.";
        _logger.debug((Object)str);
        this.setStatusText(str);
        return map;
    }

    public Map<Timestamp, SampleCmCounterInfo> getSessionSampleCmCounterInfoMap(Timestamp inSessionStartTime) {
        this.setWatermark("Loading Sessions...");
        long fetchStartTime = System.currentTimeMillis();
        this.setStatusText("Loading 'Session Samples CM Counter Info' for sessionId '" + inSessionStartTime + "'.");
        LinkedHashMap<Timestamp, SampleCmCounterInfo> map = new LinkedHashMap<Timestamp, SampleCmCounterInfo>();
        String sql = "select * from " + PersistWriterBase.getTableName(5, null, true) + " " + "where \"SessionStartTime\" = ? " + "order by \"SessionSampleTime\" ";
        SampleCmCounterInfo scmci = null;
        try {
            boolean hasSqlGuiRefreshTime;
            PreparedStatement pstmnt = this._conn.prepareStatement(sql);
            pstmnt.setString(1, inSessionStartTime.toString());
            long lastSampleTime = 0L;
            ResultSet rs = pstmnt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            boolean bl = hasSqlGuiRefreshTime = cols >= 9;
            while (rs.next()) {
                CmCounterInfo cmci = new CmCounterInfo();
                cmci._sessionStartTime = rs.getTimestamp(1);
                cmci._sessionSampleTime = rs.getTimestamp(2);
                cmci._cmName = rs.getString(3);
                cmci._type = rs.getInt(4);
                cmci._graphCount = rs.getInt(5);
                cmci._absRows = rs.getInt(6);
                cmci._diffRows = rs.getInt(7);
                cmci._rateRows = rs.getInt(8);
                cmci._sqlRefreshTime = hasSqlGuiRefreshTime ? rs.getInt(9) : -1;
                cmci._guiRefreshTime = hasSqlGuiRefreshTime ? rs.getInt(10) : -1;
                int n = cmci._lcRefreshTime = hasSqlGuiRefreshTime ? rs.getInt(11) : -1;
                if (lastSampleTime != cmci._sessionSampleTime.getTime()) {
                    lastSampleTime = cmci._sessionSampleTime.getTime();
                    scmci = new SampleCmCounterInfo(cmci._sessionStartTime, cmci._sessionSampleTime);
                    map.put(scmci._sessionSampleTime, scmci);
                }
                scmci._ciMap.put(cmci._cmName, cmci);
            }
            rs.close();
            pstmnt.close();
        }
        catch (SQLException e) {
            _logger.error((Object)("Problems loading 'session sample cm counter info' for ts '" + inSessionStartTime + "'. sql=" + sql), (Throwable)e);
        }
        String str = "Loading 'Session Samples CM Counter Info' for sessionId '" + inSessionStartTime + "' took '" + TimeUtils.msToTimeStr(System.currentTimeMillis() - fetchStartTime) + "'.";
        System.out.println(str);
        _logger.debug((Object)str);
        this.setStatusText(str);
        return map;
    }

    public MonVersionInfo getMonVersionInfo(Timestamp sessionStartTime) {
        String sql = "select * from " + PersistWriterBase.getTableName(0, null, true) + " " + "where \"SessionStartTime\" = ? ";
        try {
            PreparedStatement pstmnt = this._conn.prepareStatement(sql);
            pstmnt.setString(1, sessionStartTime.toString());
            MonVersionInfo monVersionInfo = new MonVersionInfo();
            ResultSet rs = pstmnt.executeQuery();
            while (rs.next()) {
                monVersionInfo._sessionStartTime = rs.getTimestamp(1);
                monVersionInfo._productString = rs.getString(2);
                monVersionInfo._versionString = rs.getString(3);
                monVersionInfo._buildString = rs.getString(4);
                monVersionInfo._sourceDate = rs.getString(5);
                monVersionInfo._sourceRev = rs.getInt(6);
            }
            rs.close();
            pstmnt.close();
            return monVersionInfo;
        }
        catch (SQLException e) {
            _logger.error((Object)("Problems loading 'MonVersionInfo' for ts '" + sessionStartTime + "'. sql=" + sql), (Throwable)e);
            return null;
        }
    }

    public void addNotificationListener(INotificationListener comp) {
        this._notificationListeners.add(comp);
    }

    public void removeNotificationListener(INotificationListener comp) {
        this._notificationListeners.remove(comp);
    }

    private void setWatermark(String text) {
        _logger.debug((Object)("PersistentReader.setWatermark(text='" + text + "')"));
        for (INotificationListener nl : this._notificationListeners) {
            nl.setWatermark(text);
        }
    }

    private void setWatermark() {
        this.setWatermark(null);
    }

    private void setStatusText(String status) {
        _logger.debug((Object)("setStatusText(status='" + status + "')"));
        for (INotificationListener nl : this._notificationListeners) {
            nl.setStatusText(status);
        }
    }

    public static interface INotificationListener {
        public void setWatermark(String var1);

        public void setStatusText(String var1);

        public void setSessionList(List<SessionInfo> var1);
    }

    public static class CmIndicator {
        public Timestamp _sessionStartTime = null;
        public Timestamp _sessionSampleTime = null;
        public String _cmName = null;
        public int _type = -1;
        public int _graphCount = -1;
        public int _absRows = -1;
        public int _diffRows = -1;
        public int _rateRows = -1;
        public int _sqlRefreshTime = -1;
        public int _guiRefreshTime = -1;
        public int _lcRefreshTime = -1;

        public CmIndicator(Timestamp sessionStartTime, Timestamp sessionSampleTime, String cmName, int type, int graphCount, int absRows, int diffRows, int rateRows, int sqlRefreshTime, int guiRefreshTime, int lcRefreshTime) {
            this._sessionStartTime = sessionStartTime;
            this._sessionSampleTime = sessionSampleTime;
            this._cmName = cmName;
            this._type = type;
            this._graphCount = graphCount;
            this._absRows = absRows;
            this._diffRows = diffRows;
            this._rateRows = rateRows;
            this._sqlRefreshTime = sqlRefreshTime;
            this._guiRefreshTime = guiRefreshTime;
            this._lcRefreshTime = lcRefreshTime;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("sessionStartTime='").append(this._sessionStartTime).append("'");
            sb.append(", sessionSampleTime='").append(this._sessionSampleTime).append("'");
            sb.append(", cmName='").append(this._cmName).append("'");
            sb.append(", type=").append(this._type);
            sb.append(", graphCount=").append(this._graphCount);
            sb.append(", absRows=").append(this._absRows);
            sb.append(", diffRows=").append(this._diffRows);
            sb.append(", rateRows=").append(this._rateRows);
            sb.append(", sqlRefreshTime=").append(this._sqlRefreshTime);
            sb.append(", guiRefreshTime=").append(this._guiRefreshTime);
            sb.append(", lcRefreshTime=").append(this._lcRefreshTime);
            return sb.toString();
        }
    }

    public static class SessionIndicator {
        public Timestamp _sessionStartTime = null;
        public String _cmName = null;
        public int _absSamples = -1;
        public int _diffSamples = -1;
        public int _rateSamples = -1;

        public SessionIndicator(Timestamp sessionStartTime, String cmName, int absSamples, int diffSamples, int rateSamples) {
            this._sessionStartTime = sessionStartTime;
            this._cmName = cmName;
            this._absSamples = absSamples;
            this._diffSamples = diffSamples;
            this._rateSamples = rateSamples;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("sessionStartTime='").append(this._sessionStartTime).append("'");
            sb.append(", cmName='").append(this._cmName).append("'");
            sb.append(", absSamples=").append(this._absSamples);
            sb.append(", diffSamples=").append(this._diffSamples);
            sb.append(", rateSamples=").append(this._rateSamples);
            return sb.toString();
        }
    }

    public static class SessionInfo {
        public Timestamp _sessionId = null;
        public Timestamp _lastSampleTime = null;
        public int _numOfSamples = -1;
        public List<Timestamp> _sampleList = null;
        public Map<String, CmNameSum> _sampleCmNameSumMap = null;
        public Map<Timestamp, SampleCmCounterInfo> _sampleCmCounterInfoMap = null;

        public SessionInfo(Timestamp sessionId, Timestamp lastSampleTime, int numOfSamples) {
            this._sessionId = sessionId;
            this._lastSampleTime = lastSampleTime;
            this._numOfSamples = numOfSamples;
        }
    }

    public static class CmNameSum {
        public Timestamp _sessionStartTime = null;
        public String _cmName = null;
        public int _absSamples = 0;
        public int _diffSamples = 0;
        public int _rateSamples = 0;

        public CmNameSum(Timestamp sessionStartTime, String cmName, int absSamples, int diffSamples, int rateSamples) {
            this._sessionStartTime = sessionStartTime;
            this._cmName = cmName;
            this._absSamples = absSamples;
            this._diffSamples = diffSamples;
            this._rateSamples = rateSamples;
        }
    }

    public static class SampleCmCounterInfo {
        public Timestamp _sessionStartTime = null;
        public Timestamp _sessionSampleTime = null;
        public Map<String, CmCounterInfo> _ciMap = new LinkedHashMap<String, CmCounterInfo>();

        public SampleCmCounterInfo(Timestamp sessionStartTime, Timestamp sessionSampleTime) {
            this._sessionStartTime = sessionStartTime;
            this._sessionSampleTime = sessionSampleTime;
        }

        public void merge(SampleCmCounterInfo in) {
            if (in == null) {
                return;
            }
            for (Map.Entry<String, CmCounterInfo> entry : in._ciMap.entrySet()) {
                String cmName = entry.getKey();
                CmCounterInfo cmci = entry.getValue();
                if (!this._ciMap.containsKey(cmName)) {
                    this._ciMap.put(cmName, new CmCounterInfo(cmci));
                    continue;
                }
                CmCounterInfo localCmci = this._ciMap.get(cmName);
                localCmci._graphCount += cmci._graphCount;
                localCmci._absRows += cmci._absRows;
                localCmci._diffRows += cmci._diffRows;
                localCmci._rateRows += cmci._rateRows;
                localCmci._sqlRefreshTime += cmci._sqlRefreshTime;
                localCmci._guiRefreshTime += cmci._guiRefreshTime;
                localCmci._lcRefreshTime += cmci._lcRefreshTime;
            }
        }
    }

    public static class CmCounterInfo {
        public Timestamp _sessionStartTime = null;
        public Timestamp _sessionSampleTime = null;
        public String _cmName = null;
        public int _type = -1;
        public int _graphCount = -1;
        public int _absRows = -1;
        public int _diffRows = -1;
        public int _rateRows = -1;
        public int _sqlRefreshTime = -1;
        public int _guiRefreshTime = -1;
        public int _lcRefreshTime = -1;

        public CmCounterInfo() {
        }

        public CmCounterInfo(CmCounterInfo copyMe) {
            this._sessionStartTime = copyMe._sessionStartTime;
            this._sessionSampleTime = copyMe._sessionSampleTime;
            this._cmName = copyMe._cmName;
            this._type = copyMe._type;
            this._graphCount = copyMe._graphCount;
            this._absRows = copyMe._absRows;
            this._diffRows = copyMe._diffRows;
            this._rateRows = copyMe._rateRows;
            this._sqlRefreshTime = copyMe._sqlRefreshTime;
            this._guiRefreshTime = copyMe._guiRefreshTime;
            this._lcRefreshTime = copyMe._lcRefreshTime;
        }
    }

    public static class MonVersionInfo {
        public Timestamp _sessionStartTime = null;
        public String _productString = null;
        public String _versionString = null;
        public String _buildString = null;
        public String _sourceDate = null;
        public int _sourceRev = 0;
    }

    private class OfflineCm {
        public String name = "";
        public boolean hasAbs = false;
        public boolean hasDiff = false;
        public boolean hasRate = false;
        public LinkedList<String> graphList = null;

        public OfflineCm(String name) {
            this.name = name;
        }

        public void add(String name, String type) {
            if (type == null) {
                return;
            }
            if (type.equals("abs")) {
                this.hasAbs = true;
            } else if (type.equals("diff")) {
                this.hasDiff = true;
            } else if (type.equals("rate")) {
                this.hasRate = true;
            } else {
                if (this.graphList == null) {
                    this.graphList = new LinkedList();
                }
                this.graphList.add(type);
            }
        }

        public String toString() {
            return "OfflineCm(name='" + this.name + "', hasAbs=" + this.hasAbs + ", hasDiff=" + this.hasDiff + ", hasRate=" + this.hasRate + ", graphList=" + this.graphList + ")";
        }
    }

    private static class QueueCommand {
        private String _cmd = null;
        private Timestamp _ts1 = null;
        private Timestamp _ts2 = null;
        private Timestamp _ts3 = null;
        private int _int1 = -1;

        QueueCommand(String cmd, Timestamp ts1, Timestamp ts2, Timestamp ts3, int int1) {
            this._cmd = cmd;
            this._ts1 = ts1;
            this._ts2 = ts2;
            this._ts3 = ts3;
            this._int1 = int1;
        }

        QueueCommand(String cmd, Timestamp ts1, Timestamp ts2, Timestamp ts3) {
            this(cmd, ts1, ts2, ts3, -1);
        }

        QueueCommand(String cmd, Timestamp ts1) {
            this(cmd, ts1, null, null, -1);
        }

        QueueCommand(String cmd) {
            this(cmd, null, null, null, -1);
        }
    }
}

