/*
 * Decompiled with CFR 0.152.
 */
package asemon.pcs;

import asemon.pcs.PersistWriterJdbc;
import asemon.utils.Configuration;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.h2.tools.Server;

public class PersistWriterJdbcH2
extends PersistWriterJdbc {
    private static Logger _logger = Logger.getLogger(PersistWriterJdbcH2.class);
    private boolean _startH2NetworkServer = false;

    public PersistWriterJdbcH2() {
        this._name = "PersistWriterJdbcH2";
        this._jdbcDriver = "org.h2.Driver";
        this._jdbcUrl = "jdbc:h2:pcdb_yyy";
        this._jdbcUser = "sa";
        this._jdbcPasswd = "";
        this._startH2NetworkServer = false;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void init(Configuration props) throws Exception {
        String propPrefix = "PersistWriterJdbcH2.";
        String propname = null;
        propname = propPrefix + "name";
        this._name = props.getProperty(propname, this._name);
        _logger.info((Object)("Initializing the PersistentCounterHandler.WriterClass component named '" + this._name + "'."));
        this._jdbcDriver = props.getProperty(propPrefix + "jdbcDriver", "org.h2.Driver");
        this._jdbcUrl = props.getProperty(propPrefix + "jdbcUrl", "jdbc:h2:pcdb");
        this._jdbcUser = props.getProperty(propPrefix + "jdbcUser", "sa");
        this._jdbcPasswd = props.getProperty(propPrefix + "jdbcPasswd", "");
        if (this._jdbcPasswd.equalsIgnoreCase("null")) {
            this._jdbcPasswd = "";
        }
        this._startH2NetworkServer = props.getBooleanProperty(propPrefix + "startH2NetworkServer", this._startH2NetworkServer);
        String configStr = "jdbcDriver='" + this._jdbcDriver + "', jdbcUrl='" + this._jdbcUrl + "', jdbcUser='" + this._jdbcUser + "', jdbcPasswd='*hidden*'.";
        _logger.info((Object)("Configuration for PersistentCounterHandler.WriterClass component named '" + this._name + "': " + configStr));
        if (this._startH2NetworkServer) {
            _logger.info((Object)"Starting a H2 TCP server.");
            String[] args = new String[]{"-tcpAllowOthers"};
            Server h2ServerTcp = Server.createTcpServer((String[])args);
            h2ServerTcp.start();
            _logger.info((Object)("H2 TCP server, url='" + h2ServerTcp.getURL() + "', service='" + h2ServerTcp.getService() + "'."));
            _logger.info((Object)"Starting a H2 WEB server.");
            String[] argsWeb = new String[]{"-trace"};
            Server h2ServerWeb = Server.createWebServer((String[])argsWeb);
            h2ServerWeb.start();
            _logger.info((Object)("H2 WEB server, url='" + h2ServerWeb.getURL() + "', service='" + h2ServerWeb.getService() + "'."));
        }
    }

    public static void main(String[] args) {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "INFO, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        Configuration conf = new Configuration();
        conf.setProperty("PersistWriterJdbcH2.jdbcDriver", "org.h2.Driver");
        conf.setProperty("PersistWriterJdbcH2.jdbcUrl", "jdbc:h2:file:C:/projects/asemon/data/xxx");
        conf.setProperty("PersistWriterJdbcH2.jdbcUser", "sa");
        conf.setProperty("PersistWriterJdbcH2.jdbcPasswd", "");
        conf.setProperty("PersistWriterJdbcH2.startH2NetworkServer", true);
        try {
            PersistWriterJdbcH2 pcs = new PersistWriterJdbcH2();
            pcs.init(conf);
            Object waitForever = new Object();
            waitForever.wait();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

