/*
 * Decompiled with CFR 0.152.
 */
package asemon.pcs;

import asemon.cm.CountersModel;
import asemon.pcs.IPersistWriter;
import asemon.pcs.PersistContainer;
import asemon.utils.Configuration;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class PersistentCounterHandler
implements Runnable {
    private static Logger _logger = Logger.getLogger(PersistentCounterHandler.class);
    private static PersistentCounterHandler _instance = null;
    private boolean _initialized = false;
    private boolean _running = false;
    private Thread _thread = null;
    private Configuration _props;
    private List<IPersistWriter> _writerClasses = new LinkedList<IPersistWriter>();
    private int _warnQueueSizeThresh = 2;
    private BlockingQueue<PersistContainer> _containerQueue = new LinkedBlockingQueue<PersistContainer>();

    public PersistentCounterHandler() throws Exception {
    }

    public PersistentCounterHandler(Configuration props) throws Exception {
        this.init(props);
    }

    public synchronized void init(Configuration props) throws Exception {
        this._props = props;
        _logger.info((Object)"Initializing the Persistent Counter Handler functionality.");
        this._warnQueueSizeThresh = this._props.getIntProperty("PersistentCounterHandler.warnQueueSizeThresh", this._warnQueueSizeThresh);
        String writerClasses = this._props.getProperty("PersistentCounterHandler.WriterClass");
        if (writerClasses == null) {
            _logger.info((Object)"No counters will be persisted. The property 'PersistentCounterHandler.WriterClass' is not found in configuration for the PersistentCounterHandler module. It should contain one or several classes that implemets the IPersistWriter interface. If you have more than one writer, specify them as a comma separated list.");
        } else {
            String[] writerClassArray = writerClasses.split(",");
            for (int i = 0; i < writerClassArray.length; ++i) {
                IPersistWriter writerClass;
                writerClassArray[i] = writerClassArray[i].trim();
                String writerClassName = writerClassArray[i];
                _logger.debug((Object)("Instantiating and Initializing WriterClass='" + writerClassName + "'."));
                try {
                    Class<?> c = Class.forName(writerClassName);
                    writerClass = (IPersistWriter)c.newInstance();
                    this._writerClasses.add(writerClass);
                }
                catch (ClassCastException e) {
                    throw new ClassCastException("When trying to load writerWriter class '" + writerClassName + "'. The writerWriter do not seem to follow the interface 'asemon.pcs.IPersistWriter'");
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundException("Tried to load writerWriter class '" + writerClassName + "'.", e);
                }
                writerClass.init(this._props);
                writerClass.startServices();
            }
            if (this._writerClasses.size() == 0) {
                _logger.warn((Object)"No Persistent Counter Writers has been installed, NO counters will be saved.");
            }
        }
        this._initialized = true;
    }

    public static PersistentCounterHandler getInstance() {
        return _instance;
    }

    public static boolean hasInstance() {
        return _instance != null;
    }

    public static void setInstance(PersistentCounterHandler inst) {
        _instance = inst;
    }

    public void add(PersistContainer cont) {
        if (this._writerClasses.size() == 0) {
            return;
        }
        int qsize = this._containerQueue.size();
        if (qsize > this._warnQueueSizeThresh) {
            _logger.warn((Object)("The persistent queue has " + qsize + " entries. The persistent writer might not keep in pace."));
        }
        this._containerQueue.add(cont);
    }

    private void isInitialized() {
        if (!this._initialized) {
            throw new RuntimeException("The Persistent Counter Handler module has NOT yet been initialized.");
        }
    }

    private void consume(PersistContainer cont, long prevConsumeTimeMs) {
        Timestamp initialSessionStartTime = cont.getSessionStartTime();
        for (IPersistWriter pw : this._writerClasses) {
            cont.setSessionStartTime(initialSessionStartTime);
            long startTime = System.currentTimeMillis();
            try {
                Timestamp newTs;
                pw.beginOfSample(cont);
                pw.resetCounters();
                if (!pw.isSessionStarted() || cont.getStartNewSample()) {
                    newTs = cont.getMainSampleTime();
                    cont.setSessionStartTime(newTs);
                    pw.setSessionStartTime(newTs);
                    pw.startSession(cont);
                }
                newTs = pw.getSessionStartTime();
                cont.setSessionStartTime(newTs);
                for (CountersModel cm : cont._counterObjects) {
                    if (pw.isDdlCreated(cm) || !pw.saveDdl(cm)) continue;
                    pw.markDdlAsCreated(cm);
                }
                pw.saveSample(cont);
                for (CountersModel cm : cont._counterObjects) {
                    pw.saveCounters(cm);
                }
                pw.endOfSample(cont, false);
                long stopTime = System.currentTimeMillis();
                long execTime = stopTime - startTime;
                _logger.info((Object)("Persisting Counters using '" + pw.getName() + "' for sessionStartTime='" + cont.getSessionStartTime() + "', mainSampleTime='" + cont.getMainSampleTime() + "'. This persist took " + execTime + " ms. inserts=" + pw.getInserts() + ", updates=" + pw.getUpdates() + ", deletes=" + pw.getDeletes() + ", createTables=" + pw.getCreateTables() + ", alterTables=" + pw.getAlterTables() + ", dropTables=" + pw.getDropTables() + "."));
            }
            catch (Throwable t) {
                _logger.error((Object)("The Persistent Writer got runtime error in consume() in Persistent Writer named '" + pw.getName() + "'. Continuing with next Writer..."), t);
                pw.endOfSample(cont, true);
            }
        }
    }

    public void startSession(PersistContainer cont) {
        for (IPersistWriter pw : this._writerClasses) {
            try {
                _logger.info((Object)("Starting Counters Storage Session '" + pw.getName() + "' for sessionStartTime='" + cont.getSessionStartTime() + "', server='" + cont.getServerName() + "'."));
                pw.startSession(cont);
            }
            catch (Throwable t) {
                _logger.error((Object)("The Persistent Writer got runtime error when calling the method startSession() in Persistent Writer named '" + pw.getName() + "'. Continuing with next Writer..."), t);
            }
        }
    }

    @Override
    public void run() {
        String threadName = this._thread.getName();
        _logger.info((Object)("Starting a thread for the module '" + threadName + "'."));
        this.isInitialized();
        this._running = true;
        long prevConsumeTimeMs = 0L;
        while (this._running) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Thread '" + threadName + "', waiting on queue..."));
            }
            try {
                PersistContainer cont = this._containerQueue.take();
                if (cont == null || cont._counterObjects == null || cont._counterObjects.size() <= 0) continue;
                long startTime = System.currentTimeMillis();
                this.consume(cont, prevConsumeTimeMs);
                long stopTime = System.currentTimeMillis();
                prevConsumeTimeMs = stopTime - startTime;
                _logger.debug((Object)("It took " + prevConsumeTimeMs + " ms to persist the above information (using all writers)."));
            }
            catch (InterruptedException ex) {
                this._running = false;
            }
        }
        _logger.info((Object)("Emptying the queue for module '" + threadName + "', which had " + this._containerQueue.size() + " entries."));
        this._containerQueue.clear();
        _logger.info((Object)("Thread '" + threadName + "' was stopped."));
    }

    public boolean isRunning() {
        return this._running;
    }

    public void start() {
        if (this._writerClasses.size() == 0) {
            _logger.warn((Object)"No Persistent Counter Writers has been installed, The service thread will NOT be started and NO counters will be saved.");
            return;
        }
        this.isInitialized();
        this._thread = new Thread(this);
        this._thread.setName("PersistentCounterHandler");
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public void stop() {
        this._running = false;
        if (this._thread != null) {
            this._thread.interrupt();
            this._thread = null;
        }
        for (IPersistWriter pw : this._writerClasses) {
            pw.close();
            pw.stopServices();
        }
    }

    public boolean hasWriters() {
        return this._writerClasses.size() > 0;
    }
}

