/*
 * Decompiled with CFR 0.152.
 */
package asemon.test;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ExampleTableModel
extends AbstractTableModel {
    public static final int COLUMN_AMOUNT = 3;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_PRICE = 1;
    public static final int COLUMN_QUANTITY = 2;
    private List items = new ArrayList();

    ExampleTableModel() {
    }

    public void addItem(String name, double price, int quantity) {
        this.items.add(new Item(name, price, quantity));
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: 
            case 3: {
                return Double.class;
            }
            case 2: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Price";
            }
            case 2: {
                return "Quantity";
            }
            case 3: {
                return "Amount";
            }
        }
        return "# COLUMN " + columnIndex + " #";
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Item item = (Item)this.items.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return item.name;
            }
            case 1: {
                return new Double(item.price);
            }
            case 2: {
                return new Integer(item.quantity);
            }
            case 3: {
                return new Double(item.getAmount());
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Item item = (Item)this.items.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                item.name = aValue.toString();
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 1: {
                try {
                    item.price = Double.parseDouble(aValue.toString());
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
                this.fireTableCellUpdated(rowIndex, 3);
                break;
            }
            case 2: {
                try {
                    item.quantity = Integer.parseInt(aValue.toString());
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
                this.fireTableCellUpdated(rowIndex, 3);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static class Item {
        private String name;
        private double price;
        private int quantity;

        public Item(String name, double price, int quantity) {
            this.name = name;
            this.price = price;
            this.quantity = quantity;
        }

        public double getAmount() {
            return (double)this.quantity * this.price;
        }
    }
}

