/*
 * Decompiled with CFR 0.152.
 */
package asemon.test;

import javax.swing.JComponent;
import javax.swing.JTabbedPane;

class TabManager {
    JTabbedPane tabbedPane;
    String[] titles;
    JComponent[] components;

    public TabManager(JTabbedPane tabbedPane, String[] titles, JComponent[] components) {
        this.tabbedPane = tabbedPane;
        this.titles = titles;
        this.components = components;
        this.setTabs(titles);
    }

    public void setTabs(String[] titles) {
        this.removeTabs(titles);
        this.addTabs(titles);
    }

    private void addTabs(String[] titles) {
        String[] tabTitles = this.getTabTitles();
        for (int i = 0; i < titles.length; ++i) {
            String title = titles[i];
            if (this.contains(tabTitles, title)) continue;
            this.insert(title);
        }
    }

    private void insert(String title) {
        String[] tabTitles = this.getTabTitles();
        int index = this.getIndex(tabTitles, title);
        JComponent component = this.components[this.getIndex(title)];
        if (index == -1) {
            this.tabbedPane.addTab(title, component);
        } else {
            this.tabbedPane.insertTab(title, null, component, null, index);
        }
    }

    private int getIndex(String[] array, String insert) {
        int insertIndex = this.getIndex(insert);
        for (int i = 0; i < array.length; ++i) {
            int index = this.getIndex(array[i]);
            if (insertIndex >= index) continue;
            return i;
        }
        return -1;
    }

    private int getIndex(String str) {
        for (int i = 0; i < this.titles.length; ++i) {
            if (!this.titles[i].equals(str)) continue;
            return i;
        }
        return -1;
    }

    private void removeTabs(String[] titles) {
        String[] tabTitles = this.getTabTitles();
        for (int i = tabTitles.length - 1; i >= 0; --i) {
            String title = tabTitles[i];
            if (this.contains(titles, title)) continue;
            this.tabbedPane.removeTabAt(i);
        }
    }

    private boolean contains(String[] array, String element) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(element)) continue;
            return true;
        }
        return false;
    }

    private String[] getTabTitles() {
        int tabCount = this.tabbedPane.getTabCount();
        String[] titles = new String[tabCount];
        for (int i = 0; i < tabCount; ++i) {
            titles[i] = this.tabbedPane.getTitleAt(i);
        }
        return titles;
    }
}

