/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import asemon.gui.ConnectionProgressCallback;
import asemon.utils.AseUrlHelper;
import asemon.utils.Configuration;
import asemon.utils.PlatformUtils;
import asemon.utils.StringUtil;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AseConnectionFactory {
    private static Logger _logger = Logger.getLogger(AseConnectionFactory.class);
    private static String _driver = "com.sybase.jdbc3.jdbc.SybDriver";
    private static String _urlTemplate = "jdbc:sybase:Tds:HOST:PORT";
    private static Map<String, List<String>> _hostPortMap = null;
    private static String _server = "";
    private static String _username = "";
    private static String _password = "";
    private static String _appname = "";
    private static String _hostname = "";
    private static Properties _props = new Properties();
    private static SyInterfacesDriver _interfacesDriver = null;
    private static boolean _jdbcDriverInfoHasBeenWritten = false;

    public static void reset() {
        _hostPortMap = null;
        _server = "";
        _username = "";
        _password = "";
        _appname = "";
        _hostname = "";
        _props = new Properties();
    }

    public static void setProperties(Map<String, String> map) {
        _props = new Properties();
        if (map != null) {
            _props.putAll(map);
        }
    }

    public static void setProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        _props = props;
    }

    public static void setProperty(String propname, Object prop) {
        _props.put(propname, prop);
    }

    public static void setDriver(String driver) {
        _driver = driver;
    }

    public static void setUrlTemplate(String urlTemplate) {
        _urlTemplate = urlTemplate;
    }

    public static void setUser(String username) {
        _username = username;
    }

    public static void setPassword(String password) {
        _password = password;
    }

    public static void setServer(String servername) {
        _server = servername;
        String hostPort = AseConnectionFactory.getIHostPortStr(servername);
        if (hostPort != null && !hostPort.trim().equals("")) {
            AseConnectionFactory.setHostPort(hostPort);
        }
    }

    public static void setAppName(String appname) {
        _appname = appname;
    }

    public static void setHostName(String hostname) {
        _hostname = hostname;
    }

    public static Properties getProperties() {
        return _props;
    }

    public static Object getProperty(String propname) {
        return _props.getProperty(propname);
    }

    public static String getDriver() {
        return _driver;
    }

    public static String getUrlTemplate() {
        return _urlTemplate;
    }

    public static String getUrl() {
        return _urlTemplate;
    }

    public static String getUser() {
        return _username;
    }

    public static String getPassword() {
        return _password;
    }

    public static Map<String, List<String>> getHostPortMap() {
        return _hostPortMap;
    }

    public static String getServer() {
        return _server;
    }

    public static String getAppName() {
        return _appname;
    }

    public static String getHostName() {
        return _hostname;
    }

    public static String[] getHostArr() {
        return StringUtil.commaStrToArray(AseConnectionFactory.getHosts());
    }

    public static String getHosts() {
        return AseConnectionFactory.getHosts(",");
    }

    public static String getHosts(String sepStr) {
        if (_hostPortMap == null || _hostPortMap != null && _hostPortMap.isEmpty()) {
            return null;
        }
        return StringUtil.toCommaStrMultiMapKey(_hostPortMap, sepStr);
    }

    public static String getFirstHost() {
        String[] sa = StringUtil.commaStrToArray(AseConnectionFactory.getHosts());
        if (sa.length == 0) {
            return null;
        }
        return sa[0];
    }

    public static String[] getPortArr() {
        return StringUtil.commaStrToArray(AseConnectionFactory.getPorts());
    }

    public static String getPorts() {
        return AseConnectionFactory.getPorts(",");
    }

    public static String getPorts(String sepStr) {
        if (_hostPortMap == null || _hostPortMap != null && _hostPortMap.isEmpty()) {
            return null;
        }
        return StringUtil.toCommaStrMultiMapVal(_hostPortMap, sepStr);
    }

    public static int getFirstPort() {
        String[] sa = StringUtil.commaStrToArray(AseConnectionFactory.getPorts());
        if (sa.length == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(sa[0]);
        }
        catch (NumberFormatException e) {
            _logger.debug((Object)("getFirstPort Caught: " + e));
            return -1;
        }
    }

    public static void setHostPort(Map<String, List<String>> hostPortMap) {
        _hostPortMap = hostPortMap;
        _server = AseConnectionFactory.getIServerName(_hostPortMap);
    }

    public static void setHostPort(String hosts, String ports) {
        String hostPortStr = AseConnectionFactory.toHostPortStr(hosts, ports);
        AseConnectionFactory.setHostPort(hostPortStr);
    }

    public static void setHostPort(String hostPortStr) {
        Map<String, List<String>> hostPortMap = StringUtil.parseCommaStrToMultiMap(hostPortStr, ":", ",");
        AseConnectionFactory.setHostPort(hostPortMap);
    }

    public static void addHostPort(String hostPortStr) {
        Map<String, List<String>> addHostPortMap = StringUtil.parseCommaStrToMultiMap(hostPortStr, ":", ",");
        if (_hostPortMap == null) {
            _hostPortMap = new LinkedHashMap<String, List<String>>();
        }
        _hostPortMap.putAll(addHostPortMap);
    }

    public static String getHostPortStr() {
        if (_hostPortMap == null || _hostPortMap != null && _hostPortMap.isEmpty()) {
            return null;
        }
        return StringUtil.toCommaStrMultiMap(_hostPortMap, ":", ",");
    }

    public static String getIFileName() {
        return _interfacesDriver.getBundle();
    }

    public static boolean setInterfaces(String file) throws Exception {
        try {
            SyInterfacesDriver newDriver = new SyInterfacesDriver(file);
            if (newDriver != null) {
                _interfacesDriver = newDriver;
                _logger.info((Object)("Just opened the interfaces file '" + _interfacesDriver.getBundle() + "'."));
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            _logger.error((Object)"Problems reading interfaces or sql.ini file.", (Throwable)ex);
            throw ex;
        }
    }

    public static String getIHosts(String server) {
        return AseConnectionFactory.getIHosts(server, ", ");
    }

    public static String getIHosts(String server, String sepStr) {
        SyInterfacesEntry ie = _interfacesDriver.getEntry(server);
        if (ie == null) {
            return null;
        }
        String hosts = "";
        List queryRows = ie.getServices();
        for (Service se : queryRows) {
            if (!"query".equalsIgnoreCase(se.getType())) continue;
            String seHost = se.getHost();
            String sePort = se.getPort();
            hosts = hosts + seHost + sepStr;
        }
        if (hosts.endsWith(sepStr)) {
            hosts = hosts.substring(0, hosts.length() - sepStr.length());
        }
        return hosts;
    }

    public static String getIFirstHost(String server) {
        SyInterfacesEntry interfaceEntry = _interfacesDriver.getEntry(server);
        return interfaceEntry == null ? null : interfaceEntry.getHost();
    }

    public static String getIPorts(String server) {
        return AseConnectionFactory.getIPorts(server, ", ");
    }

    public static String getIPorts(String server, String sepStr) {
        SyInterfacesEntry ie = _interfacesDriver.getEntry(server);
        if (ie == null) {
            return null;
        }
        String ports = "";
        List queryRows = ie.getServices();
        for (Service se : queryRows) {
            if (!"query".equalsIgnoreCase(se.getType())) continue;
            String seHost = se.getHost();
            String sePort = se.getPort();
            ports = ports + sePort + sepStr;
        }
        if (ports.endsWith(sepStr)) {
            ports = ports.substring(0, ports.length() - sepStr.length());
        }
        return ports;
    }

    public static int getIFirstPort(String server) {
        SyInterfacesEntry interfaceEntry = _interfacesDriver.getEntry(server);
        return interfaceEntry == null ? -1 : Integer.parseInt(interfaceEntry.getPort());
    }

    public static String getIHostPortStr(String server) {
        SyInterfacesEntry ie = _interfacesDriver.getEntry(server);
        if (ie == null) {
            return null;
        }
        String hostPortStr = "";
        List queryRows = ie.getServices();
        Iterator it = queryRows.iterator();
        while (it.hasNext()) {
            Service se = (Service)it.next();
            if (!"query".equalsIgnoreCase(se.getType())) continue;
            String seHost = se.getHost();
            String sePort = se.getPort();
            hostPortStr = hostPortStr + seHost + ":" + sePort;
            if (!it.hasNext()) continue;
            hostPortStr = hostPortStr + ",";
        }
        return hostPortStr;
    }

    public static String resolvInterfaceEntry(String serverName) {
        return AseConnectionFactory.resolvInterfaceEntry(serverName, null);
    }

    public static String resolvInterfaceEntry(String serverName, String iniFile) {
        String ret = null;
        if (serverName == null) {
            throw new RuntimeException("OpenConnectionDlg.resolvInterfaceEntry(serverName), can't be null.");
        }
        SyInterfacesDriver iniDriver = null;
        try {
            if (iniFile != null && !iniFile.trim().equals("")) {
                _logger.debug((Object)("Trying to open SyInterfacesDriver with file '" + iniFile + "'."));
                iniDriver = new SyInterfacesDriver(iniFile);
            } else {
                _logger.debug((Object)"Trying to open SyInterfacesDriver with NO FILE, using the SyInterfacesDriver default.");
                iniDriver = new SyInterfacesDriver();
            }
            if (iniDriver != null) {
                iniDriver.open();
                _logger.debug((Object)("Just opened the interfaces file '" + iniDriver.getBundle() + "'."));
                SyInterfacesEntry interfaceEntry = iniDriver.getEntry(serverName);
                if (interfaceEntry != null) {
                    ret = interfaceEntry.getHost() + ":" + interfaceEntry.getPort();
                }
            }
        }
        catch (Exception ex) {
            if (PlatformUtils.getCurrentPlattform() == 0) {
                _logger.error((Object)"Problems reading '%SYBASE%\\ini\\sql.ini' file.");
            } else {
                _logger.error((Object)"Problems reading '$SYBASE/interfaces' file.");
            }
            _logger.error((Object)("SyInterfacesDriver error: " + ex.getMessage()));
        }
        return ret;
    }

    public static String[] getIServerNames() {
        Object[] servers = _interfacesDriver.getServers();
        if (servers != null) {
            Arrays.sort(servers);
        }
        return servers;
    }

    public static String getIServerName(String host, int port) {
        if (host == null || host != null && host.trim().equals("")) {
            throw new IllegalArgumentException("Host can't be null or empty.");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("Port number must be larger than zero, port is now " + port);
        }
        if (_interfacesDriver == null) {
            return null;
        }
        Enumeration en = _interfacesDriver.entries();
        while (en.hasMoreElements()) {
            SyInterfacesEntry ie = (SyInterfacesEntry)en.nextElement();
            String serverName = ie.getName();
            List queryRows = ie.getServices();
            for (Service service : queryRows) {
                _logger.debug((Object)(serverName + " - Service: " + service.toString()));
                if (!"query".equalsIgnoreCase(service.getType())) continue;
                String eHost = service.getHost();
                String ePort = service.getPort();
                if (eHost == null || ePort == null || !eHost.equalsIgnoreCase(host) || !ePort.equals(Integer.toString(port))) continue;
                _logger.debug((Object)("Found Sybase Server Interface Entry '" + ie.getName() + "' for host '" + eHost + "', port '" + ePort + "'."));
                return ie.getName();
            }
        }
        return null;
    }

    public static String getIServerName(Map hostPortMap) {
        if (hostPortMap == null) {
            throw new IllegalArgumentException("hostPortMap can't be null.");
        }
        if (hostPortMap.size() == 0) {
            throw new IllegalArgumentException("hostPortMap is empty, it needs at least 1 entry.");
        }
        if (_interfacesDriver == null) {
            return null;
        }
        int expectedMatch = hostPortMap.size();
        Enumeration en = _interfacesDriver.entries();
        while (en.hasMoreElements()) {
            SyInterfacesEntry ie = (SyInterfacesEntry)en.nextElement();
            String serverName = ie.getName();
            _logger.trace((Object)("Searching in server '" + serverName + "'."));
            int matchCounter = 0;
            for (String hpeHost : hostPortMap.keySet()) {
                Object hpePort2 = hostPortMap.get(hpeHost);
                if (hpePort2 instanceof List) {
                    List list = (List)hpePort2;
                    expectedMatch += list.size() - 1;
                    for (Object hpePort2 : list) {
                        matchCounter += AseConnectionFactory.isHostPortInSyIntEntry(ie, hpeHost, (String)hpePort2);
                    }
                } else {
                    matchCounter += AseConnectionFactory.isHostPortInSyIntEntry(ie, hpeHost, (String)hpePort2);
                }
                if (matchCounter != expectedMatch) continue;
                _logger.debug((Object)("Found the server entry '" + serverName + "' that matched all entries in the hostPortMap '" + hostPortMap + "'."));
                return serverName;
            }
        }
        return null;
    }

    private static int isHostPortInSyIntEntry(SyInterfacesEntry ie, String hpeHost, String hpePort) {
        String serverName = ie.getName();
        List queryRows = ie.getServices();
        for (Service se : queryRows) {
            _logger.trace((Object)("      -> '" + se + "'."));
            if (!"query".equalsIgnoreCase(se.getType())) continue;
            String seHost = se.getHost();
            String sePort = se.getPort();
            if (seHost == null || sePort == null || !hpeHost.equalsIgnoreCase(seHost) || !hpePort.equals(sePort)) continue;
            _logger.debug((Object)("Found Sybase Server Interface Entry '" + serverName + "' for host '" + seHost + "', port '" + sePort + "'."));
            return 1;
        }
        return 0;
    }

    public static String getIServerName(String hostPortStr) {
        Map<String, List<String>> hostPortMap = StringUtil.parseCommaStrToMultiMap(hostPortStr, ":", ",");
        return AseConnectionFactory.getIServerName(hostPortMap);
    }

    public static String getIServerName(String hosts, String ports) {
        String hostPortStr = AseConnectionFactory.toHostPortStr(hosts, ports);
        return AseConnectionFactory.getIServerName(hostPortStr);
    }

    public static String getIServerName(String[] hostsArr, String[] portsArr) {
        String hostPortStr = AseConnectionFactory.toHostPortStr(hostsArr, portsArr);
        return AseConnectionFactory.getIServerName(hostPortStr);
    }

    public static String toHostPortStr(String hosts, String ports) {
        String[] hostsArr = StringUtil.commaStrToArray(hosts);
        String[] portsArr = StringUtil.commaStrToArray(ports);
        return AseConnectionFactory.toHostPortStr(hostsArr, portsArr);
    }

    public static String toHostPortStr(String[] hostsArr, String[] portsArr) {
        String hostPortStr = "";
        for (int i = 0; i < hostsArr.length || i < portsArr.length; ++i) {
            hostPortStr = hostPortStr + (i < hostsArr.length ? hostsArr[i] : "") + ":" + (i < portsArr.length ? portsArr[i] : "") + ",";
        }
        if (hostPortStr.endsWith(",")) {
            hostPortStr = hostPortStr.substring(0, hostPortStr.length() - 1);
        }
        return hostPortStr;
    }

    public static String toHostPortStr(String host, int port) {
        return host + ":" + port;
    }

    public static boolean isHostPortStrValid(String hostPortStr) {
        String errorStr = AseConnectionFactory.isHostPortStrValidReason(hostPortStr);
        return errorStr == null;
    }

    public static String isHostPortStrValidReason(String hostPortStr) {
        if (hostPortStr == null) {
            return "Input parameter is null.";
        }
        Map<String, List<String>> hostPortMap = StringUtil.parseCommaStrToMultiMap(hostPortStr, ":", ",");
        if (hostPortMap == null) {
            return "HostPortMap is null. input string was '" + hostPortStr + "'.";
        }
        if (hostPortMap.isEmpty()) {
            return "HostPortMap has zero entries. input string was '" + hostPortStr + "'.";
        }
        for (String host : hostPortMap.keySet()) {
            List<String> list = hostPortMap.get(host);
            if (host.trim().equals("")) {
                return "Hostname can't be empty. (host='" + host + "', port='" + list + "').";
            }
            if (list instanceof List) {
                List<String> list2 = list;
                for (String string : list2) {
                    try {
                        Integer.parseInt(string + "");
                    }
                    catch (NumberFormatException ignore) {
                        return "The port number '" + string + "' is not a number. (host='" + host + "', port='" + string + "'.)";
                    }
                }
                continue;
            }
            try {
                Integer.parseInt(list + "");
            }
            catch (NumberFormatException ignore) {
                return "The port number '" + list + "' is not a number. (host='" + host + "', port='" + list + "'.)";
            }
        }
        return null;
    }

    public static String getHostname() {
        String hostname = null;
        try {
            int firstDot;
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
            if (hostname != null && !hostname.matches("^[0-9].*") && (firstDot = hostname.indexOf(".")) > 0) {
                hostname = hostname.substring(0, firstDot);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    public static Connection getConnection(String dbname, String appname, String hostname) throws ClassNotFoundException, SQLException {
        return AseConnectionFactory.getConnection(AseConnectionFactory.getHostPortStr(), dbname, _username, _password, appname, hostname, (Properties)null, (ConnectionProgressCallback)null);
    }

    public static Connection getConnection(String dbname) throws ClassNotFoundException, SQLException {
        return AseConnectionFactory.getConnection(AseConnectionFactory.getHostPortStr(), dbname, _username, _password, _appname, _hostname, (Properties)null, (ConnectionProgressCallback)null);
    }

    public static Connection getConnection() throws ClassNotFoundException, SQLException {
        return AseConnectionFactory.getConnection(AseConnectionFactory.getHostPortStr(), null, _username, _password, _appname, _hostname, (Properties)null, (ConnectionProgressCallback)null);
    }

    public static Connection getConnection(ConnectionProgressCallback cpd) throws ClassNotFoundException, SQLException {
        return AseConnectionFactory.getConnection(AseConnectionFactory.getHostPortStr(), null, _username, _password, _appname, _hostname, (Properties)null, cpd);
    }

    public static Connection getConnection(String host, int port, String dbname, String username, String password, String appname, String hostname) throws ClassNotFoundException, SQLException {
        return AseConnectionFactory.getConnection(host + ":" + port, dbname, username, password, appname, hostname, (Properties)null, (ConnectionProgressCallback)null);
    }

    public static Connection getConnection(String host, int port, String dbname, String username, String password, String appname, String hostname, Properties connProps) throws ClassNotFoundException, SQLException {
        return AseConnectionFactory.getConnection(host + ":" + port, dbname, username, password, appname, hostname, connProps, (ConnectionProgressCallback)null);
    }

    public static Connection getConnection(String hosts, String ports, String dbname, String username, String password, String appname, String hostname, Properties connProps) throws ClassNotFoundException, SQLException {
        return AseConnectionFactory.getConnection(AseConnectionFactory.toHostPortStr(hosts, ports), dbname, username, password, appname, hostname, connProps, (ConnectionProgressCallback)null);
    }

    public static Connection getConnection(String hostPortStr, String dbname, String username, String password, String appname, String hostname, Properties connProps, ConnectionProgressCallback cpc) throws ClassNotFoundException, SQLException {
        Properties props;
        String url = AseConnectionFactory.getUrlTemplate();
        if (url == null) {
            throw new SQLException("No proper URL was passed. url='" + url + "'.");
        }
        if (hostPortStr == null) {
            throw new SQLException("No proper hostPortStr was passed. hostPortStr='" + hostPortStr + "'.");
        }
        url = url.replaceAll("HOST:PORT", hostPortStr);
        if (hostname == null || hostname != null && hostname.trim().equals("")) {
            hostname = AseConnectionFactory.getHostname();
        }
        if ((props = new Properties(_props)).getProperty("user") == null) {
            props.put("user", username);
        }
        if (props.getProperty("password") == null) {
            props.put("password", password);
        }
        if (props.getProperty("APPLICATIONNAME") == null) {
            props.put("APPLICATIONNAME", appname);
        }
        if (props.getProperty("HOSTNAME") == null) {
            props.put("HOSTNAME", hostname);
        }
        if (dbname != null && !dbname.trim().equals("")) {
            props.put("DATABASE", dbname);
        }
        if (connProps != null) {
            props.putAll((Map<?, ?>)connProps);
        }
        return AseConnectionFactory.getConnection(_driver, url, props, cpc);
    }

    public static Connection getConnection(String url, String username, String password, Properties connProps, ConnectionProgressCallback cpc) throws ClassNotFoundException, SQLException {
        String hostname = AseConnectionFactory.getHostname();
        Properties props = new Properties(_props);
        if (props.getProperty("user") == null) {
            props.put("user", username);
        }
        if (props.getProperty("password") == null) {
            props.put("password", password);
        }
        if (props.getProperty("APPLICATIONNAME") == null) {
            props.put("APPLICATIONNAME", _appname);
        }
        if (props.getProperty("HOSTNAME") == null) {
            props.put("HOSTNAME", hostname);
        }
        if (connProps != null) {
            props.putAll((Map<?, ?>)connProps);
        }
        return AseConnectionFactory.getConnection(_driver, url, props, cpc);
    }

    public static Connection getConnection(String driverClassName, String url, Properties props, ConnectionProgressCallback cpd) throws ClassNotFoundException, SQLException {
        Properties debugProps = null;
        if (_logger.isDebugEnabled()) {
            debugProps = new Properties(props);
            debugProps.remove("password");
            debugProps.remove("PASSWORD");
        }
        Class.forName(driverClassName);
        boolean emulateMultipleQueryRowSupport = true;
        int loginTimeout = 10;
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf != null) {
            emulateMultipleQueryRowSupport = conf.getBooleanProperty("AseConnectionFactory.emulateMultipleQueryRowSupport", true);
            loginTimeout = conf.getIntProperty("AseConnectionFactory.loginTimeout", loginTimeout);
        } else {
            emulateMultipleQueryRowSupport = System.getProperty("AseConnectionFactory.emulateMultipleQueryRowSupport", "true").trim().equalsIgnoreCase("true");
            try {
                loginTimeout = Integer.parseInt(System.getProperty("AseConnectionFactory.loginTimeout", loginTimeout + ""));
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        AseUrlHelper urlHelper = null;
        try {
            urlHelper = AseUrlHelper.parseUrl(url);
        }
        catch (ParseException ignore) {
            _logger.debug((Object)("Caught Exception when parsing the URL string '" + url + "'. Cause: " + ignore), (Throwable)ignore);
        }
        if (props != null && props.containsKey("REQUEST_HA_SESSION") && props.getProperty("REQUEST_HA_SESSION").trim().equalsIgnoreCase("true")) {
            emulateMultipleQueryRowSupport = false;
        }
        if (url.indexOf("REQUEST_HA_SESSION=true") > 0) {
            emulateMultipleQueryRowSupport = false;
        }
        Connection conn = null;
        if (!emulateMultipleQueryRowSupport || urlHelper == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("getConnection(simple url): driverClassName='" + driverClassName + "', url='" + url + "', props='" + debugProps + "'"));
            }
            conn = DriverManager.getConnection(url, props);
        } else {
            SQLException firstSqlex = null;
            List<String> urlList = urlHelper.getUrlList();
            Iterator<String> it = urlList.iterator();
            while (it.hasNext()) {
                String urlEntry = it.next();
                try {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("getConnection(MULTY_QUERY_ROWS): driverClassName='" + driverClassName + "', url='" + urlEntry + "', props='" + debugProps + "'"));
                    }
                    if (cpd != null) {
                        cpd.setTaskStatus(urlEntry, 0);
                    }
                    conn = DriverManager.getConnection(urlEntry, props);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("getConnection(MULTY_QUERY_ROWS): ---- SUCCEEDED ---- url='" + urlEntry + "', props='" + debugProps + "'."));
                    }
                    if (cpd == null) break;
                    cpd.setTaskStatus(urlEntry, 1);
                    break;
                }
                catch (SQLException e) {
                    if (cpd != null) {
                        cpd.setTaskStatus(urlEntry, 3, e);
                    }
                    if (firstSqlex == null) {
                        firstSqlex = e;
                    } else {
                        firstSqlex.setNextException(e);
                    }
                    boolean throwNow = false;
                    if (e.getSQLState().equals("JZ00L")) {
                        throwNow = true;
                    }
                    if (!it.hasNext()) {
                        throwNow = true;
                    }
                    if (throwNow) {
                        if (cpd != null) {
                            cpd.setTaskStatus(urlEntry, 4, e);
                        }
                        throw firstSqlex;
                    }
                    _logger.warn((Object)("Connecting to '" + urlEntry + "', had problems, but more host/port will be tried. Caught: " + e));
                }
            }
        }
        if (!_jdbcDriverInfoHasBeenWritten) {
            _jdbcDriverInfoHasBeenWritten = true;
            try {
                DatabaseMetaData dbmd;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"The following drivers have been loaded:");
                    Enumeration<Driver> drvEnum = DriverManager.getDrivers();
                    while (drvEnum.hasMoreElements()) {
                        _logger.debug((Object)("    " + drvEnum.nextElement().toString()));
                    }
                }
                if ((dbmd = conn.getMetaData()) != null) {
                    _logger.info((Object)("JDBC driver version: " + dbmd.getDriverVersion()));
                }
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        try {
            if (!conn.getAutoCommit()) {
                _logger.info((Object)"Autocommit was turned 'off'. I will turn this to 'on' for this connection.");
                conn.setAutoCommit(true);
            }
            conn.createStatement().execute("set quoted_identifier off");
        }
        catch (SQLException sqle) {
            String errStr = "";
            while (sqle != null) {
                errStr = errStr + sqle.getMessage() + " ";
                sqle = sqle.getNextException();
            }
            _logger.warn((Object)("Failed to execute 'set quoted_identifier off' when connecting. Problem: " + errStr));
        }
        return conn;
    }

    public static void printConnectionPropertyInfo() {
        AseConnectionFactory.printConnectionPropertyInfo(null, null);
    }

    public static void printConnectionPropertyInfo(String driverClassName, String url) {
        if (driverClassName == null) {
            driverClassName = _driver;
        }
        if (url == null) {
            url = _urlTemplate;
        }
        Driver driver = null;
        DriverPropertyInfo[] attributes = null;
        try {
            Class.forName(driverClassName);
            Properties info = new Properties();
            driver = DriverManager.getDriver(url);
            attributes = driver.getPropertyInfo(url, info);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        System.out.println("Resolving properties for: " + driver.getClass().getName());
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i].name;
            String[] choicesArr = attributes[i].choices;
            boolean required = attributes[i].required;
            String description = attributes[i].description;
            String value = attributes[i].value;
            String choises = "-none-";
            if (choicesArr != null && choicesArr.length > 0) {
                choises = "";
                for (int j = 0; j < choicesArr.length; ++j) {
                    choises = choises + choicesArr[j] + ", ";
                }
                if (choises.endsWith(", ")) {
                    choises = choises.substring(0, choises.length() - 2);
                }
            } else {
                System.out.println("\n-----------------------------------------------------------");
            }
            System.out.println(" Name:        " + name);
            System.out.println(" Required:    " + required);
            System.out.println(" Value:       " + value);
            System.out.println(" Choices are: ");
            System.out.println(" Description: " + description);
        }
    }

    static {
        String jdbcDriver = "com.sybase.jdbc3.jdbc.SybDriver";
        String jdbcUrlTemplate = "jdbc:sybase:Tds:HOST:PORT";
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf != null) {
            _driver = conf.getProperty("jdbcDriver", jdbcDriver);
            _urlTemplate = conf.getProperty("jdbcUrlTemplate", jdbcUrlTemplate);
        } else {
            _driver = System.getProperty("jdbcDriver", jdbcDriver);
            _urlTemplate = System.getProperty("jdbcUrlTemplate", jdbcUrlTemplate);
        }
        String envSybase = System.getProperty("SYBASE");
        String interfacesFile = null;
        if (envSybase != null) {
            if ((envSybase = envSybase.trim()).endsWith("/") || envSybase.endsWith("\\")) {
                envSybase = envSybase.substring(0, envSybase.length() - 1);
            }
            interfacesFile = PlatformUtils.getCurrentPlattform() == 0 ? envSybase + "\\ini\\sql.ini" : envSybase + "/interfaces";
        }
        if (interfacesFile != null) {
            System.setProperty("interfaces.file", interfacesFile);
        }
        try {
            _interfacesDriver = new SyInterfacesDriver();
            _interfacesDriver.open();
        }
        catch (Exception ex) {
            if (PlatformUtils.getCurrentPlattform() == 0) {
                _logger.warn((Object)("Problems reading '%SYBASE%\\ini\\sql.ini' '" + interfacesFile + "'."));
            } else {
                _logger.warn((Object)("Problems reading '$SYBASE/interfaces' file '" + interfacesFile + "'."));
            }
            _logger.warn((Object)("SyInterfacesDriver error: " + ex.getMessage()));
        }
        if (_interfacesDriver != null) {
            _logger.info((Object)("Using '" + _interfacesDriver.getBundle() + "' file for ASE server name lookup."));
        }
    }
}

