/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import asemon.MonTablesDictionary;
import asemon.gui.AseMonitoringConfigDialog;
import asemon.utils.AseSqlScript;
import asemon.utils.StringUtil;
import asemon.utils.SwingUtils;
import com.sybase.jdbc3.jdbc.SybConnection;
import com.sybase.jdbc3.jdbc.SybSQLWarning;
import com.sybase.jdbcx.EedInfo;
import com.sybase.jdbcx.SybMessageHandler;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AseConnectionUtils {
    public static final int CONFIG_TYPE_IF_CHANGED = 1;
    public static final int CONFIG_TYPE_IF_CFG_LT = 2;
    public static final int CONFIG_TYPE_IF_CFG_GT = 3;
    public static final int CE_SYSTEM_VIEW_UNKNOWN = 0;
    public static final int CE_SYSTEM_VIEW_CLUSTER = 1;
    public static final int CE_SYSTEM_VIEW_INSTANCE = 2;
    private static Logger _logger = Logger.getLogger(AseConnectionUtils.class);
    private static String SQL_VERSION = "select @@version";
    private static final int VERSION_MAJOR = 1;
    private static final int VERSION_MINOR = 2;
    private static final int VERSION_MAINTENANCE = 3;
    private static final int VERSION_ROLLUP = 4;
    public static final String SA_ROLE = "sa_role";
    public static final String SSO_ROLE = "sso_role";
    public static final String OPER_ROLE = "oper_role";
    public static final String SYBASE_TS_ROLE = "sybase_ts_role";
    public static final String NAVIGATOR_ROLE = "navigator_role";
    public static final String REPLICATION_ROLE = "replication_role";
    public static final String DTM_TM_ROLE = "dtm_tm_role";
    public static final String HA_ROLE = "ha_role";
    public static final String MON_ROLE = "mon_role";
    public static final String JS_ADMIN_ROLE = "js_admin_role";
    public static final String MESSAGING_ROLE = "messaging_role";
    public static final String JS_CLIENT_ROLE = "js_client_role";
    public static final String JS_USER_ROLE = "js_user_role";
    public static final String WEBSERVICES_ROLE = "webservices_role";
    public static final String KEYCUSTODIAN_ROLE = "keycustodian_role";
    private static Map<String, List<Integer>> _connHasTraceFlagEnabled = new HashMap<String, List<Integer>>();

    public static String getCurrentDbname(Connection conn) {
        if (!AseConnectionUtils.isConnectionOk(conn, false, null)) {
            return null;
        }
        try {
            Statement stmnt = conn.createStatement();
            ResultSet rs = stmnt.executeQuery("select db_name()");
            String cwdb = "";
            while (rs.next()) {
                cwdb = rs.getString(1);
            }
            return cwdb;
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems getting current Working Database. Error Number: " + e.getErrorCode() + ", Message: " + e.getMessage()));
            return null;
        }
    }

    public static boolean useDbname(Connection conn, String dbname) {
        if (!AseConnectionUtils.isConnectionOk(conn, false, null)) {
            return false;
        }
        if (dbname == null || dbname.equals("")) {
            return false;
        }
        String dbNameBeforeChange = AseConnectionUtils.getCurrentDbname(conn);
        if (dbNameBeforeChange.equalsIgnoreCase(dbname)) {
            _logger.debug((Object)("No need to change database to '" + dbNameBeforeChange + "', you are already in it."));
            return true;
        }
        String cmd = "use " + dbname;
        Statement stmnt = null;
        try {
            stmnt = conn.createStatement();
            stmnt.executeUpdate(cmd);
            if (AseConnectionUtils.hasSqlWarnings(stmnt.getWarnings())) {
                _logger.info((Object)("Received following warnings when changing database to '" + dbname + "', continuing... " + AseConnectionUtils.sqlWarningToString(stmnt.getWarnings())));
            }
            stmnt.close();
        }
        catch (SQLException sqle) {
            for (SQLException e = sqle; e != null; e = e.getNextException()) {
                int aseError = e.getErrorCode();
                switch (aseError) {
                    case 918: 
                    case 919: 
                    case 921: 
                    case 922: 
                    case 924: 
                    case 926: 
                    case 927: 
                    case 928: 
                    case 930: 
                    case 931: 
                    case 932: 
                    case 937: 
                    case 938: 
                    case 942: 
                    case 943: 
                    case 947: 
                    case 948: 
                    case 949: 
                    case 950: 
                    case 951: 
                    case 952: 
                    case 959: 
                    case 961: 
                    case 962: 
                    case 963: 
                    case 968: 
                    case 3471: {
                        String aseMsg = e.getMessage() == null ? "-unknown-" : e.getMessage().replaceAll("\n", "");
                        String msg = "It looks like the database '" + dbname + "' is in 'load database', 'recovery mode' or 'offline', still in the database '" + dbNameBeforeChange + "', please try again later. AseMsgNumber=" + aseError + ", AseMsg=" + aseMsg;
                        _logger.warn((Object)msg);
                        return false;
                    }
                }
            }
            String msg = "Problems when executing '" + cmd + "' in '" + dbNameBeforeChange + "'.";
            _logger.error((Object)(msg + AseConnectionUtils.sqlExceptionToString(sqle)));
            return false;
        }
        String dbNameAfterChange = AseConnectionUtils.getCurrentDbname(conn);
        if (!dbname.equalsIgnoreCase(dbNameAfterChange)) {
            return false;
        }
        _logger.debug((Object)("Changed database from '" + dbNameBeforeChange + "' to '" + dbNameAfterChange + "'."));
        return true;
    }

    public static Timestamp getAseGetdate(Connection conn) {
        Timestamp aseGetdate = null;
        Statement stmnt = null;
        ResultSet rs = null;
        String sql = "select timenow=getdate()";
        if (!AseConnectionUtils.isConnectionOk(conn, false, null)) {
            return null;
        }
        try {
            stmnt = conn.createStatement();
            rs = stmnt.executeQuery(sql);
            while (rs.next()) {
                aseGetdate = rs.getTimestamp(1);
            }
            rs.close();
            stmnt.close();
        }
        catch (SQLException sqle) {
            aseGetdate = null;
            String msg = "Problems when executing '" + sql + "' in ASE Server.";
            _logger.error((Object)(msg + AseConnectionUtils.sqlExceptionToString(sqle)));
        }
        _logger.debug((Object)("getAseGetdate(): getdate()='" + aseGetdate + "'."));
        return aseGetdate;
    }

    public static Calendar getObjectCreationCalendar(Connection conn, String dbname, String objectName) {
        return AseConnectionUtils.getObjectCreationCalendar(conn, dbname, objectName, null);
    }

    public static Calendar getObjectCreationCalendar(Connection conn, String dbname, String objectName, String type) {
        Timestamp ts = AseConnectionUtils.getObjectCreationTimestamp(conn, dbname, objectName, type);
        if (ts == null) {
            return null;
        }
        GregorianCalendar crDate = new GregorianCalendar();
        crDate.setTimeInMillis(ts.getTime());
        return crDate;
    }

    public static Date getObjectCreationDate(Connection conn, String dbname, String objectName) {
        return AseConnectionUtils.getObjectCreationDate(conn, dbname, objectName, null);
    }

    public static Date getObjectCreationDate(Connection conn, String dbname, String objectName, String type) {
        Timestamp ts = AseConnectionUtils.getObjectCreationTimestamp(conn, dbname, objectName, type);
        if (ts == null) {
            return null;
        }
        return new Date(ts.getTime());
    }

    public static Timestamp getObjectCreationTimestamp(Connection conn, String dbname, String objectName) {
        return AseConnectionUtils.getObjectCreationTimestamp(conn, dbname, objectName, null);
    }

    public static Timestamp getObjectCreationTimestamp(Connection conn, String dbname, String objectName, String type) {
        Timestamp crDate = null;
        Statement stmnt = null;
        ResultSet rs = null;
        String sql = "select crdate from " + dbname + "..sysobjects " + "where name = '" + objectName + "'";
        if (type != null) {
            sql = sql + "  and type = '" + type + "'";
        }
        if (!AseConnectionUtils.isConnectionOk(conn, false, null)) {
            return null;
        }
        try {
            stmnt = conn.createStatement();
            rs = stmnt.executeQuery(sql);
            while (rs.next()) {
                crDate = rs.getTimestamp(1);
            }
            rs.close();
            stmnt.close();
        }
        catch (SQLException sqle) {
            crDate = null;
            String msg = "Problems when executing '" + sql + "' in ASE Server.";
            _logger.error((Object)(msg + AseConnectionUtils.sqlExceptionToString(sqle)));
        }
        _logger.debug((Object)("getObjectCreationDate(): objectName='" + objectName + "', created='" + crDate + "'."));
        return crDate;
    }

    public static SQLWarning sqlExceptionToWarning(SQLException sqle) {
        if (sqle instanceof EedInfo) {
            EedInfo eed = (EedInfo)sqle;
            return new SybSQLWarning(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), eed.getState(), eed.getSeverity(), eed.getServerName(), eed.getProcedureName(), eed.getLineNumber(), eed.getEedParams(), eed.getTranState(), eed.getStatus());
        }
        return new SQLWarning(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode());
    }

    public static boolean isInLoadDbException(SQLException sqle) {
        int code = sqle.getErrorCode();
        switch (code) {
            case 918: 
            case 921: 
            case 922: 
            case 930: 
            case 937: 
            case 938: 
            case 950: 
            case 2206: 
            case 3118: 
            case 7408: 
            case 12537: 
            case 18174: {
                return true;
            }
        }
        return false;
    }

    public static String sqlExceptionToString(SQLException sqle) {
        StringBuffer sb = new StringBuffer();
        while (sqle != null) {
            if (sqle instanceof EedInfo) {
                EedInfo sybsqle = (EedInfo)sqle;
                sb.append(" (Srv=");
                sb.append(sybsqle.getServerName());
                sb.append(", Error=");
                sb.append(sqle.getErrorCode());
                sb.append(", Severity=");
                sb.append(sybsqle.getSeverity());
                sb.append(", Proc=");
                sb.append(sybsqle.getProcedureName());
                sb.append(", Line=");
                sb.append(sybsqle.getLineNumber());
                sb.append(", Text=");
                sb.append(sqle.getMessage());
                sb.append(")");
            } else {
                sb.append(" (Error=");
                sb.append(sqle.getErrorCode());
                sb.append(", Text=");
                sb.append(sqle.getMessage());
                sb.append(")");
            }
            sqle = sqle.getNextException();
        }
        return sb.toString();
    }

    public static boolean hasSqlWarnings(SQLWarning sqlw) {
        return sqlw != null;
    }

    public static String sqlWarningToString(SQLWarning sqlw) {
        StringBuffer sb = new StringBuffer();
        while (sqlw != null) {
            if (sqlw instanceof EedInfo) {
                EedInfo sybsqlw = (EedInfo)sqlw;
                sb.append(" (Srv=");
                sb.append(sybsqlw.getServerName());
                sb.append(", Error=");
                sb.append(sqlw.getErrorCode());
                sb.append(", Severity=");
                sb.append(sybsqlw.getSeverity());
                sb.append(", Proc=");
                sb.append(sybsqlw.getProcedureName());
                sb.append(", Line=");
                sb.append(sybsqlw.getLineNumber());
                sb.append(", Text=");
                sb.append(sqlw.getMessage());
                sb.append(")");
            } else {
                sb.append(" (Error=");
                sb.append(sqlw.getErrorCode());
                sb.append(", Text=");
                sb.append(sqlw.getMessage());
                sb.append(")");
            }
            sqlw = sqlw.getNextWarning();
        }
        return sb.toString();
    }

    public static String getSqlWarningMsgs(SQLException sqe) {
        if (sqe == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (sqe != null) {
            if (sqe instanceof EedInfo) {
                EedInfo eedi = (EedInfo)sqe;
                if (eedi.getSeverity() > 10) {
                    boolean firstOnLine = true;
                    sb.append("Msg " + sqe.getErrorCode() + ", Level " + eedi.getSeverity() + ", State " + eedi.getState() + ":\n");
                    if (eedi.getServerName() != null) {
                        sb.append("Server '" + eedi.getServerName() + "'");
                        firstOnLine = false;
                    }
                    if (eedi.getProcedureName() != null) {
                        sb.append((firstOnLine ? "" : ", ") + "Procedure '" + eedi.getProcedureName() + "'");
                        firstOnLine = false;
                    }
                    sb.append((firstOnLine ? "" : ", ") + "Line " + eedi.getLineNumber() + ", Status " + eedi.getStatus() + ", TranState " + eedi.getTranState() + ":\n");
                }
                String msg = sqe.getMessage();
                sb.append(msg);
                if (msg != null && !msg.endsWith("\n")) {
                    sb.append("\n");
                }
            } else if (!sqe.getSQLState().equals("010P4")) {
                sb.append("Unexpected exception : SqlState: " + sqe.getSQLState() + " " + sqe.toString() + ", ErrorCode: " + sqe.getErrorCode() + "\n");
            }
            sqe = sqe.getNextException();
        }
        return sb.toString();
    }

    public static String getAseServername(Connection conn) {
        String UNKNOWN = "";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "";
        }
        try {
            String name = "";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select @@servername");
            while (rs.next()) {
                name = rs.getString(1);
                name = name == null ? "" : name.trim();
            }
            return name;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting @@servername, Caught exception.", (Throwable)e);
            return "";
        }
    }

    public static String getAseHostname(Connection conn, boolean stripDomainName) {
        String UNKNOWN = "UNKNOWN";
        if (!AseConnectionUtils.isConnectionOk(conn, true, null)) {
            return "UNKNOWN";
        }
        try {
            String hostname = "UNKNOWN";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select asehostname()");
            while (rs.next()) {
                String host = rs.getString(1).trim();
                if (stripDomainName && host.indexOf(".") > 0) {
                    hostname = host.substring(0, host.indexOf("."));
                    continue;
                }
                hostname = host;
            }
            return hostname;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting asehostname(), Caught exception.", (Throwable)e);
            return "UNKNOWN";
        }
    }

    public static String getListeners(Connection conn, boolean addType, boolean stripDomainName, Component guiOwner) {
        if (!AseConnectionUtils.isConnectionOk(conn, true, guiOwner)) {
            return null;
        }
        try {
            String listenersStr = "";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select * from syslisteners");
            while (rs.next()) {
                if (addType) {
                    listenersStr = listenersStr + rs.getString("net_type").trim() + ":";
                }
                String host = rs.getString("address_info").trim();
                if (stripDomainName && host != null && host.indexOf(".") > 0) {
                    String hostname = host.substring(0, host.indexOf("."));
                    String portnum = host.substring(host.lastIndexOf(" "));
                    listenersStr = listenersStr + hostname + portnum;
                } else {
                    listenersStr = listenersStr + host;
                }
                listenersStr = listenersStr + ", ";
            }
            if (listenersStr.endsWith(", ")) {
                listenersStr = listenersStr.substring(0, listenersStr.length() - 2);
            }
            return listenersStr;
        }
        catch (SQLException e) {
            _logger.debug((Object)"When getting listeners, Caught exception.", (Throwable)e);
            if (guiOwner != null) {
                AseConnectionUtils.showSqlExceptionMessage(guiOwner, "Getting Listeners", "When getting listeners, we got an SQLException", e);
            }
            return null;
        }
    }

    public static boolean isConnectionOk(Connection conn, boolean guiMsgOnError, Component guiOwner) {
        String msg = "";
        String title = "Checking DB Connection";
        if (conn == null) {
            msg = "The passed Connection object is null.";
            _logger.debug((Object)msg);
            if (guiOwner != null) {
                SwingUtils.showWarnMessage(guiOwner, title, msg, new Exception(msg));
            }
            return false;
        }
        try {
            if (conn.isClosed()) {
                msg = "The passed Connection object is NOT connected.";
                _logger.debug((Object)msg);
                if (guiOwner != null) {
                    SwingUtils.showWarnMessage(guiOwner, title, msg, new Exception(msg));
                }
                return false;
            }
        }
        catch (SQLException e) {
            _logger.debug((Object)"When checking the DB Connection, Caught exception.", (Throwable)e);
            if (guiOwner != null) {
                AseConnectionUtils.showSqlExceptionMessage(guiOwner, "Checking DB Connection", "When checking the DB Connection, we got an SQLException", e);
            }
            return false;
        }
        return true;
    }

    public static String showSqlExceptionMessage(Component owner, String title, String msg, SQLException sqlex) {
        String exMsg = AseConnectionUtils.getMessageFromSQLException(sqlex);
        SwingUtils.showErrorMessage(owner, title, msg + "\n\n" + exMsg, sqlex);
        return exMsg;
    }

    public static String getMessageFromSQLException(SQLException sqlex) {
        StringBuffer sb = new StringBuffer("");
        boolean first = true;
        while (sqlex != null) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            sb.append(sqlex.getMessage());
            sqlex = sqlex.getNextException();
        }
        return sb.toString();
    }

    public static String versionIntToStr(int version) {
        int major = version / 1000;
        int minor = (version - major * 1000) / 100;
        int maintenance = (version - (major * 1000 + minor * 100)) / 10;
        int rollup = version - (major * 1000 + minor * 100 + maintenance * 10);
        if (rollup == 0) {
            return major + "." + minor + "." + maintenance;
        }
        return major + "." + minor + "." + maintenance + " ESD#" + rollup;
    }

    private static int fixVersionOverflow(int type, int version) {
        if (version < 0) {
            return 0;
        }
        if (type == 4) {
            if (version < 10) {
                return version;
            }
            if (version >= 10) {
                return 9;
            }
        }
        return version;
    }

    public static int aseVersionStringToNumber(String versionStr) {
        int aseVersionNumber;
        block24: {
            aseVersionNumber = 0;
            String[] aseVersionParts = versionStr.split("/");
            if (aseVersionParts.length > 0) {
                String aseVersionNumberStr = null;
                String aseEsdStr = null;
                for (int i = 0; i < aseVersionParts.length; ++i) {
                    if (aseVersionParts[i].matches("^[0-9][0-9][.][0-9].*") && aseVersionNumberStr == null) {
                        aseVersionNumberStr = aseVersionParts[i];
                    }
                    if (aseVersionParts[i].indexOf("ESD#") <= 0 || aseEsdStr != null) continue;
                    aseEsdStr = aseVersionParts[i];
                }
                if (aseVersionNumberStr == null) {
                    _logger.warn((Object)("There ASE version string seems to be faulty, cant find any '##.#' in the version number string '" + versionStr + "'."));
                    return aseVersionNumber;
                }
                String[] aseVersionNumberParts = aseVersionNumberStr.split("\\.");
                if (aseVersionNumberParts.length > 1) {
                    try {
                        int end;
                        String versionPart = null;
                        if (aseVersionNumberParts.length >= 1) {
                            versionPart = aseVersionNumberParts[0].trim();
                            int major = AseConnectionUtils.fixVersionOverflow(1, Integer.parseInt(versionPart));
                            aseVersionNumber += 1000 * major;
                        }
                        if (aseVersionNumberParts.length >= 2) {
                            versionPart = aseVersionNumberParts[1].trim().substring(0, 1);
                            int minor = AseConnectionUtils.fixVersionOverflow(2, Integer.parseInt(versionPart));
                            if (minor >= 10) {
                                // empty if block
                            }
                            aseVersionNumber += 100 * minor;
                        }
                        if (aseVersionNumberParts.length >= 3) {
                            versionPart = aseVersionNumberParts[2].trim().substring(0, 1);
                            int maint = AseConnectionUtils.fixVersionOverflow(3, Integer.parseInt(versionPart));
                            aseVersionNumber += 10 * maint;
                        }
                        if (aseVersionNumberParts.length >= 4) {
                            versionPart = aseVersionNumberParts[3].trim().substring(0, 1);
                            int rollup = AseConnectionUtils.fixVersionOverflow(4, Integer.parseInt(versionPart));
                            aseVersionNumber += 1 * rollup;
                            break block24;
                        }
                        if (aseEsdStr == null) break block24;
                        int start = aseEsdStr.indexOf("ESD#");
                        if (start >= 0) {
                            start += "ESD#".length();
                        }
                        if ((end = aseEsdStr.indexOf(" ", start)) == -1) {
                            end = aseEsdStr.indexOf(".", start);
                        }
                        if (end == -1) {
                            end = aseEsdStr.indexOf(",", start);
                        }
                        if (end == -1) {
                            end = aseEsdStr.indexOf(":", start);
                        }
                        if (end == -1) {
                            end = aseEsdStr.indexOf(";", start);
                        }
                        if (end == -1) {
                            end = aseEsdStr.indexOf("-", start);
                        }
                        if (end == -1) {
                            end = aseEsdStr.indexOf("_", start);
                        }
                        if (end == -1) {
                            end = aseEsdStr.length();
                        }
                        if (start == -1) break block24;
                        try {
                            versionPart = aseEsdStr.trim().substring(start, end);
                            int rollup = AseConnectionUtils.fixVersionOverflow(4, Integer.parseInt(versionPart));
                            aseVersionNumber += 1 * rollup;
                        }
                        catch (RuntimeException e) {
                            _logger.warn((Object)("Problems converting some part(s) of the ESD# in the version string '" + aseVersionNumberStr + "' into a number. ESD# string was '" + versionPart + "'. The version number will be set to " + aseVersionNumber));
                        }
                    }
                    catch (RuntimeException e) {
                        _logger.warn((Object)("Problems converting some part(s) of the version string '" + aseVersionNumberStr + "' into a number. The version number will be set to " + aseVersionNumber));
                    }
                } else {
                    _logger.warn((Object)("There ASE version string seems to be faulty, cant find any '.' in the version number subsection '" + aseVersionNumberStr + "'."));
                }
            } else {
                _logger.warn((Object)("There ASE version string seems to be faulty, cant find any / in the string '" + versionStr + "'."));
            }
        }
        return aseVersionNumber;
    }

    public static int getAseVersionNumber(Connection conn) {
        int aseVersionNum = 0;
        try {
            String aseVersionStr = "";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(SQL_VERSION);
            while (rs.next()) {
                aseVersionStr = rs.getString(1);
            }
            rs.close();
            if (aseVersionNum == 0) {
                aseVersionNum = AseConnectionUtils.aseVersionStringToNumber(aseVersionStr);
            }
        }
        catch (SQLException ex) {
            _logger.error((Object)"MonTablesDictionary:getAseVersionNumber(), @@version", (Throwable)ex);
        }
        return aseVersionNum;
    }

    public static boolean isClusterEnabled(Connection conn) {
        String clusterMode = null;
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select @@clustermode");
            while (rs.next()) {
                clusterMode = rs.getString(1).trim();
            }
            rs.close();
        }
        catch (SQLException ex) {
            _logger.debug((Object)"MonTablesDictionary:isClusterEnabled(), @@clustermode, probably an early ASE version", (Throwable)ex);
        }
        _logger.debug((Object)("Ase @@clustermode = '" + clusterMode + "'."));
        if (clusterMode == null) {
            return false;
        }
        return clusterMode.equalsIgnoreCase("shared disk cluster");
    }

    public static void setClusterEditionSystemView(Connection conn, int type) {
        String sql = null;
        if (type == 1) {
            sql = "set system_view cluster";
        }
        if (type == 2) {
            sql = "set system_view instance";
        }
        if (sql == null) {
            String err = "The passed System View type='" + type + "', is unknown.";
            _logger.error((Object)err);
            return;
        }
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            stmt.close();
        }
        catch (SQLException ex) {
            String msg = AseConnectionUtils.showSqlExceptionMessage(null, "asemon", "Problems when setting 'system view' in ASE Server.", ex);
            _logger.error((Object)("Problems when setting 'system view' in ASE Server. " + msg));
        }
    }

    public static int getClusterEditionSystemView(Connection conn) {
        String ceSystemView = null;
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select @@system_view");
            while (rs.next()) {
                ceSystemView = rs.getString(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            String msg = AseConnectionUtils.showSqlExceptionMessage(null, "asemon", "Problems when getting 'system view' in ASE Server.", ex);
            _logger.error((Object)("Problems when getting 'system view' in ASE Server. " + msg));
        }
        if (ceSystemView == null) {
            return 0;
        }
        if ((ceSystemView = ceSystemView.trim()).equalsIgnoreCase("cluster")) {
            return 1;
        }
        if (ceSystemView.equalsIgnoreCase("instance")) {
            return 2;
        }
        return 0;
    }

    public static boolean checkForMonitorOptions(Connection conn, String user, boolean gui, Component parent, String ... needsConfig) {
        int aseVersionNum = 0;
        String aseVersionStr = "";
        String atAtServername = "";
        try {
            String msg;
            ResultSet rs;
            Statement stmt;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("select @@version_number");
                while (rs.next()) {
                    aseVersionNum = rs.getInt(1);
                }
                rs.close();
            }
            catch (SQLException ex) {
                _logger.debug((Object)"checkForMonitorOptions, @@version_number failed, probably an early ASE version", (Throwable)ex);
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select @@version");
            while (rs.next()) {
                aseVersionStr = rs.getString(1);
            }
            rs.close();
            int aseVersionNumFromVerStr = AseConnectionUtils.aseVersionStringToNumber(aseVersionStr);
            aseVersionNum = Math.max(aseVersionNum, aseVersionNumFromVerStr);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select @@servername");
            while (rs.next()) {
                atAtServername = rs.getString(1);
            }
            rs.close();
            _logger.info((Object)("Just connected to an ASE Server named '" + atAtServername + "' with Version Number " + aseVersionNum + ", and the Version String '" + aseVersionStr + "'."));
            if (user == null || user != null && user.trim().equals("")) {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("select suser_name()");
                while (rs.next()) {
                    user = rs.getString(1);
                }
                stmt.close();
                rs.close();
            }
            _logger.debug((Object)"Verify mon_role");
            stmt = conn.createStatement();
            rs = stmt.executeQuery("sp_activeroles");
            boolean has_sa_role = false;
            boolean has_mon_role = false;
            while (rs.next()) {
                if (rs.getString(1).equals(SA_ROLE)) {
                    has_sa_role = true;
                }
                if (!rs.getString(1).equals(MON_ROLE)) continue;
                has_mon_role = true;
            }
            if (!has_mon_role) {
                if (has_sa_role) {
                    String sql = "sp_role 'grant', 'mon_role', '" + user + "'";
                    stmt.execute(sql);
                    _logger.info((Object)("Executed: " + sql));
                    sql = "set role 'mon_role' on";
                    stmt.execute(sql);
                    _logger.info((Object)("Executed: " + sql));
                    rs = stmt.executeQuery("sp_activeroles");
                    has_mon_role = false;
                    while (rs.next()) {
                        if (!rs.getString(1).equals(MON_ROLE)) continue;
                        has_mon_role = true;
                    }
                }
                if (!has_mon_role) {
                    msg = "You need 'mon_role' to access monitoring tables";
                    _logger.error((Object)msg);
                    if (gui) {
                        SwingUtils.showErrorMessage(parent, "Problems when checking 'Monitor Role'", msg, null);
                    }
                    return false;
                }
            }
            stmt.executeUpdate("use master");
            _logger.debug((Object)"Verify monTables existance");
            rs = stmt.executeQuery("select count(*) from sysobjects where name ='monTables'");
            while (rs.next()) {
                if (rs.getInt(1) != 0) continue;
                msg = "Monitoring tables must be installed ( execute '$SYBASE/scripts/installmontables' )";
                _logger.error((Object)msg);
                if (gui) {
                    SwingUtils.showErrorMessage(parent, "asemon - connect check", msg, null);
                }
                return false;
            }
            if (needsConfig != null) {
                _logger.debug((Object)("Verify monitor configuration: " + StringUtil.toCommaStr(needsConfig)));
                boolean notConfigured = false;
                String errorMesage = "<h1>Sorry the ASE server is not properly configured for monitoring.</h1>";
                errorMesage = errorMesage + "<UL>";
                for (String cfgOption : needsConfig) {
                    if (AseConnectionUtils.getAseConfigRunValue(conn, cfgOption) > 0) continue;
                    _logger.warn((Object)("ASE Configuration option '" + cfgOption + "' is NOT enabled."));
                    errorMesage = errorMesage + "<LI> ASE option '" + cfgOption + "' is NOT enabled.";
                    notConfigured = true;
                }
                if (notConfigured) {
                    errorMesage = errorMesage + "</UL>";
                    errorMesage = errorMesage + "<b>I will now open the configuration panel for you.</b><BR>";
                    errorMesage = errorMesage + "<b>Then try to connect again.</b>";
                    if (gui) {
                        SwingUtils.showErrorMessage(parent, "asemon - connect check", "<html>" + errorMesage + "</html>", null);
                        AseMonitoringConfigDialog.showDialog(parent, conn, aseVersionNum);
                    }
                    return false;
                }
            }
            _logger.debug((Object)"Connection passed 'Check Monitoring'.");
            return true;
        }
        catch (SQLException ex) {
            String msg = AseConnectionUtils.showSqlExceptionMessage(parent, "asemon - connect", "Problems when connecting to a ASE Server.", ex);
            _logger.error((Object)("Problems when connecting to a ASE Server. " + msg));
            return false;
        }
        catch (Exception ex) {
            _logger.error((Object)("Problems when connecting to a ASE Server. " + ex.toString()));
            if (gui) {
                SwingUtils.showErrorMessage(parent, "asemon - connect", "Problems when connecting to a ASE Server\n\n" + ex.getMessage(), ex);
            }
            return false;
        }
    }

    public static void setBasicAseMonitoring(Connection conn) throws SQLException {
        AseConnectionUtils.checkAndSetAseConfig(conn, "enable monitoring", 1);
        AseConnectionUtils.checkAndSetAseConfig(conn, "max SQL text monitored", 2048, 2);
    }

    public static boolean checkAndSetAseConfig(Connection conn, String config, int val) {
        return AseConnectionUtils.checkAndSetAseConfig(conn, config, val, 1);
    }

    public static boolean checkAndSetAseConfig(Connection conn, String config, int val, int type) {
        try {
            int aseCfg = AseConnectionUtils.getAseConfigConfigValue(conn, config);
            boolean doConfig = false;
            if (type == 1) {
                if (aseCfg != val) {
                    doConfig = true;
                }
            } else if (type == 2) {
                if (aseCfg < val) {
                    doConfig = true;
                }
            } else if (type == 3) {
                if (aseCfg > val) {
                    doConfig = true;
                }
            } else {
                throw new RuntimeException("checkAndSetAseConfig, unknown type=" + type);
            }
            if (doConfig) {
                AseConnectionUtils.setAseConfigValue(conn, config, val);
                return true;
            }
            return false;
        }
        catch (SQLException sqle) {
            String errStr = "";
            while (sqle != null) {
                errStr = errStr + sqle.getMessage() + " ";
                sqle = sqle.getNextException();
            }
            return false;
        }
    }

    public static void setAseConfigValue(Connection conn, String config, boolean val) throws SQLException {
        AseConnectionUtils.setAseConfigValue(conn, config, val ? 1 : 0);
    }

    public static void setAseConfigValue(Connection conn, String config, int val) throws SQLException {
        AseConnectionUtils.setAseConfigValue(conn, config, Integer.toString(val));
    }

    public static void setAseConfigValue(Connection conn, String config, String val) throws SQLException {
        if (val == null) {
            return;
        }
        boolean isNumber = false;
        try {
            Integer.parseInt(val);
            isNumber = true;
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        if (!isNumber) {
            val = "'" + val.trim() + "'";
        }
        _logger.info((Object)("Setting ASE Configuration '" + config + "' to value '" + val + "'."));
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("sp_configure '" + config + "', " + val);
        while (rs.next()) {
        }
        rs.close();
        stmt.close();
    }

    public static int getAseConfigRunValue(Connection conn, String config) throws SQLException {
        int val = -1;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("sp_configure '" + config + "'");
        while (rs.next()) {
            val = rs.getInt(5);
        }
        rs.close();
        stmt.close();
        return val;
    }

    public static int getAseConfigRunValueNoEx(Connection conn, String config) {
        int val = -1;
        try {
            val = AseConnectionUtils.getAseConfigRunValue(conn, config);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return val;
    }

    public static boolean getAseConfigRunValueBooleanNoEx(Connection conn, String config) {
        int val = -1;
        try {
            val = AseConnectionUtils.getAseConfigRunValue(conn, config);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return val > 0;
    }

    public static int getAseConfigConfigValue(Connection conn, String config) throws SQLException {
        int val = -1;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("sp_configure '" + config + "'");
        while (rs.next()) {
            val = rs.getInt(4);
        }
        rs.close();
        stmt.close();
        return val;
    }

    public static boolean isAseConfigStatic(Connection conn, String config) throws SQLException {
        String val = "";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("sp_configure '" + config + "'");
        while (rs.next()) {
            val = rs.getString(7);
        }
        rs.close();
        stmt.close();
        return val.equals("static");
    }

    public static boolean setCompatibilityMode(Connection conn, boolean on) {
        String option = "compatibility_mode";
        return AseConnectionUtils.setAseOption(conn, option, on);
    }

    public static boolean getCompatibilityMode(Connection conn) {
        String option = "compatibility_mode";
        return AseConnectionUtils.getAseOption(conn, option);
    }

    public static boolean setAseOption(Connection conn, String option, boolean on) {
        String sql = "set " + option + (on ? " on" : " off");
        try {
            Statement stmnt = conn.createStatement();
            stmnt.executeUpdate(sql);
            stmnt.close();
            return true;
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems execute SQL '" + sql + "', Caught: " + e.toString()));
            return false;
        }
    }

    public static boolean getAseOption(Connection conn, String option) {
        String sql = "-- check if we are in 'compatibility_mode', introduced in 15.0.3 esd#1 \ndeclare @option int \nselect @option = 0  \n    \nselect @option = sign(convert(tinyint,substring(@@options, c.low, 1)) & c.high) \n  from master.dbo.spt_values a, master.dbo.spt_values c \n  where a.number = c.number \n    and c.type = 'P' \n    and a.type = 'N' \n    and c.low <= datalength(@@options) \n    and a.name = '" + option + "' \n" + "    \n" + "    select @option\n" + "\n";
        try {
            int resultOption = 0;
            Statement stmnt = conn.createStatement();
            ResultSet rs = stmnt.executeQuery(sql);
            while (rs.next()) {
                resultOption = rs.getInt(1);
            }
            rs.close();
            stmnt.close();
            return resultOption > 0;
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems execute SQL '" + sql + "', Caught: " + e.toString()));
            return false;
        }
    }

    public static boolean hasRole(Connection conn, String role) {
        int val = -1;
        String sql = "select proc_role('" + role + "')";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                val = rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)ex);
        }
        _logger.debug((Object)("hasRole(role='" + role + "'): SQL 'select proc_role(rolename)' returned=" + val + ", so rasRole() will return=" + (val > 0)));
        return val > 0;
    }

    public static List<String> getActiveRoles(Connection conn) {
        String sql = "select show_role()";
        try {
            LinkedList<String> roleList = null;
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (roleList == null) {
                    roleList = new LinkedList<String>();
                }
                String val = rs.getString(1);
                String[] sa = val.split(" ");
                for (int i = 0; i < sa.length; ++i) {
                    String role = sa[i].trim();
                    if (roleList.contains(role)) continue;
                    roleList.add(role);
                }
            }
            rs.close();
            stmt.close();
            _logger.debug((Object)("getRoles(roleList='" + roleList + "'."));
            return roleList;
        }
        catch (SQLException ex) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)ex);
            return null;
        }
    }

    public static Map<String, Integer> getMonitorConfigs(Connection conn) {
        String sql = "exec sp_configure 'Monitoring'";
        try {
            LinkedHashMap<String, Integer> configMap = null;
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (configMap == null) {
                    configMap = new LinkedHashMap<String, Integer>();
                }
                String name = rs.getString(1);
                int runValue = rs.getInt(5);
                configMap.put(name, runValue);
            }
            rs.close();
            stmt.close();
            _logger.debug((Object)("getMonitorConfigs(configMap='" + configMap + "'."));
            return configMap;
        }
        catch (SQLException ex) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getShowplan(Connection conn, int spid, String htmlStartStr, boolean addHtmlTags) {
        if (htmlStartStr == null) {
            htmlStartStr = "";
        }
        String htmlBegin = "";
        String htmlEnd = "";
        String htmlNewLine = "";
        if (addHtmlTags) {
            htmlBegin = "<html>" + htmlStartStr + "<pre>";
            htmlEnd = "</pre></html>";
        }
        StringBuilder sb = null;
        String sql = "exec sp_showplan " + spid + ", null, null, null";
        SybMessageHandler curMsgHandler = null;
        if (conn instanceof SybConnection) {
            curMsgHandler = ((SybConnection)conn).getSybMessageHandler();
            ((SybConnection)conn).setSybMessageHandler(null);
        }
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            for (SQLWarning sqlw = stmt.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                if (sqlw.getErrorCode() == 10233 || sqlw.getSQLState() == "010P4") continue;
                if (sb == null) {
                    sb = new StringBuilder(htmlBegin);
                }
                sb = sb.append(sqlw.getMessage()).append(htmlNewLine);
            }
            stmt.close();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)e);
        }
        finally {
            if (curMsgHandler != null) {
                ((SybConnection)conn).setSybMessageHandler(curMsgHandler);
            }
        }
        if (sb == null) {
            return null;
        }
        while (sb.charAt(sb.length() - 1) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append(htmlEnd).toString();
    }

    private static boolean __isDbccTraceOnInMap(Connection conn, int trace) {
        if (conn == null) {
            return false;
        }
        List<Integer> traceList = _connHasTraceFlagEnabled.get(conn.toString());
        if (traceList == null) {
            return false;
        }
        return traceList.contains(trace);
    }

    private static void __setDbccTraceOnInMap(Connection conn, int trace) {
        if (conn == null) {
            return;
        }
        List<Integer> traceList = _connHasTraceFlagEnabled.get(conn.toString());
        if (traceList == null) {
            traceList = new ArrayList<Integer>();
        }
        traceList.add(trace);
    }

    public static void dbccTraceOn(Connection conn, int trace) {
        if (AseConnectionUtils.__isDbccTraceOnInMap(conn, trace)) {
            return;
        }
        String setSwitch = "set switch on " + trace + " with no_info";
        String dbccTraceon = "DBCC traceon(" + trace + ")";
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(setSwitch);
            stmt.close();
            AseConnectionUtils.__setDbccTraceOnInMap(conn, trace);
        }
        catch (SQLException e) {
            _logger.debug((Object)("Problems when executing sql '" + setSwitch + "', I will fallback and use '" + dbccTraceon + "' instead."));
            try {
                Statement stmt = conn.createStatement();
                stmt.executeUpdate(dbccTraceon);
                stmt.close();
                AseConnectionUtils.__setDbccTraceOnInMap(conn, trace);
            }
            catch (SQLException e2) {
                _logger.warn((Object)("Problems when executing sql: " + dbccTraceon), (Throwable)e2);
            }
        }
    }

    public static String monSqlText(Connection conn, int spid, boolean addHtmlTags) {
        String htmlBegin = "";
        String htmlEnd = "";
        if (addHtmlTags) {
            htmlBegin = "<html><pre>";
            htmlEnd = "</pre></html>";
        }
        StringBuilder sb = null;
        String sql = "select BatchID, LineNumber, SequenceInLine, SQLText from master..monProcessSQLText where SPID = " + spid;
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            int saveLineNumber = 1;
            while (rs.next()) {
                if (sb == null) {
                    sb = new StringBuilder(htmlBegin);
                }
                int atLineNum = rs.getInt(2);
                String sqltext = rs.getString(4);
                while (saveLineNumber < atLineNum) {
                    sb.append("\n");
                    if (++saveLineNumber <= 10240) continue;
                }
                if (atLineNum == saveLineNumber) {
                    sb.append(sqltext);
                } else {
                    sb.append(sqltext).append("\n");
                }
                saveLineNumber = atLineNum;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)e);
        }
        if (sb == null) {
            return null;
        }
        while (sb.charAt(sb.length() - 1) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append(htmlEnd).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dbccSqlText(Connection conn, int spid, boolean addHtmlTags) {
        String htmlBegin = "";
        String htmlEnd = "";
        String htmlNewLine = "";
        if (addHtmlTags) {
            htmlBegin = "<html><pre>";
            htmlEnd = "</pre></html>";
        }
        AseConnectionUtils.dbccTraceOn(conn, 3604);
        StringBuilder sb = null;
        String sql = "DBCC sqltext(" + spid + ")";
        SybMessageHandler curMsgHandler = null;
        if (conn instanceof SybConnection) {
            curMsgHandler = ((SybConnection)conn).getSybMessageHandler();
            ((SybConnection)conn).setSybMessageHandler(null);
        }
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            for (SQLWarning sqlw = stmt.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                if (sqlw.getMessage().startsWith("DBCC execution completed. If DBCC")) continue;
                if (sb == null) {
                    sb = new StringBuilder(htmlBegin);
                }
                String text = sqlw.getMessage();
                sb = sb.append(text).append(htmlNewLine);
            }
            stmt.close();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)e);
        }
        finally {
            if (curMsgHandler != null) {
                ((SybConnection)conn).setSybMessageHandler(curMsgHandler);
            }
        }
        if (sb == null) {
            return null;
        }
        while (sb.charAt(sb.length() - 1) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append(htmlEnd).toString();
    }

    public static String monProcCallStack(Connection conn, int spid, boolean addHtmlTags) {
        String htmlBegin = "";
        String htmlEnd = "";
        String htmlNewLine = "\n";
        if (addHtmlTags) {
            htmlBegin = "<html><pre>";
            htmlEnd = "</pre></html>";
            htmlNewLine = "<br>";
        }
        int aseVersion = 0;
        String LineNumber = "LineNumber='', ";
        String StatementNumber = "StatementNumber='', ";
        if (MonTablesDictionary.hasInstance()) {
            aseVersion = MonTablesDictionary.getInstance().aseVersionNum;
            if (aseVersion >= 12530) {
                LineNumber = "LineNumber      = convert(varchar(10),LineNumber), ";
            }
            if (aseVersion >= 15025) {
                StatementNumber = "StatementNumber = convert(varchar(10),StatementNumber), ";
            }
        }
        StringBuilder sb = null;
        String sql = "select ContextID, DBName, OwnerName, ObjectName, " + LineNumber + StatementNumber + "ObjectType \n" + "from master..monProcessProcedures \n" + "where SPID = " + spid + " \n" + "order by ContextID desc";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            boolean rows = false;
            while (rs.next()) {
                if (sb == null) {
                    sb = new StringBuilder(htmlBegin);
                }
                rows = true;
                String vContextID = rs.getString(1);
                String vDBName = rs.getString(2);
                String vOwnerName = rs.getString(3);
                String vObjectName = rs.getString(4);
                String vLineNumber = rs.getString(5).trim();
                String vStatementNumber = rs.getString(6).trim();
                String vObjectType = rs.getString(7);
                if (vOwnerName == null) {
                    vOwnerName = "";
                }
                int len = 60 - (vDBName.length() + vOwnerName.length() + vObjectName.length());
                sb.append(vContextID).append(": ");
                sb.append(vDBName).append(".");
                sb.append(vOwnerName).append(".");
                sb.append(vObjectName).append(StringUtil.replicate(" ", len));
                sb.append("LineNumber=").append(vLineNumber).append(", ");
                sb.append("StmtNumber=").append(vStatementNumber).append(", ");
                sb.append("ObjectType=").append(vObjectType).append(htmlNewLine);
            }
            if (!rows) {
                return null;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)e);
        }
        if (sb == null) {
            return null;
        }
        return sb.append(htmlEnd).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dbccStacktrace(Connection conn, int spid, boolean addHtmlTags, int waitEventID) {
        String htmlBegin = "";
        String htmlEnd = "";
        String htmlNewLine = "";
        if (addHtmlTags) {
            htmlBegin = "<html><pre>";
            htmlEnd = "</pre></html>";
        }
        AseConnectionUtils.dbccTraceOn(conn, 3604);
        StringBuilder sb = null;
        StringBuilder sqlSb = new StringBuilder();
        String sql = null;
        if (waitEventID < 0) {
            sqlSb.append("DBCC stacktrace(").append(spid).append(")");
        } else {
            sqlSb.append("declare @prevWaitEventId int, @nowWaitEventId int, @spid int \n");
            sqlSb.append("select @spid = ").append(spid).append(" \n");
            sqlSb.append("select @prevWaitEventId = ").append(waitEventID).append(" \n");
            sqlSb.append("     \n");
            sqlSb.append("select @nowWaitEventId = WaitEventID \n");
            sqlSb.append("from monProcess \n");
            sqlSb.append("where SPID = @spid \n");
            sqlSb.append("     \n");
            sqlSb.append("if (@nowWaitEventId is NULL) \n");
            sqlSb.append("    select @nowWaitEventId = 0\n");
            sqlSb.append("     \n");
            sqlSb.append("if (@prevWaitEventId = @nowWaitEventId) \n");
            sqlSb.append("begin \n");
            sqlSb.append("    DBCC stacktrace(@spid) \n");
            sqlSb.append("end \n");
            sqlSb.append("else \n");
            sqlSb.append("begin \n");
            sqlSb.append("    declare @prevWaitDescription varchar(60), @prevClassDescription varchar(60) \n");
            sqlSb.append("    declare @nowWaitDescription  varchar(60), @nowClassDescription  varchar(60) \n");
            sqlSb.append("    \n");
            sqlSb.append("    select @prevWaitDescription  = WI.Description,  \n");
            sqlSb.append("           @prevClassDescription = (select CI.Description from monWaitClassInfo CI where WI.WaitClassID = CI.WaitClassID) \n");
            sqlSb.append("    from monWaitEventInfo WI \n");
            sqlSb.append("    where WI.WaitEventID = @prevWaitEventId \n");
            sqlSb.append("    \n");
            sqlSb.append("    select @nowWaitDescription  = WI.Description,  \n");
            sqlSb.append("           @nowClassDescription = (select CI.Description from monWaitClassInfo CI where WI.WaitClassID = CI.WaitClassID) \n");
            sqlSb.append("    from monWaitEventInfo WI \n");
            sqlSb.append("    where WI.WaitEventID = @nowWaitEventId \n");
            sqlSb.append("    \n");
            sqlSb.append("    print 'The WaitEventID was changed from %1! to %2!, so there is no reason to do DBCC stacktrace anymore.', @prevWaitEventId, @nowWaitEventId \n");
            sqlSb.append("    print '-------------------------------------------------------------------------------------------------' \n");
            sqlSb.append("    print 'From WaitEventID=%1!, class=''%2!'', description=''%3!''.', @prevWaitEventId, @prevClassDescription, @prevWaitDescription \n");
            sqlSb.append("    print 'To   WaitEventID=%1!, class=''%2!'', description=''%3!''.', @nowWaitEventId,  @nowClassDescription,  @nowWaitDescription \n");
            sqlSb.append("end \n");
        }
        sql = sqlSb.toString();
        SybMessageHandler curMsgHandler = null;
        if (conn instanceof SybConnection) {
            curMsgHandler = ((SybConnection)conn).getSybMessageHandler();
            ((SybConnection)conn).setSybMessageHandler(null);
        }
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            for (SQLWarning sqlw = stmt.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                String msg;
                if (sqlw.getMessage().startsWith("DBCC execution completed. If DBCC")) continue;
                if (sb == null) {
                    sb = new StringBuilder(htmlBegin);
                }
                sb = (msg = sqlw.getMessage()).endsWith("\n") ? sb.append(msg).append(htmlNewLine) : sb.append(msg).append("\n").append(htmlNewLine);
            }
            stmt.close();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)e);
        }
        finally {
            if (curMsgHandler != null) {
                ((SybConnection)conn).setSybMessageHandler(curMsgHandler);
            }
        }
        if (sb == null) {
            return null;
        }
        while (sb.charAt(sb.length() - 1) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append(htmlEnd).toString();
    }

    public static boolean checkCreateStoredProc(Connection conn, int needsVersion, String dbname, String procName, Date procDateThreshold, Class<?> scriptLocation, String scriptName, String needsRoleToRecreate) throws Exception {
        if (dbname == null) {
            throw new IllegalArgumentException("checkCreateStoredProc(): 'dbname' cant be null");
        }
        if (procName == null) {
            throw new IllegalArgumentException("checkCreateStoredProc(): 'procName' cant be null");
        }
        if (procDateThreshold == null) {
            throw new IllegalArgumentException("checkCreateStoredProc(): 'procDateThreshold' cant be null");
        }
        if (scriptName == null) {
            throw new IllegalArgumentException("checkCreateStoredProc(): 'scriptName' cant be null");
        }
        Date crDate = AseConnectionUtils.getObjectCreationDate(conn, dbname, procName);
        if (crDate == null || crDate != null && crDate.getTime() < procDateThreshold.getTime()) {
            int aseVersion;
            if (crDate == null) {
                _logger.info((Object)("Checking for stored procedure '" + procName + "' in '" + dbname + "', which was NOT found."));
            } else {
                _logger.info((Object)("Checking for stored procedure '" + procName + "' in '" + dbname + "', which was to old, crdate was '" + crDate + "', re-creation threshold date is '" + procDateThreshold + "'."));
            }
            boolean hasProc = false;
            if (needsVersion > 0 && (aseVersion = AseConnectionUtils.getAseVersionNumber(conn)) < needsVersion) {
                String msg = "The procedure '" + procName + "' in '" + dbname + "', needs at least version '" + needsVersion + "', while we are connected to ASE Version '" + aseVersion + "'.";
                _logger.warn((Object)msg);
                throw new Exception(msg);
            }
            boolean hasRole = true;
            if (needsRoleToRecreate != null && !needsRoleToRecreate.equals("")) {
                hasRole = AseConnectionUtils.hasRole(conn, needsRoleToRecreate);
            }
            if (!hasRole) {
                String msg = "Can't (re)create procedure '" + procName + "' in '" + dbname + "', for doing that the connected user needs to have '" + needsRoleToRecreate + "'.";
                _logger.warn((Object)msg);
                throw new Exception(msg);
            }
            AseSqlScript script = new AseSqlScript(conn);
            try {
                _logger.info((Object)("Creating procedure '" + procName + "' in '" + dbname + "'."));
                script.setMsgPrefix(scriptName + ": ");
                if (scriptLocation == null) {
                    script.execute(scriptName);
                } else {
                    script.execute(scriptLocation, scriptName);
                }
                hasProc = true;
            }
            catch (SQLException e) {
                String msg = "Problem loading the script '" + scriptName + "'.";
                _logger.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
            script.close();
            if (!hasProc) {
                String location = scriptLocation == null ? "'" + scriptName + "'" : "'$ASEMON_HOME/classes' under the class '" + scriptLocation.getClass().getName() + "' you will find the script '" + scriptName + "'";
                String msg = "Missing stored proc '" + procName + "' in database '" + dbname + "' please create it. (connect with a user that has '" + needsRoleToRecreate + "' or load the proc from " + location + ").";
                _logger.warn((Object)msg);
                throw new Exception(msg);
            }
        } else {
            _logger.info((Object)("No Need to re-create procedure '" + procName + "' in '" + dbname + "', creation date was '" + crDate + "', re-creation threshold date is '" + procDateThreshold + "'."));
        }
        return true;
    }
}

