/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import asemon.gui.ResultSetTableModel;
import asemon.utils.AseConnectionUtils;
import com.sybase.jdbcx.EedInfo;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class AseSqlScript
implements SybMessageHandler {
    private static Logger _logger = Logger.getLogger(AseSqlScript.class);
    private Connection _conn;
    private String _sqlMessage = null;
    private SybMessageHandler _saveMsgHandler = null;
    private boolean _saveAutoCommit = false;
    private String _dbnameBeforeScript = null;
    private ArrayList<ResultSetTableModel> _resultCompList = null;
    private String _msgPrefix = "";

    public AseSqlScript(Connection conn) {
        this._conn = conn;
        this._saveMsgHandler = ((SybConnection)this._conn).getSybMessageHandler();
        ((SybConnection)this._conn).setSybMessageHandler((SybMessageHandler)this);
        try {
            this._saveAutoCommit = this._conn.getAutoCommit();
            if (!this._saveAutoCommit) {
                this._conn.setAutoCommit(true);
            }
            this._dbnameBeforeScript = AseConnectionUtils.getCurrentDbname(this._conn);
        }
        catch (SQLException e) {
            _logger.warn((Object)"Problems when doing set|getAutoCommit on the connection.", (Throwable)e);
        }
    }

    public void close() {
        try {
            this._conn.setAutoCommit(this._saveAutoCommit);
            AseConnectionUtils.useDbname(this._conn, this._dbnameBeforeScript);
        }
        catch (SQLException e) {
            _logger.warn((Object)"Problems when doing set|getAutoCommit on the connection.", (Throwable)e);
        }
        ((SybConnection)this._conn).setSybMessageHandler(this._saveMsgHandler);
    }

    public void setMsgPrefix(String prefix) {
        this._msgPrefix = prefix;
    }

    public String getMsgPrefix() {
        return this._msgPrefix;
    }

    public void execute(String className, String filename) throws SQLException {
        try {
            Class<?> clazz = Class.forName(className);
            this.execute(clazz, filename);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void execute(Class<?> clazz, String filename) throws SQLException {
        try {
            URL url = clazz.getResource(filename);
            if (url != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                br = new BufferedReader(new InputStreamReader(url.openStream()));
                this.execute(br);
                br.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void execute(String filename) throws SQLException {
        try {
            File file = new File(filename);
            if (file != null) {
                FileReader fr = new FileReader(file);
                BufferedReader br = new BufferedReader(fr);
                this.execute(br);
                br.close();
                fr.close();
            }
        }
        catch (IOException e) {
            throw new SQLException("Problems loading the file '" + filename + "'. Caught: " + e.getMessage(), e);
        }
    }

    public void executeStr(String sql) throws SQLException {
        try {
            StringReader sr = new StringReader(sql);
            BufferedReader br = new BufferedReader(sr);
            this.execute(br);
            br.close();
            sr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void execute(BufferedReader br) throws SQLException, IOException {
        String sql = this.readCommand(br);
        while (sql != null && sql.length() > 0) {
            try {
                SQLWarning sqlw = null;
                Statement stmnt = this._conn.createStatement();
                ResultSet rs = null;
                int rowsAffected = 0;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("EXECUTING: " + sql));
                }
                boolean hasRs = stmnt.execute(sql);
                do {
                    if (hasRs) {
                        rs = stmnt.getResultSet();
                        ResultSetTableModel tm = new ResultSetTableModel(rs, true);
                        _logger.info((Object)(this.getMsgPrefix() + ": produced a ResultSet\n" + tm.toTableString()));
                        for (sqlw = rs.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                            _logger.trace((Object)("--In loop, sqlw: " + sqlw));
                        }
                        rs.close();
                    }
                    if ((rowsAffected = stmnt.getUpdateCount()) >= 0) {
                        // empty if block
                    }
                    hasRs = stmnt.getMoreResults();
                    _logger.trace((Object)("--hasRs=" + hasRs + ", rowsAffected=" + rowsAffected));
                } while (hasRs || rowsAffected != -1);
                for (sqlw = stmnt.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                    _logger.trace((Object)("====After read RS loop, sqlw: " + sqlw));
                }
                stmnt.close();
            }
            catch (SQLWarning w) {
                _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)w);
            }
            sql = this.readCommand(br);
        }
    }

    public String executeSql(String className, String filename) throws SQLException {
        try {
            Class<?> clazz = Class.forName(className);
            return this.executeSql(clazz, filename);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public String executeSql(Class<?> clazz, String filename) throws SQLException {
        try {
            URL url = clazz.getResource(filename);
            if (url != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                br = new BufferedReader(new InputStreamReader(url.openStream()));
                String result = this.executeSql(br);
                br.close();
                return result;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String executeSql(String filename) throws SQLException {
        try {
            File file = new File(filename);
            if (file != null) {
                FileReader fr = new FileReader(file);
                BufferedReader br = new BufferedReader(fr);
                String result = this.executeSql(br);
                br.close();
                fr.close();
                return result;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String executeSqlStr(String sql) throws SQLException {
        try {
            StringReader sr = new StringReader(sql);
            BufferedReader br = new BufferedReader(sr);
            String result = this.executeSql(br);
            br.close();
            sr.close();
            return result;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeSql(BufferedReader br) throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        String sql = this.readCommand(br);
        while (sql != null && sql.length() > 0) {
            SybMessageHandler oldMsgHandler = ((SybConnection)this._conn).getSybMessageHandler();
            ((SybConnection)this._conn).setSybMessageHandler(new SybMessageHandler(){

                public SQLException messageHandler(SQLException sqle) {
                    if (AseConnectionUtils.isInLoadDbException(sqle)) {
                        return AseConnectionUtils.sqlExceptionToWarning(sqle);
                    }
                    return sqle;
                }
            });
            try {
                Statement stmnt = this._conn.createStatement();
                ResultSet rs = null;
                int rowsAffected = 0;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("EXECUTING: " + sql));
                }
                boolean hasRs = stmnt.execute(sql);
                do {
                    sb.append(this.getSqlWarningMsgs(stmnt, true));
                    if (hasRs) {
                        rs = stmnt.getResultSet();
                        sb.append(this.getSqlWarningMsgs(stmnt, true));
                        ResultSetTableModel tm = new ResultSetTableModel(rs, true);
                        sb.append(tm.toTableString());
                        sb.append(this.getSqlWarningMsgs(stmnt, true));
                        rs.close();
                    }
                    if ((rowsAffected = stmnt.getUpdateCount()) >= 0) {
                        // empty if block
                    }
                    hasRs = stmnt.getMoreResults();
                    _logger.trace((Object)("--hasRs=" + hasRs + ", rowsAffected=" + rowsAffected));
                } while (hasRs || rowsAffected != -1);
                sb.append(this.getSqlWarningMsgs(stmnt, true));
                stmnt.close();
            }
            catch (SQLWarning w) {
                _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)w);
            }
            finally {
                ((SybConnection)this._conn).setSybMessageHandler(oldMsgHandler);
            }
            sql = this.readCommand(br);
        }
        return sb.toString();
    }

    private String getSqlWarningMsgs(Statement stmnt, boolean clearWawnings) {
        try {
            String out = this.getSqlWarningMsgs(stmnt.getWarnings());
            stmnt.clearWarnings();
            return out;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private String getSqlWarningMsgs(SQLException sqe) {
        StringBuilder sb = new StringBuilder();
        while (sqe != null) {
            if (sqe instanceof EedInfo) {
                EedInfo eedi = (EedInfo)sqe;
                if (eedi.getSeverity() > 10) {
                    boolean firstOnLine = true;
                    sb.append("Msg " + sqe.getErrorCode() + ", Level " + eedi.getSeverity() + ", State " + eedi.getState() + ":\n");
                    if (eedi.getServerName() != null) {
                        sb.append("Server '" + eedi.getServerName() + "'");
                        firstOnLine = false;
                    }
                    if (eedi.getProcedureName() != null) {
                        sb.append((firstOnLine ? "" : ", ") + "Procedure '" + eedi.getProcedureName() + "'");
                        firstOnLine = false;
                    }
                    sb.append((firstOnLine ? "" : ", ") + "Line " + eedi.getLineNumber() + ", Status " + eedi.getStatus() + ", TranState " + eedi.getTranState() + ":\n");
                }
                sb.append(sqe.getMessage() + "\n");
            } else if (!sqe.getSQLState().equals("010P4")) {
                sb.append("Unexpected exception : SqlState: " + sqe.getSQLState() + " " + sqe.toString() + ", ErrorCode: " + sqe.getErrorCode() + "\n");
            }
            sqe = sqe.getNextException();
        }
        return sb.toString();
    }

    private String readCommand(BufferedReader br) throws IOException {
        String s = "";
        try {
            String s1 = br.readLine();
            while (s1 != null && !s1.trim().equalsIgnoreCase("go")) {
                s = s + s1 + "\n";
                s1 = br.readLine();
            }
        }
        catch (IOException e) {
            s = null;
            throw e;
        }
        return s.trim();
    }

    public SQLException messageHandlerXXX(SQLException sqle) {
        StringBuffer sb = new StringBuffer();
        boolean discard = true;
        if (sqle instanceof EedInfo) {
            EedInfo sybsqle = (EedInfo)sqle;
            if (sybsqle.getSeverity() > 10) {
                discard = false;
            }
            sb.append("Srv=");
            sb.append(sybsqle.getServerName());
            sb.append(", Msg=");
            sb.append(sqle.getErrorCode());
            sb.append(", Severity=");
            sb.append(sybsqle.getSeverity());
            sb.append(": ");
            sb.append(sqle.getMessage().replaceAll("\n", ""));
        } else {
            sb.append("Msg=");
            sb.append(sqle.getErrorCode());
            sb.append(": ");
            sb.append(sqle.getMessage().replaceAll("\n", ""));
        }
        if (discard) {
            _logger.info((Object)(this.getMsgPrefix() + sb.toString()));
        } else {
            _logger.error((Object)(this.getMsgPrefix() + sb.toString()));
        }
        if (discard) {
            return null;
        }
        return sqle;
    }

    public SQLException messageHandler(SQLException sqe) {
        boolean isInformational = false;
        StringBuffer m = new StringBuffer(500);
        String threadName = " ThreadName='" + Thread.currentThread().getName() + "'.";
        String procName = "";
        int msgNumber = sqe.getErrorCode();
        String message = sqe.getMessage();
        if (message.endsWith("\n")) {
            message = message.replaceAll("\n", "");
        }
        boolean bl = isInformational = msgNumber == 0;
        if (isInformational) {
            m.append(message);
        } else {
            m.append("Msg=");
            m.append(msgNumber);
            m.append(": ");
            m.append(message);
        }
        if (sqe instanceof EedInfo && ((EedInfo)sqe).getProcedureName() != null) {
            procName = " ProcName='" + ((EedInfo)sqe).getProcedureName() + "'.";
        }
        if (!isInformational) {
            m.append(", SqlState='");
            m.append(sqe.getSQLState());
            m.append("'");
            if (sqe instanceof EedInfo) {
                m.append(", State=");
                m.append(((EedInfo)sqe).getState());
                m.append(", Severity=");
                m.append(((EedInfo)sqe).getSeverity());
                m.append(", ServerName=");
                m.append(((EedInfo)sqe).getServerName());
                m.append(", ProcName=");
                m.append(((EedInfo)sqe).getProcedureName());
                m.append(", LineNum=");
                m.append(((EedInfo)sqe).getLineNumber());
                procName = "";
                if (((EedInfo)sqe).getSeverity() <= 10) {
                    isInformational = true;
                }
            }
        }
        m.append(".");
        if (sqe instanceof SQLWarning) {
            if (isInformational) {
                this._sqlMessage = "INFO: " + m.toString();
                _logger.info((Object)(this.getMsgPrefix() + m.toString()));
            } else {
                this._sqlMessage = "WARNING: " + m.toString();
                _logger.warn((Object)(this.getMsgPrefix() + m.toString()));
            }
        } else {
            this._sqlMessage = "ERROR: " + m.toString();
            _logger.error((Object)(this.getMsgPrefix() + m.toString()));
        }
        return sqe;
    }

    private void displayQueryResults(Connection conn, String sql) {
        try {
            if (conn == null) {
                throw new IllegalStateException("Connection already closed.");
            }
            SQLWarning sqlw = null;
            Statement stmnt = conn.createStatement();
            ResultSet rs = null;
            int rowsAffected = 0;
            this._resultCompList = new ArrayList();
            _logger.debug((Object)("Executing SQL statement: " + sql));
            boolean hasRs = stmnt.execute(sql);
            do {
                if (hasRs) {
                    rs = stmnt.getResultSet();
                    ResultSetTableModel tm = new ResultSetTableModel(rs, true);
                    this._resultCompList.add(tm);
                    for (sqlw = rs.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                        _logger.trace((Object)("--In loop, sqlw: " + sqlw));
                    }
                    rs.close();
                }
                if ((rowsAffected = stmnt.getUpdateCount()) >= 0) {
                    // empty if block
                }
                hasRs = stmnt.getMoreResults();
                _logger.trace((Object)("--hasRs=" + hasRs + ", rowsAffected=" + rowsAffected));
            } while (hasRs || rowsAffected != -1);
            for (sqlw = stmnt.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                _logger.trace((Object)("====After read RS loop, sqlw: " + sqlw));
            }
            stmnt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeGoString(String dbname, int timeout, String msgHandlerPrefix, String goStr) {
        String cmd = "";
        SybMessageHandler oldMsgHandler = ((SybConnection)this._conn).getSybMessageHandler();
        try {
            if (!AseConnectionUtils.isConnectionOk(this._conn, false, null)) {
                _logger.error((Object)"Connection is already closed. Cant execute the sql script.");
            }
            if (dbname != null && !dbname.equals("")) {
                AseConnectionUtils.useDbname(this._conn, dbname);
            }
            ((SybConnection)this._conn).setSybMessageHandler((SybMessageHandler)new AseMessageHandlerPrintToLog(msgHandlerPrefix));
            Statement stmt = this._conn.createStatement();
            if (timeout > 0) {
                stmt.setQueryTimeout(timeout);
            }
            BufferedReader br = new BufferedReader(new StringReader(goStr));
            String s1 = this.readCommand(br);
            while (s1 != null && s1.length() > 0) {
                cmd = s1;
                _logger.debug((Object)("EXECUTING: " + cmd));
                stmt.executeUpdate(cmd);
                s1 = this.readCommand(br);
            }
            br.close();
            stmt.close();
        }
        catch (IOException e) {
            String msg = "Problems when executing '" + cmd + "' in DB '" + AseConnectionUtils.getCurrentDbname(this._conn) + "'.";
            _logger.error((Object)msg);
            boolean bl = false;
            return bl;
        }
        catch (SQLException sqle) {
            String msg = "Problems when executing '" + cmd + "' in DB '" + AseConnectionUtils.getCurrentDbname(this._conn) + "'.";
            _logger.error((Object)(msg + AseConnectionUtils.sqlExceptionToString(sqle)));
            boolean bl = false;
            return bl;
        }
        finally {
            ((SybConnection)this._conn).setSybMessageHandler(oldMsgHandler);
        }
        return true;
    }

    private class AseMessageHandlerPrintToLog
    implements SybMessageHandler {
        private String _prefix = "";

        public AseMessageHandlerPrintToLog(String prefix) {
            if (prefix != null) {
                this._prefix = prefix;
            }
        }

        public SQLException messageHandler(SQLException sqle) {
            StringBuffer sb = new StringBuffer();
            boolean discard = true;
            if (sqle instanceof EedInfo) {
                EedInfo sybsqle = (EedInfo)sqle;
                if (sybsqle.getSeverity() > 10) {
                    discard = false;
                }
                sb.append("Srv=");
                sb.append(sybsqle.getServerName());
                sb.append(", Msg=");
                sb.append(sqle.getErrorCode());
                sb.append(", Severity=");
                sb.append(sybsqle.getSeverity());
                sb.append(": ");
                sb.append(sqle.getMessage().replaceAll("\n", ""));
            } else {
                sb.append("Msg=");
                sb.append(sqle.getErrorCode());
                sb.append(": ");
                sb.append(sqle.getMessage().replaceAll("\n", ""));
            }
            if (discard) {
                _logger.info((Object)(this._prefix + sb.toString()));
            } else {
                _logger.error((Object)(this._prefix + sb.toString()));
            }
            if (discard) {
                return null;
            }
            return sqle;
        }
    }
}

