/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import asemon.utils.AseConnectionFactory;
import asemon.utils.StringUtil;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AseUrlHelper {
    private static Logger _logger = Logger.getLogger(AseUrlHelper.class);
    private static final long serialVersionUID = 1L;
    private static String _urlStart = "jdbc:sybase:Tds:";
    private String _originUrl = null;
    private String _serverName = null;
    private Map<String, List<String>> _hostPort = null;
    private String _dbname = null;
    private Map<String, String> _options = null;

    private AseUrlHelper() {
    }

    private AseUrlHelper(String originUrl, String serverName, Map<String, List<String>> hostPort, String dbname, Map<String, String> options) {
        this._originUrl = originUrl;
        this._serverName = serverName;
        this._hostPort = hostPort;
        this._dbname = dbname;
        this._options = options;
    }

    public String getServerName() {
        return this._serverName;
    }

    public String getHosts() {
        return this.getHosts(", ");
    }

    public String getHosts(String entrySep) {
        return StringUtil.toCommaStrMultiMapKey(this._hostPort, entrySep);
    }

    public String getPorts() {
        return this.getPorts(", ");
    }

    public String getPorts(String entrySep) {
        return StringUtil.toCommaStrMultiMapVal(this._hostPort, entrySep);
    }

    public int getHostPortCount() {
        if (this._hostPort == null) {
            return 0;
        }
        int count = 0;
        for (Map.Entry<String, List<String>> val : this._hostPort.entrySet()) {
            if (val instanceof List) {
                count += ((List)((Object)val)).size();
                continue;
            }
            ++count;
        }
        return count;
    }

    public Map<String, List<String>> getHostPortMap() {
        return this._hostPort;
    }

    public String[] getHostPortArr() {
        return StringUtil.commaStrToArray(this.getHostPortStr());
    }

    public String getHostPortStr() {
        return this.getHostPortStr(", ");
    }

    public String getHostPortStr(String entrySep) {
        return StringUtil.toCommaStrMultiMap(this._hostPort, ":", entrySep);
    }

    public String getDbname() {
        return this._dbname;
    }

    public String getOptions() {
        return this.getOptions(", ");
    }

    public String getOptions(String entrySep) {
        return StringUtil.toCommaStr(this._options, "=", entrySep);
    }

    public String getUrlOrigin() {
        return this._originUrl;
    }

    public String getUrl() {
        StringBuilder url = new StringBuilder();
        url.append(_urlStart);
        if (this._hostPort != null && this._hostPort.size() > 0) {
            url.append(StringUtil.toCommaStrMultiMap(this._hostPort, ":", ","));
        }
        if (this._dbname != null && !this._dbname.trim().equals("")) {
            url.append("/").append(this._dbname);
        }
        if (this._options != null && this._options.size() > 0) {
            url.append("?");
            url.append(StringUtil.toCommaStr(this._options, "=", "&"));
        }
        return url.toString();
    }

    public List<String> getUrlList() {
        LinkedList<String> urlList = new LinkedList<String>();
        if (this._hostPort != null && this._hostPort.size() > 0) {
            for (String host : this._hostPort.keySet()) {
                List<String> list = this._hostPort.get(host);
                if (list instanceof List) {
                    List<String> list2 = list;
                    for (String string : list2) {
                        urlList.add(this.composeUrlEntry(host, string));
                    }
                    continue;
                }
                urlList.add(this.composeUrlEntry(host, list));
            }
        }
        return urlList;
    }

    public String composeUrlEntry(String host, Object port) {
        StringBuilder urlEntry = new StringBuilder();
        urlEntry.append(_urlStart);
        urlEntry.append(host).append(":").append(port);
        if (this._dbname != null && !this._dbname.trim().equals("")) {
            urlEntry.append("/").append(this._dbname);
        }
        if (this._options != null && this._options.size() > 0) {
            urlEntry.append("?");
            urlEntry.append(StringUtil.toCommaStr(this._options, "=", "&"));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("composeUrlEntry: returns '" + urlEntry.toString() + "'."));
        }
        return urlEntry.toString();
    }

    public boolean hasMultiHostPort() {
        return this.getHostPortCount() > 1;
    }

    public String toString() {
        return super.toString();
    }

    public static AseUrlHelper parseUrl(String urlStr) throws ParseException {
        String urlStart = "jdbc:sybase:Tds:";
        if (!urlStr.startsWith(urlStart)) {
            throw new ParseException("The URL has to start with '" + urlStart + "'. The input looks like '" + urlStr + "'.", 0);
        }
        Map<String, List<String>> hostPort = null;
        String dbname = null;
        Map<String, String> options = null;
        String baseStr = null;
        String optionsStr = null;
        if (urlStr.indexOf("?") >= 0) {
            baseStr = urlStr.substring(0, urlStr.indexOf("?"));
            optionsStr = urlStr.substring(urlStr.indexOf("?") + 1);
            options = StringUtil.parseCommaStrToMap(optionsStr, "=", "&");
        } else {
            baseStr = urlStr;
        }
        if (baseStr.indexOf("/") >= 0) {
            dbname = baseStr.substring(baseStr.indexOf("/") + 1);
            baseStr = baseStr.substring(0, baseStr.indexOf("/"));
        }
        baseStr = baseStr.substring(urlStart.length());
        hostPort = StringUtil.parseCommaStrToMultiMap(baseStr, ":", ",");
        String serverName = AseConnectionFactory.getIServerName(hostPort);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"----------------------------------------------");
            _logger.debug((Object)("originUrl  = '" + urlStr + "'."));
            _logger.debug((Object)("serverName = '" + serverName + "'."));
            _logger.debug((Object)("hostPort   = '" + hostPort + "'."));
            _logger.debug((Object)("dbname     = '" + dbname + "'."));
            _logger.debug((Object)("options    = '" + options + "'."));
        }
        return new AseUrlHelper(urlStr, serverName, hostPort, dbname, options);
    }

    public static String buildUrlString(Map<String, List<String>> hostPort, String dbname, Map<String, String> options) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("AseUrlHelper.getUrlString(hostPort='" + hostPort + "', dbname='" + dbname + "', options='" + options + "')."));
        }
        if (hostPort == null) {
            throw new IllegalArgumentException("hostPort can't be null");
        }
        if (hostPort.isEmpty()) {
            throw new IllegalArgumentException("hostPort can't be empty");
        }
        String urlTemplate = AseConnectionFactory.getUrlTemplate();
        if (urlTemplate == null) {
            throw new IllegalArgumentException("The url template grabbed from AseConnectionFactory can't be null.");
        }
        if (urlTemplate.indexOf("HOST:PORT") == -1) {
            throw new IllegalArgumentException("The url template grabbed from AseConnectionFactory must contain 'HOST:PORT'. urlTemplate='" + urlTemplate + "'");
        }
        String url = urlTemplate;
        String hostPortStr = StringUtil.toCommaStrMultiMap(hostPort, ":", ",");
        url = url.replaceAll("HOST:PORT", hostPortStr);
        if (dbname != null && dbname.trim().length() > 0) {
            url = url + "/" + dbname;
        }
        if (options != null && options.size() > 0) {
            url = url + "?" + StringUtil.toCommaStr(options, "=", "&");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("AseUrlHelper.returns='" + url + "'."));
        }
        return url;
    }
}

