/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import asemon.utils.Encrypter;
import asemon.utils.MandatoryPropertyException;
import asemon.utils.OSCommand;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Configuration
extends Properties {
    private static final long serialVersionUID = 5707562050158600080L;
    private static final String ENCRYPTED_PREFIX = "encrypted:";
    public static final String SYSTEM_CONF = "SYSTEM_CONF";
    public static final String USER_CONF = "USER_CONF";
    public static final String USER_TEMP = "USER_TEMP";
    public static final String PCS = "PCS";
    private static Logger _logger = Logger.getLogger(Configuration.class);
    private static HashMap<String, Configuration> _instMap = new HashMap();
    private String _propFileName = null;
    private boolean _saveOnExit = false;
    private static String encrypterBaseKey = "qazZSE44wsxXDR555707562050158600080edcCFT66rfvVGY77";
    private String _embeddedMessage = "This file will be overwritten and maintained by asemon";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static String[] _searchOrder = new String[0];
    private static Configuration _combinedConfig = new CombinedConfiguration();

    public Configuration() {
    }

    public Configuration(String filename) {
        this.load(filename);
    }

    public static Configuration getInstance(String confName) {
        Configuration conf = _instMap.get(confName);
        if (conf == null) {
            _logger.warn((Object)("Cant find any configuration named '" + confName + "', creating a new one."));
            conf = new Configuration();
            _instMap.put(confName, conf);
        }
        return conf;
    }

    public static boolean hasInstance(String confName) {
        return _instMap.containsKey(confName);
    }

    public static void setInstance(String confName, Configuration configuration) {
        _instMap.put(confName, configuration);
    }

    public String getFilename() {
        return this._propFileName;
    }

    public void setFilename(String filename) {
        this._propFileName = filename;
    }

    public String getEmbeddedMessage() {
        return this._embeddedMessage;
    }

    public void setEmbeddedMessage(String embeddedMessage) {
        this._embeddedMessage = embeddedMessage;
    }

    public void setSaveOnExit(boolean b) {
        this._saveOnExit = b;
    }

    public void append(String str, String responsible) throws IOException {
        if (str == null) {
            return;
        }
        FileOutputStream os = new FileOutputStream(new File(this._propFileName), true);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "8859_1"));
        if (!str.endsWith("\n")) {
            str = str + "\n";
        }
        bw.write("\n");
        bw.write("\n");
        bw.write("#--------------------------------------------------------------------\n");
        bw.write("# The below entries was Append at: " + new Date().toString() + "\n");
        bw.write("# By: " + responsible + "\n");
        bw.write("#--------------------------------------------------------------------\n");
        bw.write(str);
        bw.write("#--------------------------------------------------------------------\n");
        bw.flush();
        os.close();
    }

    public void save() {
        if (this._propFileName == null) {
            _logger.debug((Object)"No filename has been assigned to this property file, cant save...");
            return;
        }
        try {
            FileOutputStream os = new FileOutputStream(new File(this._propFileName));
            this.store(os, this.getEmbeddedMessage());
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        super.clear();
        this.load(this._propFileName);
    }

    public void load() {
        this.load(this._propFileName);
    }

    public void load(String filename) {
        this.setFilename(filename);
        if (filename == null) {
            _logger.warn((Object)"No config file was passed, filename=null, continuing anyway.");
            return;
        }
        try {
            FileInputStream in = new FileInputStream(filename);
            super.load(in);
            in.close();
        }
        catch (FileNotFoundException e) {
            _logger.warn((Object)("The file '" + filename + "' could not be loaded, continuing anyway."));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeAll(String prefix) {
        Iterator<Object> it = this.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(prefix)) continue;
            it.remove();
        }
    }

    public List<String> getKeys(String prefix) {
        ArrayList<String> matchingKeys = new ArrayList<String>();
        for (String string : this.keySet()) {
            if (!string.startsWith(prefix)) continue;
            matchingKeys.add(string);
        }
        Collections.sort(matchingKeys);
        return matchingKeys;
    }

    public List<String> getUniqueSubKeys(String prefix, boolean keepPrefix) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        for (String key : this.getKeys(prefix)) {
            String name;
            int start = keepPrefix ? 0 : prefix.length();
            int end = key.indexOf(".", prefix.length());
            if (end < 0) {
                end = key.length();
            }
            if (uniqueNames.contains(name = key.substring(start, end))) continue;
            uniqueNames.add(name);
        }
        Collections.sort(uniqueNames);
        return uniqueNames;
    }

    public boolean hasProperty(String propName) {
        return this.getProperty(propName) != null;
    }

    public int getIntMandatoryProperty(String propName) throws MandatoryPropertyException {
        String val = this.getProperty(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("The property '" + propName + "' must be a number. I found value '" + val + "'.");
        }
    }

    public int getIntProperty(String propName) {
        String val = this.getProperty(propName);
        return Integer.parseInt(val);
    }

    public int getIntProperty(String propName, int defaultValue) {
        return this.getIntProperty(propName, Integer.toString(defaultValue));
    }

    public int getIntProperty(String propName, String defaultValue) {
        String val = this.getProperty(propName, defaultValue);
        if (val != null && val.equals("")) {
            val = defaultValue;
        }
        return Integer.parseInt(val);
    }

    public long getLongMandatoryProperty(String propName) throws MandatoryPropertyException {
        String val = this.getProperty(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        return Long.parseLong(val);
    }

    public long getLongProperty(String propName) {
        String val = this.getProperty(propName);
        return Long.parseLong(val);
    }

    public long getLongProperty(String propName, long defaultValue) {
        return this.getLongProperty(propName, Long.toString(defaultValue));
    }

    public long getLongProperty(String propName, String defaultValue) {
        String val = this.getProperty(propName, defaultValue);
        if (val != null && val.equals("")) {
            val = defaultValue;
        }
        return Long.parseLong(val);
    }

    public boolean getBooleanMandatoryProperty(String propName) throws MandatoryPropertyException {
        String val = this.getProperty(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        return val.equalsIgnoreCase("true");
    }

    public boolean getBooleanProperty(String propName, boolean defaultValue) {
        String val = this.getProperty(propName, Boolean.toString(defaultValue));
        if (val == null) {
            return false;
        }
        return val.equalsIgnoreCase("true");
    }

    public boolean getBooleanProperty(String propName, String defaultValue) {
        String val = this.getProperty(propName, defaultValue);
        if (val == null) {
            return false;
        }
        return val.equalsIgnoreCase("true");
    }

    public String getMandatoryProperty(String propName) throws MandatoryPropertyException {
        String val = this.getProperty(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        return val;
    }

    @Override
    public String getProperty(String propName) {
        String val = super.getProperty(propName);
        if (val != null) {
            val = val.trim();
        }
        return this.parseProperty(propName, val);
    }

    @Override
    public String getProperty(String propName, String defaultValue) {
        String val = this.getProperty(propName);
        return val != null ? val : defaultValue;
    }

    public String getMandatoryPropertyRaw(String propName) throws MandatoryPropertyException {
        String val = this.getPropertyRaw(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        return val;
    }

    public String getPropertyRaw(String propName) {
        String val = super.getProperty(propName);
        if (val != null) {
            val = val.trim();
        }
        return val;
    }

    public String getPropertyRaw(String propName, String defaultValue) {
        String val = this.getPropertyRaw(propName);
        return val != null ? val : defaultValue;
    }

    public static String encryptPropertyValue(String propName, String str) {
        Encrypter propEncrypter = new Encrypter(encrypterBaseKey + propName);
        String encryptedStr = propEncrypter.encrypt(str);
        return ENCRYPTED_PREFIX + encryptedStr;
    }

    public Object setEncrypedProperty(String propName, String str) {
        return super.setProperty(propName, Configuration.encryptPropertyValue(propName, str));
    }

    @Override
    public Object setProperty(String propName, String str) {
        return super.setProperty(propName, str);
    }

    public int setProperty(String propName, int t) {
        Object prev = this.setProperty(propName, Integer.toString(t));
        return prev == null ? -1 : Integer.parseInt((String)prev);
    }

    public long setProperty(String propName, long l) {
        Object prev = this.setProperty(propName, Long.toString(l));
        return prev == null ? -1L : Long.parseLong((String)prev);
    }

    public boolean setProperty(String propName, boolean b) {
        Object prev = this.setProperty(propName, Boolean.toString(b));
        return prev == null ? false : Boolean.parseBoolean((String)prev);
    }

    public String parseProperty(String propName, String val) {
        if (val == null) {
            return null;
        }
        Pattern compiledRegex = Pattern.compile("\\$\\{.*\\}");
        while (compiledRegex.matcher(val).find()) {
            String envName;
            String envVal;
            block11: {
                envVal = null;
                envName = val.substring(val.indexOf("${") + 2, val.indexOf("}"));
                try {
                    envVal = System.getenv(envName);
                }
                catch (Throwable t) {
                    envVal = System.getProperty(envName);
                    if (envVal != null) break block11;
                    _logger.warn((Object)("System.getenv(): Is not supported on this platform or version of Java. Please pass '-D" + envName + "=value' when starting the JVM."));
                }
            }
            if (envVal == null) {
                _logger.warn((Object)("The Environment variable '" + envName + "' can't be found, replacing it with an empty string ''."));
                envVal = "";
            }
            envVal = envVal.replace('\\', '/');
            _logger.debug((Object)("The Environment variable '" + envName + "' will be substituted with the value of '" + envVal + "'."));
            val = val.replaceFirst("\\$\\{" + envName + "\\}", envVal);
        }
        if (val.startsWith("prop:")) {
            val = this.getProperty(val.substring("prop:".length()));
        }
        if (val.startsWith(ENCRYPTED_PREFIX)) {
            String decryptedStr;
            val = val.substring(ENCRYPTED_PREFIX.length());
            Encrypter propEncrypter = new Encrypter(encrypterBaseKey + propName);
            val = decryptedStr = propEncrypter.decrypt(val);
        }
        if (val != null) {
            if (val.startsWith("oscmd:")) {
                val = this.osCmd(val.substring("oscmd:".length()), false);
            } else if (val.startsWith("oscmd-n:")) {
                val = this.osCmd(val.substring("oscmd-n:".length()), true);
            }
        }
        return val;
    }

    private String osCmd(String osCmdStr, boolean discardNewlines) {
        try {
            OSCommand osCmd = OSCommand.execute(osCmdStr);
            String retVal = osCmd.getOutput();
            if (discardNewlines) {
                retVal = retVal.replaceAll("\r", "");
                retVal = retVal.replaceAll("\n", "");
            }
            return retVal;
        }
        catch (IOException e) {
            _logger.error((Object)("Problems when executing the OS Command '" + osCmdStr + "'. Cought: " + e));
            return e.toString();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._saveOnExit) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void store(OutputStream outputstream, String s) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputstream, "8859_1"));
        Configuration.writeln(bw, "#=======================================================");
        if (s != null) {
            Configuration.writeln(bw, "# " + s);
        }
        Configuration.writeln(bw, "# Last save time: " + new Date().toString());
        Configuration.writeln(bw, "#-------------------------------------------------------");
        Configuration.writeln(bw, "");
        String sectionStr = "";
        String sectionStrSave = "";
        bw.flush();
        boolean escUnicode = true;
        Configuration configuration = this;
        synchronized (configuration) {
            TreeMap<Object, Object> aSortedOne = new TreeMap<Object, Object>(this);
            for (String key : aSortedOne.keySet()) {
                String val = (String)this.get(key);
                int end = (key = this.saveConvert(key, true, escUnicode)).indexOf(".");
                if (end < 0) {
                    end = key.length();
                }
                if (!(sectionStr = key.substring(0, end)).equals(sectionStrSave)) {
                    Configuration.writeln(bw, "");
                    sectionStrSave = sectionStr;
                }
                val = this.saveConvert(val, false, escUnicode);
                bw.write(key + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    private static void writeln(BufferedWriter bufferedwriter, String s) throws IOException {
        bufferedwriter.write(s);
        bufferedwriter.newLine();
    }

    private static char toHex(int i) {
        return hexDigit[i & 0xF];
    }

    private String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(Configuration.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(Configuration.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(Configuration.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(Configuration.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static void setSearchOrder(String ... searchOrder) {
        _searchOrder = searchOrder;
    }

    public static String[] getSearchOrder() {
        return _searchOrder;
    }

    public static Configuration getCombinedConfiguration() {
        return _combinedConfig;
    }

    public static Configuration parse(String parseStr) throws ParseException {
        return Configuration.parse(parseStr, ",");
    }

    public static Configuration parse(String parseStr, String delimiter) throws ParseException {
        Configuration conf = new Configuration();
        String[] strArr = parseStr.split(delimiter);
        for (int i = 0; i < strArr.length; ++i) {
            strArr[i] = strArr[i].trim();
            _logger.trace((Object)("parse() strArr[" + i + "]='" + strArr[i] + "'."));
            String[] strKeyVal = strArr[i].split("=");
            if (strKeyVal.length < 2) {
                throw new ParseException("Faulty key=value representation '" + strArr[i] + "' at position '" + i + "' in the string '" + strArr[i] + "'.", i);
            }
            String key = strKeyVal[0].trim();
            String val = strKeyVal[1].trim();
            conf.put(key, val);
        }
        return conf;
    }

    public void add(Configuration conf) {
        this.putAll((Map<?, ?>)conf);
    }

    public static void main(String[] args) {
        Configuration tConf = new Configuration();
        Configuration uConf = new Configuration();
        Configuration sConf = new Configuration();
        tConf.setFilename("c:\\tmpConfigFile.prop");
        uConf.setFilename("c:\\userConfigFile.prop");
        sConf.setFilename("c:\\systemConfigFile.prop");
        Configuration.setInstance(USER_TEMP, tConf);
        Configuration.setInstance(USER_CONF, uConf);
        Configuration.setInstance(SYSTEM_CONF, sConf);
        Configuration.setSearchOrder(USER_TEMP, USER_CONF, SYSTEM_CONF);
        tConf.setProperty("tmp1", "-tmp1-");
        uConf.setProperty("user1", "-user1-");
        sConf.setProperty("system1", "-system1-");
        tConf.setProperty("prop1", "-prop1-tmp-");
        uConf.setProperty("prop1", "-prop1-user-");
        sConf.setProperty("prop1", "-prop1-system-");
        tConf.setProperty("prop2.p1", "-tmp-prop2.p1-");
        tConf.setProperty("prop2.p2", "-tmp-prop2.p2-");
        tConf.setProperty("prop2.p3", "-tmp-prop2.p3-");
        uConf.setProperty("prop2.p2", "-user-prop2.p2-");
        uConf.setProperty("prop2.p3", "-user-prop2.p3-");
        uConf.setProperty("prop2.p4", "-user-prop2.p4-");
        sConf.setProperty("prop2.p1", "-system-prop2.p1-");
        sConf.setProperty("prop2.p3", "-system-prop2.p3-");
        sConf.setProperty("prop2.p5", "-system-prop2.p5-");
        tConf.setProperty("udc.prop2.p1", "-tmp-udc.prop2.p1-");
        tConf.setProperty("udc.prop2.p2", "-tmp-udc.prop2.p2-");
        tConf.setProperty("udc.prop2.p3", "-tmp-udc.prop2.p3-");
        uConf.setProperty("udc.prop2.p2", "-user-udc.prop2.p2-");
        uConf.setProperty("udc.prop2.p3", "-user-udc.prop2.p3-");
        uConf.setProperty("udc.prop2.p4", "-user-udc.prop2.p4-");
        sConf.setProperty("udc.prop2.p1", "-system-udc.prop2.p1-");
        sConf.setProperty("udc.prop2.p3", "-system-udc.prop2.p3-");
        sConf.setProperty("udc.prop2.p5", "-system-udc.prop2.p5-");
        Configuration cfg = Configuration.getCombinedConfiguration();
        System.out.println("tmp      FILENAME='" + tConf.getFilename() + "'.");
        System.out.println("user     FILENAME='" + uConf.getFilename() + "'.");
        System.out.println("system   FILENAME='" + sConf.getFilename() + "'.");
        System.out.println("Combined FILENAME='" + cfg.getFilename() + "'.");
        System.out.println();
        System.out.println("TMP:    tmp1    = '" + tConf.getProperty("tmp1") + "'.");
        System.out.println("USER:   user1   = '" + uConf.getProperty("user1") + "'.");
        System.out.println("SYSTEM: system1 = '" + sConf.getProperty("system1") + "'.");
        System.out.println();
        System.out.println("notFound= '" + cfg.getProperty("notFound") + "'.");
        System.out.println("tmp1    = '" + cfg.getProperty("tmp1") + "'.");
        System.out.println("user1   = '" + cfg.getProperty("user1") + "'.");
        System.out.println("system1 = '" + cfg.getProperty("system1") + "'.");
        System.out.println();
        System.out.println("prop1 = '" + cfg.getProperty("prop1") + "'.");
        System.out.println();
        System.out.println("prop2.p1 = '" + cfg.getProperty("prop2.p1") + "'.");
        System.out.println("prop2.p2 = '" + cfg.getProperty("prop2.p2") + "'.");
        System.out.println("prop2.p3 = '" + cfg.getProperty("prop2.p3") + "'.");
        System.out.println("prop2.p4 = '" + cfg.getProperty("prop2.p4") + "'.");
        System.out.println("prop2.p5 = '" + cfg.getProperty("prop2.p5") + "'.");
        System.out.println();
        System.out.println("getKeys('prop2.')     = '" + cfg.getKeys("prop2.") + "'.");
        System.out.println("getKeys('udc.prop2.') = '" + cfg.getKeys("udc.prop2.") + "'.");
        System.out.println();
        System.out.println("getUniqueSubKeys(TMP: 'udc.prop2.',true)  = '" + tConf.getUniqueSubKeys("udc.prop2.", true) + "'.");
        System.out.println("getUniqueSubKeys(TMP: 'udc.prop2.',false) = '" + tConf.getUniqueSubKeys("udc.prop2.", false) + "'.");
        System.out.println();
        System.out.println("getUniqueSubKeys('prop2.',true)  = '" + cfg.getUniqueSubKeys("prop2.", true) + "'.");
        System.out.println("getUniqueSubKeys('prop2.',false) = '" + cfg.getUniqueSubKeys("prop2.", false) + "'.");
    }

    private static class CombinedConfiguration
    extends Configuration {
        private static final long serialVersionUID = 1L;

        private CombinedConfiguration() {
        }

        @Override
        public void save() {
            throw new RuntimeException("save() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public Object setEncrypedProperty(String propName, String str) {
            throw new RuntimeException("setEncrypedProperty() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public Object setProperty(String propName, String str) {
            throw new RuntimeException("setProperty() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public int setProperty(String propName, int t) {
            throw new RuntimeException("setProperty() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public long setProperty(String propName, long l) {
            throw new RuntimeException("setProperty() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public boolean setProperty(String propName, boolean b) {
            throw new RuntimeException("setProperty() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public void setFilename(String filename) {
            throw new RuntimeException("setFilename() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public String getEmbeddedMessage() {
            throw new RuntimeException("getEmbeddedMessage() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public void setEmbeddedMessage(String embeddedMessage) {
            throw new RuntimeException("setEmbeddedMessage() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public void setSaveOnExit(boolean b) {
            throw new RuntimeException("setSaveOnExit() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public void append(String str, String responsible) throws IOException {
            throw new RuntimeException("append() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public void removeAll(String prefix) {
            throw new RuntimeException("removeAll() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public String getFilename() {
            String filenames = "";
            for (String instName : _searchOrder) {
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null) continue;
                filenames = filenames + conf.getFilename() + ", ";
            }
            if (filenames.endsWith(", ")) {
                filenames = filenames.substring(0, filenames.length() - 2);
            }
            return "Combined Configuration of files: " + filenames;
        }

        @Override
        public boolean hasProperty(String propName) {
            for (String instName : _searchOrder) {
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null || !conf.hasProperty(propName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<String> getKeys(String prefix) {
            ArrayList<String> matchingKeys = new ArrayList<String>();
            for (String instName : _searchOrder) {
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null) continue;
                for (String string : conf.keySet()) {
                    if (!string.startsWith(prefix) || matchingKeys.contains(string)) continue;
                    matchingKeys.add(string);
                }
            }
            Collections.sort(matchingKeys);
            return matchingKeys;
        }

        @Override
        public List<String> getUniqueSubKeys(String prefix, boolean keepPrefix) {
            ArrayList<String> uniqueNames = new ArrayList<String>();
            for (String instName : _searchOrder) {
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null) continue;
                for (String key : conf.getKeys(prefix)) {
                    String name;
                    int start = keepPrefix ? 0 : prefix.length();
                    int end = key.indexOf(".", prefix.length());
                    if (end < 0) {
                        end = key.length();
                    }
                    if (uniqueNames.contains(name = key.substring(start, end))) continue;
                    uniqueNames.add(name);
                }
            }
            Collections.sort(uniqueNames);
            return uniqueNames;
        }

        @Override
        public String getMandatoryProperty(String propName) throws MandatoryPropertyException {
            String val = this.getProperty(propName);
            if (val == null) {
                throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
            }
            return val;
        }

        @Override
        public String getProperty(String propName) {
            for (String instName : _searchOrder) {
                String val;
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null || (val = conf.getProperty(propName)) == null) continue;
                return val;
            }
            return null;
        }

        @Override
        public String getProperty(String propName, String defaultValue) {
            String val = this.getProperty(propName);
            return val != null ? val : defaultValue;
        }

        @Override
        public String getMandatoryPropertyRaw(String propName) throws MandatoryPropertyException {
            String val = this.getPropertyRaw(propName);
            if (val == null) {
                throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
            }
            return val;
        }

        @Override
        public String getPropertyRaw(String propName) {
            for (String instName : _searchOrder) {
                String val;
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null || (val = conf.getPropertyRaw(propName)) == null) continue;
                return val;
            }
            return null;
        }

        @Override
        public String getPropertyRaw(String propName, String defaultValue) {
            String val = this.getPropertyRaw(propName);
            return val != null ? val : defaultValue;
        }
    }
}

