/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Debug {
    private static Map<String, String> _knownDebugOptions = new LinkedHashMap<String, String>();
    private static Set<String> _debug = new HashSet<String>();
    private static boolean _caseSensitive = true;

    public static boolean hasDebug(String debugOption) {
        return _debug.contains(_caseSensitive ? debugOption : debugOption.toLowerCase());
    }

    public static void addDebug(String debugOption) {
        if (debugOption == null) {
            throw new IllegalArgumentException("debug option can't be null.");
        }
        _debug.add(_caseSensitive ? debugOption : debugOption.toLowerCase());
    }

    public static void removeDebug(String debugOption) {
        if (debugOption == null) {
            throw new IllegalArgumentException("debug option can't be null.");
        }
        _debug.remove(_caseSensitive ? debugOption : debugOption.toLowerCase());
    }

    public static Set<String> getDebugs() {
        return _debug;
    }

    public static String getDebugsString() {
        String ret = "";
        for (String str : _debug) {
            ret = ret + str + ", ";
        }
        return ret;
    }

    public static void addKnownDebug(String debugOption, String description) {
        if (debugOption == null) {
            throw new IllegalArgumentException("debug option can't be null.");
        }
        if (description == null) {
            throw new IllegalArgumentException("description can't be null.");
        }
        _knownDebugOptions.put(debugOption, description);
    }

    public static Map<String, String> getKnownDebugs() {
        return _knownDebugOptions;
    }
}

