/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import asemon.utils.MandatoryPropertyException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class PropPropEntry
implements Iterable<String> {
    private static Logger _logger = Logger.getLogger(PropPropEntry.class);
    private LinkedHashMap<String, Entry> _keys = new LinkedHashMap();

    @Override
    public Iterator<String> iterator() {
        return this._keys.keySet().iterator();
    }

    public PropPropEntry() {
    }

    public PropPropEntry(String confVal) {
        this.parse(confVal);
    }

    public void parse(String confVal) {
        String[] strArr = confVal.split(";");
        for (int i = 0; i < strArr.length; ++i) {
            try {
                Entry entry = new Entry(strArr[i]);
                this._keys.put(entry._propName, entry);
                continue;
            }
            catch (ParseException e) {
                _logger.info((Object)("Problems parsing '" + confVal + "' with string '" + strArr[i] + "'. Caught: " + e));
            }
        }
    }

    public void put(String mainKeyName, Properties props) {
        Entry entry = new Entry(mainKeyName, props);
        this._keys.put(mainKeyName, entry);
    }

    public void put(String mainKeyName, Map<String, String> map) {
        Entry entry = new Entry(mainKeyName, map);
        this._keys.put(mainKeyName, entry);
    }

    public void put(String mainKeyName, String subKeyName, String value) {
        Entry entry = this._keys.get(mainKeyName);
        if (entry == null) {
            entry = new Entry();
            entry.setName(mainKeyName);
        }
        entry.put(subKeyName, value);
        this._keys.put(mainKeyName, entry);
    }

    public Set<String> keySet() {
        return this._keys.keySet();
    }

    public Map<String, String> getPropertyMap(String name) {
        Entry entry = this._keys.get(name);
        if (entry == null) {
            return null;
        }
        return entry;
    }

    public Properties getPropertyProp(String name) {
        Entry entry = this._keys.get(name);
        if (entry == null) {
            return null;
        }
        return entry.toProperties();
    }

    public String getPropertyString(String name) {
        Entry entry = this._keys.get(name);
        if (entry == null) {
            return null;
        }
        return entry.toString();
    }

    public boolean hasProperty(String mainKey, String propName) {
        return this.getProperty(mainKey, propName) != null;
    }

    public int getIntMandatoryProperty(String mainKey, String propName) throws MandatoryPropertyException {
        String val = this.getProperty(mainKey, propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + mainKey + "', '" + propName + "' is mandatory.");
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("The property '" + mainKey + "', '" + propName + "' must be a number. I found value '" + val + "'.");
        }
    }

    public int getIntProperty(String mainKey, String propName) {
        String val = this.getProperty(mainKey, propName);
        return Integer.parseInt(val);
    }

    public int getIntProperty(String mainKey, String propName, int defaultValue) {
        String val = this.getProperty(mainKey, propName, Integer.toString(defaultValue));
        return Integer.parseInt(val);
    }

    public int getIntProperty(String mainKey, String propName, String defaultValue) {
        String val = this.getProperty(mainKey, propName, defaultValue);
        return Integer.parseInt(val);
    }

    public long getLongMandatoryProperty(String mainKey, String propName) throws MandatoryPropertyException {
        String val = this.getProperty(mainKey, propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + mainKey + "', '" + propName + "' is mandatory.");
        }
        return Long.parseLong(val);
    }

    public long getLongProperty(String mainKey, String propName) {
        String val = this.getProperty(mainKey, propName);
        return Long.parseLong(val);
    }

    public long getLongProperty(String mainKey, String propName, long defaultValue) {
        String val = this.getProperty(mainKey, propName, Long.toString(defaultValue));
        return Long.parseLong(val);
    }

    public long getLongProperty(String mainKey, String propName, String defaultValue) {
        String val = this.getProperty(mainKey, propName, defaultValue);
        return Long.parseLong(val);
    }

    public boolean getBooleanMandatoryProperty(String mainKey, String propName) throws MandatoryPropertyException {
        String val = this.getProperty(mainKey, propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + mainKey + "', '" + propName + "' is mandatory.");
        }
        return val.equalsIgnoreCase("true");
    }

    public boolean getBooleanProperty(String mainKey, String propName, boolean defaultValue) {
        String val = this.getProperty(mainKey, propName, Boolean.toString(defaultValue));
        if (val == null) {
            return false;
        }
        return val.equalsIgnoreCase("true");
    }

    public boolean getBooleanProperty(String mainKey, String propName, String defaultValue) {
        String val = this.getProperty(mainKey, propName, defaultValue);
        if (val == null) {
            return false;
        }
        return val.equalsIgnoreCase("true");
    }

    public String getMandatoryProperty(String mainKey, String propName) throws MandatoryPropertyException {
        String val = this.getProperty(mainKey, propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + mainKey + "', '" + propName + "' is mandatory.");
        }
        val = val.trim();
        return val;
    }

    public String getProperty(String mainKey, String propName) {
        Entry entry = this._keys.get(mainKey);
        if (entry == null) {
            return null;
        }
        String val = (String)entry.get(propName);
        if (val != null) {
            val = val.trim();
        }
        return val;
    }

    public String getProperty(String mainKey, String propName, String defaultValue) {
        String val = this.getProperty(mainKey, propName);
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public String toString() {
        if (this._keys.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Entry entry : this._keys.values()) {
            sb.append(entry.toString()).append("; ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    public static void main(String[] args) {
        PropPropEntry ppe = null;
        ppe = new PropPropEntry("Cm1={p1=1, p2=2, p3=3};Cm2={p1=1,p2=2,p3=3}; Cm3={ p1 = 1, p2 = 2, p3 = 3 };");
        System.out.println("Test1: '" + ppe + "'.");
        System.out.println("Test1.getPropertyProp(Cm1): '" + ppe.getPropertyProp("Cm1") + "'.");
        System.out.println();
        ppe = new PropPropEntry("DBID={modelPos=0,viewPos=0,isVisible=true,sortOrder=UNSORTED}; ObjectID={modelPos=1,viewPos=1,isVisible=true,sortOrder=UNSORTED}; IndexID={modelPos=2,viewPos=2,isVisible=true,sortOrder=UNSORTED}; DBName={modelPos=3,viewPos=3,isVisible=true,sortOrder=UNSORTED}; ObjectName={modelPos=4,viewPos=4,isVisible=true,sortOrder=UNSORTED}; ObjectType={modelPos=5,viewPos=5,isVisible=true,sortOrder=UNSORTED}; PartitionID={modelPos=6,viewPos=6,isVisible=true,sortOrder=UNSORTED}; PartitionName={modelPos=7,viewPos=7,isVisible=true,sortOrder=UNSORTED}; TotalSizeKB={modelPos=8,viewPos=8,isVisible=true,sortOrder=UNSORTED}; CachedKB={modelPos=9,viewPos=9,isVisible=true,sortOrder=UNSORTED}; CacheName={modelPos=10,viewPos=10,isVisible=true,sortOrder=UNSORTED}");
        System.out.println("Test2: '" + ppe + "'.");
        System.out.println();
        ppe = new PropPropEntry();
        ppe.put("CM1", "p1", "v1");
        ppe.put("CM1", "p2", "v2");
        ppe.put("CM1", "p3", "v3");
        ppe.put("CM2", "p1", "v1");
        ppe.put("CM2", "p2", "v2");
        System.out.println("Test3: '" + ppe + "'.");
        System.out.println();
        ppe = new PropPropEntry("Objects={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Processes={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Databases={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Temp Db={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Waits={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Engines={postpone=0,paused=false,bg=true,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; System Load={postpone=0,paused=false,bg=false,resetNC20=false,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Data Caches={postpone=0,paused=false,bg=true,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Pools={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Devices={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; IO Sum={postpone=0,paused=false,bg=true,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; IO Queue={postpone=0,paused=false,bg=true,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Spinlock Sum={postpone=300,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Sysmon Raw={postpone=300,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; RepAgent={postpone=300,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Cached Procedures={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Procedure Cache={postpone=0,paused=false,bg=true,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Procedure Call Stack={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Cached Objects={postpone=600,paused=false,bg=false,resetNC20=false,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Errorlog={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=false,pcsRate=false}; Deadlock={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=false,pcsRate=false}; Proc Cache Module Usage={postpone=0,paused=false,bg=false,resetNC20=false,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Proc Cache Memory Usage={postpone=0,paused=false,bg=false,resetNC20=false,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Statement Cache={postpone=0,paused=false,bg=false,resetNC20=false,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Statement Cache Details={postpone=0,paused=false,bg=false,resetNC20=false,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Active Objects={postpone=0,paused=false,bg=false,resetNC20=false,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Active Statements={postpone=0,paused=false,bg=false,resetNC20=true,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Blocking={postpone=0,paused=false,bg=false,resetNC20=false,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; Missing Statistics={postpone=0,paused=false,bg=false,resetNC20=false,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}; sp_monitorconfig={postpone=600,paused=false,bg=false,resetNC20=false,storePcs=false,pcsAbs=true,pcsDiff=true,pcsRate=true}");
        System.out.println("TestX: '" + ppe + "'.");
        System.out.println();
    }

    public class Entry
    extends LinkedHashMap<String, String> {
        private static final long serialVersionUID = 1L;
        private String _propName = null;

        public void setName(String name) {
            this._propName = name;
        }

        public String getName() {
            return this._propName;
        }

        public Entry() {
        }

        public Entry(String name, Map<String, String> map) {
            this._propName = name;
            this.putAll(map);
        }

        public Entry(String name, Properties props) {
            this._propName = name;
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.put(key, props.getProperty(key));
            }
        }

        public Entry(boolean keyVal, String propName, String valStr) throws ParseException {
            Entry e = this;
            valStr = valStr.trim();
            e._propName = propName;
            if (keyVal) {
                if (e._propName == null) {
                    e._propName = "";
                }
                int startPos = valStr.indexOf("={");
                int endPos = valStr.lastIndexOf("}");
                if (startPos == -1) {
                    throw new ParseException("Can't find '={' in the input string '" + valStr + "'.", 0);
                }
                if (endPos == -1) {
                    throw new ParseException("Can't find ending '}' in the input string '" + valStr + "'.", 0);
                }
                e._propName = valStr.substring(0, startPos).trim();
                valStr = valStr.substring(startPos + 2, endPos);
            }
            String[] strArr = valStr.split(",");
            for (int i = 0; i < strArr.length; ++i) {
                strArr[i] = strArr[i].trim();
                _logger.trace((Object)("parse() colName='" + e._propName + "': i=" + i + ", keyVal='" + strArr[i] + "'."));
                String[] strKeyVal = strArr[i].split("=");
                if (strKeyVal.length < 2) {
                    _logger.info((Object)("Faulty key=value representation '" + strArr[i] + "' at position '" + i + "' in the string '" + strArr[i] + "'."));
                    continue;
                }
                String key = strKeyVal[0].trim();
                String val = strKeyVal[1].trim();
                e.put(key, val);
            }
        }

        public Entry(String propsStr) throws ParseException {
            this(true, null, propsStr);
        }

        public Entry(String name, String propsStr) throws ParseException {
            this(false, name, propsStr);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this._propName != null) {
                sb.append(this._propName).append("={");
            }
            for (Map.Entry entry : this.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                sb.append(key).append("=").append(val).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            if (this._propName != null) {
                sb.append("}");
            }
            return sb.toString();
        }

        public Map<String, String> getMap() {
            return this;
        }

        public Properties toProperties() {
            Properties props = new Properties();
            for (Map.Entry entry : this.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                props.setProperty(key, val);
            }
            return props;
        }
    }
}

