/*
 * Decompiled with CFR 0.152.
 */
package asemon.xmenu;

import asemon.utils.ConnectionFactory;
import asemon.xmenu.XmenuAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class TablePopupAction
implements ActionListener {
    private static Logger _logger = Logger.getLogger(TablePopupAction.class);
    private String _menuName;
    private String _connName;
    private String _classname;
    private String _config;
    private List<String> _params;
    private Properties _menuProps;
    private Properties _allProps;
    private XmenuAction _xmenuObject;
    private JTable _table;
    private ConnectionFactory _connFactory;
    private boolean _closeConnOnExit;

    public TablePopupAction(String menuName, String connName, String classname, List<String> params, String config, Properties menuProps, Properties allProps, JTable table, ConnectionFactory connFactory, boolean closeConnOnExit) {
        this._menuName = menuName;
        this._connName = connName != null ? connName : classname;
        this._classname = classname;
        this._params = params;
        this._config = config;
        this._menuProps = menuProps;
        this._allProps = allProps;
        this._table = table;
        this._connFactory = connFactory;
        this._closeConnOnExit = closeConnOnExit;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        String s = "Action event detected.    Event source: " + source.getText() + " (an instance of " + source + ")";
        _logger.debug((Object)("PopupMenuAction: " + s));
        _logger.debug((Object)("PopupMenuAction._classname: " + this._classname));
        _logger.debug((Object)("PopupMenuAction._params: " + this._params.toString()));
        LinkedHashMap<String, String> paramsVal = this.getParamValues();
        if (paramsVal == null) {
            return;
        }
        this.loadClass();
        if (this._xmenuObject != null) {
            this._xmenuObject.setMenuName(this._menuName);
            this._xmenuObject.setParamValues(paramsVal);
            this._xmenuObject.setConfig(this._config);
            this._xmenuObject.setMenuProperties(this._menuProps);
            this._xmenuObject.setAllProperties(this._allProps);
            this._xmenuObject.setConnection(this._connFactory.getConnection(this._connName));
            this._xmenuObject.setCloseConnOnExit(this._closeConnOnExit);
            this._xmenuObject.doWork();
        }
    }

    public int getParamCount() {
        return this._params.size();
    }

    public String getParam(int i) {
        return this._params.get(i);
    }

    public void loadClass() {
        this._xmenuObject = null;
        try {
            Class<?> c = Class.forName(this._classname);
            this._xmenuObject = (XmenuAction)c.newInstance();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Trying to load classname '" + this._classname + "'. Found the following error:\n." + e, "Error", 0);
        }
    }

    public LinkedHashMap<String, String> getParamValues() {
        int selectedRow;
        LinkedHashMap<String, String> paramValues = new LinkedHashMap<String, String>();
        int row = selectedRow = this._table.getSelectedRow();
        if (this._table instanceof JXTable) {
            row = ((JXTable)this._table).convertRowIndexToModel(selectedRow);
        }
        _logger.debug((Object)("PopupMenuAction: selected row is " + row));
        for (int p = 0; p < this._params.size(); ++p) {
            String val;
            String param = this._params.get(p);
            int colPos = -1;
            for (int c = 0; c < this._table.getColumnCount(); ++c) {
                String colName = this._table.getColumnName(c);
                if (!colName.equalsIgnoreCase(param)) continue;
                colPos = c;
                break;
            }
            _logger.debug((Object)("PopupMenuAction: column name '" + param + "' has table index " + colPos + "."));
            TableModel model = this._table.getModel();
            if (colPos >= 0) {
                Object obj = model.getValueAt(row, colPos);
                val = "";
                if (obj == null) {
                    JOptionPane.showMessageDialog(null, "The value for column '" + param + "' can not be a NULL or empty.", "Error", 0);
                    return null;
                }
                val = obj.toString().trim();
            } else {
                _logger.debug((Object)("PopupMenuAction: looking for column name '" + param + "' which could NOT be found."));
                JOptionPane.showMessageDialog(null, "looking for column name '" + param + "' which could NOT be found in the current result set.", "Error", 0);
                return null;
            }
            paramValues.put(param, val);
            _logger.debug((Object)("PopupMenuAction: column name '" + param + "' has value '" + val + "'."));
        }
        return paramValues;
    }
}

