/*
 * Decompiled with CFR 0.152.
 */
package asemon.xmenu;

import asemon.gui.TabularCntrPanel;
import asemon.utils.Configuration;
import asemon.utils.ConnectionFactory;
import asemon.utils.SwingUtils;
import asemon.xmenu.TablePopupAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class TablePopupFactory {
    private static Logger _logger = Logger.getLogger(TablePopupFactory.class);
    public static final String TABLE_PUPUP_MENU_PREFIX = "table.menu.";
    public static final String ENABLE_MENU_ALWAYS = "alwaysEnabled";
    public static final String ENABLE_MENU_IF_ON_A_ROW = "enabledIfOnrow";
    public static final String ENABLE_MENU_ROW_IS_SELECTED = "enabledIfRowIsSelected";

    private static Component getPopupMenuInvoker(JMenuItem mi) {
        Component invoker = null;
        JPopupMenu popmenu = null;
        for (Container c = mi.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JPopupMenu)) continue;
            popmenu = (JPopupMenu)c;
        }
        if (popmenu != null) {
            invoker = popmenu.getInvoker();
        }
        return invoker;
    }

    public static JPopupMenu createCopyTable(JPopupMenu popup) {
        return TablePopupFactory.createCopyTable(popup, false, false);
    }

    public static JPopupMenu createCopyTable(JPopupMenu popup, boolean addSeparatorBefore, boolean addSeparatorAfter) {
        if (popup == null) {
            throw new IllegalArgumentException("createCopyTable(): The passed JPopupMenu was NULL.");
        }
        JMenuItem menuItem = null;
        if (addSeparatorBefore) {
            popup.addSeparator();
        }
        menuItem = new JMenuItem("Copy Table to clipboard");
        menuItem.setActionCommand(ENABLE_MENU_ALWAYS);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component invoker = TablePopupFactory.getPopupMenuInvoker((JMenuItem)e.getSource());
                if (invoker instanceof JTable) {
                    JTable table = (JTable)invoker;
                    String selection = SwingUtils.tableToString(table.getModel());
                    StringSelection data = new StringSelection(selection);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(data, data);
                }
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem("Copy Row to clipboard");
        menuItem.setActionCommand(ENABLE_MENU_ROW_IS_SELECTED);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component invoker = TablePopupFactory.getPopupMenuInvoker((JMenuItem)e.getSource());
                if (invoker instanceof JTable) {
                    JTable table = (JTable)invoker;
                    int selectedRow = table.getSelectedRow();
                    String selection = SwingUtils.tableToString(table.getModel(), selectedRow);
                    StringSelection data = new StringSelection(selection);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(data, data);
                }
            }
        });
        popup.add(menuItem);
        if (addSeparatorAfter) {
            popup.addSeparator();
        }
        return popup;
    }

    public static JPopupMenu createMenu(Configuration conf, JTable table, ConnectionFactory connFactory) {
        return TablePopupFactory.createMenu(null, TABLE_PUPUP_MENU_PREFIX, conf, table, connFactory);
    }

    public static JPopupMenu createMenu(String prefix, Configuration conf, JTable table, ConnectionFactory connFactory) {
        return TablePopupFactory.createMenu(null, prefix, conf, table, connFactory);
    }

    public static JPopupMenu createMenu(JPopupMenu popup, String prefix, Configuration conf, JTable table, ConnectionFactory connFactory) {
        _logger.debug((Object)("createMenu(): prefix='" + prefix + "'."));
        if (popup == null) {
            popup = new JPopupMenu();
        }
        boolean firstAdd = true;
        for (String prefixStr : conf.getUniqueSubKeys(prefix, true)) {
            String param;
            _logger.debug((Object)("createDataTablePopupMenu(): found prefix '" + prefixStr + "'."));
            String menuItemName = conf.getPropertyRaw(prefixStr + ".name");
            String classname = conf.getPropertyRaw(prefixStr + ".classname");
            String connName = conf.getPropertyRaw(prefixStr + ".connName");
            String config = conf.getPropertyRaw(prefixStr + ".config");
            ArrayList<String> params = new ArrayList<String>();
            int p = 1;
            while ((param = conf.getPropertyRaw(prefixStr + ".param." + p)) != null) {
                params.add(param);
                ++p;
            }
            if (menuItemName == null) {
                _logger.warn((Object)("Missing property '" + prefixStr + ".name'"));
                continue;
            }
            if (classname == null) {
                _logger.warn((Object)("Missing property '" + prefixStr + ".classname'"));
                continue;
            }
            if ("asemon.xmenu.SQLWindow".equals(classname) && config == null) {
                _logger.warn((Object)("Missing property '" + prefixStr + ".config', where SQL statement to SQLWindow should be specified."));
                continue;
            }
            if (connName == null) {
                connName = classname.substring(classname.lastIndexOf(".") + 1);
            }
            if (connName.length() > 30) {
                connName = connName.substring(0, 30);
            }
            TablePopupAction action = new TablePopupAction(menuItemName, connName, classname, params, config, null, null, table, connFactory, true);
            JMenuItem menuItem = new JMenuItem(menuItemName);
            menuItem.addActionListener(action);
            if (firstAdd) {
                firstAdd = false;
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
            }
            popup.add(menuItem);
        }
        popup.addPopupMenuListener(TablePopupFactory.createPopupMenuListener());
        return popup;
    }

    public static PopupMenuListener createPopupMenuListener() {
        return new TablePopupMenuListener();
    }

    public static class TablePopupMenuListener
    implements PopupMenuListener {
        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            _logger.trace((Object)("popupMenuWillBecomeVisible(), source=" + e.getSource()));
            JPopupMenu pop = (JPopupMenu)e.getSource();
            Component invokerComp = pop.getInvoker();
            _logger.trace((Object)("getInvoker(): " + invokerComp));
            if (!(invokerComp instanceof JTable)) {
                _logger.debug((Object)"It needs to be a instance of JTable.");
            }
            JTable tab = (JTable)invokerComp;
            for (int c = 0; c < pop.getComponentCount(); ++c) {
                Component comp = pop.getComponent(c);
                if (!(comp instanceof JMenuItem)) continue;
                JMenuItem mi = (JMenuItem)comp;
                String actionName = mi.getActionCommand();
                if (actionName != null && actionName.equals(TablePopupFactory.ENABLE_MENU_ALWAYS)) {
                    mi.setEnabled(true);
                    continue;
                }
                if (actionName != null && actionName.equals(TablePopupFactory.ENABLE_MENU_ROW_IS_SELECTED) && tab.getSelectedRowCount() > 0) {
                    mi.setEnabled(true);
                    continue;
                }
                if (actionName != null && actionName.equals(TablePopupFactory.ENABLE_MENU_IF_ON_A_ROW)) {
                    if (!(tab instanceof TabularCntrPanel.TCPTable)) continue;
                    TabularCntrPanel.TCPTable tcpTab = (TabularCntrPanel.TCPTable)((Object)tab);
                    mi.setEnabled(tcpTab.isLastMousePressedAtModelRowColValid());
                    continue;
                }
                if (tab.getSelectedRow() == -1) {
                    mi.setEnabled(false);
                    continue;
                }
                mi.setEnabled(true);
                ActionListener[] al = mi.getActionListeners();
                for (int a = 0; a < al.length; ++a) {
                    if (!(al[a] instanceof TablePopupAction)) continue;
                    TablePopupAction pa = (TablePopupAction)al[a];
                    _logger.trace((Object)("ActionListener[" + a + "] is PopupActions, which has pa._params.size()=" + pa.getParamCount()));
                    int foundColumns = 0;
                    block2: for (int p = 0; p < pa.getParamCount(); ++p) {
                        String param = pa.getParam(p);
                        for (int x = 0; x < tab.getColumnCount(); ++x) {
                            String colName = tab.getColumnName(x);
                            if (!colName.equalsIgnoreCase(param)) continue;
                            ++foundColumns;
                            continue block2;
                        }
                    }
                    if (foundColumns >= pa.getParamCount()) continue;
                    mi.setEnabled(false);
                }
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            _logger.trace((Object)"popupMenuWillBecomeInvisible()");
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            _logger.trace((Object)"popupMenuCanceled()");
        }
    }
}

