/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.Utils;

public class Service {
    public static final int MASTER_TYPE = 0;
    public static final int QUERY_TYPE = 1;
    public static final String MASTER = "master";
    public static final String QUERY = "query";
    public static final String SSL_FILTER = "ssl";
    private int _type;
    private String _value;
    private String _protocol;
    private String _host;
    private String _port;
    private String _filter;
    private int _format;

    public Service(String string, String string2) {
        this(Service.getInitType(string), string2);
    }

    public Service(int n, String string) {
        this(n, string, 0);
    }

    protected Service(int n, String string, int n2) {
        this._type = n;
        this._value = string;
        this._format = n2;
        this._init();
    }

    public Service(String string, String string2, String string3, String string4) {
        this(Service.getInitType(string), string2, string3, string4, 0);
    }

    public Service(int n, String string, String string2, String string3) {
        this(n, string, string2, string3, 0);
    }

    protected Service(int n, String string, String string2, String string3, int n2) {
        this._type = n;
        this._protocol = string;
        this._host = string2;
        this._port = string3;
        this._format = n2;
    }

    private void _init() {
        if (this._value == null || this._value.length() == 0) {
            return;
        }
        String[] stringArray = this._value.split("[,\\s]");
        if (stringArray.length > 0) {
            this._protocol = stringArray[0];
        }
        if (!this.hasPort()) {
            return;
        }
        for (int i = stringArray.length - 1; i > 0; --i) {
            try {
                Integer.parseInt(stringArray[i]);
                this._port = stringArray[i];
                if (i > 1) {
                    this._host = stringArray[i - 1];
                }
                if (i + 1 > stringArray.length - 1) continue;
                this._filter = stringArray[i + 1];
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static int getInitType(String string) {
        if (string == null) {
            return 1;
        }
        if (string.toLowerCase().endsWith(MASTER)) {
            return 0;
        }
        return 1;
    }

    public String getType() {
        if (this._type == 0) {
            return MASTER;
        }
        if (this._type == 1) {
            return QUERY;
        }
        return null;
    }

    public int getFormat() {
        return this._format;
    }

    public void setFormat(int n) {
        this._format = n;
    }

    public String getValue() {
        return this.getValue(this._format);
    }

    public String getValue(int n) {
        String string;
        if (!this.hasPort()) {
            return this._value;
        }
        if (n == 0) {
            string = Utils.OS_WINDOWS ? "," : " ";
        } else if (n == 1) {
            string = ",";
        } else if (n == 2) {
            string = " ";
        } else {
            throw new IllegalArgumentException();
        }
        String string2 = this._protocol + string + this._host + string + this._port;
        if (this._filter != null && this._filter.trim().length() > 0) {
            string2 = string2 + string + this._filter;
        }
        return string2;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public boolean hasPort() {
        return this._protocol != null && (this._protocol.toUpperCase().indexOf("TCP") >= 0 || this._protocol.toUpperCase().indexOf("NLWNSCK") >= 0);
    }

    public String getPort() {
        return this._port;
    }

    public void setPort(String string) {
        this._port = string;
    }

    public String getHost() {
        return this._host;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setFilter(String string) {
        this._filter = string;
    }

    public boolean isSSL() {
        return this._filter != null && this._filter.equalsIgnoreCase(SSL_FILTER);
    }

    public String toString() {
        String string;
        if (this._format == 0) {
            string = Utils.OS_WINDOWS ? "=" : " ";
        } else if (this._format == 1) {
            string = "=";
        } else if (this._format == 2) {
            string = " ";
        } else {
            throw new IllegalArgumentException();
        }
        if (this._type == 0) {
            return MASTER + string + this.getValue();
        }
        if (this._type == 1) {
            return QUERY + string + this.getValue();
        }
        return null;
    }

    public boolean isType(String string) {
        return this.getType().equals(string.toLowerCase());
    }
}

