/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.misc;

import com.btr.proxy.selector.direct.NoProxySelector;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolDispatchSelector
extends ProxySelector {
    private Map<String, ProxySelector> selectors = new ConcurrentHashMap<String, ProxySelector>();
    private ProxySelector fallbackSelector = NoProxySelector.getInstance();

    public void setSelector(String protocol, ProxySelector selector) {
        if (protocol == null) {
            throw new NullPointerException("Protocol must not be null.");
        }
        if (selector == null) {
            throw new NullPointerException("Selector must not be null.");
        }
        this.selectors.put(protocol, selector);
    }

    public ProxySelector removeSelector(String protocol) {
        return this.selectors.remove(protocol);
    }

    public ProxySelector getSelector(String protocol) {
        return this.selectors.get(protocol);
    }

    public void setFallbackSelector(ProxySelector selector) {
        if (selector == null) {
            throw new NullPointerException("Selector must not be null.");
        }
        this.fallbackSelector = selector;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        String protocol = uri.getScheme();
        ProxySelector selector = this.selectors.get(protocol);
        if (selector == null) {
            selector = this.fallbackSelector;
        }
        selector.connectFailed(uri, sa, ioe);
    }

    @Override
    public List<Proxy> select(URI uri) {
        String protocol = uri.getScheme();
        ProxySelector selector = this.selectors.get(protocol);
        if (selector == null) {
            selector = this.fallbackSelector;
        }
        return selector.select(uri);
    }
}

