/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.pac;

import com.btr.proxy.selector.pac.JavaxPacScriptParser;
import com.btr.proxy.selector.pac.ScriptMethods;
import com.btr.proxy.util.Logger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacScriptMethods
implements ScriptMethods {
    public static final String OVERRIDE_LOCAL_IP = "com.btr.proxy.pac.overrideLocalIP";
    private static final String GMT = "GMT";
    private static final List<String> DAYS = Collections.unmodifiableList(Arrays.asList("SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"));
    private static final List<String> MONTH = Collections.unmodifiableList(Arrays.asList("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"));
    private Calendar currentTime;

    @Override
    public boolean isPlainHostName(String host) {
        return host.indexOf(".") < 0;
    }

    @Override
    public boolean dnsDomainIs(String host, String domain) {
        return host.endsWith(domain);
    }

    @Override
    public boolean localHostOrDomainIs(String host, String domain) {
        return domain.startsWith(host);
    }

    @Override
    public boolean isResolvable(String host) {
        try {
            InetAddress.getByName(host).getHostAddress();
            return true;
        }
        catch (UnknownHostException ex) {
            Logger.log(JavaxPacScriptParser.class, Logger.LogLevel.DEBUG, "Hostname not resolveable {0}.", host);
            return false;
        }
    }

    @Override
    public boolean isInNet(String host, String pattern, String mask) {
        long lhost = this.parseIpAddressToLong(host);
        long lpattern = this.parseIpAddressToLong(pattern);
        long lmask = this.parseIpAddressToLong(mask);
        boolean result = (lhost & lmask) == lpattern;
        return result;
    }

    private long parseIpAddressToLong(String address) {
        long result = 0L;
        String[] parts = address.split("\\.");
        long shift = 24L;
        for (String part : parts) {
            long lpart = Long.parseLong(part);
            result |= lpart << (int)shift;
            shift -= 8L;
        }
        return result;
    }

    @Override
    public String dnsResolve(String host) {
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e) {
            Logger.log(JavaxPacScriptParser.class, Logger.LogLevel.DEBUG, "DNS name not resolvable {0}.", host);
            return "";
        }
    }

    @Override
    public String myIpAddress() {
        try {
            String overrideIP = System.getProperty(OVERRIDE_LOCAL_IP);
            if (overrideIP != null && overrideIP.trim().length() > 0) {
                return overrideIP.trim();
            }
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            Logger.log(JavaxPacScriptParser.class, Logger.LogLevel.DEBUG, "Local address not resolvable.", new Object[0]);
            return "";
        }
    }

    @Override
    public int dnsDomainLevels(String host) {
        int count = 0;
        int startPos = 0;
        while ((startPos = host.indexOf(".", startPos + 1)) > -1) {
            ++count;
        }
        return count;
    }

    @Override
    public boolean shExpMatch(String str, String shexp) {
        StringTokenizer tokenizer = new StringTokenizer(shexp, "*");
        int startPos = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int temp = str.indexOf(token, startPos);
            if (temp == -1) {
                return false;
            }
            startPos = temp + token.length();
        }
        return true;
    }

    @Override
    public boolean weekdayRange(String wd1, String wd2, String gmt) {
        boolean useGmt = GMT.equalsIgnoreCase(wd2) || GMT.equalsIgnoreCase(gmt);
        Calendar cal = this.getCurrentTime(useGmt);
        int currentDay = cal.get(7) - 1;
        int from = DAYS.indexOf(wd1 == null ? null : wd1.toUpperCase());
        int to = DAYS.indexOf(wd2 == null ? null : wd2.toUpperCase());
        if (to == -1) {
            to = from;
        }
        if (to < from) {
            return currentDay >= from || currentDay <= to;
        }
        return currentDay >= from && currentDay <= to;
    }

    public void setCurrentTime(Calendar cal) {
        this.currentTime = cal;
    }

    private Calendar getCurrentTime(boolean useGmt) {
        if (this.currentTime != null) {
            return (Calendar)this.currentTime.clone();
        }
        return Calendar.getInstance(useGmt ? TimeZone.getTimeZone(GMT) : TimeZone.getDefault());
    }

    @Override
    public boolean dateRange(Object day1, Object month1, Object year1, Object day2, Object month2, Object year2, Object gmt) {
        Date to;
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        this.parseDateParam(params, day1);
        this.parseDateParam(params, month1);
        this.parseDateParam(params, year1);
        this.parseDateParam(params, day2);
        this.parseDateParam(params, month2);
        this.parseDateParam(params, year2);
        this.parseDateParam(params, gmt);
        boolean useGmt = params.get("gmt") != null;
        Calendar cal = this.getCurrentTime(useGmt);
        Date current = cal.getTime();
        if (params.get("day1") != null) {
            cal.set(5, (Integer)params.get("day1"));
        }
        if (params.get("month1") != null) {
            cal.set(2, (Integer)params.get("month1"));
        }
        if (params.get("year1") != null) {
            cal.set(1, (Integer)params.get("year1"));
        }
        Date from = cal.getTime();
        if (params.get("day2") != null) {
            cal.set(5, (Integer)params.get("day2"));
        }
        if (params.get("month2") != null) {
            cal.set(2, (Integer)params.get("month2"));
        }
        if (params.get("year2") != null) {
            cal.set(1, (Integer)params.get("year2"));
        }
        if ((to = cal.getTime()).before(from)) {
            cal.add(2, 1);
            to = cal.getTime();
        }
        if (to.before(from)) {
            cal.add(1, 1);
            cal.add(2, -1);
            to = cal.getTime();
        }
        return current.compareTo(from) >= 0 && current.compareTo(to) <= 0;
    }

    private void parseDateParam(Map<String, Integer> params, Object value) {
        int n;
        if (value instanceof Number) {
            n = ((Number)value).intValue();
            if (n <= 31) {
                if (params.get("day1") == null) {
                    params.put("day1", n);
                } else {
                    params.put("day2", n);
                }
            } else if (params.get("year1") == null) {
                params.put("year1", n);
            } else {
                params.put("year2", n);
            }
        }
        if (value instanceof String && (n = MONTH.indexOf(((String)value).toUpperCase())) > -1) {
            if (params.get("month1") == null) {
                params.put("month1", n);
            } else {
                params.put("month2", n);
            }
        }
        if (GMT.equalsIgnoreCase(String.valueOf(value))) {
            params.put("gmt", 1);
        }
    }

    @Override
    public boolean timeRange(Object hour1, Object min1, Object sec1, Object hour2, Object min2, Object sec2, Object gmt) {
        Date to;
        Date from;
        boolean useGmt = GMT.equalsIgnoreCase(String.valueOf(min1)) || GMT.equalsIgnoreCase(String.valueOf(sec1)) || GMT.equalsIgnoreCase(String.valueOf(min2)) || GMT.equalsIgnoreCase(String.valueOf(gmt));
        Calendar cal = this.getCurrentTime(useGmt);
        cal.set(14, 0);
        Date current = cal.getTime();
        if (sec2 instanceof Number) {
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, ((Number)min1).intValue());
            cal.set(13, ((Number)sec1).intValue());
            from = cal.getTime();
            cal.set(11, ((Number)hour2).intValue());
            cal.set(12, ((Number)min2).intValue());
            cal.set(13, ((Number)sec2).intValue());
            to = cal.getTime();
        } else if (hour2 instanceof Number) {
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, ((Number)min1).intValue());
            cal.set(13, 0);
            from = cal.getTime();
            cal.set(11, ((Number)sec1).intValue());
            cal.set(12, ((Number)hour2).intValue());
            cal.set(13, 59);
            to = cal.getTime();
        } else if (min1 instanceof Number) {
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, 0);
            cal.set(13, 0);
            from = cal.getTime();
            cal.set(11, ((Number)min1).intValue());
            cal.set(12, 59);
            cal.set(13, 59);
            to = cal.getTime();
        } else {
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, 0);
            cal.set(13, 0);
            from = cal.getTime();
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, 59);
            cal.set(13, 59);
            to = cal.getTime();
        }
        if (to.before(from)) {
            cal.setTime(to);
            cal.add(5, 1);
            to = cal.getTime();
        }
        return current.compareTo(from) >= 0 && current.compareTo(to) <= 0;
    }
}

