/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.uaf;

import com.sybase.ua.AgentDiscovery;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.FastDiscoveryFilter;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.discovery.DiscoveryException;
import com.sybase.util.ds.Debug;
import com.sybase.util.ds.uaf.DiscoveryFilter;
import com.sybase.util.ds.uaf.DiscoverySetting;
import com.sybase.util.ds.uaf.SYSAMEntry;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import com.sybase.util.ds.uaf.SyUAFEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SyUAF {
    public static final String PROP_DISCOVERY_SERVICE = "discovery.service";
    public static final String PROP_DISCOVERY_HOST = "discovery.host";
    public static final String PROP_DISCOVERY_PORT = "discovery.port";
    public static final String SERVICE_UDP = "udp".toUpperCase();
    public static final String SERVICE_JINI = "jini".toUpperCase();
    public static final String DEFAULT_DISCOVERY_SERVICE = SERVICE_UDP;
    public static final String DEFAULT_DISCOVERY_HOST = "";
    public static final String DEFAULT_DISCOVERY_PORT = "";
    public static final int DEFAULT_JINI_PORT = 4160;
    public static final int DEFAULT_RMI_PORT = Integer.valueOf("9999");
    public static final int DEFAULT_MIN_PORT = 1025;
    public static final int DEFUALT_MAX_PORT = 65535;
    public static final String PROP_ASE_PLUGIN_ID = "agent.ase.plugin.id";
    public static final String ASE_PLUGIN_ID;
    public static final String PROP_ASE_SYSAM_ID = "agent.sysam.plugin.id";
    public static final String SYSAM_PLUGIN_ID;
    public static final String PROP_SDC_PLUGIN_ID = "agent.sdc.plugin.id";
    public static final String SDC_PLUGIN_ID;
    public static final String[] DISCOVERY_METHODS;
    public static final String AUTHORIZATION_ERROR = "<permission denied>";
    private AgentDiscovery _agentDiscovery;
    private DiscoverySetting _discoverySetting = new DiscoverySetting();
    static /* synthetic */ Class class$com$sybase$util$ds$uaf$SyUAFASEEntry;
    static /* synthetic */ Class class$com$sybase$util$ds$uaf$SYSAMEntry;

    public SyUAF() {
        String string;
        String string2;
        String string3 = System.getProperty(PROP_DISCOVERY_SERVICE);
        if (string3 != null) {
            this._discoverySetting.service = string3;
        }
        if ((string2 = System.getProperty(PROP_DISCOVERY_HOST)) != null) {
            this._discoverySetting.host = string2;
        }
        if ((string = System.getProperty(PROP_DISCOVERY_PORT)) != null) {
            this._discoverySetting.port = string;
        }
    }

    public void init(String string, String string2, String string3) {
        this._discoverySetting.service = string;
        this._discoverySetting.host = string2;
        this._discoverySetting.port = string3;
    }

    public void initAgentDiscovery() throws DiscoveryException {
        this._agentDiscovery = new AgentDiscovery(this._discoverySetting.service.toLowerCase(), this._discoverySetting.host, this._discoverySetting.port);
    }

    public List discover() throws DiscoveryException {
        List list = this.discover(ASE_PLUGIN_ID);
        List list2 = this.discover(SDC_PLUGIN_ID);
        list.addAll(list2);
        return list;
    }

    public List discover(Boolean bl) throws DiscoveryException {
        List list = this.discover(ASE_PLUGIN_ID, bl);
        List list2 = this.discover(SDC_PLUGIN_ID, bl);
        list.addAll(list2);
        return list;
    }

    public List discover(String string) throws DiscoveryException {
        return this.discover(string, true);
    }

    public List discover(String string, boolean bl) throws DiscoveryException {
        final String string2 = string;
        FastDiscoveryFilter fastDiscoveryFilter = new FastDiscoveryFilter(){

            public boolean acceptAgentPlugin(PluginInfo pluginInfo) {
                return pluginInfo.getId().equals(string2);
            }
        };
        return this.discover(string, fastDiscoveryFilter, bl);
    }

    public List discover(String string, FastDiscoveryFilter fastDiscoveryFilter, boolean bl) throws DiscoveryException {
        String string2 = string;
        ArrayList<SyUAFASEEntry> arrayList = new ArrayList<SyUAFASEEntry>();
        this._agentDiscovery.discover((com.sybase.ua.DiscoveryFilter)fastDiscoveryFilter);
        List list = this._agentDiscovery.getAgentInfos();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AgentInfo agentInfo = (AgentInfo)iterator.next();
            try {
                List list2 = agentInfo.getPluginInfos(string2);
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    PluginInfo pluginInfo = null;
                    Map map = null;
                    try {
                        SyUAFEntry syUAFEntry;
                        pluginInfo = (PluginInfo)iterator2.next();
                        String string3 = pluginInfo.getVersion();
                        int n = pluginInfo.getInstanceNumber();
                        map = pluginInfo.getDiscoveryProperties();
                        if (string2.equals(ASE_PLUGIN_ID) || string2.equals(SDC_PLUGIN_ID)) {
                            syUAFEntry = new SyUAFASEEntry(map, string2, string3, n, agentInfo);
                            if (bl && (!bl || !DiscoveryFilter.passFilters("ASE", class$com$sybase$util$ds$uaf$SyUAFASEEntry == null ? SyUAF.class$("com.sybase.util.ds.uaf.SyUAFASEEntry") : class$com$sybase$util$ds$uaf$SyUAFASEEntry, syUAFEntry))) continue;
                            arrayList.add((SyUAFASEEntry)syUAFEntry);
                            continue;
                        }
                        if (!string2.equals(SYSAM_PLUGIN_ID)) continue;
                        syUAFEntry = new SYSAMEntry(map, string3, n, agentInfo);
                        if (bl && !DiscoveryFilter.passFilters("SYSAM", class$com$sybase$util$ds$uaf$SYSAMEntry == null ? SyUAF.class$("com.sybase.util.ds.uaf.SYSAMEntry") : class$com$sybase$util$ds$uaf$SYSAMEntry, syUAFEntry)) continue;
                        arrayList.add((SyUAFASEEntry)syUAFEntry);
                    }
                    catch (Exception exception) {
                        if (!Debug.isOn()) continue;
                        if (pluginInfo != null) {
                            System.out.println("plugin info: " + pluginInfo);
                        }
                        if (map != null) {
                            System.out.println("discovery props: " + map);
                        }
                        exception.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                if (!Debug.isOn()) continue;
                System.out.println("Discovery error: " + exception);
            }
        }
        return arrayList;
    }

    static {
        String string = System.getProperty(PROP_ASE_PLUGIN_ID);
        ASE_PLUGIN_ID = string == null ? "com.sybase.ase" : string;
        string = System.getProperty(PROP_ASE_SYSAM_ID);
        SYSAM_PLUGIN_ID = string == null ? "com.sybase.sysam" : string;
        string = System.getProperty(PROP_SDC_PLUGIN_ID);
        SDC_PLUGIN_ID = string == null ? "com.sybase.ase.cluster" : string;
        DISCOVERY_METHODS = new String[]{SERVICE_JINI, SERVICE_UDP};
    }
}

