/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.asa.ASABaseGridBagPanel;
import com.sybase.asa.ASACheckBox;
import com.sybase.asa.ASALabel;
import com.sybase.asa.ASASpinBox;
import com.sybase.util.ds.Settings;
import com.sybase.util.ds.ui.BasePanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;

public class GeneralPage
extends BasePanel {
    public ASACheckBox saveServersCheckBox;
    public ASASpinBox numSavedServersSpinBox;
    public ASALabel serversLabel;
    public ASACheckBox clearServersCheckBox;
    public ASACheckBox loginTimeoutCheckBox;
    public ASASpinBox loginTimeoutSpinBox;
    public ASALabel secondsLabel;
    private int _initNumSavedServers;
    private boolean _initSaveServers;

    public GeneralPage() {
        this.createGUI();
    }

    private void createGUI() {
        this.saveServersCheckBox = new ASACheckBox(_res.get("LABC_REMEMBER"));
        this.saveServersCheckBox.setMnemonic(_res.get("R").charAt(0));
        this.numSavedServersSpinBox = new ASASpinBox(1, 1, 20);
        this.numSavedServersSpinBox.setPreferredWidthToDigits(2);
        this.serversLabel = new ASALabel(_res.get("RECENT_SERVERS"));
        this.clearServersCheckBox = new ASACheckBox(_res.get("CHKB_CLEAR_SERVERS"));
        this.clearServersCheckBox.setMnemonic(_res.get("MNEM_CLEAR_SERVERS").charAt(0));
        this.loginTimeoutCheckBox = new ASACheckBox(_res.get("CHKB_LOGIN_TIMEOUT"));
        this.loginTimeoutCheckBox.setMnemonic(_res.get("MNEM_LOGIN_TIMEOUT").charAt(0));
        this.loginTimeoutSpinBox = new ASASpinBox(30, 1, 999);
        this.loginTimeoutSpinBox.setPreferredWidthToDigits(3);
        this.secondsLabel = new ASALabel(_res.get("SECONDS"));
        int n = 0;
        ASABaseGridBagPanel aSABaseGridBagPanel = new ASABaseGridBagPanel(INSETS_NONE);
        aSABaseGridBagPanel.add((Component)this.saveServersCheckBox, 0, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS_NONE, 0, 0);
        aSABaseGridBagPanel.add((Component)this.numSavedServersSpinBox, 1, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.serversLabel, 2, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add((Component)aSABaseGridBagPanel, 0, n, 1, 1, 0.0, 0.0, 17, 0, INSETS_FIRST, 0, 0);
        this.add((Component)this.clearServersCheckBox, 0, ++n, 1, 1, 0.0, 0.0, 17, 0, INSETS_INDENT_LAST, 0, 0);
        aSABaseGridBagPanel = new ASABaseGridBagPanel(INSETS_NONE);
        aSABaseGridBagPanel.add((Component)this.loginTimeoutCheckBox, 0, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS_NONE, 0, 0);
        aSABaseGridBagPanel.add((Component)this.loginTimeoutSpinBox, 1, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.secondsLabel, 2, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add((Component)aSABaseGridBagPanel, 0, ++n, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add(Box.createGlue(), 0, ++n, 0, 1, 1.0, 1.0, 10, 1, INSETS_NONE, 0, 0);
    }

    public void init(ActionListener actionListener) {
        this.saveServersCheckBox.removeActionListener(actionListener);
        this.loginTimeoutCheckBox.removeActionListener(actionListener);
        this._initNumSavedServers = Settings.getNumberOfSavedServers();
        this._initSaveServers = Settings.getEnableSaveServers();
        this.saveServersCheckBox.setSelected(this._initSaveServers);
        this.numSavedServersSpinBox.setValue(this._initNumSavedServers);
        this.numSavedServersSpinBox.setEnabled(this._initSaveServers);
        boolean bl = Settings.getEnableLoginTimeout();
        this.loginTimeoutCheckBox.setSelected(bl);
        this.loginTimeoutSpinBox.setValue(Settings.getLoginTimeout());
        this.loginTimeoutSpinBox.setEnabled(bl);
        this.saveServersCheckBox.addActionListener(actionListener);
        this.loginTimeoutCheckBox.addActionListener(actionListener);
    }

    public void releaseResources(ActionListener actionListener) {
        this.loginTimeoutCheckBox.removeActionListener(actionListener);
    }

    public void handleActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveServersCheckBox) {
            boolean bl = this.saveServersCheckBox.isSelected();
            this.numSavedServersSpinBox.setEnabled(bl);
            if (bl) {
                this.numSavedServersSpinBox.requestFocusInWindow();
            }
        } else if (object == this.loginTimeoutCheckBox) {
            boolean bl = this.loginTimeoutCheckBox.isSelected();
            this.loginTimeoutSpinBox.setEnabled(bl);
            if (bl) {
                this.loginTimeoutSpinBox.requestFocusInWindow();
            }
        }
    }

    public boolean saveSettings() {
        Settings.setEnableLoginTimeout(this.loginTimeoutCheckBox.isSelected());
        Settings.setLoginTimeout(this.loginTimeoutSpinBox.getValue());
        if (this.isNumSavedServersChanged()) {
            Settings.setNumberOfSavedServers(this.numSavedServersSpinBox.getValue());
            Settings.setEnableSaveServers(this.saveServersCheckBox.isSelected());
        }
        return true;
    }

    boolean isNumSavedServersChanged() {
        int n = this.numSavedServersSpinBox.getValue();
        boolean bl = this.saveServersCheckBox.isSelected();
        return bl != this._initSaveServers || n != this._initNumSavedServers;
    }
}

