/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.planviewer;

import com.sybase.ase.planviewer.Column;
import com.sybase.ase.planviewer.Table;
import com.sybase.ase.planviewer.TableContainer;
import java.util.Vector;

class OptimizerStatistics {
    private TableContainer _tables = new TableContainer();

    OptimizerStatistics() {
    }

    protected void addTable(String string) {
        this._tables.add(new Table(string));
    }

    protected void addColumn(Column column) {
        Table table = this.getLastTable();
        if (table != null) {
            table.addColumn(column);
        }
    }

    private Table getLastTable() {
        return (Table)this._tables.getItems().lastElement();
    }

    private Column getLastColumnOfLastTable() {
        Table table = this.getLastTable();
        if (table == null) {
            return null;
        }
        if (table.getColumns() == null) {
            return null;
        }
        return (Column)table.getColumns().lastElement();
    }

    private Column getColumnOfTable(String string) {
        Table table = this.getLastTable();
        if (table == null) {
            return null;
        }
        Vector vector = table.getColumns();
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!((Column)vector.elementAt(i)).getName().equals(string)) continue;
            return (Column)vector.elementAt(i);
        }
        return null;
    }

    protected void setLastUpdateStatTime(String string) {
        Column column = this.getLastColumnOfLastTable();
        if (column != null) {
            column.setLastUpdateStatTime(string);
        }
    }

    protected void setMissingHistogram(String string) {
        Column column = this.getColumnOfTable(string);
        if (column != null) {
            column.setMissingHistogram(true);
        }
    }

    protected void markMissingDensityComplete() {
        Table table = this.getLastTable();
        if (table == null) {
            return;
        }
        Vector vector = table.getColumns();
        if (vector == null || vector.size() == 0) {
            return;
        }
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            Column column = (Column)vector.elementAt(i);
            if (column == null || !column.isMissingDensity() || column.isMissingDensityComposite()) continue;
            string = string + column.getName() + ",";
            column.setMissingDensity(false);
        }
        if (string.endsWith(",")) {
            string = string.substring(0, string.length() - 1);
        }
        Column column = new Column(string);
        column.setMissingDensity(true);
        column.setMissingDensityComposite(true);
        this.addColumn(column);
    }

    protected void setMissingDensity(String string) {
        Column column = this.getColumnOfTable(string);
        if (column != null) {
            column.setMissingDensity(true);
        }
    }

    public TableContainer getTables() {
        return this._tables;
    }
}

