/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.pcs.PersistWriterJdbc;
import asemon.utils.SwingUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class AseConfig
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(AseConfig.class);
    private static AseConfig _instance = null;
    private boolean _offline = false;
    private boolean _hasGui = false;
    private Timestamp _timestamp = null;
    public static final String NON_DEFAULT = "NonDefault";
    public static final String SECTION_NAME = "SectionName";
    public static final String CONFIG_NAME = "ConfigName";
    public static final String CONFIG_VALUE = "ConfigValue";
    public static final String PENDING = "Pending";
    public static final String PENDING_VALUE = "PendingValue";
    public static final String DEFAULT_VALUE = "DefaultValue";
    public static final String MEMORY_USED = "UsedMemory";
    public static final String CONFIG_UNIT = "Unit";
    public static final String RESTART_IS_REQ = "RestartIsReq";
    public static final String CFG_VAL_STR = "CfgValStr";
    public static final String CFG_VAL_STR_PENDNING = "CfgValStrPending";
    public static final String READ_ONLY = "ReadOnly";
    public static final String TYPE = "Type";
    public static final String MIN_VALUE = "MinValue";
    public static final String MAX_VALUE = "MaxValue";
    public static final String DESCRIPTION = "Description";
    public static final String CONFIG_ID = "ConfigId";
    public static final String SECTION_ID = "SectionId";
    public static final String DISPLAY_LEVEL = "DisplayLevel";
    public static final String DATA_TYPE = "DataType";
    private static final int COL_NAME = 0;
    private static final int COL_CLASS = 1;
    private static final int COL_SQLTYPE = 2;
    private static final int COL_TOOLTIP = 3;
    private static Object[][] COLUMN_HEADERS = new Object[][]{{"NonDefault", Boolean.class, "bit", "True if the value is not configured to the default value. (same as for sp_configure 'nondefault')"}, {"SectionName", String.class, "varchar(60)", "Configuration Group"}, {"ConfigName", String.class, "varchar(60)", "Name of the configuration, same as the name in sp_configure."}, {"ConfigValue", Integer.class, "int", "Value of the configuration."}, {"Pending", Boolean.class, "bit", "The Configuration has not yet taken effect, probably needs restart to take effect."}, {"PendingValue", Integer.class, "int", "The value which will be configured on next restart, if PENDING is true."}, {"DefaultValue", Integer.class, "varchar(100)", "The default configuration value."}, {"UsedMemory", Integer.class, "varchar(30)", "Memory Used by this configuration parameter"}, {"Unit", String.class, "varchar(30)", "In what unit is this configuration"}, {"RestartIsReq", Boolean.class, "bit", "ASE needs to be rebooted for the configuration to take effect."}, {"CfgValStr", String.class, "varchar(100)", "The char value of the configuration."}, {"CfgValStrPending", String.class, "varchar(100)", "The pending char configuration."}, {"ReadOnly", Boolean.class, "bit", "This config is a read only value"}, {"Type", String.class, "varchar(30)", "dynamic or static"}, {"MinValue", Integer.class, "int", "integer minimum value of the configuration"}, {"MaxValue", Integer.class, "int", "integer maximum value of the configuration"}, {"Description", String.class, "varchar(255)", "Description of the configuration."}, {"ConfigId", Integer.class, "int", "Internal ID number for this configuration."}, {"SectionId", Integer.class, "int", "Configuration Group ID"}, {"DisplayLevel", Integer.class, "int", ""}, {"DataType", Integer.class, "int", ""}};
    private static String GET_CONFIG_ONLINE_SQL = "select \n    CONFIG_DATE   = getdate(),  \n    NON_DEFAULT   = case when (b.defvalue != isnull(a.value2, convert(char(32), a.value)) or b.defvalue != isnull(b.value2, convert(char(32), b.value))) \n                               and b.config != 114 /* Exclude option 'configuration file' */ \n                               and b.type != 'read-only' \n                               and b.display_level <= 10 \n\t                      then convert(bit, 1) \n\t                      else convert(bit, 0) \n                    end, \n    SECTION       = (select convert(char(35),x.name) from master.dbo.sysconfigures x where a.parent = x.config), \n    NAME          = convert(char(35),a.name),  \n    VALUE         = b.value,  \n    PENDING       = case when    a.value = b.value \n                              or b.type = 'read-only' \n                              or convert(bit,(b.status&0x10)|(b.status&0x20)) = 1 \n                         then convert(bit,0) \n                         else convert(bit,1) \n                    end, \n    PENDING_VALUE = nullif(a.value, b.value), \n    DEFAULT_VALUE = b.defvalue,  \n    USED_MEMORY   = b.comment, \n    CONFIG_UNIT   = b.unit, \n    RESTART_REQ   = convert(bit, 1-convert(bit, a.status&8)),  \n    CHAR_VALUE    = b.value2,  \n    CHAR_PENDING  = a.value2,  \n    READONLY      = convert(bit,(b.status&0x10)|(b.status&0x20)),  \n    TYPE          = b.type, \n    MIN_VALUE     = b.minimum_value,  \n    MAX_VALUE     = b.maximum_value,  \n    DESCRIPTION   = (select m.description from master.dbo.sysmessages m where m.error = b.message_num and m.langid = NULL),  \n    CONFIG_ID     = a.config, \n    PARENT_ID     = a.parent,  \n    DISP_LEVEL    = b.display_level,  \n    DATA_TYPE     = b.datatype  \nfrom master.dbo.sysconfigures a,  \n     master.dbo.syscurconfigs b  \nwhere a.config=b.config  \n  and b.display_level<>null  \n  and a.parent!= 19  \n  and a.parent > 1  \norder by a.parent, a.name \n";
    private static String GET_CONFIG_OFFLINE_SQL = "select * from " + PersistWriterJdbc.getTableName(8, null, true) + " \n" + "where \"SessionStartTime\" = SESSION_START_TIME \n";
    private static String GET_CONFIG_OFFLINE_MAX_SESSION_SQL = " (select max(\"SessionStartTime\")   from " + PersistWriterJdbc.getTableName(8, null, true) + " ) ";
    private HashMap<String, AseConfigEntry> _aseConfigMap = null;
    private ArrayList<AseConfigEntry> _aseConfigList = null;
    private ArrayList<String> _aseConfigSectionList = null;

    public static boolean hasInstance() {
        return _instance != null;
    }

    public static AseConfig getInstance() {
        if (_instance == null) {
            _instance = new AseConfig();
        }
        return _instance;
    }

    public static void reset() {
        _instance = null;
    }

    public Map<String, AseConfigEntry> getAseConfigMap() {
        return this._aseConfigMap;
    }

    public boolean isInitialized() {
        return this._aseConfigMap != null;
    }

    public void initialize(Connection conn, boolean hasGui, boolean offline, Timestamp ts) {
        this._hasGui = hasGui;
        this._offline = offline;
        this.refresh(conn, ts);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(Connection conn, Timestamp ts) {
        if (conn == null) {
            return;
        }
        this._aseConfigMap = new HashMap();
        this._aseConfigList = new ArrayList();
        this._aseConfigSectionList = new ArrayList();
        String sql = GET_CONFIG_ONLINE_SQL;
        if (this._offline) {
            sql = GET_CONFIG_OFFLINE_SQL;
            String tsStr = "";
            tsStr = ts == null ? GET_CONFIG_OFFLINE_MAX_SESSION_SQL : "'" + ts + "'";
            sql = sql.replace("SESSION_START_TIME", tsStr);
        }
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (true) {
                if (!rs.next()) {
                    rs.close();
                    return;
                }
                AseConfigEntry entry = new AseConfigEntry();
                int pos = 2;
                this._timestamp = rs.getTimestamp(1);
                entry.isNonDefault = rs.getBoolean(pos++);
                entry.sectionName = rs.getString(pos++);
                entry.configName = rs.getString(pos++);
                entry.configValue = rs.getInt(pos++);
                entry.isPending = rs.getBoolean(pos++);
                entry.pendingValue = rs.getInt(pos++);
                entry.defaultValue = rs.getString(pos++);
                entry.usedMemoryStr = rs.getString(pos++);
                entry.configUnit = rs.getString(pos++);
                entry.requiresRestart = rs.getBoolean(pos++);
                entry.configValueString = rs.getString(pos++);
                entry.pendingValueString = rs.getString(pos++);
                entry.isReadOnly = rs.getBoolean(pos++);
                entry.configType = rs.getString(pos++);
                entry.minValue = rs.getInt(pos++);
                entry.maxValue = rs.getInt(pos++);
                entry.description = rs.getString(pos++);
                entry.configId = rs.getInt(pos++);
                entry.parentId = rs.getInt(pos++);
                entry.displayLevel = rs.getInt(pos++);
                entry.dataType = rs.getInt(pos++);
                if (!this._offline) {
                    try {
                        int mem = Integer.parseInt(entry.usedMemoryStr);
                        if (mem == 0) {
                            entry.usedMemoryStr = "";
                        } else {
                            double memInMb = (double)mem / 1024.0;
                            BigDecimal bdMem = new BigDecimal(memInMb).setScale(2, 6);
                            entry.usedMemoryStr = bdMem + " MB";
                            String unit = entry.configUnit;
                            if (!unit.equals("memory pages(2k)") && !unit.equals("kilobytes")) {
                                // empty if block
                            }
                        }
                    }
                    catch (NumberFormatException ignore) {
                        // empty catch block
                    }
                }
                this._aseConfigMap.put(entry.configName, entry);
                this._aseConfigList.add(entry);
                if (this._aseConfigSectionList.contains(entry.sectionName)) continue;
                this._aseConfigSectionList.add(entry.sectionName);
            }
        }
        catch (SQLException ex) {
            _logger.error((Object)("AseConfig:initialize:sql='" + sql + "'"), (Throwable)ex);
            if (this._hasGui) {
                SwingUtils.showErrorMessage("AseConfig - Initialize", "SQL Exception: " + ex.getMessage() + "\n\nThis was found when executing SQL statement:\n\n" + sql, ex);
            }
            this._aseConfigMap = null;
            this._aseConfigList = null;
            this._aseConfigSectionList = null;
            return;
        }
    }

    public String getDescription(String configName) {
        if (this._aseConfigMap == null) {
            return null;
        }
        AseConfigEntry e = this._aseConfigMap.get(configName);
        return e == null ? null : e.description;
    }

    public int getRunValue(String configName) {
        if (this._aseConfigMap == null) {
            return -1;
        }
        AseConfigEntry e = this._aseConfigMap.get(configName);
        return e == null ? -1 : e.configValue;
    }

    public List<String> getSectionList() {
        return this._aseConfigSectionList;
    }

    public Timestamp getTimestamp() {
        return this._timestamp;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return (Class)COLUMN_HEADERS[columnIndex][1];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_HEADERS.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return (String)COLUMN_HEADERS[columnIndex][0];
    }

    @Override
    public int getRowCount() {
        return this._aseConfigList == null ? 0 : this._aseConfigList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AseConfigEntry e = this._aseConfigList.get(rowIndex);
        if (e == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return e.isNonDefault;
            }
            case 1: {
                return e.sectionName;
            }
            case 2: {
                return e.configName;
            }
            case 3: {
                return e.configValue;
            }
            case 4: {
                return e.isPending;
            }
            case 5: {
                return e.pendingValue;
            }
            case 6: {
                return e.defaultValue;
            }
            case 7: {
                return e.usedMemoryStr;
            }
            case 8: {
                return e.configUnit;
            }
            case 9: {
                return e.requiresRestart;
            }
            case 10: {
                return e.configValueString;
            }
            case 11: {
                return e.pendingValueString;
            }
            case 12: {
                return e.isReadOnly;
            }
            case 13: {
                return e.configType;
            }
            case 14: {
                return e.minValue;
            }
            case 15: {
                return e.maxValue;
            }
            case 16: {
                return e.description;
            }
            case 17: {
                return e.configId;
            }
            case 18: {
                return e.parentId;
            }
            case 19: {
                return e.displayLevel;
            }
            case 20: {
                return e.dataType;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int findColumn(String columnName) {
        for (int i = 0; i < COLUMN_HEADERS.length; ++i) {
            if (!COLUMN_HEADERS[i][0].equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public String getColumnToolTip(String colName) {
        for (int i = 0; i < COLUMN_HEADERS.length; ++i) {
            if (!COLUMN_HEADERS[i][0].equals(colName)) continue;
            return (String)COLUMN_HEADERS[i][3];
        }
        return "";
    }

    public String getSqlDataType(String colName) {
        for (int i = 0; i < COLUMN_HEADERS.length; ++i) {
            if (!COLUMN_HEADERS[i][0].equals(colName)) continue;
            return (String)COLUMN_HEADERS[i][2];
        }
        return "";
    }

    public String getSqlDataType(int colIndex) {
        return (String)COLUMN_HEADERS[colIndex][2];
    }

    public class AseConfigEntry {
        public boolean isNonDefault;
        public String sectionName;
        public String configName;
        public int configValue;
        public boolean isPending;
        public int pendingValue;
        public String defaultValue;
        public String usedMemoryStr;
        public String configUnit;
        public boolean requiresRestart;
        public String configValueString;
        public String pendingValueString;
        public boolean isReadOnly;
        public String configType;
        public int minValue;
        public int maxValue;
        public String description;
        public int configId;
        public int parentId;
        public int displayLevel;
        public int dataType;
    }
}

