/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import java.util.Iterator;
import java.util.Vector;

class Batch {
    protected int spid = 0;
    protected int kpid = 0;
    protected int batchId = 0;
    protected int dbid = 0;
    protected int procedureId = 0;
    protected String dbname = "";
    protected String procedureName = "";
    protected int planId = 0;
    protected int lineNumber = 0;
    private Vector sqlTextLines = new Vector();
    private Vector showplanLines = new Vector();

    Batch() {
    }

    Batch(int bID) {
        this.batchId = bID;
    }

    Batch(int spid, int kpid, int batchId) {
        this.spid = spid;
        this.kpid = kpid;
        this.batchId = batchId;
    }

    public String getKey() {
        return this.spid + ":" + this.kpid + ":" + this.batchId;
    }

    public void addSqlTextLine(StringBuffer line) {
        this.sqlTextLines.add(line);
    }

    public void appendSqlText(String line) {
        StringBuffer sb = null;
        if (this.sqlTextLines.size() == 0) {
            sb = new StringBuffer(line);
            this.sqlTextLines.add(sb);
        } else {
            sb = (StringBuffer)this.sqlTextLines.lastElement();
            sb.append(line);
        }
    }

    public void addShowplanTextLine(StringBuffer line) {
        this.addShowplanTextLine(line, false);
    }

    public void addShowplanTextLine(StringBuffer line, boolean chopLastNewLine) {
        int len;
        if (chopLastNewLine && line.charAt(len = line.length() - 1) == '\n') {
            line.setCharAt(len, ' ');
        }
        this.showplanLines.add(line);
    }

    public void appendShowplanText(String line) {
        this.appendShowplanText(line, false);
    }

    public void appendShowplanText(String line, boolean chopLastNewLine) {
        int len;
        StringBuffer sb = null;
        if (chopLastNewLine && (len = line.length() - 1) > 0 && line.charAt(len) == '\n') {
            line = line.substring(0, len);
        }
        if (this.showplanLines.size() == 0) {
            sb = new StringBuffer(line);
            this.showplanLines.add(sb);
        } else {
            sb = (StringBuffer)this.showplanLines.lastElement();
            sb.append(line);
        }
    }

    public Iterator getIterator() {
        SqlTextIterator bi = new SqlTextIterator();
        return bi;
    }

    public Iterator getSqlTextIterator() {
        SqlTextIterator bi = new SqlTextIterator();
        return bi;
    }

    public Iterator getShowplanTextIterator() {
        ShowplanTextIterator bi = new ShowplanTextIterator();
        return bi;
    }

    public int getBatchId() {
        return this.batchId;
    }

    public String getSqlText() {
        return this.getSqlText(false);
    }

    public String getSqlText(boolean number) {
        Iterator bi = this.getSqlTextIterator();
        StringBuffer sb = new StringBuffer();
        int lineNum = 0;
        while (bi.hasNext()) {
            ++lineNum;
            if (number) {
                sb.append(lineNum + ": " + bi.next() + "\n");
                continue;
            }
            sb.append(bi.next() + "\n");
        }
        return sb.toString();
    }

    public String getShowplanText() {
        Iterator bi = this.getShowplanTextIterator();
        StringBuffer sb = new StringBuffer();
        while (bi.hasNext()) {
            sb.append(bi.next() + "\n");
        }
        return sb.toString();
    }

    private class ShowplanTextIterator
    implements Iterator {
        int currentLine = 0;

        ShowplanTextIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentLine < Batch.this.showplanLines.size();
        }

        public Object next() {
            ++this.currentLine;
            return Batch.this.showplanLines.get(this.currentLine - 1);
        }

        @Override
        public void remove() {
        }
    }

    private class SqlTextIterator
    implements Iterator {
        int currentLine = 0;

        SqlTextIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentLine < Batch.this.sqlTextLines.size();
        }

        public Object next() {
            ++this.currentLine;
            return Batch.this.sqlTextLines.get(this.currentLine - 1);
        }

        @Override
        public void remove() {
        }
    }
}

