/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.Batch;
import asemon.MonTablesDictionary;
import asemon.ProcessDetailFrame;
import asemon.cm.CmSybMessageHandler;
import asemon.cm.CountersModel;
import asemon.gui.AseMonitoringConfigDialog;
import asemon.gui.swing.GTabbedPane;
import asemon.utils.SwingUtils;
import asemon.utils.TimeUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class RefreshProcess
extends Thread {
    private static Logger _logger = Logger.getLogger(RefreshProcess.class);
    private ProcessDetailFrame pdf;
    private Connection conn;
    private boolean refreshProcessFlag;
    private int _refreshInterval = 1;
    boolean batchCapture = false;
    boolean stmtPipe = false;
    boolean stmtPipeMsg = false;
    boolean stmtStat = false;
    boolean sqlTextSample = true;
    boolean sqlTextPipe = false;
    boolean sqlTextPipeMsg = false;
    boolean SQLTextMonitor = false;
    boolean planTextSample = true;
    boolean planTextPipe = false;
    boolean planTextPipeMsg = false;
    boolean procWaitEvents = false;
    boolean has_sa_role = false;
    private boolean _firstTimeSample = true;
    private boolean _discardPreOpenStmnts = true;
    private Statement stmt;
    private int kpid;
    private int spid;
    private ResultSet rs;
    private int currentSpid = -1;
    private int currentKpid = -1;
    private int currentBatchID = -1;
    private int currentDBID = -1;
    private int currentProcedureID = -1;
    private int currentPlanID = -1;
    private int currentSqlLine = -1;
    private String currentDbname = "";
    private String currentProcName = "";
    private int pos_currentSpid = -1;
    private int pos_currentKpid = -1;
    private int pos_currentBatchID = -1;
    private int pos_currentSqlLine = -1;
    private int pos_currentDbname = -1;
    private int pos_currentProcName = -1;
    private int pos_currentPlanID = -1;
    private int pos_currentDBID = -1;
    private int pos_currentProcedureID = -1;
    private int pos_currentWaitEventID = -1;
    private int pos_currentWaitEventDesc = -1;
    private int pos_capturedSpid = -1;
    private int pos_capturedKpid = -1;
    private int pos_capturedBatchID = -1;
    private int pos_capturedSqlLine = -1;
    private int pos_capturedDbname = -1;
    private int pos_capturedProcName = -1;
    private int pos_capturedPlanID = -1;
    private int pos_capturedDBID = -1;
    private int pos_capturedProcedureID = -1;
    private Vector currentStmtColNames = null;
    private StatementsModel currentStmtModel;
    private boolean currentSMInitialized = false;
    private Vector currentStmt = null;
    private Vector currentStmtRows = null;
    private Batch currentBatch = null;
    private Vector capturedStmtColNames = null;
    private StatementsModel capturedStmtModel;
    private boolean capturedSMInitialized = false;
    private boolean capturedTableColmnsIsResized = false;
    private Vector newCapturedStatements = null;
    private int selectedStatement;
    private Hashtable batchHistory = new Hashtable();
    private Hashtable plansHistory = new Hashtable();
    private Hashtable compiledPlansHistory = new Hashtable();
    private Hashtable procedureTextCache = new Hashtable();
    public CountersModel CMProcObjects;
    public CountersModel CMProcWaits;
    public CountersModel CMLocks;
    private int _aseVersion = 0;
    private int _monTablesVersion = 0;
    private String _captureRestrictionSql = "";
    private boolean _captureRestrictions = false;

    public void setCaptureRestriction(String str) {
        this._captureRestrictionSql = str;
        this._captureRestrictions = this._captureRestrictionSql != null && this._captureRestrictionSql.length() > 0;
        _logger.debug((Object)("Setting CaptureRestrictingSql to '" + str + "'."));
    }

    public void setSqlTextSample(boolean b) {
        this.sqlTextSample = b;
    }

    public void setPlanTextSample(boolean b) {
        this.planTextSample = b;
    }

    public void setDiscardPreOpenStmnts(boolean b) {
        this._discardPreOpenStmnts = b;
    }

    public RefreshProcess(ProcessDetailFrame aPdf, Connection conn, int kpid) {
        this.pdf = aPdf;
        this.conn = conn;
        this.kpid = kpid;
        this.refreshProcessFlag = true;
        this.selectedStatement = -1;
        try {
            this.stmt = conn.createStatement();
            this.currentStmt = new Vector();
            this.currentStmtModel = new StatementsModel();
            this.pdf.currentStatementTable.setModel(this.currentStmtModel);
            this.capturedStmtModel = new StatementsModel();
            this.pdf.capturedStatementsTable.setModel(this.capturedStmtModel);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void addBatchHistory(Batch batch) {
        String id = batch.getKey();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Adding SQL text for for id='" + id + "'. text=" + batch.getSqlText(false)));
        }
        this.batchHistory.put(id, batch);
    }

    private Batch getBatchHistory(String id) {
        Batch batch = (Batch)this.batchHistory.get(id);
        if (batch == null) {
            _logger.debug((Object)("No SQL text was found for batch  id='" + id + "'."));
        }
        return batch;
    }

    private Batch getBatchHistory(int spid, int kpid, int batchId) {
        String id = spid + ":" + kpid + ":" + batchId;
        Batch batch = (Batch)this.batchHistory.get(id);
        if (batch == null) {
            _logger.debug((Object)("No SQL text was found for batch  id='" + id + "', spid='" + spid + "', kpid='" + kpid + "', batchId='" + batchId + "'."));
        }
        return batch;
    }

    private void addPlanHistory(int spid, int kpid, int batchId, int dbId, int procId, Batch batch, StringBuffer planText) {
        String id;
        Batch existingBatch;
        if (planText == null) {
            throw new RuntimeException("Passed StringBuffer 'planText' cant be null.");
        }
        int len = planText.length() - 1;
        if (planText.charAt(len) == '\n') {
            planText.setCharAt(len, ' ');
        }
        if ((existingBatch = (Batch)this.plansHistory.get(id = spid + ":" + kpid + ":" + batchId + ":" + procId)) != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Appending SHOWPLAN to spid='" + spid + "', kpid='" + kpid + "', batchId='" + batchId + "', procId='" + procId + "', hashtable.key='" + id + "'. text=" + planText));
            }
            existingBatch.addShowplanTextLine(planText);
        } else {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Adding SHOWPLAN for spid='" + spid + "', kpid='" + kpid + "', batchId='" + batchId + "', procId='" + procId + "', hashtable.key='" + id + "'. text=" + planText));
            }
            batch.addShowplanTextLine(planText);
            this.plansHistory.put(id, batch);
        }
    }

    private void addPlanHistory(Batch batch) {
        String id = batch.spid + ":" + batch.kpid + ":" + batch.batchId + ":" + batch.procedureId;
        Batch existingBatch = (Batch)this.plansHistory.get(id);
        if (existingBatch != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Appending SHOWPLAN to spid='" + batch.spid + "', kpid='" + batch.kpid + "', batchId='" + batch.batchId + "', procId='" + batch.procedureId + "', hashtable.key='" + id + "'. text=" + batch.getShowplanText()));
            }
            existingBatch.appendShowplanText(batch.getShowplanText());
        } else {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Adding SHOWPLAN for spid='" + batch.spid + "', kpid='" + batch.kpid + "', batchId='" + batch.batchId + "', procId='" + batch.procedureId + "', hashtable.key='" + id + "'. text=" + batch.getShowplanText()));
            }
            this.plansHistory.put(id, batch);
        }
    }

    private Batch getPlanHistory(int spid, int kpid, int batchId, int dbId, int procId) {
        String id = spid + ":" + kpid + ":" + batchId + ":" + procId;
        Batch batch = (Batch)this.plansHistory.get(id);
        if (batch == null) {
            _logger.debug((Object)("No SHOWPLAN text was found for spid='" + spid + "', kpid='" + kpid + "', batchId='" + batchId + "', procId='" + procId + "', hashtable.key='" + id + "'."));
        }
        return batch;
    }

    private String nullFix(Object o) {
        return o == null ? "" : o.toString();
    }

    private void refreshStmt() {
        try {
            if (this.kpid > 0) {
                this.rs = this.stmt.executeQuery("select P.spid, P.enginenum, P.status, P.suid, suser_name(P.suid), P.hostname, P.hostprocess, P.cmd, P.cpu,    P.physical_io, P.memusage, LocksHeld, P.blocked, P.dbid, db_name(P.dbid), P.uid, '' /*user_name(P.uid)*/, P.gid,    P.tran_name, P.time_blocked, P.network_pktsz, P.fid, P.execlass, P.priority, P.affinity, P.id, object_name(P.id,P.dbid),    P.stmtnum, P.linenum, P.origsuid, P.block_xloid, P.clientname, P.clienthostname,  P.clientapplname, P.sys_id,    P.ses_id, P.loggedindatetime, P.ipaddr,  program_name=convert(varchar,P.program_name), CPUTime,    WaitTime, LogicalReads, PhysicalReads, PagesRead, PhysicalWrites, PagesWritten, MemUsageKB,    ScanPgs =  TableAccesses,IdxPgs = IndexAccesses, TmpTbl = TempDbObjects, UlcBytWrite =  ULCBytesWritten,    UlcFlush = ULCFlushes, ULCFlushFull, Transactions, Commits, Rollbacks, PacketsSent, PacketsReceived,    BytesSent, BytesReceived from sysprocesses P , monProcessActivity A, monProcessNetIO N where P.kpid=A.KPID   and N.KPID=P.kpid   and P.kpid=" + Integer.toString(this.kpid));
                this.rs.next();
                if (this.rs.getRow() > 0) {
                    this.spid = ((Number)this.rs.getObject(1)).intValue();
                    this.pdf.spidFld.setText(this.nullFix(this.rs.getObject(1)));
                    this.pdf.enginenumFld.setText(this.nullFix(this.rs.getObject(2)));
                    this.pdf.statusFld.setText(this.nullFix(this.rs.getObject(3)));
                    this.pdf.suidFld.setText(this.nullFix(this.rs.getObject(4)));
                    this.pdf.suser_nameFld.setText(this.nullFix(this.rs.getObject(5)));
                    this.pdf.hostnameFld.setText(this.nullFix(this.rs.getObject(6)));
                    this.pdf.hostprocessFld.setText(this.nullFix(this.rs.getObject(7)));
                    this.pdf.cmdFld.setText(this.nullFix(this.rs.getObject(8)));
                    this.pdf.cpuFld.setText(this.nullFix(this.rs.getObject(9)));
                    this.pdf.physical_ioFld.setText(this.nullFix(this.rs.getObject(10)));
                    this.pdf.memusageFld.setText(this.nullFix(this.rs.getObject(11)));
                    this.pdf.LocksHeldFld.setText(this.nullFix(this.rs.getObject(12)));
                    this.pdf.blockedFld.setText(this.nullFix(this.rs.getObject(13)));
                    this.pdf.dbidFld.setText(this.nullFix(this.rs.getObject(14)));
                    this.pdf.db_nameFld.setText(this.nullFix(this.rs.getObject(15)));
                    this.pdf.uidFld.setText(this.nullFix(this.rs.getObject(16)));
                    this.pdf.user_nameFld.setText(this.nullFix(this.rs.getObject(17)));
                    this.pdf.gidFld.setText(this.nullFix(this.rs.getObject(18)));
                    this.pdf.tran_nameFld.setText(this.nullFix(this.rs.getObject(19)));
                    this.pdf.time_blockedFld.setText(this.nullFix(this.rs.getObject(20)));
                    this.pdf.network_pktszFld.setText(this.nullFix(this.rs.getObject(21)));
                    this.pdf.fidFld.setText(this.nullFix(this.rs.getObject(22)));
                    this.pdf.execlassFld.setText(this.nullFix(this.rs.getObject(23)));
                    this.pdf.priorityFld.setText(this.nullFix(this.rs.getObject(24)));
                    this.pdf.affinityFld.setText(this.nullFix(this.rs.getObject(25)));
                    this.pdf.procIDFld.setText(this.nullFix(this.rs.getObject(26)));
                    this.pdf.object_nameFld.setText(this.nullFix(this.rs.getObject(27)));
                    this.pdf.stmtnumFld.setText(this.nullFix(this.rs.getObject(28)));
                    this.pdf.linenumFld.setText(this.nullFix(this.rs.getObject(29)));
                    this.pdf.origsuidFld.setText(this.nullFix(this.rs.getObject(30)));
                    this.pdf.block_xloidFld.setText(this.nullFix(this.rs.getObject(31)));
                    this.pdf.clientnameFld.setText(this.nullFix(this.rs.getObject(32)));
                    this.pdf.clienthostnameFld.setText(this.nullFix(this.rs.getObject(33)));
                    this.pdf.clientapplnameFld.setText(this.nullFix(this.rs.getObject(34)));
                    this.pdf.sys_idFld.setText(this.nullFix(this.rs.getObject(35)));
                    this.pdf.ses_idFld.setText(this.nullFix(this.rs.getObject(36)));
                    this.pdf.loggedindatetimeFld.setText(this.nullFix(this.rs.getObject(37)));
                    this.pdf.ipaddrFld.setText(this.nullFix(this.rs.getObject(38)));
                    this.pdf.program_nameFld.setText(this.nullFix(this.rs.getObject(39)));
                    this.pdf.CPUTimeFld.setText(this.nullFix(this.rs.getObject(40)));
                    this.pdf.WaitTimeFld.setText(this.nullFix(this.rs.getObject(41)));
                    this.pdf.LogicalReadsFld.setText(this.nullFix(this.rs.getObject(42)));
                    this.pdf.PhysicalReadsFld.setText(this.nullFix(this.rs.getObject(43)));
                    this.pdf.PagesReadFld.setText(this.nullFix(this.rs.getObject(44)));
                    this.pdf.PhysicalWritesFld.setText(this.nullFix(this.rs.getObject(45)));
                    this.pdf.PagesWrittenFld.setText(this.nullFix(this.rs.getObject(46)));
                    this.pdf.MemUsageKBFld.setText(this.nullFix(this.rs.getObject(47)));
                    this.pdf.ScanPgsFld.setText(this.nullFix(this.rs.getObject(48)));
                    this.pdf.IdxPgsFld.setText(this.nullFix(this.rs.getObject(49)));
                    this.pdf.TmpTblFld.setText(this.nullFix(this.rs.getObject(50)));
                    this.pdf.UlcBytWriteFld.setText(this.nullFix(this.rs.getObject(51)));
                    this.pdf.UlcFlushFld.setText(this.nullFix(this.rs.getObject(52)));
                    this.pdf.ULCFlushFullFld.setText(this.nullFix(this.rs.getObject(53)));
                    this.pdf.TransactionsFld.setText(this.nullFix(this.rs.getObject(54)));
                    this.pdf.CommitsFld.setText(this.nullFix(this.rs.getObject(55)));
                    this.pdf.RollbacksFld.setText(this.nullFix(this.rs.getObject(56)));
                    this.pdf.PacketsSentFld.setText(this.nullFix(this.rs.getObject(57)));
                    this.pdf.PacketsReceivedFld.setText(this.nullFix(this.rs.getObject(58)));
                    this.pdf.BytesSentFld.setText(this.nullFix(this.rs.getObject(59)));
                    this.pdf.BytesReceivedFld.setText(this.nullFix(this.rs.getObject(60)));
                } else {
                    this.pdf.statusBarLbl.setText("Process disconnected");
                    this.stopRefresh();
                }
            }
            this.currentStmtRows = null;
            boolean currentStmtHasRow = false;
            boolean currentStmtHasChanged = false;
            if (this.stmtStat) {
                String extraCols = "";
                if (this._aseVersion >= 15002 || this._aseVersion >= 12540 && this._aseVersion <= 15000) {
                    extraCols = "  S.RowsAffected, \n";
                }
                String sql = "select  S.SPID, S.KPID, S.BatchID, S.LineNumber, dbname=db_name(S.DBID), procname=isnull(object_name(S.ProcedureID,S.DBID),''), \n  S.CpuTime, S.WaitTime, ExecTimeInMs=datediff(ms, S.StartTime, getdate()), S.MemUsageKB, S.PhysicalReads, S.LogicalReads, \n" + extraCols + "  S.PagesModified, S.PacketsSent, S.PacketsReceived, \n" + "  S.NetworkPacketSize, S.PlansAltered, S.StartTime, S.PlanID, S.DBID, S.ProcedureID, \n" + "  P.SecondsConnected, P.EngineNumber, P.NumChildren, P.SecondsWaiting, P.WaitEventID, WaitEventDesc = '', P.BlockingSPID \n" + "from monProcessStatement S, monProcess P \n" + "where S.KPID = P.KPID\n";
                sql = this.kpid > 0 ? sql + "and S.KPID=" + Integer.toString(this.kpid) : sql + "and S.SPID != @@spid order by S.LogicalReads desc\n";
                this.rs = this.stmt.executeQuery(sql);
                ResultSetMetaData rsmdCurStmt = this.rs.getMetaData();
                int nbColsCurStmt = rsmdCurStmt.getColumnCount();
                if (this.currentStmtColNames == null) {
                    this.currentStmtColNames = new Vector();
                    for (int i = 1; i <= nbColsCurStmt; ++i) {
                        String colName = rsmdCurStmt.getColumnName(i);
                        this.currentStmtColNames.add(colName);
                        if (colName.equals("SPID")) {
                            this.pos_currentSpid = i;
                        }
                        if (colName.equals("KPID")) {
                            this.pos_currentKpid = i;
                        }
                        if (colName.equals("BatchID")) {
                            this.pos_currentBatchID = i;
                        }
                        if (colName.equals("LineNumber")) {
                            this.pos_currentSqlLine = i;
                        }
                        if (colName.equals("dbname")) {
                            this.pos_currentDbname = i;
                        }
                        if (colName.equals("procname")) {
                            this.pos_currentProcName = i;
                        }
                        if (colName.equals("PlanID")) {
                            this.pos_currentPlanID = i;
                        }
                        if (colName.equals("DBID")) {
                            this.pos_currentDBID = i;
                        }
                        if (colName.equals("ProcedureID")) {
                            this.pos_currentProcedureID = i;
                        }
                        if (colName.equals("WaitEventDesc")) {
                            this.pos_currentWaitEventDesc = i;
                        }
                        if (!colName.equals("WaitEventID")) continue;
                        this.pos_currentWaitEventID = i;
                    }
                }
                this.currentSpid = -1;
                this.currentKpid = -1;
                this.currentBatchID = -1;
                this.currentSqlLine = -1;
                this.currentDbname = null;
                this.currentProcName = null;
                this.currentPlanID = -1;
                this.currentDBID = -1;
                this.currentProcedureID = -1;
                MonTablesDictionary mtd = MonTablesDictionary.getInstance();
                boolean firstRow = true;
                while (this.rs.next()) {
                    Vector<Object> row = new Vector<Object>();
                    for (int i = 1; i <= nbColsCurStmt; ++i) {
                        Object o = this.rs.getObject(i);
                        if (i == this.pos_currentWaitEventDesc && mtd != null) {
                            int witEventId = this.rs.getInt(this.pos_currentWaitEventID);
                            o = mtd.getWaitEventDescription(witEventId);
                        }
                        row.add(o);
                    }
                    if (this.currentStmtRows == null) {
                        this.currentStmtRows = new Vector();
                    }
                    this.currentStmtRows.add(row);
                    if (!firstRow) continue;
                    currentStmtHasRow = true;
                    firstRow = false;
                    this.currentSpid = this.rs.getInt(this.pos_currentSpid);
                    this.currentKpid = this.rs.getInt(this.pos_currentKpid);
                    this.currentBatchID = this.rs.getInt(this.pos_currentBatchID);
                    this.currentSqlLine = this.rs.getInt(this.pos_currentSqlLine);
                    this.currentDbname = this.rs.getString(this.pos_currentDbname).trim();
                    this.currentProcName = this.rs.getString(this.pos_currentProcName).trim();
                    this.currentPlanID = this.rs.getInt(this.pos_currentPlanID);
                    this.currentDBID = this.rs.getInt(this.pos_currentDBID);
                    this.currentProcedureID = this.rs.getInt(this.pos_currentProcedureID);
                    if (this.currentBatch == null) {
                        this.currentBatch = new Batch();
                    }
                    if (this.currentBatch.spid != this.currentSpid && this.currentBatch.kpid != this.currentKpid && this.currentBatch.batchId != this.currentBatchID) {
                        currentStmtHasChanged = true;
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("currentStmtHasChanged: currentBatch.spid(" + this.currentBatch.spid + ") != currentSpid(" + this.currentSpid + ")   &&   currentBatch.kpid(" + this.currentBatch.kpid + ") != currentKpid(" + this.currentKpid + ")   &&   currentBatch.batchId(" + this.currentBatch.batchId + ") != currentBatchID(" + this.currentBatchID + ")."));
                        }
                        this.currentBatch.spid = this.currentSpid;
                        this.currentBatch.kpid = this.currentKpid;
                        this.currentBatch.batchId = this.currentBatchID;
                        this.currentBatch.dbid = this.currentDBID;
                        this.currentBatch.dbname = this.currentDbname;
                        this.currentBatch.procedureId = this.currentProcedureID;
                        this.currentBatch.procedureName = this.currentProcName;
                        this.currentBatch.planId = this.currentPlanID;
                    }
                    this.currentBatch.lineNumber = this.currentSqlLine;
                }
            }
            if (!currentStmtHasRow) {
                this.currentBatch = null;
            }
            if (this.selectedStatement == -1 && !currentStmtHasRow) {
                this.pdf.batchTextArea.setText("");
            }
            if (this.SQLTextMonitor && this.batchCapture && currentStmtHasRow && currentStmtHasChanged) {
                String sql = "select SPID, KPID, BatchID, LineNumber, SQLText from monProcessSQLText where KPID=" + this.currentBatch.kpid + " and  SPID=" + this.currentBatch.spid + " and  BatchID=" + this.currentBatch.batchId + " order by SPID, KPID, LineNumber, SequenceInLine";
                _logger.debug((Object)("EXEC SQL: " + sql));
                this.rs = this.stmt.executeQuery(sql);
                int saveLineNumber = 1;
                String sqlText = "";
                while (this.rs.next()) {
                    int atLineNum = this.rs.getInt(4);
                    while (saveLineNumber < atLineNum) {
                        sqlText = sqlText + "\n";
                        if (++saveLineNumber <= 10240) continue;
                    }
                    if (atLineNum == saveLineNumber) {
                        sqlText = sqlText + this.rs.getString(5);
                    } else {
                        sqlText = sqlText + this.rs.getString(5);
                        sqlText = sqlText + "\n";
                    }
                    saveLineNumber = atLineNum;
                }
                if (!sqlText.equals("")) {
                    this.currentBatch.appendSqlText(sqlText);
                }
                if (this.has_sa_role) {
                    _logger.debug((Object)("EXEC sp_showplanfull " + this.currentSpid));
                    this.stmt.executeUpdate("sp_showplanfull " + this.currentSpid);
                    StringBuffer planSb = null;
                    SQLWarning sqlw = this.stmt.getWarnings();
                    do {
                        if (planSb == null) {
                            planSb = new StringBuffer();
                        }
                        if (sqlw.getErrorCode() == 10233 || sqlw.getSQLState() == "010P4") break;
                        planSb = planSb.append(sqlw.getMessage());
                    } while ((sqlw = sqlw.getNextWarning()) != null);
                    if (planSb != null) {
                        this.currentBatch.addShowplanTextLine(planSb);
                    }
                    if (this.currentBatch.procedureId > 0) {
                        String key = Integer.toString(this.currentBatch.planId);
                    }
                }
                this.addBatchHistory(this.currentBatch);
            }
            if (this.selectedStatement == -1) {
                this.displayCurrentBatch();
            }
            Hashtable<String, String> restrictionsCapturedKeys = new Hashtable<String, String>();
            this.newCapturedStatements = null;
            if (this.stmtPipe && this.stmtPipeMsg) {
                String extraCols = "";
                if (this._aseVersion >= 15002 || this._aseVersion >= 12540 && this._aseVersion <= 15000) {
                    extraCols = "       RowsAffected, ErrorStatus, \n";
                }
                if (this._aseVersion >= 15030) {
                    extraCols = extraCols + "      ProcNestLevel, StatementNumber, \n";
                }
                String sql = "select SPID, KPID, BatchID, LineNumber, \n       dbname=db_name(DBID), \n       procname=isnull(object_name(ProcedureID,DBID),''), \n       Elapsed_ms=datediff(ms,StartTime, EndTime), \n       CpuTime, WaitTime, MemUsageKB, PhysicalReads, LogicalReads, \n" + extraCols + "       PagesModified, PacketsSent, \n" + "       PacketsReceived, NetworkPacketSize, \n" + "       PlansAltered, StartTime, EndTime, \n" + "       PlanID, DBID, ProcedureID \n" + "from monSysStatement \n" + "where 1 = 1\n";
                sql = this.kpid > 0 ? sql + "and KPID = " + Integer.toString(this.kpid) + "\n" : sql + "and SPID != @@spid\n";
                if (this._captureRestrictions) {
                    sql = sql + "and (" + this._captureRestrictionSql + ")\n";
                }
                if (this._firstTimeSample && this._discardPreOpenStmnts) {
                    long startTime = System.currentTimeMillis();
                    _logger.info((Object)"BEGIN: Discarding everything in the transient monSysStatement table in the first sample.");
                    this.rs = this.stmt.executeQuery("select count(*) from monSysStatement");
                    while (this.rs.next()) {
                    }
                    this.rs.close();
                    _logger.info((Object)("END:   Discarding everything in the transient monSysStatement table in the first sample. this took " + TimeUtils.msToTimeStr(System.currentTimeMillis() - startTime) + "."));
                }
                this.rs = this.stmt.executeQuery(sql);
                ResultSetMetaData rsmd = this.rs.getMetaData();
                int nbCols = rsmd.getColumnCount();
                if (this.capturedStmtColNames == null) {
                    this.capturedStmtColNames = new Vector();
                    for (int i = 1; i <= nbCols; ++i) {
                        String colName = rsmd.getColumnName(i);
                        this.capturedStmtColNames.add(colName);
                        if (colName.equals("SPID")) {
                            this.pos_capturedSpid = i;
                        }
                        if (colName.equals("KPID")) {
                            this.pos_capturedKpid = i;
                        }
                        if (colName.equals("BatchID")) {
                            this.pos_capturedBatchID = i;
                        }
                        if (colName.equals("LineNumber")) {
                            this.pos_capturedSqlLine = i;
                        }
                        if (colName.equals("dbname")) {
                            this.pos_capturedDbname = i;
                        }
                        if (colName.equals("procname")) {
                            this.pos_capturedProcName = i;
                        }
                        if (colName.equals("PlanID")) {
                            this.pos_capturedPlanID = i;
                        }
                        if (colName.equals("DBID")) {
                            this.pos_capturedDBID = i;
                        }
                        if (!colName.equals("ProcedureID")) continue;
                        this.pos_capturedProcedureID = i;
                    }
                }
                this.newCapturedStatements = new Vector();
                while (this.rs.next()) {
                    if (this._captureRestrictions) {
                        int lSpid = this.rs.getInt(1);
                        int lKpid = this.rs.getInt(2);
                        int lBatchId = this.rs.getInt(3);
                        String key = lSpid + ":" + lKpid + ":" + lBatchId;
                        restrictionsCapturedKeys.put(key, "dummy");
                    }
                    Vector<Object> row = new Vector<Object>();
                    for (int i = 1; i <= nbCols; ++i) {
                        row.add(this.rs.getObject(i));
                    }
                    this.newCapturedStatements.add(row);
                }
            }
            if (this.sqlTextSample && this.sqlTextPipe && this.sqlTextPipeMsg && this.SQLTextMonitor) {
                String sql = "select SPID, KPID, BatchID, SQLText from monSysSQLText where 1=1 ";
                if (this.kpid > 0) {
                    sql = sql + "and KPID=" + Integer.toString(this.kpid);
                }
                if (this._firstTimeSample && this._discardPreOpenStmnts) {
                    long startTime = System.currentTimeMillis();
                    _logger.info((Object)"BEGIN: Discarding everything in the transient monSysSQLText table in the first sample.");
                    this.rs = this.stmt.executeQuery("select count(*) from monSysSQLText");
                    while (this.rs.next()) {
                    }
                    this.rs.close();
                    _logger.info((Object)("END:   Discarding everything in the transient monSysSQLText table in the first sample. this took " + TimeUtils.msToTimeStr(System.currentTimeMillis() - startTime) + "."));
                }
                sql = sql + " order by SPID, KPID, BatchID, SequenceInBatch";
                this.rs = this.stmt.executeQuery(sql);
                String lastKey = "";
                Batch batch = null;
                while (this.rs.next()) {
                    int lSpid = this.rs.getInt(1);
                    int lKpid = this.rs.getInt(2);
                    int lBatchId = this.rs.getInt(3);
                    String lSqlText = this.rs.getString(4);
                    String lKey = lSpid + ":" + lKpid + ":" + lBatchId;
                    if (!lastKey.equals(lKey)) {
                        if (batch != null) {
                            this.addBatchHistory(batch);
                            batch = null;
                        }
                        boolean addBatch = true;
                        if (this._captureRestrictions && restrictionsCapturedKeys.get(lKey) == null) {
                            addBatch = false;
                        }
                        if (addBatch) {
                            batch = new Batch(lSpid, lKpid, lBatchId);
                            batch.appendSqlText(lSqlText);
                        }
                    } else if (batch != null) {
                        batch.appendSqlText(lSqlText);
                    }
                    lastKey = lKey;
                }
                if (batch != null) {
                    this.addBatchHistory(batch);
                }
            }
            if (this.planTextSample && this.planTextPipe && this.planTextPipeMsg) {
                String sql = "select SPID, KPID, BatchID, PlanID, PlanText, DBID, ProcedureID from monSysPlanText where 1=1 ";
                if (this.kpid > 0) {
                    sql = sql + " and KPID=" + Integer.toString(this.kpid);
                }
                if (this._firstTimeSample && this._discardPreOpenStmnts) {
                    long startTime = System.currentTimeMillis();
                    _logger.info((Object)"BEGIN: Discarding everything in the transient monSysPlanText table in the first sample.");
                    this.rs = this.stmt.executeQuery("select count(*) from monSysSQLText");
                    while (this.rs.next()) {
                    }
                    this.rs.close();
                    _logger.info((Object)("END:   Discarding everything in the transient monSysPlanText table in the first sample. this took " + TimeUtils.msToTimeStr(System.currentTimeMillis() - startTime) + "."));
                }
                sql = sql + " order by SPID, KPID, PlanID, SequenceNumber";
                this.rs = this.stmt.executeQuery(sql);
                String lastKey = "";
                Batch batch = null;
                while (this.rs.next()) {
                    int lSpid = this.rs.getInt(1);
                    int lKpid = this.rs.getInt(2);
                    int lBatchId = this.rs.getInt(3);
                    int lPlanID = this.rs.getInt(4);
                    String lPlanText = this.rs.getString(5);
                    int lDbId = this.rs.getInt(6);
                    int lProcId = this.rs.getInt(7);
                    String lKey = lSpid + ":" + lKpid + ":" + lBatchId;
                    if (!lastKey.equals(lKey)) {
                        boolean addBatch = true;
                        if (this._captureRestrictions && restrictionsCapturedKeys.get(lKey) == null) {
                            addBatch = false;
                        }
                        if (addBatch && (batch = this.getBatchHistory(lKey)) != null) {
                            batch.dbid = lDbId;
                            batch.procedureId = lProcId;
                            batch.planId = lPlanID;
                            batch.appendShowplanText(lPlanText);
                        }
                    } else if (batch != null) {
                        batch.appendShowplanText(lPlanText);
                    }
                    lastKey = lKey;
                }
            }
            if (this.selectedStatement == -1) {
                if (this.currentBatch != null) {
                    this.displayPlan(this.currentBatch.spid, this.currentBatch.kpid, this.currentBatch.batchId, this.currentBatch.planId, this.currentBatch.dbid, this.currentBatch.procedureId, this.currentBatch.lineNumber);
                } else {
                    this.pdf.planTextArea.setText("");
                }
            }
            Runnable updatePanel_inSwingThread = new Runnable(){

                @Override
                public void run() {
                    RefreshProcess.this.updatePanel_code();
                }
            };
            SwingUtilities.invokeLater(updatePanel_inSwingThread);
            this._firstTimeSample = false;
        }
        catch (SQLException SQLEx) {
            _logger.error((Object)("RefreshProcess : " + SQLEx));
            _logger.error((Object)("Error Code=" + SQLEx.getErrorCode()));
            _logger.error((Object)"Got SQL error(s) when refreshing information.", (Throwable)SQLEx);
            this.pdf.setRefreshError(SQLEx);
            this.pdf.statusBarLbl.setForeground(Color.RED);
            this.pdf.statusBarLbl.setText("Error when executing SQL, check 'Restrictions syntax'. ASE Message '" + SQLEx.getMessage() + "'.");
        }
    }

    public void setTextFix(JTextArea text) {
        StringTokenizer st = new StringTokenizer(text.getText(), "\n", true);
        int linenumber = 0;
        int count = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            count += s.length();
            if (!s.equals("\n")) continue;
            ++linenumber;
        }
        _logger.debug((Object)("setting JTextArea to rows='" + linenumber + "'"));
        text.setRows(linenumber);
    }

    public void setSelectionAndMoveToTop(JTextArea text, int start, int end) {
        if (start > 0 && end > 0) {
            text.setSelectedTextColor(Color.RED);
            text.setCaretPosition(start);
            text.setSelectionStart(start);
            text.setSelectionEnd(end);
            text.getCaret().setSelectionVisible(true);
            try {
                Point pointAtPos = text.modelToView(start).getLocation();
                pointAtPos.x = 0;
                _logger.debug((Object)("text.modelToView(start): " + pointAtPos));
                for (Container parent = text.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent instanceof JViewport) {
                        ((JViewport)parent).setViewPosition(pointAtPos);
                    } else {
                        if (!(parent instanceof JScrollPane)) continue;
                        ((JScrollPane)parent).getViewport().setViewPosition(pointAtPos);
                    }
                    break;
                }
            }
            catch (BadLocationException e) {
                _logger.debug((Object)("text.modelToView(): " + e));
            }
        }
    }

    public void setCaretToBatchLine(JTextArea text, int linenumber) {
        String s;
        if (linenumber <= 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(text.getText(), "\n", true);
        int count = 0;
        int countRowAfter = 0;
        while (st.hasMoreTokens() && linenumber > 1) {
            s = st.nextToken();
            count += s.length();
            if (!s.equals("\n")) continue;
            --linenumber;
        }
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            countRowAfter = count + s.length();
            ++countRowAfter;
        }
        this.setSelectionAndMoveToTop(text, count, countRowAfter);
    }

    public void setCaretToPlanLine(JTextArea text, int sqlLine) {
        int start = text.getText().indexOf("(at line " + sqlLine + ")");
        int end = text.getText().indexOf("\n", start);
        this.setSelectionAndMoveToTop(text, start, ++end);
    }

    public void displayProcInBatchWindow(String dbname, String procName, int procLine) {
        String sqlStatement = null;
        StringBuffer procTextSb = null;
        String procTextStr = null;
        String fullProcName = dbname + ".dbo." + procName;
        if (this.pdf.titledBorderBatch.getTitle().equals(fullProcName)) {
            this.setCaretToBatchLine(this.pdf.batchTextArea, procLine);
            return;
        }
        procTextStr = (String)this.procedureTextCache.get(fullProcName);
        if (procTextStr != null) {
            _logger.debug((Object)("Found object '" + fullProcName + "' in procedureTextCache."));
        } else {
            _logger.debug((Object)("Getting object '" + fullProcName + "' from database."));
            sqlStatement = "select c.text, c.status, c.id from " + dbname + "..sysobjects o, " + dbname + "..syscomments c" + " where o.name = '" + procName + "'" + "   and o.id = c.id" + " order by c.number, c.colid2, c.colid";
            try {
                Statement statement = this.conn.createStatement();
                ResultSet rs = statement.executeQuery(sqlStatement);
                while (rs.next()) {
                    String textPart = rs.getString(1);
                    int status = rs.getInt(2);
                    int id = rs.getInt(3);
                    if (procTextSb == null) {
                        procTextSb = new StringBuffer();
                    }
                    if ((status & 1) == 1) {
                        procTextSb.append("ASE StoredProcedure Source text for compiled object '" + dbname + ".dbo." + procName + "' (id = " + id + ") is hidden.");
                        break;
                    }
                    procTextSb.append(textPart);
                }
                rs.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Executing SQL command '" + sqlStatement + "'. Found the following error:\n." + e, "Error", 0);
            }
            if (procTextSb != null) {
                procTextStr = procTextSb.toString();
                this.procedureTextCache.put(fullProcName, procTextStr);
            }
        }
        if (procTextStr != null) {
            this.pdf.titledBorderBatch.setTitle(fullProcName);
            this.pdf.batchTextArea.setText(procTextStr);
            this.setCaretToBatchLine(this.pdf.batchTextArea, procLine);
        } else {
            this.pdf.batchTextArea.setText("Cant find text for procedure.");
        }
    }

    public void displayCurrentBatch() {
        this.pdf.titledBorderBatch.setTitle("Batch text");
        this.pdf.batchTextArea.setCaretPosition(0);
        this.pdf.batchTextArea.setFocusable(true);
        if (this.currentBatch == null) {
            this.pdf.batchTextArea.setText("");
            return;
        }
        if (!this.currentBatch.dbname.equals("") && !this.currentBatch.procedureName.equals("") && this.currentSqlLine > 0 && this.pdf.sqlTextShowProcSrcCheckbox.isSelected()) {
            this.displayProcInBatchWindow(this.currentBatch.dbname, this.currentBatch.procedureName, this.currentBatch.lineNumber);
        } else {
            this.pdf.batchTextArea.setText(this.currentBatch.getSqlText());
            this.setCaretToBatchLine(this.pdf.batchTextArea, this.currentSqlLine);
        }
    }

    public void displayBatch(int spid, int kpid, int batchId, int sqlLine) {
        this.pdf.titledBorderBatch.setTitle("Batch text");
        this.pdf.batchTextArea.setText(null);
        Batch batch = this.getBatchHistory(spid, kpid, batchId);
        if (batch == null) {
            this.pdf.batchTextArea.setText("");
            return;
        }
        if (batch.getBatchId() != batchId) {
            _logger.debug((Object)("Asemon.RefreshProcess : bd batchId, asked " + batchId + " returned " + batch.getBatchId()));
        }
        this.pdf.batchTextArea.setText(batch.getSqlText(false));
        this.setCaretToBatchLine(this.pdf.batchTextArea, sqlLine);
    }

    public void displayPlan(int spid, int kpid, int batchId, int planId, int dbId, int procId, int sqlLine) {
        _logger.debug((Object)("displayPlan(): batchId=" + batchId + ", planId=" + planId + ", dbId=" + dbId + ", procId=" + procId + ", sqlLine=" + sqlLine + "."));
        this.pdf.planTextArea.setCaretPosition(0);
        Batch batch = this.getBatchHistory(spid, kpid, batchId);
        if (batch == null) {
            this.pdf.planTextArea.setText("No SHOWPLAN text was found in the plan history.");
            return;
        }
        String planStr = batch.getShowplanText();
        this.pdf.planTextArea.setText(planStr);
        if (sqlLine >= 0) {
            this.setCaretToPlanLine(this.pdf.planTextArea, sqlLine);
        }
    }

    public void setSelectedStatement(int rowid) {
        _logger.debug((Object)("setSelectedStatement(rowid=" + rowid + ")"));
        if (rowid == this.selectedStatement) {
            return;
        }
        this.selectedStatement = rowid;
        if (rowid >= 0) {
            Object o = this.capturedStmtModel.getValueAt(rowid, 0);
            if (o == null) {
                _logger.error((Object)("Row " + rowid + " column 0, does NOT contain any data..."));
                return;
            }
            int spid = ((Number)this.capturedStmtModel.getValueAt(rowid, this.pos_capturedSpid - 1)).intValue();
            int kpid = ((Number)this.capturedStmtModel.getValueAt(rowid, this.pos_capturedKpid - 1)).intValue();
            int batchId = ((Number)this.capturedStmtModel.getValueAt(rowid, this.pos_capturedBatchID - 1)).intValue();
            int sqlLine = ((Number)this.capturedStmtModel.getValueAt(rowid, this.pos_capturedSqlLine - 1)).intValue();
            int planId = ((Number)this.capturedStmtModel.getValueAt(rowid, this.pos_capturedPlanID - 1)).intValue();
            int dbId = ((Number)this.capturedStmtModel.getValueAt(rowid, this.pos_capturedDBID - 1)).intValue();
            int procId = ((Number)this.capturedStmtModel.getValueAt(rowid, this.pos_capturedProcedureID - 1)).intValue();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("setSelectedStatement(), batchId='" + batchId + "', planId='" + planId + "', dbId='" + dbId + "', procId='" + procId + "', (sqlLine='" + sqlLine + "')"));
            }
            if (procId > 0 && sqlLine > 0 && this.pdf.sqlTextShowProcSrcCheckbox.isSelected()) {
                String dbname = (String)this.capturedStmtModel.getValueAt(rowid, this.pos_capturedDbname - 1);
                String procname = (String)this.capturedStmtModel.getValueAt(rowid, this.pos_capturedProcName - 1);
                this.displayProcInBatchWindow(dbname, procname, sqlLine);
            } else {
                this.displayBatch(spid, kpid, batchId, sqlLine);
            }
            this.displayPlan(spid, kpid, batchId, planId, dbId, procId, sqlLine);
        } else {
            if (this.currentDbname != null && !this.currentDbname.equals("") && this.currentProcName != null && !this.currentProcName.equals("") && this.currentSqlLine > 0 && this.pdf.sqlTextShowProcSrcCheckbox.isSelected()) {
                this.displayProcInBatchWindow(this.currentDbname, this.currentProcName, this.currentSqlLine);
            } else {
                this.displayCurrentBatch();
            }
            this.displayPlan(this.currentSpid, this.currentKpid, this.currentBatchID, 0, this.currentDBID, this.currentProcedureID, this.currentSqlLine);
        }
    }

    public int getSelectedStatement() {
        return this.selectedStatement;
    }

    private void updatePanel_code() {
        if (!this.currentSMInitialized) {
            this.currentStmtModel.setDataVector(this.currentStmt, this.currentStmtColNames);
            this.currentSMInitialized = true;
        }
        if (this.currentStmtRows != null) {
            this.currentStmtModel.setDataVector(this.currentStmtRows, this.currentStmtColNames);
            SwingUtils.calcColumnWidths(this.pdf.currentStatementTable);
        } else if (this.currentStmtModel.getRowCount() > 0) {
            this.currentStmtModel.setRowCount(0);
        }
        if (this.newCapturedStatements != null) {
            if (!this.capturedSMInitialized) {
                this.capturedStmtModel.setDataVector(new Vector(), this.capturedStmtColNames);
                this.capturedSMInitialized = true;
                SwingUtils.calcColumnWidths(this.pdf.capturedStatementsTable);
                this.capturedTableColmnsIsResized = false;
            }
            for (int i = 0; i < this.newCapturedStatements.size(); ++i) {
                this.capturedStmtModel.addRow((Vector)this.newCapturedStatements.get(i));
                if (this.capturedTableColmnsIsResized) continue;
                this.capturedTableColmnsIsResized = true;
                SwingUtils.calcColumnWidths(this.pdf.capturedStatementsTable);
            }
        }
    }

    private boolean getAseConfigBoolean(String cfgName) throws SQLException {
        boolean b = false;
        ResultSet rs = this.stmt.executeQuery("sp_configure '" + cfgName + "'");
        while (rs.next()) {
            if (rs.getInt(5) <= 0) continue;
            b = true;
        }
        rs.close();
        return b;
    }

    public void clear() {
        _logger.debug((Object)("Before clear(), batchHistory had " + this.batchHistory.size() + " entries."));
        this.batchHistory.clear();
        _logger.debug((Object)("Before clear(), plansHistory had " + this.plansHistory.size() + " entries."));
        this.plansHistory.clear();
        _logger.debug((Object)("Before clear(), compiledPlansHistory had " + this.compiledPlansHistory.size() + " entries."));
        this.compiledPlansHistory.clear();
        _logger.debug((Object)("Before clear(), procedureTextCache had " + this.procedureTextCache.size() + " entries."));
        this.procedureTextCache.clear();
        _logger.debug((Object)("Before clear(), currentStmtModel had " + this.currentStmtModel.getRowCount() + " entries."));
        this.currentStmtModel.clear();
        _logger.debug((Object)("Before clear(), capturedStmtModel had " + this.capturedStmtModel.getRowCount() + " entries."));
        this.capturedStmtModel.clear();
        this.pdf.batchTextArea.setText("");
        this.pdf.planTextArea.setText("");
    }

    public void saveCapturedStatementsToFile() {
        this.saveCapturedStatementsToFile(null, "", "", "");
    }

    public void saveCapturedStatementsToFile(String saveToDir, String bcpFilename, String txtFilename, String tabDefFilename) {
        BufferedWriter bcpWriter = null;
        BufferedWriter txtWriter = null;
        boolean txtWriterNewFile = false;
        Writer tabWriter = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd H:mm:ss.SSS");
        String sqlSaveTime = sdf.format(new Date());
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        String fileTime = sdf2.format(new Date());
        if (saveToDir == null && (saveToDir = System.getProperty("ASEMON_SAVE_DIR")) == null && (saveToDir = System.getProperty("ASEMON_HOME")) == null) {
            _logger.error((Object)"Directory name was not specified and ASEMON_SAVE_DIR or ASEMON_HOME was not set, can't save information about Captured Statements.");
            return;
        }
        if (bcpFilename != null && bcpFilename.length() == 0) {
            bcpFilename = saveToDir + "/capStmts." + fileTime + ".bcp";
        }
        if (txtFilename != null && txtFilename.length() == 0) {
            txtFilename = saveToDir + "/capStmts." + fileTime + ".txt";
        }
        if (tabDefFilename != null && tabDefFilename.length() == 0) {
            tabDefFilename = saveToDir + "/capStmts." + fileTime + ".ddl.sql";
        }
        try {
            if (bcpFilename != null) {
                bcpWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(bcpFilename, true)));
            }
            if (txtFilename != null) {
                File txtWriterFile = new File(txtFilename);
                txtWriterNewFile = !txtWriterFile.exists();
                txtWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(txtWriterFile, true)));
            }
            if (tabDefFilename != null) {
                tabWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tabDefFilename)));
            }
        }
        catch (FileNotFoundException e) {
            _logger.warn((Object)("Problems opening/creating the a file. " + e));
            return;
        }
        if (tabWriter != null) {
            try {
                tabWriter.write("create table CapturedStatements \n");
                tabWriter.write("( \n");
                tabWriter.write("    SaveTime           datetime        not null,\n");
                tabWriter.write("    SPID               int             not null,\n");
                tabWriter.write("    KPID               int             not null,\n");
                tabWriter.write("    BatchID            int             not null,\n");
                tabWriter.write("    LineNumber         int             not null,\n");
                tabWriter.write("    dbname             varchar(30)     not null,\n");
                tabWriter.write("    procname           varchar(30)     not null,\n");
                tabWriter.write("    Elapsed_ms         int             not null,\n");
                tabWriter.write("    CpuTime            int             not null,\n");
                tabWriter.write("    WaitTime           int             not null,\n");
                tabWriter.write("    MemUsageKB         int             not null,\n");
                tabWriter.write("    PhysicalReads      int             not null,\n");
                tabWriter.write("    LogicalReads       int             not null,\n");
                if (this._aseVersion >= 15002 || this._aseVersion >= 12540 && this._aseVersion <= 15000) {
                    tabWriter.write("    RowsAffected       int             not null,\n");
                    tabWriter.write("    ErrorStatus        int             not null,\n");
                }
                if (this._aseVersion >= 15030) {
                    tabWriter.write("    ProcNestLevel      int             not null,\n");
                    tabWriter.write("    StatementNumber    int             not null,\n");
                }
                tabWriter.write("    PagesModified      int             not null,\n");
                tabWriter.write("    PacketsSent        int             not null,\n");
                tabWriter.write("    PacketsReceived    int             not null,\n");
                tabWriter.write("    NetworkPacketSize  int             not null,\n");
                tabWriter.write("    PlansAltered       int             not null,\n");
                tabWriter.write("    StartTime          datetime        not null,\n");
                tabWriter.write("    EndTime            datetime        not null,\n");
                tabWriter.write("    PlanID             int             not null,\n");
                tabWriter.write("    DBID               int             not null,\n");
                tabWriter.write("    ProcedureID        int             not null,\n");
                tabWriter.write(") \n");
                tabWriter.write("go\n");
                tabWriter.write("\n");
                tabWriter.write("create index CapStmnts_ix1 on CapturedStatements(SaveTime)\n");
                tabWriter.write("go\n");
                tabWriter.write("\n");
                tabWriter.write("create index CapStmnts_ix2 on CapturedStatements(procname, LineNumber)\n");
                tabWriter.write("go\n");
            }
            catch (IOException e) {
                _logger.warn((Object)"Error writing to file.", (Throwable)e);
            }
        }
        String colSep = "\t";
        String rowSep = "\n";
        Object colObj = null;
        StringBuffer rowSb = new StringBuffer();
        StringBuffer headerSb = new StringBuffer();
        int rows = this.capturedStmtModel.getRowCount();
        int cols = this.capturedStmtModel.getColumnCount();
        headerSb.append("SaveTime");
        headerSb.append(colSep);
        for (int c = 0; c < cols; ++c) {
            String colName = this.capturedStmtModel.getColumnName(c);
            if (colName != null) {
                headerSb.append(colName);
            } else {
                headerSb.append("");
            }
            headerSb.append(colSep);
        }
        for (int r = 0; r < rows; ++r) {
            rowSb.setLength(0);
            rowSb.append(sqlSaveTime);
            rowSb.append(colSep);
            for (int c = 0; c < cols; ++c) {
                colObj = this.capturedStmtModel.getValueAt(r, c);
                if (colObj != null) {
                    rowSb.append(colObj);
                } else {
                    rowSb.append("");
                }
                rowSb.append(colSep);
            }
            if (rowSb.length() <= 0) continue;
            try {
                if (bcpWriter != null) {
                    bcpWriter.write(rowSb.toString());
                    bcpWriter.newLine();
                }
                if (txtWriter == null) continue;
                if (r == 0) {
                    txtWriter.write(headerSb.toString());
                    txtWriter.newLine();
                }
                txtWriter.write(rowSb.toString());
                txtWriter.newLine();
                continue;
            }
            catch (IOException e) {
                _logger.warn((Object)"Error writing to file.", (Throwable)e);
            }
        }
        try {
            if (bcpWriter != null) {
                bcpWriter.close();
            }
            if (txtWriter != null) {
                txtWriter.close();
            }
            if (tabWriter != null) {
                ((BufferedWriter)tabWriter).close();
            }
        }
        catch (IOException e) {
            _logger.warn((Object)"Error closing file.", (Throwable)e);
        }
    }

    @Override
    public void run() {
        try {
            this.batchCapture = this.getAseConfigBoolean("SQL batch capture");
            this.SQLTextMonitor = this.getAseConfigBoolean("max SQL text monitored");
            this.planTextPipe = this.getAseConfigBoolean("plan text pipe active");
            this.planTextPipeMsg = this.getAseConfigBoolean("plan text pipe max messages");
            this.sqlTextPipe = this.getAseConfigBoolean("sql text pipe active");
            this.sqlTextPipeMsg = this.getAseConfigBoolean("sql text pipe max messages");
            this.stmtPipe = this.getAseConfigBoolean("statement pipe active");
            this.stmtPipeMsg = this.getAseConfigBoolean("statement pipe max messages");
            this.stmtStat = this.getAseConfigBoolean("statement statistics active");
            this.procWaitEvents = this.getAseConfigBoolean("process wait events");
            ResultSet rs = this.stmt.executeQuery("sp_activeroles");
            while (rs.next()) {
                if (!rs.getString(1).equals("sa_role")) continue;
                this.has_sa_role = true;
            }
        }
        catch (SQLException SQLEx) {
            _logger.error((Object)"asemon : error in refreshProcess getting options. ", (Throwable)SQLEx);
        }
        StringBuffer msg = new StringBuffer();
        if (!this.stmtStat) {
            msg = msg.append("       'statement statistics active' to 1\n");
        }
        if (!this.batchCapture) {
            msg = msg.append("       'SQL batch capture' to 1 \n");
        }
        if (!this.SQLTextMonitor) {
            msg = msg.append("       'max SQL text monitored' to a value greater than 0 (ex : 4094)\n");
        }
        if (!this.sqlTextPipe) {
            msg = msg.append("       'sql text pipe active' to 1\n");
        }
        if (!this.sqlTextPipeMsg) {
            msg = msg.append("       'sql text pipe max messages' to a value greater than 0\n");
        }
        if (!this.stmtPipe) {
            msg = msg.append("       'statement pipe active' to 1\n");
        }
        if (!this.stmtPipeMsg) {
            msg = msg.append("       'statement pipe max messages' to a value greater than 0\n");
        }
        if (!this.planTextPipe) {
            msg = msg.append("       'plan text pipe active' to 1\n");
        }
        if (!this.planTextPipeMsg) {
            msg = msg.append("       'plan text pipe max messages' to a value greater than 0\n");
        }
        if (!this.procWaitEvents) {
            msg = msg.append("       'process wait events' to 1\n");
        }
        if (!this.has_sa_role) {
            if (msg.length() > 0) {
                msg = msg.append(" and ");
            }
            msg = msg.append("user should have 'sa_role'");
        }
        if (msg.length() > 0) {
            msg.insert(0, "RECOMMENDATION : for full features, configure the following parameters :\n\n");
            msg = msg.append("\n\nConfigure the ASE and re-open the window.\n");
            JOptionPane.showMessageDialog(this.pdf, msg.toString(), "asemon - SPID monitoring", 2);
            AseMonitoringConfigDialog.showDialog(this.pdf, this.conn, -1);
        }
        if (this.has_sa_role) {
            try {
                this.rs = this.stmt.executeQuery("select name from sybsystemprocs..sysobjects where name ='sp_showplanfull' and type='P'");
                this.rs.next();
                if (this.rs.getRow() == 0) {
                    this.stmt.executeUpdate("use sybsystemprocs");
                    this.stmt.executeUpdate("create proc sp_showplanfull    \n(   \n    @spid int   \n)   \nas   \ndeclare   \n     @batchid int,   \n     @contextid int,   \n     @stmtid int,   \n     @return_value int,   \n     @procname varchar(30),   \n     @procid int,   \n     @dbid int   \n    \nset nocount on   \n    \nselect @return_value = show_plan(@spid, -1, -1, -1)   \nif (@return_value < 0)   \nbegin   \n        print 'No plan for spid %1!', @spid   \n        goto fin   \nend   \nelse   \nbegin   \n        select @batchid = @return_value   \nend   \n    \nselect @return_value = show_plan(@spid, @batchid, -1, -1)   \nif (@return_value < 0)   \nbegin   \n        print 'No plan for spid %1!', @spid   \n        goto fin   \nend   \nelse   \nbegin   \n        select @contextid = @return_value   \nend   \n    \nselect @procname=object_name(id, dbid), @procid=id, @dbid=dbid from master..sysprocesses where spid=@spid   \nif @procid>0    \nbegin   \n       print 'Plan for procedure : %1! (id=%2!, dbid=%3!)', @procname, @procid, @dbid   \nend   \n    \nselect @stmtid =1   \nwhile (1=1)   \nbegin   \n      select @return_value = show_plan(@spid, @batchid, @contextid , @stmtid)   \n      if (@return_value < 0)   \n          break   \n      else   \n          select @stmtid =@stmtid +1   \nend   \nfin:   \n");
                    this.stmt.executeUpdate("use master");
                }
            }
            catch (SQLException sqlex) {
                _logger.error((Object)"When creating stored proc 'sp_showplanfull'.", (Throwable)sqlex);
            }
        }
        this._aseVersion = MonTablesDictionary.getInstance().aseVersionNum;
        this._monTablesVersion = MonTablesDictionary.getInstance().montablesVersionNum;
        String cols1 = null;
        String cols2 = null;
        String cols3 = null;
        int needVersion = 0;
        int needCeVersion = 0;
        String name = "CMProcObjects";
        String displayName = "Objects";
        String description = "What objects are accessed right now.";
        needVersion = 0;
        String[] monTables = new String[]{"monProcessObject"};
        String[] needRole = new String[]{"mon_role"};
        String[] needConfig = new String[]{"enable monitoring", "per object statistics active"};
        String[] colsCalcDiff = new String[]{"LogicalReads", "PhysicalReads", "PhysicalAPFReads"};
        String[] colsCalcPCT = new String[]{};
        LinkedList<String> pkList = new LinkedList<String>();
        pkList.add("KPID");
        pkList.add("DBName");
        pkList.add("ObjectID");
        pkList.add("IndexID");
        cols3 = "";
        cols2 = "";
        cols1 = "";
        cols1 = "SPID, KPID, DBName, ObjectID, OwnerUserID, ObjectName, IndexID, ObjectType, ";
        cols2 = "LogicalReads, PhysicalReads, PhysicalAPFReads";
        cols3 = "";
        if (this._aseVersion >= 12520) {
            cols3 = ", TableSize";
        }
        if (this._aseVersion >= 15000) {
            cols1 = cols1 + "PartitionID, PartitionName, ";
            cols3 = ", PartitionSize";
            pkList.add("PartitionID");
        }
        String CMProcObjectsSqlBase = "select " + cols1 + cols2 + cols3 + "\n" + "from monProcessObject \n" + "where 1=1 ";
        this.CMProcObjects = new CountersModel("CMProcObjects", CMProcObjectsSqlBase, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){

            @Override
            public boolean isRefreshable() {
                GTabbedPane gtp;
                JTabbedPane tp;
                boolean refresh = false;
                if (this.equalsTabPanel(RefreshProcess.this.pdf.getActiveTab())) {
                    refresh = true;
                }
                if (this.getTabPanel() != null && (tp = RefreshProcess.this.pdf.getTabbedPane()) instanceof GTabbedPane && (gtp = (GTabbedPane)tp).isTabUnDocked(this.getTabPanel().getPanelName())) {
                    refresh = true;
                }
                if (this.isBackgroundDataPollingEnabled()) {
                    refresh = true;
                }
                if (this.isDataPollingPaused()) {
                    refresh = false;
                }
                if (this.getTimeToNextPostponedRefresh() > 0L) {
                    _logger.debug((Object)("Next refresh for the cm '" + this.getName() + "' will have to wait '" + TimeUtils.msToTimeStr(this.getTimeToNextPostponedRefresh()) + "'."));
                    refresh = false;
                }
                return refresh;
            }
        };
        this.CMProcObjects.setTabPanel(this.pdf.processObjectsPanel);
        if (this.kpid > 0) {
            this.CMProcObjects.setSqlWhere(" and KPID = " + this.kpid);
        }
        name = "CMProcWaits";
        displayName = "Waits";
        description = "What is this spid waiting for right now.";
        needVersion = 0;
        monTables = new String[]{"monProcessWaits", "monWaitEventInfo", "monWaitClassInfo"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring", "process wait events", "wait event timing"};
        colsCalcDiff = new String[]{"WaitTime", "Waits"};
        colsCalcPCT = new String[]{};
        pkList = new LinkedList();
        pkList.add("KPID");
        pkList.add("WaitEventID");
        String CMProcWaitsSqlBase = "select SPID, KPID, Class=C.Description, Event=I.Description, W.WaitEventID, WaitTime, Waits from monProcessWaits W, monWaitEventInfo I, monWaitClassInfo C where W.WaitEventID=I.WaitEventID   and I.WaitClassID=C.WaitClassID ";
        this.CMProcWaits = new CountersModel("CMProcWaits", CMProcWaitsSqlBase, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, true, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected CmSybMessageHandler createSybMessageHandler() {
                CmSybMessageHandler msgHandler = super.createSybMessageHandler();
                msgHandler.addDiscardMsgStr("WaitClassID, WaitEventID");
                return msgHandler;
            }

            @Override
            public boolean isRefreshable() {
                GTabbedPane gtp;
                JTabbedPane tp;
                boolean refresh = false;
                if (this.equalsTabPanel(RefreshProcess.this.pdf.getActiveTab())) {
                    refresh = true;
                }
                if (this.getTabPanel() != null && (tp = RefreshProcess.this.pdf.getTabbedPane()) instanceof GTabbedPane && (gtp = (GTabbedPane)tp).isTabUnDocked(this.getTabPanel().getPanelName())) {
                    refresh = true;
                }
                if (this.isBackgroundDataPollingEnabled()) {
                    refresh = true;
                }
                if (this.isDataPollingPaused()) {
                    refresh = false;
                }
                if (this.getTimeToNextPostponedRefresh() > 0L) {
                    _logger.debug((Object)("Next refresh for the cm '" + this.getName() + "' will have to wait '" + TimeUtils.msToTimeStr(this.getTimeToNextPostponedRefresh()) + "'."));
                    refresh = false;
                }
                return refresh;
            }
        };
        this.CMProcWaits.setTabPanel(this.pdf.processWaitsPanel);
        if (this.kpid > 0) {
            this.CMProcWaits.setSqlWhere(" and KPID = " + this.kpid);
        }
        name = "CMProcLocks";
        displayName = "Locks";
        description = "What locks does this spid hold right now.";
        needVersion = 0;
        monTables = new String[]{"monLocks"};
        needRole = new String[]{"mon_role"};
        needConfig = new String[]{"enable monitoring"};
        colsCalcDiff = new String[]{};
        colsCalcPCT = new String[]{};
        pkList = null;
        cols3 = "";
        cols2 = "";
        cols1 = "";
        cols1 = "SPID, KPID, DBID, ParentSPID, LockID, Context, ObjectID, ObjectName=object_name(ObjectID, DBID), LockState, LockType, LockLevel, ";
        cols2 = "";
        cols3 = "WaitTime, PageNumber, RowNumber";
        if (this._aseVersion >= 15002) {
            cols2 = "BlockedState, BlockedBy, ";
        }
        if (this._aseVersion >= 15020) {
            cols3 = cols3 + ", SourceCodeID";
        }
        String CMLocksSqlBase = "select " + cols1 + cols2 + cols3 + "\n" + "from monLocks L " + "where 1=1 ";
        this.CMLocks = new CountersModel("CMLocks", CMLocksSqlBase, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, true){

            @Override
            public boolean isRefreshable() {
                GTabbedPane gtp;
                JTabbedPane tp;
                boolean refresh = false;
                if (this.equalsTabPanel(RefreshProcess.this.pdf.getActiveTab())) {
                    refresh = true;
                }
                if (this.getTabPanel() != null && (tp = RefreshProcess.this.pdf.getTabbedPane()) instanceof GTabbedPane && (gtp = (GTabbedPane)tp).isTabUnDocked(this.getTabPanel().getPanelName())) {
                    refresh = true;
                }
                if (this.isBackgroundDataPollingEnabled()) {
                    refresh = true;
                }
                if (this.isDataPollingPaused()) {
                    refresh = false;
                }
                if (this.getTimeToNextPostponedRefresh() > 0L) {
                    _logger.debug((Object)("Next refresh for the cm '" + this.getName() + "' will have to wait '" + TimeUtils.msToTimeStr(this.getTimeToNextPostponedRefresh()) + "'."));
                    refresh = false;
                }
                return refresh;
            }
        };
        this.CMLocks.setTabPanel(this.pdf.processLocksPanel);
        if (this.kpid > 0) {
            this.CMLocks.setSqlWhere(" and KPID = " + this.kpid);
        }
        boolean firstTime = true;
        while (this.refreshProcessFlag) {
            try {
                if (!firstTime) {
                    Thread.sleep(this._refreshInterval * 1000);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            firstTime = false;
            this.refreshProcess();
        }
        try {
            this.conn.close();
        }
        catch (SQLException sqlex) {
            _logger.error((Object)"SQL problems", (Throwable)sqlex);
        }
        this.pdf.statusBarLbl.setText("Process disconnected");
    }

    public void setRefreshInterval(int interval) {
        this._refreshInterval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshProcess() {
        try {
            this.pdf.statusBarLbl.setText("Refreshing");
            this.pdf.statusBarLbl.setForeground(Color.BLACK);
            this.refreshStmt();
            this.CMProcObjects.getTabPanel().setWatermark();
            if (this.procWaitEvents) {
                this.CMProcWaits.getTabPanel().setWatermark();
            }
            this.CMLocks.getTabPanel().setWatermark();
            if (this.kpid > 0) {
                if (this.CMProcObjects.isRefreshable()) {
                    this.CMProcObjects.refresh();
                }
                if (this.procWaitEvents && this.CMProcWaits.isRefreshable()) {
                    this.CMProcWaits.refresh();
                }
                if (this.CMLocks.isRefreshable()) {
                    this.CMLocks.refresh();
                }
            } else if (this.currentBatch != null) {
                this.pdf.kpidFld.setText(this.currentBatch.kpid + "");
                this.pdf.kpidFld.setForeground(Color.BLUE);
                this.pdf.spidFld.setText(this.currentBatch.spid + "");
                this.pdf.spidFld.setForeground(Color.BLUE);
                this.CMProcObjects.setSqlWhere(" and KPID = " + this.currentBatch.kpid);
                if (this.procWaitEvents) {
                    this.CMProcWaits.setSqlWhere(" and KPID = " + this.currentBatch.kpid);
                }
                this.CMLocks.setSqlWhere(" and KPID = " + this.currentBatch.kpid);
                if (this.CMProcObjects.isRefreshable()) {
                    this.CMProcObjects.refresh();
                }
                if (this.procWaitEvents && this.CMProcWaits.isRefreshable()) {
                    this.CMProcWaits.refresh();
                }
                if (this.CMLocks.isRefreshable()) {
                    this.CMLocks.refresh();
                }
            } else {
                this.CMProcObjects.clear();
                if (this.procWaitEvents) {
                    this.CMProcWaits.clear();
                }
                this.CMLocks.clear();
                String watermark = "No SQL Statement is executing, the \"Current Statements\" table is empty.";
                this.CMProcObjects.getTabPanel().setWatermarkText(watermark);
                if (this.procWaitEvents) {
                    this.CMProcWaits.getTabPanel().setWatermarkText(watermark);
                }
                this.CMLocks.getTabPanel().setWatermarkText(watermark);
                this.pdf.kpidFld.setText("none");
                this.pdf.kpidFld.setForeground(Color.BLACK);
                this.pdf.spidFld.setText("none");
                this.pdf.spidFld.setForeground(Color.BLACK);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"asemon : error in refreshProcess loop. ", (Throwable)e);
        }
        finally {
            if (!this.pdf.statusBarLbl.getText().startsWith("Error")) {
                this.pdf.statusBarLbl.setText("");
            }
        }
    }

    public void stopRefresh() {
        this.refreshProcessFlag = false;
    }

    class StatementsModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -2280839765834154391L;

        public StatementsModel() {
        }

        public StatementsModel(int row, int col) {
            super(row, col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void clear() {
            int r = this.getRowCount();
            if (r > 0) {
                while (r > 0) {
                    this.removeRow(r - 1);
                    --r;
                }
            }
        }
    }
}

